// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateJobCommon = "CreateJob"

// CreateJobCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateJobCommon operation. The "output" return
// value will be populated with the CreateJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateJobCommon Send returns without error.
//
// See CreateJobCommon for more information on using the CreateJobCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateJobCommonRequest method.
//    req, resp := client.CreateJobCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateJobCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateJobCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateJobCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateJobCommon for usage and error information.
func (c *MLPLATFORM20240701) CreateJobCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateJobCommonRequest(input)
	return out, req.Send()
}

// CreateJobCommonWithContext is the same as CreateJobCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJobCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateJobCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateJobCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the CreateJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateJobCommon Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateJob API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateJob for usage and error information.
func (c *MLPLATFORM20240701) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateJobWithContext(ctx volcengine.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CfsForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForCreateJobInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForCreateJobInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForCreateJobInput) SetFileSystemName(v string) *CfsForCreateJobInput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForCreateJobInput) SetNamespaceId(v string) *CfsForCreateJobInput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForCreateJobInput) SetOptions(v *OptionsForCreateJobInput) *CfsForCreateJobInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForCreateJobInput) SetTos(v *TosForCreateJobInput) *CfsForCreateJobInput {
	s.Tos = v
	return s
}

type CodeForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	LocalPath *string `type:"string" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	SavedPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CodeForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeForCreateJobInput) GoString() string {
	return s.String()
}

// SetLocalPath sets the LocalPath field's value.
func (s *CodeForCreateJobInput) SetLocalPath(v string) *CodeForCreateJobInput {
	s.LocalPath = &v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *CodeForCreateJobInput) SetMountPath(v string) *CodeForCreateJobInput {
	s.MountPath = &v
	return s
}

// SetSavedPath sets the SavedPath field's value.
func (s *CodeForCreateJobInput) SetSavedPath(v string) *CodeForCreateJobInput {
	s.SavedPath = &v
	return s
}

type ConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForCreateJobInput `type:"structure" json:",omitempty"`

	Nas *NasForCreateJobInput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForCreateJobInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateJobInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForCreateJobInput) SetCfs(v *CfsForCreateJobInput) *ConfigForCreateJobInput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForCreateJobInput) SetNas(v *NasForCreateJobInput) *ConfigForCreateJobInput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForCreateJobInput) SetSfcs(v *SfcsForCreateJobInput) *ConfigForCreateJobInput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForCreateJobInput) SetTos(v *TosForCreateJobInput) *ConfigForCreateJobInput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForCreateJobInput) SetVepfs(v *VepfsForCreateJobInput) *ConfigForCreateJobInput {
	s.Vepfs = v
	return s
}

type ConvertCredentialForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertCredentialForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCredentialForCreateJobInput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *ConvertCredentialForCreateJobInput) SetAccessKey(v string) *ConvertCredentialForCreateJobInput {
	s.AccessKey = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *ConvertCredentialForCreateJobInput) SetSecretAccessKey(v string) *ConvertCredentialForCreateJobInput {
	s.SecretAccessKey = &v
	return s
}

type ConvertOptionsForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForCreateJobInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForCreateJobInput) SetInternalSync(v int64) *ConvertOptionsForCreateJobInput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForCreateJobInput) SetReplicas(v int64) *ConvertOptionsForCreateJobInput {
	s.Replicas = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DiagnoseConfig []*DiagnoseConfigForCreateJobInput `type:"list" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ObservableConfig *ObservableConfigForCreateJobInput `type:"structure" json:",omitempty"`

	ResourceConfig *ResourceConfigForCreateJobInput `type:"structure" json:",omitempty"`

	RetryConfig *RetryConfigForCreateJobInput `type:"structure" json:",omitempty"`

	RuntimeConfig *RuntimeConfigForCreateJobInput `type:"structure" json:",omitempty"`

	StorageConfig *StorageConfigForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetDiagnoseConfig sets the DiagnoseConfig field's value.
func (s *CreateJobInput) SetDiagnoseConfig(v []*DiagnoseConfigForCreateJobInput) *CreateJobInput {
	s.DiagnoseConfig = v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateJobInput) SetDryRun(v bool) *CreateJobInput {
	s.DryRun = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJobInput) SetName(v string) *CreateJobInput {
	s.Name = &v
	return s
}

// SetObservableConfig sets the ObservableConfig field's value.
func (s *CreateJobInput) SetObservableConfig(v *ObservableConfigForCreateJobInput) *CreateJobInput {
	s.ObservableConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateJobInput) SetResourceConfig(v *ResourceConfigForCreateJobInput) *CreateJobInput {
	s.ResourceConfig = v
	return s
}

// SetRetryConfig sets the RetryConfig field's value.
func (s *CreateJobInput) SetRetryConfig(v *RetryConfigForCreateJobInput) *CreateJobInput {
	s.RetryConfig = v
	return s
}

// SetRuntimeConfig sets the RuntimeConfig field's value.
func (s *CreateJobInput) SetRuntimeConfig(v *RuntimeConfigForCreateJobInput) *CreateJobInput {
	s.RuntimeConfig = v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *CreateJobInput) SetStorageConfig(v *StorageConfigForCreateJobInput) *CreateJobInput {
	s.StorageConfig = v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateJobOutput) SetId(v string) *CreateJobOutput {
	s.Id = &v
	return s
}

type CredentialForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForCreateJobInput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *CredentialForCreateJobInput) SetRegistryToken(v string) *CredentialForCreateJobInput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *CredentialForCreateJobInput) SetRegistryUsername(v string) *CredentialForCreateJobInput {
	s.RegistryUsername = &v
	return s
}

type CustomMetricServiceForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Port *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CustomMetricServiceForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomMetricServiceForCreateJobInput) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *CustomMetricServiceForCreateJobInput) SetPath(v string) *CustomMetricServiceForCreateJobInput {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CustomMetricServiceForCreateJobInput) SetPort(v string) *CustomMetricServiceForCreateJobInput {
	s.Port = &v
	return s
}

type DiagnoseConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DetectionIntervalSeconds *int64 `type:"int64" json:",omitempty"`

	FirstDetectionWaitSeconds *int64 `type:"int64" json:",omitempty"`

	Name *string `type:"string" json:",omitempty" enum:"EnumOfNameForCreateJobInput"`

	Triggers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DiagnoseConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DiagnoseConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetDetectionIntervalSeconds sets the DetectionIntervalSeconds field's value.
func (s *DiagnoseConfigForCreateJobInput) SetDetectionIntervalSeconds(v int64) *DiagnoseConfigForCreateJobInput {
	s.DetectionIntervalSeconds = &v
	return s
}

// SetFirstDetectionWaitSeconds sets the FirstDetectionWaitSeconds field's value.
func (s *DiagnoseConfigForCreateJobInput) SetFirstDetectionWaitSeconds(v int64) *DiagnoseConfigForCreateJobInput {
	s.FirstDetectionWaitSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *DiagnoseConfigForCreateJobInput) SetName(v string) *DiagnoseConfigForCreateJobInput {
	s.Name = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *DiagnoseConfigForCreateJobInput) SetTriggers(v []*string) *DiagnoseConfigForCreateJobInput {
	s.Triggers = v
	return s
}

type EnvForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IsPrivate *bool `type:"boolean" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForCreateJobInput) GoString() string {
	return s.String()
}

// SetIsPrivate sets the IsPrivate field's value.
func (s *EnvForCreateJobInput) SetIsPrivate(v bool) *EnvForCreateJobInput {
	s.IsPrivate = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvForCreateJobInput) SetName(v string) *EnvForCreateJobInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForCreateJobInput) SetValue(v string) *EnvForCreateJobInput {
	s.Value = &v
	return s
}

type FlexibleResourceClaimForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForCreateJobInput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetCpu(v float64) *FlexibleResourceClaimForCreateJobInput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetFamily(v string) *FlexibleResourceClaimForCreateJobInput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetGpuCount(v float64) *FlexibleResourceClaimForCreateJobInput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetGpuType(v string) *FlexibleResourceClaimForCreateJobInput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetMemoryGiB(v float64) *FlexibleResourceClaimForCreateJobInput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForCreateJobInput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForCreateJobInput {
	s.RdmaEniCount = &v
	return s
}

type ImageForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *CredentialForCreateJobInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForCreateJobInput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForCreateJobInput) SetCredential(v *CredentialForCreateJobInput) *ImageForCreateJobInput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForCreateJobInput) SetType(v string) *ImageForCreateJobInput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForCreateJobInput) SetUrl(v string) *ImageForCreateJobInput {
	s.Url = &v
	return s
}

type NasForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForCreateJobInput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForCreateJobInput) SetAddr(v string) *NasForCreateJobInput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForCreateJobInput) SetFileSystemName(v string) *NasForCreateJobInput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForCreateJobInput) SetId(v string) *NasForCreateJobInput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForCreateJobInput) SetNasType(v string) *NasForCreateJobInput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForCreateJobInput) SetSubPath(v string) *NasForCreateJobInput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForCreateJobInput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForCreateJobInput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForCreateJobInput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForCreateJobInput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForCreateJobInput) SetStrategyType(v string) *NodeAffinitySpecForCreateJobInput {
	s.StrategyType = &v
	return s
}

type ObservableConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomMetricService *CustomMetricServiceForCreateJobInput `type:"structure" json:",omitempty"`

	DashboardPrivateUrl *string `type:"string" json:",omitempty"`

	DashboardPublicUrl *string `type:"string" json:",omitempty"`

	TensorboardStorage *TensorboardStorageForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ObservableConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObservableConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetCustomMetricService sets the CustomMetricService field's value.
func (s *ObservableConfigForCreateJobInput) SetCustomMetricService(v *CustomMetricServiceForCreateJobInput) *ObservableConfigForCreateJobInput {
	s.CustomMetricService = v
	return s
}

// SetDashboardPrivateUrl sets the DashboardPrivateUrl field's value.
func (s *ObservableConfigForCreateJobInput) SetDashboardPrivateUrl(v string) *ObservableConfigForCreateJobInput {
	s.DashboardPrivateUrl = &v
	return s
}

// SetDashboardPublicUrl sets the DashboardPublicUrl field's value.
func (s *ObservableConfigForCreateJobInput) SetDashboardPublicUrl(v string) *ObservableConfigForCreateJobInput {
	s.DashboardPublicUrl = &v
	return s
}

// SetTensorboardStorage sets the TensorboardStorage field's value.
func (s *ObservableConfigForCreateJobInput) SetTensorboardStorage(v *TensorboardStorageForCreateJobInput) *ObservableConfigForCreateJobInput {
	s.TensorboardStorage = v
	return s
}

type OptionsForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForCreateJobInput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForCreateJobInput) SetInternalSync(v int64) *OptionsForCreateJobInput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForCreateJobInput) SetMetaCacheCapacity(v int64) *OptionsForCreateJobInput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForCreateJobInput) SetMetaCacheExpiryMinutes(v int64) *OptionsForCreateJobInput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForCreateJobInput) SetMetaCacheExpiryMsec(v int64) *OptionsForCreateJobInput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type ResourceConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HoldingTimeSeconds *int64 `type:"int64" json:",omitempty"`

	MaxRuntimeSeconds *int64 `type:"int64" json:",omitempty"`

	NumaAffinity *string `type:"string" json:",omitempty"`

	OnlyUseSuspectedNode *bool `type:"boolean" json:",omitempty"`

	Preemptible *bool `type:"boolean" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	ResourceReservation *bool `type:"boolean" json:",omitempty"`

	ResourceReservationPlanId *string `type:"string" json:",omitempty"`

	Roles []*RoleForCreateJobInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetHoldingTimeSeconds sets the HoldingTimeSeconds field's value.
func (s *ResourceConfigForCreateJobInput) SetHoldingTimeSeconds(v int64) *ResourceConfigForCreateJobInput {
	s.HoldingTimeSeconds = &v
	return s
}

// SetMaxRuntimeSeconds sets the MaxRuntimeSeconds field's value.
func (s *ResourceConfigForCreateJobInput) SetMaxRuntimeSeconds(v int64) *ResourceConfigForCreateJobInput {
	s.MaxRuntimeSeconds = &v
	return s
}

// SetNumaAffinity sets the NumaAffinity field's value.
func (s *ResourceConfigForCreateJobInput) SetNumaAffinity(v string) *ResourceConfigForCreateJobInput {
	s.NumaAffinity = &v
	return s
}

// SetOnlyUseSuspectedNode sets the OnlyUseSuspectedNode field's value.
func (s *ResourceConfigForCreateJobInput) SetOnlyUseSuspectedNode(v bool) *ResourceConfigForCreateJobInput {
	s.OnlyUseSuspectedNode = &v
	return s
}

// SetPreemptible sets the Preemptible field's value.
func (s *ResourceConfigForCreateJobInput) SetPreemptible(v bool) *ResourceConfigForCreateJobInput {
	s.Preemptible = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ResourceConfigForCreateJobInput) SetPriority(v int32) *ResourceConfigForCreateJobInput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *ResourceConfigForCreateJobInput) SetResourceQueueId(v string) *ResourceConfigForCreateJobInput {
	s.ResourceQueueId = &v
	return s
}

// SetResourceReservation sets the ResourceReservation field's value.
func (s *ResourceConfigForCreateJobInput) SetResourceReservation(v bool) *ResourceConfigForCreateJobInput {
	s.ResourceReservation = &v
	return s
}

// SetResourceReservationPlanId sets the ResourceReservationPlanId field's value.
func (s *ResourceConfigForCreateJobInput) SetResourceReservationPlanId(v string) *ResourceConfigForCreateJobInput {
	s.ResourceReservationPlanId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *ResourceConfigForCreateJobInput) SetRoles(v []*RoleForCreateJobInput) *ResourceConfigForCreateJobInput {
	s.Roles = v
	return s
}

type ResourceForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForCreateJobInput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForCreateJobInput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForCreateJobInput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForCreateJobInput) *ResourceForCreateJobInput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForCreateJobInput) SetInstanceTypeId(v string) *ResourceForCreateJobInput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForCreateJobInput) SetType(v string) *ResourceForCreateJobInput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForCreateJobInput) SetZoneId(v string) *ResourceForCreateJobInput {
	s.ZoneId = &v
	return s
}

type RetryConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IntervalSeconds *int64 `type:"int64" json:",omitempty"`

	MaxRetryTimes *int64 `type:"int64" json:",omitempty"`

	Triggers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RetryConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RetryConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *RetryConfigForCreateJobInput) SetIntervalSeconds(v int64) *RetryConfigForCreateJobInput {
	s.IntervalSeconds = &v
	return s
}

// SetMaxRetryTimes sets the MaxRetryTimes field's value.
func (s *RetryConfigForCreateJobInput) SetMaxRetryTimes(v int64) *RetryConfigForCreateJobInput {
	s.MaxRetryTimes = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *RetryConfigForCreateJobInput) SetTriggers(v []*string) *RetryConfigForCreateJobInput {
	s.Triggers = v
	return s
}

type RoleForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForCreateJobInput `type:"structure" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`

	Resource *ResourceForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RoleForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForCreateJobInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RoleForCreateJobInput) SetName(v string) *RoleForCreateJobInput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForCreateJobInput) SetNodeAffinitySpec(v *NodeAffinitySpecForCreateJobInput) *RoleForCreateJobInput {
	s.NodeAffinitySpec = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForCreateJobInput) SetReplicas(v int64) *RoleForCreateJobInput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForCreateJobInput) SetResource(v *ResourceForCreateJobInput) *RoleForCreateJobInput {
	s.Resource = v
	return s
}

type RuntimeConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdvanceArgs *string `type:"string" json:",omitempty"`

	Code *CodeForCreateJobInput `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	Envs []*EnvForCreateJobInput `type:"list" json:",omitempty"`

	Framework *string `type:"string" json:",omitempty" enum:"EnumOfFrameworkForCreateJobInput"`

	Image *ImageForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RuntimeConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuntimeConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetAdvanceArgs sets the AdvanceArgs field's value.
func (s *RuntimeConfigForCreateJobInput) SetAdvanceArgs(v string) *RuntimeConfigForCreateJobInput {
	s.AdvanceArgs = &v
	return s
}

// SetCode sets the Code field's value.
func (s *RuntimeConfigForCreateJobInput) SetCode(v *CodeForCreateJobInput) *RuntimeConfigForCreateJobInput {
	s.Code = v
	return s
}

// SetCommand sets the Command field's value.
func (s *RuntimeConfigForCreateJobInput) SetCommand(v string) *RuntimeConfigForCreateJobInput {
	s.Command = &v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *RuntimeConfigForCreateJobInput) SetEnvs(v []*EnvForCreateJobInput) *RuntimeConfigForCreateJobInput {
	s.Envs = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *RuntimeConfigForCreateJobInput) SetFramework(v string) *RuntimeConfigForCreateJobInput {
	s.Framework = &v
	return s
}

// SetImage sets the Image field's value.
func (s *RuntimeConfigForCreateJobInput) SetImage(v *ImageForCreateJobInput) *RuntimeConfigForCreateJobInput {
	s.Image = v
	return s
}

type SfcsForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForCreateJobInput `type:"structure" json:",omitempty"`

	Tos *TosForCreateJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForCreateJobInput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForCreateJobInput) SetCachePolicyId(v string) *SfcsForCreateJobInput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForCreateJobInput) SetFileSystemName(v string) *SfcsForCreateJobInput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForCreateJobInput) SetOptions(v *ConvertOptionsForCreateJobInput) *SfcsForCreateJobInput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForCreateJobInput) SetTos(v *TosForCreateJobInput) *SfcsForCreateJobInput {
	s.Tos = v
	return s
}

type StorageConfigForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *ConvertCredentialForCreateJobInput `type:"structure" json:",omitempty"`

	SidecarMemoryRatio *float64 `type:"double" json:",omitempty"`

	Storages []*StorageForCreateJobInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForCreateJobInput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *StorageConfigForCreateJobInput) SetCredential(v *ConvertCredentialForCreateJobInput) *StorageConfigForCreateJobInput {
	s.Credential = v
	return s
}

// SetSidecarMemoryRatio sets the SidecarMemoryRatio field's value.
func (s *StorageConfigForCreateJobInput) SetSidecarMemoryRatio(v float64) *StorageConfigForCreateJobInput {
	s.SidecarMemoryRatio = &v
	return s
}

// SetStorages sets the Storages field's value.
func (s *StorageConfigForCreateJobInput) SetStorages(v []*StorageForCreateJobInput) *StorageConfigForCreateJobInput {
	s.Storages = v
	return s
}

type StorageForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForCreateJobInput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForCreateJobInput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForCreateJobInput) SetConfig(v *ConfigForCreateJobInput) *StorageForCreateJobInput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForCreateJobInput) SetMountPath(v string) *StorageForCreateJobInput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForCreateJobInput) SetReadOnly(v bool) *StorageForCreateJobInput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForCreateJobInput) SetType(v string) *StorageForCreateJobInput {
	s.Type = &v
	return s
}

type TensorboardStorageForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForCreateJobInput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TensorboardStorageForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TensorboardStorageForCreateJobInput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *TensorboardStorageForCreateJobInput) SetConfig(v *ConfigForCreateJobInput) *TensorboardStorageForCreateJobInput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *TensorboardStorageForCreateJobInput) SetMountPath(v string) *TensorboardStorageForCreateJobInput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *TensorboardStorageForCreateJobInput) SetReadOnly(v bool) *TensorboardStorageForCreateJobInput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *TensorboardStorageForCreateJobInput) SetType(v string) *TensorboardStorageForCreateJobInput {
	s.Type = &v
	return s
}

type TosForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForCreateJobInput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForCreateJobInput) SetBucket(v string) *TosForCreateJobInput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForCreateJobInput) SetPrefix(v string) *TosForCreateJobInput {
	s.Prefix = &v
	return s
}

type VepfsForCreateJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForCreateJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForCreateJobInput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForCreateJobInput) SetFileSystemName(v string) *VepfsForCreateJobInput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForCreateJobInput) SetHostPath(v string) *VepfsForCreateJobInput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForCreateJobInput) SetId(v string) *VepfsForCreateJobInput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForCreateJobInput) SetSubPath(v string) *VepfsForCreateJobInput {
	s.SubPath = &v
	return s
}

const (
	// EnumOfFrameworkForCreateJobInputPyTorch is a EnumOfFrameworkForCreateJobInput enum value
	EnumOfFrameworkForCreateJobInputPyTorch = "PyTorch"

	// EnumOfFrameworkForCreateJobInputMpi is a EnumOfFrameworkForCreateJobInput enum value
	EnumOfFrameworkForCreateJobInputMpi = "MPI"

	// EnumOfFrameworkForCreateJobInputRay is a EnumOfFrameworkForCreateJobInput enum value
	EnumOfFrameworkForCreateJobInputRay = "Ray"

	// EnumOfFrameworkForCreateJobInputTensorFlow is a EnumOfFrameworkForCreateJobInput enum value
	EnumOfFrameworkForCreateJobInputTensorFlow = "TensorFlow"

	// EnumOfFrameworkForCreateJobInputCustom is a EnumOfFrameworkForCreateJobInput enum value
	EnumOfFrameworkForCreateJobInputCustom = "Custom"
)

const (
	// EnumOfGPUCPUNodePreferenceForCreateJobInputGpurequired is a EnumOfGPUCPUNodePreferenceForCreateJobInput enum value
	EnumOfGPUCPUNodePreferenceForCreateJobInputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForCreateJobInputGpupreferred is a EnumOfGPUCPUNodePreferenceForCreateJobInput enum value
	EnumOfGPUCPUNodePreferenceForCreateJobInputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForCreateJobInputCpurequired is a EnumOfGPUCPUNodePreferenceForCreateJobInput enum value
	EnumOfGPUCPUNodePreferenceForCreateJobInputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForCreateJobInputCpupreferred is a EnumOfGPUCPUNodePreferenceForCreateJobInput enum value
	EnumOfGPUCPUNodePreferenceForCreateJobInputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfNameForCreateJobInputEnvironmentalDiagnosis is a EnumOfNameForCreateJobInput enum value
	EnumOfNameForCreateJobInputEnvironmentalDiagnosis = "EnvironmentalDiagnosis"

	// EnumOfNameForCreateJobInputPythonDetection is a EnumOfNameForCreateJobInput enum value
	EnumOfNameForCreateJobInputPythonDetection = "PythonDetection"

	// EnumOfNameForCreateJobInputLogDetection is a EnumOfNameForCreateJobInput enum value
	EnumOfNameForCreateJobInputLogDetection = "LogDetection"
)

const (
	// EnumOfTriggerListForCreateJobInputBeforeStart is a EnumOfTriggerListForCreateJobInput enum value
	EnumOfTriggerListForCreateJobInputBeforeStart = "BeforeStart"

	// EnumOfTriggerListForCreateJobInputJobRunning is a EnumOfTriggerListForCreateJobInput enum value
	EnumOfTriggerListForCreateJobInputJobRunning = "JobRunning"

	// EnumOfTriggerListForCreateJobInputJobFailed is a EnumOfTriggerListForCreateJobInput enum value
	EnumOfTriggerListForCreateJobInputJobFailed = "JobFailed"

	// EnumOfTriggerListForCreateJobInputStopByUser is a EnumOfTriggerListForCreateJobInput enum value
	EnumOfTriggerListForCreateJobInputStopByUser = "StopByUser"
)
