// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateCustomKeyStoreCommon = "UpdateCustomKeyStore"

// UpdateCustomKeyStoreCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateCustomKeyStoreCommon operation. The "output" return
// value will be populated with the UpdateCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateCustomKeyStoreCommon Send returns without error.
//
// See UpdateCustomKeyStoreCommon for more information on using the UpdateCustomKeyStoreCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateCustomKeyStoreCommonRequest method.
//    req, resp := client.UpdateCustomKeyStoreCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateCustomKeyStoreCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateCustomKeyStoreCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateCustomKeyStoreCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateCustomKeyStoreCommon for usage and error information.
func (c *KMS) UpdateCustomKeyStoreCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateCustomKeyStoreCommonRequest(input)
	return out, req.Send()
}

// UpdateCustomKeyStoreCommonWithContext is the same as UpdateCustomKeyStoreCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomKeyStoreCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateCustomKeyStoreCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateCustomKeyStoreCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomKeyStore = "UpdateCustomKeyStore"

// UpdateCustomKeyStoreRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateCustomKeyStore operation. The "output" return
// value will be populated with the UpdateCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateCustomKeyStoreCommon Send returns without error.
//
// See UpdateCustomKeyStore for more information on using the UpdateCustomKeyStore
// API call, and error handling.
//
//    // Example sending a request using the UpdateCustomKeyStoreRequest method.
//    req, resp := client.UpdateCustomKeyStoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) UpdateCustomKeyStoreRequest(input *UpdateCustomKeyStoreInput) (req *request.Request, output *UpdateCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomKeyStoreInput{}
	}

	output = &UpdateCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateCustomKeyStore API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation UpdateCustomKeyStore for usage and error information.
func (c *KMS) UpdateCustomKeyStore(input *UpdateCustomKeyStoreInput) (*UpdateCustomKeyStoreOutput, error) {
	req, out := c.UpdateCustomKeyStoreRequest(input)
	return out, req.Send()
}

// UpdateCustomKeyStoreWithContext is the same as UpdateCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) UpdateCustomKeyStoreWithContext(ctx volcengine.Context, input *UpdateCustomKeyStoreInput, opts ...request.Option) (*UpdateCustomKeyStoreOutput, error) {
	req, out := c.UpdateCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateCustomKeyStoreInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomKeyStoreID is a required field
	CustomKeyStoreID *string `min:"36" max:"36" type:"string" json:",omitempty" required:"true"`

	NewCustomKeyStoreName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	TrustAnchorCertificate *string `min:"1" max:"5000" type:"string" json:",omitempty"`

	XksAccessKey *string `min:"20" max:"30" type:"string" json:",omitempty"`

	XksProxyConnectivity *string `type:"string" json:",omitempty" enum:"EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInput"`

	XksProxyUriEndpoint *string `min:"10" max:"128" type:"string" json:",omitempty"`

	XksProxyUriPath *string `min:"10" max:"128" type:"string" json:",omitempty"`

	XksProxyVpcEndpointServiceName *string `min:"20" max:"128" type:"string" json:",omitempty"`

	XksSecretAccessKey *string `min:"43" max:"64" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateCustomKeyStoreInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomKeyStoreInput"}
	if s.CustomKeyStoreID == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreID"))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreID", 36))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) > 36 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreID", 36, *s.CustomKeyStoreID))
	}
	if s.NewCustomKeyStoreName != nil && len(*s.NewCustomKeyStoreName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("NewCustomKeyStoreName", 2))
	}
	if s.NewCustomKeyStoreName != nil && len(*s.NewCustomKeyStoreName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("NewCustomKeyStoreName", 31, *s.NewCustomKeyStoreName))
	}
	if s.TrustAnchorCertificate != nil && len(*s.TrustAnchorCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustAnchorCertificate", 1))
	}
	if s.TrustAnchorCertificate != nil && len(*s.TrustAnchorCertificate) > 5000 {
		invalidParams.Add(request.NewErrParamMaxLen("TrustAnchorCertificate", 5000, *s.TrustAnchorCertificate))
	}
	if s.XksAccessKey != nil && len(*s.XksAccessKey) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksAccessKey", 20))
	}
	if s.XksAccessKey != nil && len(*s.XksAccessKey) > 30 {
		invalidParams.Add(request.NewErrParamMaxLen("XksAccessKey", 30, *s.XksAccessKey))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriEndpoint", 10))
	}
	if s.XksProxyUriEndpoint != nil && len(*s.XksProxyUriEndpoint) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyUriEndpoint", 128, *s.XksProxyUriEndpoint))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyUriPath", 10))
	}
	if s.XksProxyUriPath != nil && len(*s.XksProxyUriPath) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyUriPath", 128, *s.XksProxyUriPath))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("XksProxyVpcEndpointServiceName", 20))
	}
	if s.XksProxyVpcEndpointServiceName != nil && len(*s.XksProxyVpcEndpointServiceName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("XksProxyVpcEndpointServiceName", 128, *s.XksProxyVpcEndpointServiceName))
	}
	if s.XksSecretAccessKey != nil && len(*s.XksSecretAccessKey) < 43 {
		invalidParams.Add(request.NewErrParamMinLen("XksSecretAccessKey", 43))
	}
	if s.XksSecretAccessKey != nil && len(*s.XksSecretAccessKey) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("XksSecretAccessKey", 64, *s.XksSecretAccessKey))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *UpdateCustomKeyStoreInput) SetCustomKeyStoreID(v string) *UpdateCustomKeyStoreInput {
	s.CustomKeyStoreID = &v
	return s
}

// SetNewCustomKeyStoreName sets the NewCustomKeyStoreName field's value.
func (s *UpdateCustomKeyStoreInput) SetNewCustomKeyStoreName(v string) *UpdateCustomKeyStoreInput {
	s.NewCustomKeyStoreName = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *UpdateCustomKeyStoreInput) SetTrustAnchorCertificate(v string) *UpdateCustomKeyStoreInput {
	s.TrustAnchorCertificate = &v
	return s
}

// SetXksAccessKey sets the XksAccessKey field's value.
func (s *UpdateCustomKeyStoreInput) SetXksAccessKey(v string) *UpdateCustomKeyStoreInput {
	s.XksAccessKey = &v
	return s
}

// SetXksProxyConnectivity sets the XksProxyConnectivity field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyConnectivity(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyConnectivity = &v
	return s
}

// SetXksProxyUriEndpoint sets the XksProxyUriEndpoint field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyUriEndpoint(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyUriEndpoint = &v
	return s
}

// SetXksProxyUriPath sets the XksProxyUriPath field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyUriPath(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyUriPath = &v
	return s
}

// SetXksProxyVpcEndpointServiceName sets the XksProxyVpcEndpointServiceName field's value.
func (s *UpdateCustomKeyStoreInput) SetXksProxyVpcEndpointServiceName(v string) *UpdateCustomKeyStoreInput {
	s.XksProxyVpcEndpointServiceName = &v
	return s
}

// SetXksSecretAccessKey sets the XksSecretAccessKey field's value.
func (s *UpdateCustomKeyStoreInput) SetXksSecretAccessKey(v string) *UpdateCustomKeyStoreInput {
	s.XksSecretAccessKey = &v
	return s
}

type UpdateCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCustomKeyStoreOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInputPublicEndpoint is a EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInput enum value
	EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInputPublicEndpoint = "PUBLIC_ENDPOINT"

	// EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInputVpcEndpointService is a EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInput enum value
	EnumOfXksProxyConnectivityForUpdateCustomKeyStoreInputVpcEndpointService = "VPC_ENDPOINT_SERVICE"
)
