// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opScheduleSecretDeletionCommon = "ScheduleSecretDeletion"

// ScheduleSecretDeletionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ScheduleSecretDeletionCommon operation. The "output" return
// value will be populated with the ScheduleSecretDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScheduleSecretDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScheduleSecretDeletionCommon Send returns without error.
//
// See ScheduleSecretDeletionCommon for more information on using the ScheduleSecretDeletionCommon
// API call, and error handling.
//
//    // Example sending a request using the ScheduleSecretDeletionCommonRequest method.
//    req, resp := client.ScheduleSecretDeletionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ScheduleSecretDeletionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opScheduleSecretDeletionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScheduleSecretDeletionCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ScheduleSecretDeletionCommon for usage and error information.
func (c *KMS) ScheduleSecretDeletionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ScheduleSecretDeletionCommonRequest(input)
	return out, req.Send()
}

// ScheduleSecretDeletionCommonWithContext is the same as ScheduleSecretDeletionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleSecretDeletionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ScheduleSecretDeletionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ScheduleSecretDeletionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScheduleSecretDeletion = "ScheduleSecretDeletion"

// ScheduleSecretDeletionRequest generates a "volcengine/request.Request" representing the
// client's request for the ScheduleSecretDeletion operation. The "output" return
// value will be populated with the ScheduleSecretDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScheduleSecretDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScheduleSecretDeletionCommon Send returns without error.
//
// See ScheduleSecretDeletion for more information on using the ScheduleSecretDeletion
// API call, and error handling.
//
//    // Example sending a request using the ScheduleSecretDeletionRequest method.
//    req, resp := client.ScheduleSecretDeletionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ScheduleSecretDeletionRequest(input *ScheduleSecretDeletionInput) (req *request.Request, output *ScheduleSecretDeletionOutput) {
	op := &request.Operation{
		Name:       opScheduleSecretDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleSecretDeletionInput{}
	}

	output = &ScheduleSecretDeletionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScheduleSecretDeletion API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ScheduleSecretDeletion for usage and error information.
func (c *KMS) ScheduleSecretDeletion(input *ScheduleSecretDeletionInput) (*ScheduleSecretDeletionOutput, error) {
	req, out := c.ScheduleSecretDeletionRequest(input)
	return out, req.Send()
}

// ScheduleSecretDeletionWithContext is the same as ScheduleSecretDeletion with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleSecretDeletion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ScheduleSecretDeletionWithContext(ctx volcengine.Context, input *ScheduleSecretDeletionInput, opts ...request.Option) (*ScheduleSecretDeletionOutput, error) {
	req, out := c.ScheduleSecretDeletionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ScheduleSecretDeletionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ForceDelete *bool `type:"boolean" json:",omitempty"`

	PendingWindowInDays *int32 `min:"7" max:"30" type:"int32" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"128" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ScheduleSecretDeletionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleSecretDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleSecretDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleSecretDeletionInput"}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays < 7 {
		invalidParams.Add(request.NewErrParamMinValue("PendingWindowInDays", 7))
	}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays > 30 {
		invalidParams.Add(request.NewErrParamMaxValue("PendingWindowInDays", 30))
	}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 128, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceDelete sets the ForceDelete field's value.
func (s *ScheduleSecretDeletionInput) SetForceDelete(v bool) *ScheduleSecretDeletionInput {
	s.ForceDelete = &v
	return s
}

// SetPendingWindowInDays sets the PendingWindowInDays field's value.
func (s *ScheduleSecretDeletionInput) SetPendingWindowInDays(v int32) *ScheduleSecretDeletionInput {
	s.PendingWindowInDays = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *ScheduleSecretDeletionInput) SetSecretName(v string) *ScheduleSecretDeletionInput {
	s.SecretName = &v
	return s
}

type ScheduleSecretDeletionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ScheduleSecretDeletionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleSecretDeletionOutput) GoString() string {
	return s.String()
}
