// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateSecretCommon = "CreateSecret"

// CreateSecretCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSecretCommon operation. The "output" return
// value will be populated with the CreateSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSecretCommon Send returns without error.
//
// See CreateSecretCommon for more information on using the CreateSecretCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateSecretCommonRequest method.
//    req, resp := client.CreateSecretCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateSecretCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateSecretCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateSecretCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateSecretCommon for usage and error information.
func (c *KMS) CreateSecretCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateSecretCommonRequest(input)
	return out, req.Send()
}

// CreateSecretCommonWithContext is the same as CreateSecretCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecretCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateSecretCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateSecretCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecret = "CreateSecret"

// CreateSecretRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateSecret operation. The "output" return
// value will be populated with the CreateSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateSecretCommon Send returns without error.
//
// See CreateSecret for more information on using the CreateSecret
// API call, and error handling.
//
//    // Example sending a request using the CreateSecretRequest method.
//    req, resp := client.CreateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) CreateSecretRequest(input *CreateSecretInput) (req *request.Request, output *CreateSecretOutput) {
	op := &request.Operation{
		Name:       opCreateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSecretInput{}
	}

	output = &CreateSecretOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateSecret API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation CreateSecret for usage and error information.
func (c *KMS) CreateSecret(input *CreateSecretInput) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	return out, req.Send()
}

// CreateSecretWithContext is the same as CreateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) CreateSecretWithContext(ctx volcengine.Context, input *CreateSecretInput, opts ...request.Option) (*CreateSecretOutput, error) {
	req, out := c.CreateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateSecretInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutomaticRotation *bool `type:"boolean" json:",omitempty"`

	Description *string `max:"8192" type:"string" json:",omitempty"`

	EncryptionKey *string `type:"string" json:",omitempty"`

	ExtendedConfig *string `max:"1024" type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RotationInterval *string `type:"string" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"128" type:"string" json:",omitempty" required:"true"`

	// SecretType is a required field
	SecretType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfSecretTypeForCreateSecretInput"`

	// SecretValue is a required field
	SecretValue *string `max:"30720" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateSecretInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecretInput"}
	if s.Description != nil && len(*s.Description) > 8192 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 8192, *s.Description))
	}
	if s.ExtendedConfig != nil && len(*s.ExtendedConfig) > 1024 {
		invalidParams.Add(request.NewErrParamMaxLen("ExtendedConfig", 1024, *s.ExtendedConfig))
	}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 128, *s.SecretName))
	}
	if s.SecretType == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretType"))
	}
	if s.SecretValue == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretValue"))
	}
	if s.SecretValue != nil && len(*s.SecretValue) > 30720 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretValue", 30720, *s.SecretValue))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticRotation sets the AutomaticRotation field's value.
func (s *CreateSecretInput) SetAutomaticRotation(v bool) *CreateSecretInput {
	s.AutomaticRotation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecretInput) SetDescription(v string) *CreateSecretInput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateSecretInput) SetEncryptionKey(v string) *CreateSecretInput {
	s.EncryptionKey = &v
	return s
}

// SetExtendedConfig sets the ExtendedConfig field's value.
func (s *CreateSecretInput) SetExtendedConfig(v string) *CreateSecretInput {
	s.ExtendedConfig = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateSecretInput) SetProjectName(v string) *CreateSecretInput {
	s.ProjectName = &v
	return s
}

// SetRotationInterval sets the RotationInterval field's value.
func (s *CreateSecretInput) SetRotationInterval(v string) *CreateSecretInput {
	s.RotationInterval = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *CreateSecretInput) SetSecretName(v string) *CreateSecretInput {
	s.SecretName = &v
	return s
}

// SetSecretType sets the SecretType field's value.
func (s *CreateSecretInput) SetSecretType(v string) *CreateSecretInput {
	s.SecretType = &v
	return s
}

// SetSecretValue sets the SecretValue field's value.
func (s *CreateSecretInput) SetSecretValue(v string) *CreateSecretInput {
	s.SecretValue = &v
	return s
}

type CreateSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Secret *SecretForCreateSecretOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSecretOutput) GoString() string {
	return s.String()
}

// SetSecret sets the Secret field's value.
func (s *CreateSecretOutput) SetSecret(v *SecretForCreateSecretOutput) *CreateSecretOutput {
	s.Secret = v
	return s
}

type SecretForCreateSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	EncryptionKey *string `type:"string" json:",omitempty"`

	ExtendedConfig *string `max:"1024" type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	Managed *bool `type:"boolean" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RotationInterval *int32 `type:"int32" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	SecretName *string `type:"string" json:",omitempty"`

	SecretState *string `type:"string" json:",omitempty" enum:"EnumOfSecretStateForCreateSecretOutput"`

	SecretType *string `type:"string" json:",omitempty" enum:"EnumOfSecretTypeForCreateSecretOutput"`

	Trn *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SecretForCreateSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretForCreateSecretOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SecretForCreateSecretOutput) SetCreationDate(v int64) *SecretForCreateSecretOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecretForCreateSecretOutput) SetDescription(v string) *SecretForCreateSecretOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *SecretForCreateSecretOutput) SetEncryptionKey(v string) *SecretForCreateSecretOutput {
	s.EncryptionKey = &v
	return s
}

// SetExtendedConfig sets the ExtendedConfig field's value.
func (s *SecretForCreateSecretOutput) SetExtendedConfig(v string) *SecretForCreateSecretOutput {
	s.ExtendedConfig = &v
	return s
}

// SetID sets the ID field's value.
func (s *SecretForCreateSecretOutput) SetID(v string) *SecretForCreateSecretOutput {
	s.ID = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *SecretForCreateSecretOutput) SetLastRotationTime(v string) *SecretForCreateSecretOutput {
	s.LastRotationTime = &v
	return s
}

// SetManaged sets the Managed field's value.
func (s *SecretForCreateSecretOutput) SetManaged(v bool) *SecretForCreateSecretOutput {
	s.Managed = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SecretForCreateSecretOutput) SetProjectName(v string) *SecretForCreateSecretOutput {
	s.ProjectName = &v
	return s
}

// SetRotationInterval sets the RotationInterval field's value.
func (s *SecretForCreateSecretOutput) SetRotationInterval(v int32) *SecretForCreateSecretOutput {
	s.RotationInterval = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *SecretForCreateSecretOutput) SetRotationState(v string) *SecretForCreateSecretOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *SecretForCreateSecretOutput) SetScheduleDeleteTime(v string) *SecretForCreateSecretOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *SecretForCreateSecretOutput) SetScheduleRotationTime(v string) *SecretForCreateSecretOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *SecretForCreateSecretOutput) SetSecretName(v string) *SecretForCreateSecretOutput {
	s.SecretName = &v
	return s
}

// SetSecretState sets the SecretState field's value.
func (s *SecretForCreateSecretOutput) SetSecretState(v string) *SecretForCreateSecretOutput {
	s.SecretState = &v
	return s
}

// SetSecretType sets the SecretType field's value.
func (s *SecretForCreateSecretOutput) SetSecretType(v string) *SecretForCreateSecretOutput {
	s.SecretType = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *SecretForCreateSecretOutput) SetTrn(v string) *SecretForCreateSecretOutput {
	s.Trn = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SecretForCreateSecretOutput) SetUID(v string) *SecretForCreateSecretOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *SecretForCreateSecretOutput) SetUpdateDate(v int64) *SecretForCreateSecretOutput {
	s.UpdateDate = &v
	return s
}

const (
	// EnumOfSecretStateForCreateSecretOutputEnable is a EnumOfSecretStateForCreateSecretOutput enum value
	EnumOfSecretStateForCreateSecretOutputEnable = "Enable"

	// EnumOfSecretStateForCreateSecretOutputDisable is a EnumOfSecretStateForCreateSecretOutput enum value
	EnumOfSecretStateForCreateSecretOutputDisable = "Disable"

	// EnumOfSecretStateForCreateSecretOutputPendingDelete is a EnumOfSecretStateForCreateSecretOutput enum value
	EnumOfSecretStateForCreateSecretOutputPendingDelete = "PendingDelete"
)

const (
	// EnumOfSecretTypeForCreateSecretInputGeneric is a EnumOfSecretTypeForCreateSecretInput enum value
	EnumOfSecretTypeForCreateSecretInputGeneric = "Generic"

	// EnumOfSecretTypeForCreateSecretInputIam is a EnumOfSecretTypeForCreateSecretInput enum value
	EnumOfSecretTypeForCreateSecretInputIam = "IAM"

	// EnumOfSecretTypeForCreateSecretInputRds is a EnumOfSecretTypeForCreateSecretInput enum value
	EnumOfSecretTypeForCreateSecretInputRds = "RDS"

	// EnumOfSecretTypeForCreateSecretInputRedis is a EnumOfSecretTypeForCreateSecretInput enum value
	EnumOfSecretTypeForCreateSecretInputRedis = "Redis"

	// EnumOfSecretTypeForCreateSecretInputEcs is a EnumOfSecretTypeForCreateSecretInput enum value
	EnumOfSecretTypeForCreateSecretInputEcs = "ECS"
)

const (
	// EnumOfSecretTypeForCreateSecretOutputGeneric is a EnumOfSecretTypeForCreateSecretOutput enum value
	EnumOfSecretTypeForCreateSecretOutputGeneric = "Generic"

	// EnumOfSecretTypeForCreateSecretOutputIam is a EnumOfSecretTypeForCreateSecretOutput enum value
	EnumOfSecretTypeForCreateSecretOutputIam = "IAM"

	// EnumOfSecretTypeForCreateSecretOutputRds is a EnumOfSecretTypeForCreateSecretOutput enum value
	EnumOfSecretTypeForCreateSecretOutputRds = "RDS"

	// EnumOfSecretTypeForCreateSecretOutputRedis is a EnumOfSecretTypeForCreateSecretOutput enum value
	EnumOfSecretTypeForCreateSecretOutputRedis = "Redis"

	// EnumOfSecretTypeForCreateSecretOutputEcs is a EnumOfSecretTypeForCreateSecretOutput enum value
	EnumOfSecretTypeForCreateSecretOutputEcs = "ECS"
)
