// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package hbase

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDBInstanceCommon = "CreateDBInstance"

// CreateDBInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDBInstanceCommon operation. The "output" return
// value will be populated with the CreateDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDBInstanceCommon Send returns without error.
//
// See CreateDBInstanceCommon for more information on using the CreateDBInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDBInstanceCommonRequest method.
//    req, resp := client.CreateDBInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *HBASE) CreateDBInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDBInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDBInstanceCommon API operation for HBASE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for HBASE's
// API operation CreateDBInstanceCommon for usage and error information.
func (c *HBASE) CreateDBInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDBInstanceCommonRequest(input)
	return out, req.Send()
}

// CreateDBInstanceCommonWithContext is the same as CreateDBInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HBASE) CreateDBInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDBInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDBInstance operation. The "output" return
// value will be populated with the CreateDBInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDBInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDBInstanceCommon Send returns without error.
//
// See CreateDBInstance for more information on using the CreateDBInstance
// API call, and error handling.
//
//    // Example sending a request using the CreateDBInstanceRequest method.
//    req, resp := client.CreateDBInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *HBASE) CreateDBInstanceRequest(input *CreateDBInstanceInput) (req *request.Request, output *CreateDBInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	output = &CreateDBInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDBInstance API operation for HBASE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for HBASE's
// API operation CreateDBInstance for usage and error information.
func (c *HBASE) CreateDBInstance(input *CreateDBInstanceInput) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	return out, req.Send()
}

// CreateDBInstanceWithContext is the same as CreateDBInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDBInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *HBASE) CreateDBInstanceWithContext(ctx volcengine.Context, input *CreateDBInstanceInput, opts ...request.Option) (*CreateDBInstanceOutput, error) {
	req, out := c.CreateDBInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateDBInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	// ChargeType is a required field
	ChargeType *string `type:"string" json:",omitempty" required:"true"`

	ColdStorage *int32 `type:"int32" json:",omitempty"`

	DeletionProtection *string `type:"string" json:",omitempty"`

	EnableAuth *bool `type:"boolean" json:",omitempty"`

	EnableCloudStorage *bool `type:"boolean" json:",omitempty"`

	// EngineVersion is a required field
	EngineVersion *string `type:"string" json:",omitempty" required:"true"`

	InstanceName *string `type:"string" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	// MasterSpec is a required field
	MasterSpec *string `type:"string" json:",omitempty" required:"true"`

	MultiAZ *bool `type:"boolean" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	PurchaseMonths *int32 `type:"int32" json:",omitempty"`

	// RSCount is a required field
	RSCount *int32 `type:"int32" json:",omitempty" required:"true"`

	// RSSpec is a required field
	RSSpec *string `type:"string" json:",omitempty" required:"true"`

	// RegionId is a required field
	RegionId *string `type:"string" json:",omitempty" required:"true"`

	// StorageCapacity is a required field
	StorageCapacity *int32 `type:"int32" json:",omitempty" required:"true"`

	StorageType *string `type:"string" json:",omitempty"`

	// SubnetId is a required field
	SubnetId *string `type:"string" json:",omitempty" required:"true"`

	Tags []*TagForCreateDBInstanceInput `type:"list" json:",omitempty"`

	// VpcId is a required field
	VpcId *string `type:"string" json:",omitempty" required:"true"`

	// ZoneId is a required field
	ZoneId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDBInstanceInput"}
	if s.ChargeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeType"))
	}
	if s.EngineVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineVersion"))
	}
	if s.MasterSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterSpec"))
	}
	if s.RSCount == nil {
		invalidParams.Add(request.NewErrParamRequired("RSCount"))
	}
	if s.RSSpec == nil {
		invalidParams.Add(request.NewErrParamRequired("RSSpec"))
	}
	if s.RegionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionId"))
	}
	if s.StorageCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageCapacity"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.ZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *CreateDBInstanceInput) SetAutoRenew(v bool) *CreateDBInstanceInput {
	s.AutoRenew = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateDBInstanceInput) SetChargeType(v string) *CreateDBInstanceInput {
	s.ChargeType = &v
	return s
}

// SetColdStorage sets the ColdStorage field's value.
func (s *CreateDBInstanceInput) SetColdStorage(v int32) *CreateDBInstanceInput {
	s.ColdStorage = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateDBInstanceInput) SetDeletionProtection(v string) *CreateDBInstanceInput {
	s.DeletionProtection = &v
	return s
}

// SetEnableAuth sets the EnableAuth field's value.
func (s *CreateDBInstanceInput) SetEnableAuth(v bool) *CreateDBInstanceInput {
	s.EnableAuth = &v
	return s
}

// SetEnableCloudStorage sets the EnableCloudStorage field's value.
func (s *CreateDBInstanceInput) SetEnableCloudStorage(v bool) *CreateDBInstanceInput {
	s.EnableCloudStorage = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateDBInstanceInput) SetEngineVersion(v string) *CreateDBInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateDBInstanceInput) SetInstanceName(v string) *CreateDBInstanceInput {
	s.InstanceName = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateDBInstanceInput) SetInstanceType(v string) *CreateDBInstanceInput {
	s.InstanceType = &v
	return s
}

// SetMasterSpec sets the MasterSpec field's value.
func (s *CreateDBInstanceInput) SetMasterSpec(v string) *CreateDBInstanceInput {
	s.MasterSpec = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateDBInstanceInput) SetMultiAZ(v bool) *CreateDBInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateDBInstanceInput) SetProjectName(v string) *CreateDBInstanceInput {
	s.ProjectName = &v
	return s
}

// SetPurchaseMonths sets the PurchaseMonths field's value.
func (s *CreateDBInstanceInput) SetPurchaseMonths(v int32) *CreateDBInstanceInput {
	s.PurchaseMonths = &v
	return s
}

// SetRSCount sets the RSCount field's value.
func (s *CreateDBInstanceInput) SetRSCount(v int32) *CreateDBInstanceInput {
	s.RSCount = &v
	return s
}

// SetRSSpec sets the RSSpec field's value.
func (s *CreateDBInstanceInput) SetRSSpec(v string) *CreateDBInstanceInput {
	s.RSSpec = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *CreateDBInstanceInput) SetRegionId(v string) *CreateDBInstanceInput {
	s.RegionId = &v
	return s
}

// SetStorageCapacity sets the StorageCapacity field's value.
func (s *CreateDBInstanceInput) SetStorageCapacity(v int32) *CreateDBInstanceInput {
	s.StorageCapacity = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *CreateDBInstanceInput) SetStorageType(v string) *CreateDBInstanceInput {
	s.StorageType = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDBInstanceInput) SetSubnetId(v string) *CreateDBInstanceInput {
	s.SubnetId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDBInstanceInput) SetTags(v []*TagForCreateDBInstanceInput) *CreateDBInstanceInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateDBInstanceInput) SetVpcId(v string) *CreateDBInstanceInput {
	s.VpcId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateDBInstanceInput) SetZoneId(v string) *CreateDBInstanceInput {
	s.ZoneId = &v
	return s
}

type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	OrderNo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDBInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateDBInstanceOutput) SetInstanceId(v string) *CreateDBInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetOrderNo sets the OrderNo field's value.
func (s *CreateDBInstanceOutput) SetOrderNo(v string) *CreateDBInstanceOutput {
	s.OrderNo = &v
	return s
}

type TagForCreateDBInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateDBInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateDBInstanceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateDBInstanceInput) SetKey(v string) *TagForCreateDBInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateDBInstanceInput) SetValue(v string) *TagForCreateDBInstanceInput {
	s.Value = &v
	return s
}
