// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListGtmsCommon = "ListGtms"

// ListGtmsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGtmsCommon operation. The "output" return
// value will be populated with the ListGtmsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGtmsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGtmsCommon Send returns without error.
//
// See ListGtmsCommon for more information on using the ListGtmsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListGtmsCommonRequest method.
//    req, resp := client.ListGtmsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) ListGtmsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListGtmsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGtmsCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation ListGtmsCommon for usage and error information.
func (c *GTM) ListGtmsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListGtmsCommonRequest(input)
	return out, req.Send()
}

// ListGtmsCommonWithContext is the same as ListGtmsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListGtmsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) ListGtmsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListGtmsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGtms = "ListGtms"

// ListGtmsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGtms operation. The "output" return
// value will be populated with the ListGtmsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGtmsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGtmsCommon Send returns without error.
//
// See ListGtms for more information on using the ListGtms
// API call, and error handling.
//
//    // Example sending a request using the ListGtmsRequest method.
//    req, resp := client.ListGtmsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) ListGtmsRequest(input *ListGtmsInput) (req *request.Request, output *ListGtmsOutput) {
	op := &request.Operation{
		Name:       opListGtms,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGtmsInput{}
	}

	output = &ListGtmsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGtms API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation ListGtms for usage and error information.
func (c *GTM) ListGtms(input *ListGtmsInput) (*ListGtmsOutput, error) {
	req, out := c.ListGtmsRequest(input)
	return out, req.Send()
}

// ListGtmsWithContext is the same as ListGtms with the addition of
// the ability to pass a context and additional request options.
//
// See ListGtms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) ListGtmsWithContext(ctx volcengine.Context, input *ListGtmsInput, opts ...request.Option) (*ListGtmsOutput, error) {
	req, out := c.ListGtmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataForListGtmsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessMode *string `type:"string" json:",omitempty"`

	AddressType *string `type:"string" json:",omitempty"`

	AlarmId *string `type:"string" json:",omitempty"`

	Cname *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	GtmId *string `min:"36" max:"36" type:"string" json:",omitempty"`

	LastOperator *string `type:"string" json:",omitempty"`

	Owner *string `type:"string" json:",omitempty"`

	PolicyType *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	ResourceTags []*ResourceTagForListGtmsOutput `type:"list" json:",omitempty"`

	SpecName *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`

	Ttl *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DataForListGtmsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForListGtmsOutput) GoString() string {
	return s.String()
}

// SetAccessMode sets the AccessMode field's value.
func (s *DataForListGtmsOutput) SetAccessMode(v string) *DataForListGtmsOutput {
	s.AccessMode = &v
	return s
}

// SetAddressType sets the AddressType field's value.
func (s *DataForListGtmsOutput) SetAddressType(v string) *DataForListGtmsOutput {
	s.AddressType = &v
	return s
}

// SetAlarmId sets the AlarmId field's value.
func (s *DataForListGtmsOutput) SetAlarmId(v string) *DataForListGtmsOutput {
	s.AlarmId = &v
	return s
}

// SetCname sets the Cname field's value.
func (s *DataForListGtmsOutput) SetCname(v string) *DataForListGtmsOutput {
	s.Cname = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DataForListGtmsOutput) SetCreateTime(v string) *DataForListGtmsOutput {
	s.CreateTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DataForListGtmsOutput) SetDomain(v string) *DataForListGtmsOutput {
	s.Domain = &v
	return s
}

// SetGtmId sets the GtmId field's value.
func (s *DataForListGtmsOutput) SetGtmId(v string) *DataForListGtmsOutput {
	s.GtmId = &v
	return s
}

// SetLastOperator sets the LastOperator field's value.
func (s *DataForListGtmsOutput) SetLastOperator(v string) *DataForListGtmsOutput {
	s.LastOperator = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DataForListGtmsOutput) SetOwner(v string) *DataForListGtmsOutput {
	s.Owner = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *DataForListGtmsOutput) SetPolicyType(v string) *DataForListGtmsOutput {
	s.PolicyType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DataForListGtmsOutput) SetProjectName(v string) *DataForListGtmsOutput {
	s.ProjectName = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *DataForListGtmsOutput) SetRemark(v string) *DataForListGtmsOutput {
	s.Remark = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *DataForListGtmsOutput) SetResourceTags(v []*ResourceTagForListGtmsOutput) *DataForListGtmsOutput {
	s.ResourceTags = v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *DataForListGtmsOutput) SetSpecName(v string) *DataForListGtmsOutput {
	s.SpecName = &v
	return s
}

// SetState sets the State field's value.
func (s *DataForListGtmsOutput) SetState(v string) *DataForListGtmsOutput {
	s.State = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *DataForListGtmsOutput) SetTtl(v int32) *DataForListGtmsOutput {
	s.Ttl = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DataForListGtmsOutput) SetUpdateTime(v string) *DataForListGtmsOutput {
	s.UpdateTime = &v
	return s
}

type ListGtmsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cname *string `type:"string" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `max:"500" type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	SearchMode *string `type:"string" json:",omitempty" enum:"EnumOfSearchModeForListGtmsInput"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListGtmsInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListGtmsInput"`

	SpecName *string `type:"string" json:",omitempty"`

	TagFilters []*TagFilterForListGtmsInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListGtmsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGtmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGtmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGtmsInput"}
	if s.PageSize != nil && *s.PageSize > 500 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 500))
	}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCname sets the Cname field's value.
func (s *ListGtmsInput) SetCname(v string) *ListGtmsInput {
	s.Cname = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ListGtmsInput) SetDomain(v string) *ListGtmsInput {
	s.Domain = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGtmsInput) SetPageNumber(v int32) *ListGtmsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGtmsInput) SetPageSize(v int32) *ListGtmsInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListGtmsInput) SetProjectName(v string) *ListGtmsInput {
	s.ProjectName = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *ListGtmsInput) SetRemark(v string) *ListGtmsInput {
	s.Remark = &v
	return s
}

// SetSearchMode sets the SearchMode field's value.
func (s *ListGtmsInput) SetSearchMode(v string) *ListGtmsInput {
	s.SearchMode = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListGtmsInput) SetSortBy(v string) *ListGtmsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListGtmsInput) SetSortOrder(v string) *ListGtmsInput {
	s.SortOrder = &v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *ListGtmsInput) SetSpecName(v string) *ListGtmsInput {
	s.SpecName = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ListGtmsInput) SetTagFilters(v []*TagFilterForListGtmsInput) *ListGtmsInput {
	s.TagFilters = v
	return s
}

type ListGtmsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*DataForListGtmsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListGtmsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGtmsOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ListGtmsOutput) SetData(v []*DataForListGtmsOutput) *ListGtmsOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGtmsOutput) SetPageNumber(v int32) *ListGtmsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGtmsOutput) SetPageSize(v int32) *ListGtmsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListGtmsOutput) SetTotalCount(v int32) *ListGtmsOutput {
	s.TotalCount = &v
	return s
}

type ResourceTagForListGtmsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForListGtmsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForListGtmsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagForListGtmsOutput) SetKey(v string) *ResourceTagForListGtmsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTagForListGtmsOutput) SetValue(v string) *ResourceTagForListGtmsOutput {
	s.Value = &v
	return s
}

type TagFilterForListGtmsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForListGtmsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForListGtmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilterForListGtmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilterForListGtmsInput"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilterForListGtmsInput) SetKey(v string) *TagFilterForListGtmsInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForListGtmsInput) SetValues(v []*string) *TagFilterForListGtmsInput {
	s.Values = v
	return s
}

const (
	// EnumOfSearchModeForListGtmsInputLike is a EnumOfSearchModeForListGtmsInput enum value
	EnumOfSearchModeForListGtmsInputLike = "like"

	// EnumOfSearchModeForListGtmsInputExact is a EnumOfSearchModeForListGtmsInput enum value
	EnumOfSearchModeForListGtmsInputExact = "exact"
)

const (
	// EnumOfSortByForListGtmsInputDomain is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputDomain = "Domain"

	// EnumOfSortByForListGtmsInputCname is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputCname = "Cname"

	// EnumOfSortByForListGtmsInputState is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputState = "State"

	// EnumOfSortByForListGtmsInputRemark is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputRemark = "Remark"

	// EnumOfSortByForListGtmsInputUpdateTime is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputUpdateTime = "UpdateTime"

	// EnumOfSortByForListGtmsInputCreateTime is a EnumOfSortByForListGtmsInput enum value
	EnumOfSortByForListGtmsInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListGtmsInputAsc is a EnumOfSortOrderForListGtmsInput enum value
	EnumOfSortOrderForListGtmsInputAsc = "Asc"

	// EnumOfSortOrderForListGtmsInputDesc is a EnumOfSortOrderForListGtmsInput enum value
	EnumOfSortOrderForListGtmsInputDesc = "Desc"
)
