// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetRuleCommon = "GetRule"

// GetRuleCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetRuleCommon operation. The "output" return
// value will be populated with the GetRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetRuleCommon Send returns without error.
//
// See GetRuleCommon for more information on using the GetRuleCommon
// API call, and error handling.
//
//    // Example sending a request using the GetRuleCommonRequest method.
//    req, resp := client.GetRuleCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetRuleCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetRuleCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// GetRuleCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetRuleCommon for usage and error information.
func (c *GTM) GetRuleCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetRuleCommonRequest(input)
	return out, req.Send()
}

// GetRuleCommonWithContext is the same as GetRuleCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetRuleCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetRuleCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetRuleCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "volcengine/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value will be populated with the GetRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetRuleCommon Send returns without error.
//
// See GetRule for more information on using the GetRule
// API call, and error handling.
//
//    // Example sending a request using the GetRuleRequest method.
//    req, resp := client.GetRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetRuleRequest(input *GetRuleInput) (req *request.Request, output *GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	output = &GetRuleOutput{}
	req = c.newRequest(op, input, output)

	return
}

// GetRule API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetRule for usage and error information.
func (c *GTM) GetRule(input *GetRuleInput) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetRuleWithContext(ctx volcengine.Context, input *GetRuleInput, opts ...request.Option) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForGetRuleOutput struct {
	_ struct{} `type:"structure"`

	Active *bool `type:"boolean"`

	Capacity *int64 `type:"int64"`

	Geo *string `type:"string"`

	Latency *int32 `type:"int32"`

	Mode *string `type:"string"`

	RectifiedGeos []*string `type:"list"`

	Value *string `type:"string"`

	Weight *int32 `type:"int32"`
}

// String returns the string representation
func (s AddressForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForGetRuleOutput) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *AddressForGetRuleOutput) SetActive(v bool) *AddressForGetRuleOutput {
	s.Active = &v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *AddressForGetRuleOutput) SetCapacity(v int64) *AddressForGetRuleOutput {
	s.Capacity = &v
	return s
}

// SetGeo sets the Geo field's value.
func (s *AddressForGetRuleOutput) SetGeo(v string) *AddressForGetRuleOutput {
	s.Geo = &v
	return s
}

// SetLatency sets the Latency field's value.
func (s *AddressForGetRuleOutput) SetLatency(v int32) *AddressForGetRuleOutput {
	s.Latency = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AddressForGetRuleOutput) SetMode(v string) *AddressForGetRuleOutput {
	s.Mode = &v
	return s
}

// SetRectifiedGeos sets the RectifiedGeos field's value.
func (s *AddressForGetRuleOutput) SetRectifiedGeos(v []*string) *AddressForGetRuleOutput {
	s.RectifiedGeos = v
	return s
}

// SetValue sets the Value field's value.
func (s *AddressForGetRuleOutput) SetValue(v string) *AddressForGetRuleOutput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AddressForGetRuleOutput) SetWeight(v int32) *AddressForGetRuleOutput {
	s.Weight = &v
	return s
}

type GetRuleInput struct {
	_ struct{} `type:"structure"`

	// GtmId is a required field
	GtmId *string `type:"string" required:"true"`

	// PolicyType is a required field
	PolicyType *string `type:"string" required:"true"`

	// RuleId is a required field
	RuleId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGtmId sets the GtmId field's value.
func (s *GetRuleInput) SetGtmId(v string) *GetRuleInput {
	s.GtmId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *GetRuleInput) SetPolicyType(v string) *GetRuleInput {
	s.PolicyType = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRuleInput) SetRuleId(v string) *GetRuleInput {
	s.RuleId = &v
	return s
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CreateTime *string `type:"string"`

	Disable *bool `type:"boolean"`

	EffectivePoolSetIndex *int32 `type:"int32"`

	Line *string `type:"string"`

	Name *string `type:"string"`

	PoolSetMode *string `type:"string"`

	PoolSets []*PoolSetForGetRuleOutput `type:"list"`

	Probe *ProbeForGetRuleOutput `type:"structure"`

	Remark *string `type:"string"`

	RuleId *string `type:"string"`

	UpdateTime *string `type:"string"`

	Weight *int32 `type:"int32"`
}

// String returns the string representation
func (s GetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetRuleOutput) SetCreateTime(v string) *GetRuleOutput {
	s.CreateTime = &v
	return s
}

// SetDisable sets the Disable field's value.
func (s *GetRuleOutput) SetDisable(v bool) *GetRuleOutput {
	s.Disable = &v
	return s
}

// SetEffectivePoolSetIndex sets the EffectivePoolSetIndex field's value.
func (s *GetRuleOutput) SetEffectivePoolSetIndex(v int32) *GetRuleOutput {
	s.EffectivePoolSetIndex = &v
	return s
}

// SetLine sets the Line field's value.
func (s *GetRuleOutput) SetLine(v string) *GetRuleOutput {
	s.Line = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetRuleOutput) SetName(v string) *GetRuleOutput {
	s.Name = &v
	return s
}

// SetPoolSetMode sets the PoolSetMode field's value.
func (s *GetRuleOutput) SetPoolSetMode(v string) *GetRuleOutput {
	s.PoolSetMode = &v
	return s
}

// SetPoolSets sets the PoolSets field's value.
func (s *GetRuleOutput) SetPoolSets(v []*PoolSetForGetRuleOutput) *GetRuleOutput {
	s.PoolSets = v
	return s
}

// SetProbe sets the Probe field's value.
func (s *GetRuleOutput) SetProbe(v *ProbeForGetRuleOutput) *GetRuleOutput {
	s.Probe = v
	return s
}

// SetRemark sets the Remark field's value.
func (s *GetRuleOutput) SetRemark(v string) *GetRuleOutput {
	s.Remark = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRuleOutput) SetRuleId(v string) *GetRuleOutput {
	s.RuleId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetRuleOutput) SetUpdateTime(v string) *GetRuleOutput {
	s.UpdateTime = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *GetRuleOutput) SetWeight(v int32) *GetRuleOutput {
	s.Weight = &v
	return s
}

type HttpHeaderForGetRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s HttpHeaderForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpHeaderForGetRuleOutput) GoString() string {
	return s.String()
}

type HttpUsabilityCodeForGetRuleOutput struct {
	_ struct{} `type:"structure"`

	Codes []*int32 `type:"list"`

	Operator *string `type:"string"`
}

// String returns the string representation
func (s HttpUsabilityCodeForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpUsabilityCodeForGetRuleOutput) GoString() string {
	return s.String()
}

// SetCodes sets the Codes field's value.
func (s *HttpUsabilityCodeForGetRuleOutput) SetCodes(v []*int32) *HttpUsabilityCodeForGetRuleOutput {
	s.Codes = v
	return s
}

// SetOperator sets the Operator field's value.
func (s *HttpUsabilityCodeForGetRuleOutput) SetOperator(v string) *HttpUsabilityCodeForGetRuleOutput {
	s.Operator = &v
	return s
}

type PoolForGetRuleOutput struct {
	_ struct{} `type:"structure"`

	Address []*AddressForGetRuleOutput `type:"list"`

	InactiveAddrCount *int32 `type:"int32"`

	Name *string `type:"string"`

	PoolId *string `type:"string"`

	Weight *int32 `type:"int32"`
}

// String returns the string representation
func (s PoolForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PoolForGetRuleOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *PoolForGetRuleOutput) SetAddress(v []*AddressForGetRuleOutput) *PoolForGetRuleOutput {
	s.Address = v
	return s
}

// SetInactiveAddrCount sets the InactiveAddrCount field's value.
func (s *PoolForGetRuleOutput) SetInactiveAddrCount(v int32) *PoolForGetRuleOutput {
	s.InactiveAddrCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *PoolForGetRuleOutput) SetName(v string) *PoolForGetRuleOutput {
	s.Name = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *PoolForGetRuleOutput) SetPoolId(v string) *PoolForGetRuleOutput {
	s.PoolId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *PoolForGetRuleOutput) SetWeight(v int32) *PoolForGetRuleOutput {
	s.Weight = &v
	return s
}

type PoolSetForGetRuleOutput struct {
	_ struct{} `type:"structure"`

	Active *bool `type:"boolean"`

	ActiveAddrCount *int32 `type:"int32"`

	Name *string `type:"string"`

	PoolSetId *string `type:"string"`

	Pools []*PoolForGetRuleOutput `type:"list"`
}

// String returns the string representation
func (s PoolSetForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PoolSetForGetRuleOutput) GoString() string {
	return s.String()
}

// SetActive sets the Active field's value.
func (s *PoolSetForGetRuleOutput) SetActive(v bool) *PoolSetForGetRuleOutput {
	s.Active = &v
	return s
}

// SetActiveAddrCount sets the ActiveAddrCount field's value.
func (s *PoolSetForGetRuleOutput) SetActiveAddrCount(v int32) *PoolSetForGetRuleOutput {
	s.ActiveAddrCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *PoolSetForGetRuleOutput) SetName(v string) *PoolSetForGetRuleOutput {
	s.Name = &v
	return s
}

// SetPoolSetId sets the PoolSetId field's value.
func (s *PoolSetForGetRuleOutput) SetPoolSetId(v string) *PoolSetForGetRuleOutput {
	s.PoolSetId = &v
	return s
}

// SetPools sets the Pools field's value.
func (s *PoolSetForGetRuleOutput) SetPools(v []*PoolForGetRuleOutput) *PoolSetForGetRuleOutput {
	s.Pools = v
	return s
}

type ProbeForGetRuleOutput struct {
	_ struct{} `type:"structure"`

	AdvisedNodeCount *int32 `type:"int32"`

	Disable *bool `type:"boolean"`

	FailedCount *int32 `type:"int32"`

	Host *string `type:"string"`

	HttpHeader *HttpHeaderForGetRuleOutput `type:"structure"`

	HttpMethod *string `type:"string"`

	HttpUsabilityCodes []*HttpUsabilityCodeForGetRuleOutput `type:"list"`

	Interval *int32 `type:"int32"`

	IsManualNodes *bool `type:"boolean"`

	Nodes []*string `type:"list"`

	PingCount *int32 `type:"int32"`

	PingLossPercent *int32 `type:"int32"`

	Port *int32 `type:"int32"`

	Protocol *string `type:"string"`

	Timeout *int32 `type:"int32"`

	Url *string `type:"string"`
}

// String returns the string representation
func (s ProbeForGetRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProbeForGetRuleOutput) GoString() string {
	return s.String()
}

// SetAdvisedNodeCount sets the AdvisedNodeCount field's value.
func (s *ProbeForGetRuleOutput) SetAdvisedNodeCount(v int32) *ProbeForGetRuleOutput {
	s.AdvisedNodeCount = &v
	return s
}

// SetDisable sets the Disable field's value.
func (s *ProbeForGetRuleOutput) SetDisable(v bool) *ProbeForGetRuleOutput {
	s.Disable = &v
	return s
}

// SetFailedCount sets the FailedCount field's value.
func (s *ProbeForGetRuleOutput) SetFailedCount(v int32) *ProbeForGetRuleOutput {
	s.FailedCount = &v
	return s
}

// SetHost sets the Host field's value.
func (s *ProbeForGetRuleOutput) SetHost(v string) *ProbeForGetRuleOutput {
	s.Host = &v
	return s
}

// SetHttpHeader sets the HttpHeader field's value.
func (s *ProbeForGetRuleOutput) SetHttpHeader(v *HttpHeaderForGetRuleOutput) *ProbeForGetRuleOutput {
	s.HttpHeader = v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *ProbeForGetRuleOutput) SetHttpMethod(v string) *ProbeForGetRuleOutput {
	s.HttpMethod = &v
	return s
}

// SetHttpUsabilityCodes sets the HttpUsabilityCodes field's value.
func (s *ProbeForGetRuleOutput) SetHttpUsabilityCodes(v []*HttpUsabilityCodeForGetRuleOutput) *ProbeForGetRuleOutput {
	s.HttpUsabilityCodes = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *ProbeForGetRuleOutput) SetInterval(v int32) *ProbeForGetRuleOutput {
	s.Interval = &v
	return s
}

// SetIsManualNodes sets the IsManualNodes field's value.
func (s *ProbeForGetRuleOutput) SetIsManualNodes(v bool) *ProbeForGetRuleOutput {
	s.IsManualNodes = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *ProbeForGetRuleOutput) SetNodes(v []*string) *ProbeForGetRuleOutput {
	s.Nodes = v
	return s
}

// SetPingCount sets the PingCount field's value.
func (s *ProbeForGetRuleOutput) SetPingCount(v int32) *ProbeForGetRuleOutput {
	s.PingCount = &v
	return s
}

// SetPingLossPercent sets the PingLossPercent field's value.
func (s *ProbeForGetRuleOutput) SetPingLossPercent(v int32) *ProbeForGetRuleOutput {
	s.PingLossPercent = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ProbeForGetRuleOutput) SetPort(v int32) *ProbeForGetRuleOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ProbeForGetRuleOutput) SetProtocol(v string) *ProbeForGetRuleOutput {
	s.Protocol = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *ProbeForGetRuleOutput) SetTimeout(v int32) *ProbeForGetRuleOutput {
	s.Timeout = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ProbeForGetRuleOutput) SetUrl(v string) *ProbeForGetRuleOutput {
	s.Url = &v
	return s
}
