// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetPolicyCommon = "GetPolicy"

// GetPolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPolicyCommon operation. The "output" return
// value will be populated with the GetPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPolicyCommon Send returns without error.
//
// See GetPolicyCommon for more information on using the GetPolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the GetPolicyCommonRequest method.
//    req, resp := client.GetPolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetPolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetPolicyCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetPolicyCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetPolicyCommon for usage and error information.
func (c *GTM) GetPolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetPolicyCommonRequest(input)
	return out, req.Send()
}

// GetPolicyCommonWithContext is the same as GetPolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetPolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetPolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the GetPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPolicyCommon Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetPolicy API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetPolicy for usage and error information.
func (c *GTM) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetPolicyWithContext(ctx volcengine.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GetPolicyInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// GtmId is a required field
	GtmId *string `type:"string" json:",omitempty" required:"true"`

	// PolicyType is a required field
	PolicyType *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}
	if s.PolicyType == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGtmId sets the GtmId field's value.
func (s *GetPolicyInput) SetGtmId(v string) *GetPolicyInput {
	s.GtmId = &v
	return s
}

// SetPolicyType sets the PolicyType field's value.
func (s *GetPolicyInput) SetPolicyType(v string) *GetPolicyInput {
	s.PolicyType = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AlarmOnly *bool `type:"boolean" json:",omitempty"`

	PerfMode *string `type:"string" json:",omitempty"`

	RoutingMode *string `type:"string" json:",omitempty"`

	SourceFlow *SourceFlowForGetPolicyOutput `type:"structure" json:",omitempty"`

	Statistics *StatisticsForGetPolicyOutput `type:"structure" json:",omitempty"`

	Targets *TargetsForGetPolicyOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetAlarmOnly sets the AlarmOnly field's value.
func (s *GetPolicyOutput) SetAlarmOnly(v bool) *GetPolicyOutput {
	s.AlarmOnly = &v
	return s
}

// SetPerfMode sets the PerfMode field's value.
func (s *GetPolicyOutput) SetPerfMode(v string) *GetPolicyOutput {
	s.PerfMode = &v
	return s
}

// SetRoutingMode sets the RoutingMode field's value.
func (s *GetPolicyOutput) SetRoutingMode(v string) *GetPolicyOutput {
	s.RoutingMode = &v
	return s
}

// SetSourceFlow sets the SourceFlow field's value.
func (s *GetPolicyOutput) SetSourceFlow(v *SourceFlowForGetPolicyOutput) *GetPolicyOutput {
	s.SourceFlow = v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetPolicyOutput) SetStatistics(v *StatisticsForGetPolicyOutput) *GetPolicyOutput {
	s.Statistics = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *GetPolicyOutput) SetTargets(v *TargetsForGetPolicyOutput) *GetPolicyOutput {
	s.Targets = v
	return s
}

type SourceFlowForGetPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SourceFlowForGetPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceFlowForGetPolicyOutput) GoString() string {
	return s.String()
}

type StatisticsForGetPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ActiveAddr *int32 `type:"int32" json:",omitempty"`

	InactiveAddr *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StatisticsForGetPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatisticsForGetPolicyOutput) GoString() string {
	return s.String()
}

// SetActiveAddr sets the ActiveAddr field's value.
func (s *StatisticsForGetPolicyOutput) SetActiveAddr(v int32) *StatisticsForGetPolicyOutput {
	s.ActiveAddr = &v
	return s
}

// SetInactiveAddr sets the InactiveAddr field's value.
func (s *StatisticsForGetPolicyOutput) SetInactiveAddr(v int32) *StatisticsForGetPolicyOutput {
	s.InactiveAddr = &v
	return s
}

type TargetsForGetPolicyOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PoolId []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TargetsForGetPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetsForGetPolicyOutput) GoString() string {
	return s.String()
}

// SetPoolId sets the PoolId field's value.
func (s *TargetsForGetPolicyOutput) SetPoolId(v []*string) *TargetsForGetPolicyOutput {
	s.PoolId = v
	return s
}
