// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ga

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListIPSetsCommon = "ListIPSets"

// ListIPSetsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListIPSetsCommon operation. The "output" return
// value will be populated with the ListIPSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListIPSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListIPSetsCommon Send returns without error.
//
// See ListIPSetsCommon for more information on using the ListIPSetsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListIPSetsCommonRequest method.
//    req, resp := client.ListIPSetsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GA) ListIPSetsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListIPSetsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListIPSetsCommon API operation for GA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GA's
// API operation ListIPSetsCommon for usage and error information.
func (c *GA) ListIPSetsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListIPSetsCommonRequest(input)
	return out, req.Send()
}

// ListIPSetsCommonWithContext is the same as ListIPSetsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSetsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GA) ListIPSetsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListIPSetsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the ListIPSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListIPSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListIPSetsCommon Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GA) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	output = &ListIPSetsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListIPSets API operation for GA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GA's
// API operation ListIPSets for usage and error information.
func (c *GA) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GA) ListIPSetsWithContext(ctx volcengine.Context, input *ListIPSetsInput, opts ...request.Option) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type IPSetForListIPSetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccelerateRegion *string `type:"string" json:",omitempty"`

	AcceleratorId *string `type:"string" json:",omitempty"`

	IPSetId *string `type:"string" json:",omitempty"`

	IPVersion *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IPSetForListIPSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetForListIPSetsOutput) GoString() string {
	return s.String()
}

// SetAccelerateRegion sets the AccelerateRegion field's value.
func (s *IPSetForListIPSetsOutput) SetAccelerateRegion(v string) *IPSetForListIPSetsOutput {
	s.AccelerateRegion = &v
	return s
}

// SetAcceleratorId sets the AcceleratorId field's value.
func (s *IPSetForListIPSetsOutput) SetAcceleratorId(v string) *IPSetForListIPSetsOutput {
	s.AcceleratorId = &v
	return s
}

// SetIPSetId sets the IPSetId field's value.
func (s *IPSetForListIPSetsOutput) SetIPSetId(v string) *IPSetForListIPSetsOutput {
	s.IPSetId = &v
	return s
}

// SetIPVersion sets the IPVersion field's value.
func (s *IPSetForListIPSetsOutput) SetIPVersion(v string) *IPSetForListIPSetsOutput {
	s.IPVersion = &v
	return s
}

// SetState sets the State field's value.
func (s *IPSetForListIPSetsOutput) SetState(v string) *IPSetForListIPSetsOutput {
	s.State = &v
	return s
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// AcceleratorId is a required field
	AcceleratorId *string `type:"string" json:",omitempty" required:"true"`

	PageNum *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIPSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIPSetsInput"}
	if s.AcceleratorId == nil {
		invalidParams.Add(request.NewErrParamRequired("AcceleratorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorId sets the AcceleratorId field's value.
func (s *ListIPSetsInput) SetAcceleratorId(v string) *ListIPSetsInput {
	s.AcceleratorId = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListIPSetsInput) SetPageNum(v int32) *ListIPSetsInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListIPSetsInput) SetPageSize(v int32) *ListIPSetsInput {
	s.PageSize = &v
	return s
}

type ListIPSetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	IPSets []*IPSetForListIPSetsOutput `type:"list" json:",omitempty"`

	PageNum *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

// SetIPSets sets the IPSets field's value.
func (s *ListIPSetsOutput) SetIPSets(v []*IPSetForListIPSetsOutput) *ListIPSetsOutput {
	s.IPSets = v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListIPSetsOutput) SetPageNum(v int32) *ListIPSetsOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListIPSetsOutput) SetPageSize(v int32) *ListIPSetsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListIPSetsOutput) SetTotalCount(v int32) *ListIPSetsOutput {
	s.TotalCount = &v
	return s
}
