// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAssetListCommon = "AssetList"

// AssetListCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AssetListCommon operation. The "output" return
// value will be populated with the AssetListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AssetListCommon Request to send the API call to the service.
// the "output" return value is not valid until after AssetListCommon Send returns without error.
//
// See AssetListCommon for more information on using the AssetListCommon
// API call, and error handling.
//
//    // Example sending a request using the AssetListCommonRequest method.
//    req, resp := client.AssetListCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) AssetListCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAssetListCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AssetListCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation AssetListCommon for usage and error information.
func (c *FWCENTER) AssetListCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AssetListCommonRequest(input)
	return out, req.Send()
}

// AssetListCommonWithContext is the same as AssetListCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AssetListCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) AssetListCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AssetListCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssetList = "AssetList"

// AssetListRequest generates a "volcengine/request.Request" representing the
// client's request for the AssetList operation. The "output" return
// value will be populated with the AssetListCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AssetListCommon Request to send the API call to the service.
// the "output" return value is not valid until after AssetListCommon Send returns without error.
//
// See AssetList for more information on using the AssetList
// API call, and error handling.
//
//    // Example sending a request using the AssetListRequest method.
//    req, resp := client.AssetListRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) AssetListRequest(input *AssetListInput) (req *request.Request, output *AssetListOutput) {
	op := &request.Operation{
		Name:       opAssetList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssetListInput{}
	}

	output = &AssetListOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AssetList API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation AssetList for usage and error information.
func (c *FWCENTER) AssetList(input *AssetListInput) (*AssetListOutput, error) {
	req, out := c.AssetListRequest(input)
	return out, req.Send()
}

// AssetListWithContext is the same as AssetList with the addition of
// the ability to pass a context and additional request options.
//
// See AssetList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) AssetListWithContext(ctx volcengine.Context, input *AssetListInput, opts ...request.Option) (*AssetListOutput, error) {
	req, out := c.AssetListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssetListInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Asset *string `type:"string" json:"asset,omitempty"`

	Asset_type []*string `type:"list" json:"asset_type,omitempty"`

	Current_page *int32 `type:"int32" json:"current_page,omitempty"`

	Instance_type []*string `type:"list" json:"instance_type,omitempty"`

	InternetFirewallId *string `type:"string" json:",omitempty"`

	Ip_type *string `type:"string" json:"ip_type,omitempty" enum:"EnumOfip_typeForAssetListInput"`

	Order_dir *string `type:"string" json:"order_dir,omitempty" enum:"EnumOforder_dirForAssetListInput"`

	Page_size *int32 `max:"1e+06" type:"int32" json:"page_size,omitempty"`

	Region_code []*string `type:"list" json:"region_code,omitempty"`

	Stat *int32 `type:"int32" json:"stat,omitempty"`
}

// String returns the string representation
func (s AssetListInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssetListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssetListInput"}
	if s.Page_size != nil && *s.Page_size > 1e+06 {
		invalidParams.Add(request.NewErrParamMaxValue("Page_size", 1e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAsset sets the Asset field's value.
func (s *AssetListInput) SetAsset(v string) *AssetListInput {
	s.Asset = &v
	return s
}

// SetAsset_type sets the Asset_type field's value.
func (s *AssetListInput) SetAsset_type(v []*string) *AssetListInput {
	s.Asset_type = v
	return s
}

// SetCurrent_page sets the Current_page field's value.
func (s *AssetListInput) SetCurrent_page(v int32) *AssetListInput {
	s.Current_page = &v
	return s
}

// SetInstance_type sets the Instance_type field's value.
func (s *AssetListInput) SetInstance_type(v []*string) *AssetListInput {
	s.Instance_type = v
	return s
}

// SetInternetFirewallId sets the InternetFirewallId field's value.
func (s *AssetListInput) SetInternetFirewallId(v string) *AssetListInput {
	s.InternetFirewallId = &v
	return s
}

// SetIp_type sets the Ip_type field's value.
func (s *AssetListInput) SetIp_type(v string) *AssetListInput {
	s.Ip_type = &v
	return s
}

// SetOrder_dir sets the Order_dir field's value.
func (s *AssetListInput) SetOrder_dir(v string) *AssetListInput {
	s.Order_dir = &v
	return s
}

// SetPage_size sets the Page_size field's value.
func (s *AssetListInput) SetPage_size(v int32) *AssetListInput {
	s.Page_size = &v
	return s
}

// SetRegion_code sets the Region_code field's value.
func (s *AssetListInput) SetRegion_code(v []*string) *AssetListInput {
	s.Region_code = v
	return s
}

// SetStat sets the Stat field's value.
func (s *AssetListInput) SetStat(v int32) *AssetListInput {
	s.Stat = &v
	return s
}

type AssetListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	Data []*DataForAssetListOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s AssetListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssetListOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *AssetListOutput) SetCount(v int32) *AssetListOutput {
	s.Count = &v
	return s
}

// SetData sets the Data field's value.
func (s *AssetListOutput) SetData(v []*DataForAssetListOutput) *AssetListOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *AssetListOutput) SetPageNumber(v int32) *AssetListOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *AssetListOutput) SetPageSize(v int32) *AssetListOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *AssetListOutput) SetTotalCount(v int32) *AssetListOutput {
	s.TotalCount = &v
	return s
}

type DataForAssetListOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccountID *string `type:"string" json:",omitempty"`

	Eip_id *string `type:"string" json:"eip_id,omitempty"`

	Enable *bool `type:"boolean" json:"enable,omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	Instance_type *string `type:"string" json:"instance_type,omitempty"`

	Ip *string `type:"string" json:"ip,omitempty"`

	Ip_type *string `type:"string" json:"ip_type,omitempty"`

	Latest_7_days_peak_traffic *int32 `type:"int32" json:"latest_7_days_peak_traffic,omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Region *string `type:"string" json:"region,omitempty"`

	RegionN *string `type:"string" json:"regionN,omitempty"`

	Type *string `type:"string" json:"type,omitempty"`
}

// String returns the string representation
func (s DataForAssetListOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForAssetListOutput) GoString() string {
	return s.String()
}

// SetAccountID sets the AccountID field's value.
func (s *DataForAssetListOutput) SetAccountID(v string) *DataForAssetListOutput {
	s.AccountID = &v
	return s
}

// SetEip_id sets the Eip_id field's value.
func (s *DataForAssetListOutput) SetEip_id(v string) *DataForAssetListOutput {
	s.Eip_id = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *DataForAssetListOutput) SetEnable(v bool) *DataForAssetListOutput {
	s.Enable = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *DataForAssetListOutput) SetInstanceID(v string) *DataForAssetListOutput {
	s.InstanceID = &v
	return s
}

// SetInstance_type sets the Instance_type field's value.
func (s *DataForAssetListOutput) SetInstance_type(v string) *DataForAssetListOutput {
	s.Instance_type = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *DataForAssetListOutput) SetIp(v string) *DataForAssetListOutput {
	s.Ip = &v
	return s
}

// SetIp_type sets the Ip_type field's value.
func (s *DataForAssetListOutput) SetIp_type(v string) *DataForAssetListOutput {
	s.Ip_type = &v
	return s
}

// SetLatest_7_days_peak_traffic sets the Latest_7_days_peak_traffic field's value.
func (s *DataForAssetListOutput) SetLatest_7_days_peak_traffic(v int32) *DataForAssetListOutput {
	s.Latest_7_days_peak_traffic = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataForAssetListOutput) SetName(v string) *DataForAssetListOutput {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DataForAssetListOutput) SetRegion(v string) *DataForAssetListOutput {
	s.Region = &v
	return s
}

// SetRegionN sets the RegionN field's value.
func (s *DataForAssetListOutput) SetRegionN(v string) *DataForAssetListOutput {
	s.RegionN = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataForAssetListOutput) SetType(v string) *DataForAssetListOutput {
	s.Type = &v
	return s
}

const (
	// EnumOfip_typeForAssetListInputV4 is a EnumOfip_typeForAssetListInput enum value
	EnumOfip_typeForAssetListInputV4 = "v4"

	// EnumOfip_typeForAssetListInputV6 is a EnumOfip_typeForAssetListInput enum value
	EnumOfip_typeForAssetListInputV6 = "v6"
)

const (
	// EnumOforder_dirForAssetListInputAsc is a EnumOforder_dirForAssetListInput enum value
	EnumOforder_dirForAssetListInputAsc = "asc"

	// EnumOforder_dirForAssetListInputDesc is a EnumOforder_dirForAssetListInput enum value
	EnumOforder_dirForAssetListInputDesc = "desc"
)
