// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRenameInstanceCommon = "RenameInstance"

// RenameInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RenameInstanceCommon operation. The "output" return
// value will be populated with the RenameInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RenameInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RenameInstanceCommon Send returns without error.
//
// See RenameInstanceCommon for more information on using the RenameInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the RenameInstanceCommonRequest method.
//    req, resp := client.RenameInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) RenameInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRenameInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RenameInstanceCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation RenameInstanceCommon for usage and error information.
func (c *ESCLOUD) RenameInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RenameInstanceCommonRequest(input)
	return out, req.Send()
}

// RenameInstanceCommonWithContext is the same as RenameInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RenameInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) RenameInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RenameInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRenameInstance = "RenameInstance"

// RenameInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the RenameInstance operation. The "output" return
// value will be populated with the RenameInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RenameInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RenameInstanceCommon Send returns without error.
//
// See RenameInstance for more information on using the RenameInstance
// API call, and error handling.
//
//    // Example sending a request using the RenameInstanceRequest method.
//    req, resp := client.RenameInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) RenameInstanceRequest(input *RenameInstanceInput) (req *request.Request, output *RenameInstanceOutput) {
	op := &request.Operation{
		Name:       opRenameInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenameInstanceInput{}
	}

	output = &RenameInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RenameInstance API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation RenameInstance for usage and error information.
func (c *ESCLOUD) RenameInstance(input *RenameInstanceInput) (*RenameInstanceOutput, error) {
	req, out := c.RenameInstanceRequest(input)
	return out, req.Send()
}

// RenameInstanceWithContext is the same as RenameInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RenameInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) RenameInstanceWithContext(ctx volcengine.Context, input *RenameInstanceInput, opts ...request.Option) (*RenameInstanceOutput, error) {
	req, out := c.RenameInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RenameInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// NewName is a required field
	NewName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RenameInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenameInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenameInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenameInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.NewName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *RenameInstanceInput) SetInstanceId(v string) *RenameInstanceInput {
	s.InstanceId = &v
	return s
}

// SetNewName sets the NewName field's value.
func (s *RenameInstanceInput) SetNewName(v string) *RenameInstanceInput {
	s.NewName = &v
	return s
}

type RenameInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Message *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RenameInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenameInstanceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *RenameInstanceOutput) SetMessage(v string) *RenameInstanceOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RenameInstanceOutput) SetStatus(v string) *RenameInstanceOutput {
	s.Status = &v
	return s
}
