// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRunApplicationActionCommon = "RunApplicationAction"

// RunApplicationActionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RunApplicationActionCommon operation. The "output" return
// value will be populated with the RunApplicationActionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunApplicationActionCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunApplicationActionCommon Send returns without error.
//
// See RunApplicationActionCommon for more information on using the RunApplicationActionCommon
// API call, and error handling.
//
//    // Example sending a request using the RunApplicationActionCommonRequest method.
//    req, resp := client.RunApplicationActionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) RunApplicationActionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRunApplicationActionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RunApplicationActionCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation RunApplicationActionCommon for usage and error information.
func (c *EMR) RunApplicationActionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RunApplicationActionCommonRequest(input)
	return out, req.Send()
}

// RunApplicationActionCommonWithContext is the same as RunApplicationActionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RunApplicationActionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RunApplicationActionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RunApplicationActionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunApplicationAction = "RunApplicationAction"

// RunApplicationActionRequest generates a "volcengine/request.Request" representing the
// client's request for the RunApplicationAction operation. The "output" return
// value will be populated with the RunApplicationActionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunApplicationActionCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunApplicationActionCommon Send returns without error.
//
// See RunApplicationAction for more information on using the RunApplicationAction
// API call, and error handling.
//
//    // Example sending a request using the RunApplicationActionRequest method.
//    req, resp := client.RunApplicationActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) RunApplicationActionRequest(input *RunApplicationActionInput) (req *request.Request, output *RunApplicationActionOutput) {
	op := &request.Operation{
		Name:       opRunApplicationAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunApplicationActionInput{}
	}

	output = &RunApplicationActionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RunApplicationAction API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation RunApplicationAction for usage and error information.
func (c *EMR) RunApplicationAction(input *RunApplicationActionInput) (*RunApplicationActionOutput, error) {
	req, out := c.RunApplicationActionRequest(input)
	return out, req.Send()
}

// RunApplicationActionWithContext is the same as RunApplicationAction with the addition of
// the ability to pass a context and additional request options.
//
// See RunApplicationAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) RunApplicationActionWithContext(ctx volcengine.Context, input *RunApplicationActionInput, opts ...request.Option) (*RunApplicationActionOutput, error) {
	req, out := c.RunApplicationActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CommandParamForRunApplicationActionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CommandParamForRunApplicationActionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CommandParamForRunApplicationActionInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *CommandParamForRunApplicationActionInput) SetKey(v string) *CommandParamForRunApplicationActionInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CommandParamForRunApplicationActionInput) SetValue(v string) *CommandParamForRunApplicationActionInput {
	s.Value = &v
	return s
}

type ResultDataForRunApplicationActionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ResultDataForRunApplicationActionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultDataForRunApplicationActionOutput) GoString() string {
	return s.String()
}

type RunApplicationActionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ActionName is a required field
	ActionName *string `type:"string" json:",omitempty" required:"true"`

	// ApplicationName is a required field
	ApplicationName *string `type:"string" json:",omitempty" required:"true"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	CommandParams []*CommandParamForRunApplicationActionInput `type:"list" json:",omitempty"`

	ComponentName *string `type:"string" json:"componentName,omitempty"`

	// Remark is a required field
	Remark *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RunApplicationActionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunApplicationActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunApplicationActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunApplicationActionInput"}
	if s.ActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionName"))
	}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.Remark == nil {
		invalidParams.Add(request.NewErrParamRequired("Remark"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionName sets the ActionName field's value.
func (s *RunApplicationActionInput) SetActionName(v string) *RunApplicationActionInput {
	s.ActionName = &v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *RunApplicationActionInput) SetApplicationName(v string) *RunApplicationActionInput {
	s.ApplicationName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *RunApplicationActionInput) SetClientToken(v string) *RunApplicationActionInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *RunApplicationActionInput) SetClusterId(v string) *RunApplicationActionInput {
	s.ClusterId = &v
	return s
}

// SetCommandParams sets the CommandParams field's value.
func (s *RunApplicationActionInput) SetCommandParams(v []*CommandParamForRunApplicationActionInput) *RunApplicationActionInput {
	s.CommandParams = v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *RunApplicationActionInput) SetComponentName(v string) *RunApplicationActionInput {
	s.ComponentName = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *RunApplicationActionInput) SetRemark(v string) *RunApplicationActionInput {
	s.Remark = &v
	return s
}

type RunApplicationActionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ClusterId *string `type:"string" json:",omitempty"`

	OperationId *string `type:"string" json:",omitempty"`

	ResultData *ResultDataForRunApplicationActionOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RunApplicationActionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunApplicationActionOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *RunApplicationActionOutput) SetClusterId(v string) *RunApplicationActionOutput {
	s.ClusterId = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *RunApplicationActionOutput) SetOperationId(v string) *RunApplicationActionOutput {
	s.OperationId = &v
	return s
}

// SetResultData sets the ResultData field's value.
func (s *RunApplicationActionOutput) SetResultData(v *ResultDataForRunApplicationActionOutput) *RunApplicationActionOutput {
	s.ResultData = v
	return s
}
