// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNodesCommon = "ListNodes"

// ListNodesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodesCommon operation. The "output" return
// value will be populated with the ListNodesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodesCommon Send returns without error.
//
// See ListNodesCommon for more information on using the ListNodesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNodesCommonRequest method.
//    req, resp := client.ListNodesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListNodesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNodesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodesCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListNodesCommon for usage and error information.
func (c *EMR) ListNodesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNodesCommonRequest(input)
	return out, req.Send()
}

// ListNodesCommonWithContext is the same as ListNodesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListNodesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNodesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the ListNodesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodesCommon Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodes API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListNodes for usage and error information.
func (c *EMR) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListNodesWithContext(ctx volcengine.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListNodesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	CreateTime *int64 `type:"int64" json:",omitempty"`

	EcsInstanceType *string `type:"string" json:",omitempty"`

	NodeFqdn *string `type:"string" json:",omitempty"`

	NodeGroupId *string `type:"string" json:",omitempty"`

	NodeId *string `type:"string" json:",omitempty"`

	NodeName *string `type:"string" json:",omitempty"`

	NodeState *string `type:"string" json:",omitempty"`

	PrivateIp *string `type:"string" json:",omitempty"`

	PublicIp *string `type:"string" json:",omitempty"`

	ReadyTime *int64 `type:"int64" json:",omitempty"`

	TerminateTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListNodesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListNodesOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *ItemForListNodesOutput) SetClusterId(v string) *ItemForListNodesOutput {
	s.ClusterId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListNodesOutput) SetCreateTime(v int64) *ItemForListNodesOutput {
	s.CreateTime = &v
	return s
}

// SetEcsInstanceType sets the EcsInstanceType field's value.
func (s *ItemForListNodesOutput) SetEcsInstanceType(v string) *ItemForListNodesOutput {
	s.EcsInstanceType = &v
	return s
}

// SetNodeFqdn sets the NodeFqdn field's value.
func (s *ItemForListNodesOutput) SetNodeFqdn(v string) *ItemForListNodesOutput {
	s.NodeFqdn = &v
	return s
}

// SetNodeGroupId sets the NodeGroupId field's value.
func (s *ItemForListNodesOutput) SetNodeGroupId(v string) *ItemForListNodesOutput {
	s.NodeGroupId = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *ItemForListNodesOutput) SetNodeId(v string) *ItemForListNodesOutput {
	s.NodeId = &v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *ItemForListNodesOutput) SetNodeName(v string) *ItemForListNodesOutput {
	s.NodeName = &v
	return s
}

// SetNodeState sets the NodeState field's value.
func (s *ItemForListNodesOutput) SetNodeState(v string) *ItemForListNodesOutput {
	s.NodeState = &v
	return s
}

// SetPrivateIp sets the PrivateIp field's value.
func (s *ItemForListNodesOutput) SetPrivateIp(v string) *ItemForListNodesOutput {
	s.PrivateIp = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *ItemForListNodesOutput) SetPublicIp(v string) *ItemForListNodesOutput {
	s.PublicIp = &v
	return s
}

// SetReadyTime sets the ReadyTime field's value.
func (s *ItemForListNodesOutput) SetReadyTime(v int64) *ItemForListNodesOutput {
	s.ReadyTime = &v
	return s
}

// SetTerminateTime sets the TerminateTime field's value.
func (s *ItemForListNodesOutput) SetTerminateTime(v int64) *ItemForListNodesOutput {
	s.TerminateTime = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	Fqdns []*string `type:"list" json:",omitempty"`

	MaxResults *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	NodeGroupIds []*string `type:"list" json:",omitempty"`

	NodeIds []*string `type:"list" json:",omitempty"`

	NodeNames []*string `type:"list" json:",omitempty"`

	NodeStates []*string `type:"list" json:",omitempty"`

	PrivateIps []*string `type:"list" json:",omitempty"`

	PublicIps []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListNodesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MaxResults != nil && *s.MaxResults > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxResults", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListNodesInput) SetClusterId(v string) *ListNodesInput {
	s.ClusterId = &v
	return s
}

// SetFqdns sets the Fqdns field's value.
func (s *ListNodesInput) SetFqdns(v []*string) *ListNodesInput {
	s.Fqdns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesInput) SetMaxResults(v int32) *ListNodesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesInput) SetNextToken(v string) *ListNodesInput {
	s.NextToken = &v
	return s
}

// SetNodeGroupIds sets the NodeGroupIds field's value.
func (s *ListNodesInput) SetNodeGroupIds(v []*string) *ListNodesInput {
	s.NodeGroupIds = v
	return s
}

// SetNodeIds sets the NodeIds field's value.
func (s *ListNodesInput) SetNodeIds(v []*string) *ListNodesInput {
	s.NodeIds = v
	return s
}

// SetNodeNames sets the NodeNames field's value.
func (s *ListNodesInput) SetNodeNames(v []*string) *ListNodesInput {
	s.NodeNames = v
	return s
}

// SetNodeStates sets the NodeStates field's value.
func (s *ListNodesInput) SetNodeStates(v []*string) *ListNodesInput {
	s.NodeStates = v
	return s
}

// SetPrivateIps sets the PrivateIps field's value.
func (s *ListNodesInput) SetPrivateIps(v []*string) *ListNodesInput {
	s.PrivateIps = v
	return s
}

// SetPublicIps sets the PublicIps field's value.
func (s *ListNodesInput) SetPublicIps(v []*string) *ListNodesInput {
	s.PublicIps = v
	return s
}

type ListNodesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListNodesOutput `type:"list" json:",omitempty"`

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListNodesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListNodesOutput) SetItems(v []*ItemForListNodesOutput) *ListNodesOutput {
	s.Items = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodesOutput) SetMaxResults(v int32) *ListNodesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodesOutput) SetNextToken(v string) *ListNodesOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListNodesOutput) SetTotalCount(v int32) *ListNodesOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfNodeStateListForListNodesInputUnknown is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputUnknown = "UNKNOWN"

	// EnumOfNodeStateListForListNodesInputCreating is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputCreating = "CREATING"

	// EnumOfNodeStateListForListNodesInputRunning is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputRunning = "RUNNING"

	// EnumOfNodeStateListForListNodesInputStopping is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputStopping = "STOPPING"

	// EnumOfNodeStateListForListNodesInputStopped is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputStopped = "STOPPED"

	// EnumOfNodeStateListForListNodesInputRebooting is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputRebooting = "REBOOTING"

	// EnumOfNodeStateListForListNodesInputRebuilding is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputRebuilding = "REBUILDING"

	// EnumOfNodeStateListForListNodesInputDeleted is a EnumOfNodeStateListForListNodesInput enum value
	EnumOfNodeStateListForListNodesInputDeleted = "DELETED"
)
