// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNodeGroupCommon = "CreateNodeGroup"

// CreateNodeGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNodeGroupCommon operation. The "output" return
// value will be populated with the CreateNodeGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNodeGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNodeGroupCommon Send returns without error.
//
// See CreateNodeGroupCommon for more information on using the CreateNodeGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNodeGroupCommonRequest method.
//    req, resp := client.CreateNodeGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) CreateNodeGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNodeGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNodeGroupCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation CreateNodeGroupCommon for usage and error information.
func (c *EMR) CreateNodeGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNodeGroupCommonRequest(input)
	return out, req.Send()
}

// CreateNodeGroupCommonWithContext is the same as CreateNodeGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodeGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateNodeGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNodeGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNodeGroup = "CreateNodeGroup"

// CreateNodeGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNodeGroup operation. The "output" return
// value will be populated with the CreateNodeGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNodeGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNodeGroupCommon Send returns without error.
//
// See CreateNodeGroup for more information on using the CreateNodeGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateNodeGroupRequest method.
//    req, resp := client.CreateNodeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) CreateNodeGroupRequest(input *CreateNodeGroupInput) (req *request.Request, output *CreateNodeGroupOutput) {
	op := &request.Operation{
		Name:       opCreateNodeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNodeGroupInput{}
	}

	output = &CreateNodeGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNodeGroup API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation CreateNodeGroup for usage and error information.
func (c *EMR) CreateNodeGroup(input *CreateNodeGroupInput) (*CreateNodeGroupOutput, error) {
	req, out := c.CreateNodeGroupRequest(input)
	return out, req.Send()
}

// CreateNodeGroupWithContext is the same as CreateNodeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateNodeGroupWithContext(ctx volcengine.Context, input *CreateNodeGroupInput, opts ...request.Option) (*CreateNodeGroupOutput, error) {
	req, out := c.CreateNodeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApplicationLayoutForCreateNodeGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationName *string `type:"string" json:",omitempty"`

	LayoutComponentNames []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ApplicationLayoutForCreateNodeGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationLayoutForCreateNodeGroupInput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationLayoutForCreateNodeGroupInput) SetApplicationName(v string) *ApplicationLayoutForCreateNodeGroupInput {
	s.ApplicationName = &v
	return s
}

// SetLayoutComponentNames sets the LayoutComponentNames field's value.
func (s *ApplicationLayoutForCreateNodeGroupInput) SetLayoutComponentNames(v []*string) *ApplicationLayoutForCreateNodeGroupInput {
	s.LayoutComponentNames = v
	return s
}

type CreateNodeGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationLayouts []*ApplicationLayoutForCreateNodeGroupInput `type:"list" json:",omitempty"`

	// ChargeType is a required field
	ChargeType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfChargeTypeForCreateNodeGroupInput"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	DataDisks []*DataDiskForCreateNodeGroupInput `type:"list" json:",omitempty"`

	EcsInstanceTypes []*string `type:"list" json:",omitempty"`

	// NodeCount is a required field
	NodeCount *int32 `max:"1000" type:"int32" json:",omitempty" required:"true"`

	// NodeGroupName is a required field
	NodeGroupName *string `type:"string" json:",omitempty" required:"true"`

	// NodeGroupType is a required field
	NodeGroupType *string `type:"string" json:",omitempty" required:"true"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	SystemDisk *SystemDiskForCreateNodeGroupInput `type:"structure" json:",omitempty"`

	WithPublicIp *bool `type:"boolean" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateNodeGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodeGroupInput"}
	if s.ChargeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeType"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.NodeCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeCount"))
	}
	if s.NodeCount != nil && *s.NodeCount > 1000 {
		invalidParams.Add(request.NewErrParamMaxValue("NodeCount", 1000))
	}
	if s.NodeGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupName"))
	}
	if s.NodeGroupType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeGroupType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationLayouts sets the ApplicationLayouts field's value.
func (s *CreateNodeGroupInput) SetApplicationLayouts(v []*ApplicationLayoutForCreateNodeGroupInput) *CreateNodeGroupInput {
	s.ApplicationLayouts = v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateNodeGroupInput) SetChargeType(v string) *CreateNodeGroupInput {
	s.ChargeType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNodeGroupInput) SetClientToken(v string) *CreateNodeGroupInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateNodeGroupInput) SetClusterId(v string) *CreateNodeGroupInput {
	s.ClusterId = &v
	return s
}

// SetDataDisks sets the DataDisks field's value.
func (s *CreateNodeGroupInput) SetDataDisks(v []*DataDiskForCreateNodeGroupInput) *CreateNodeGroupInput {
	s.DataDisks = v
	return s
}

// SetEcsInstanceTypes sets the EcsInstanceTypes field's value.
func (s *CreateNodeGroupInput) SetEcsInstanceTypes(v []*string) *CreateNodeGroupInput {
	s.EcsInstanceTypes = v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *CreateNodeGroupInput) SetNodeCount(v int32) *CreateNodeGroupInput {
	s.NodeCount = &v
	return s
}

// SetNodeGroupName sets the NodeGroupName field's value.
func (s *CreateNodeGroupInput) SetNodeGroupName(v string) *CreateNodeGroupInput {
	s.NodeGroupName = &v
	return s
}

// SetNodeGroupType sets the NodeGroupType field's value.
func (s *CreateNodeGroupInput) SetNodeGroupType(v string) *CreateNodeGroupInput {
	s.NodeGroupType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateNodeGroupInput) SetSubnetIds(v []*string) *CreateNodeGroupInput {
	s.SubnetIds = v
	return s
}

// SetSystemDisk sets the SystemDisk field's value.
func (s *CreateNodeGroupInput) SetSystemDisk(v *SystemDiskForCreateNodeGroupInput) *CreateNodeGroupInput {
	s.SystemDisk = v
	return s
}

// SetWithPublicIp sets the WithPublicIp field's value.
func (s *CreateNodeGroupInput) SetWithPublicIp(v bool) *CreateNodeGroupInput {
	s.WithPublicIp = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *CreateNodeGroupInput) SetZoneId(v string) *CreateNodeGroupInput {
	s.ZoneId = &v
	return s
}

type CreateNodeGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ClusterId *string `type:"string" json:",omitempty"`

	OperationId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateNodeGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodeGroupOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateNodeGroupOutput) SetClusterId(v string) *CreateNodeGroupOutput {
	s.ClusterId = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *CreateNodeGroupOutput) SetOperationId(v string) *CreateNodeGroupOutput {
	s.OperationId = &v
	return s
}

type DataDiskForCreateNodeGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DataDiskForCreateNodeGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataDiskForCreateNodeGroupInput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DataDiskForCreateNodeGroupInput) SetCount(v int32) *DataDiskForCreateNodeGroupInput {
	s.Count = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DataDiskForCreateNodeGroupInput) SetSize(v int32) *DataDiskForCreateNodeGroupInput {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *DataDiskForCreateNodeGroupInput) SetVolumeType(v string) *DataDiskForCreateNodeGroupInput {
	s.VolumeType = &v
	return s
}

type SystemDiskForCreateNodeGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SystemDiskForCreateNodeGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemDiskForCreateNodeGroupInput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *SystemDiskForCreateNodeGroupInput) SetSize(v int32) *SystemDiskForCreateNodeGroupInput {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *SystemDiskForCreateNodeGroupInput) SetVolumeType(v string) *SystemDiskForCreateNodeGroupInput {
	s.VolumeType = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateNodeGroupInputPre is a EnumOfChargeTypeForCreateNodeGroupInput enum value
	EnumOfChargeTypeForCreateNodeGroupInputPre = "PRE"

	// EnumOfChargeTypeForCreateNodeGroupInputPost is a EnumOfChargeTypeForCreateNodeGroupInput enum value
	EnumOfChargeTypeForCreateNodeGroupInputPost = "POST"
)
