// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateClusterCommon = "CreateCluster"

// CreateClusterCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateClusterCommon operation. The "output" return
// value will be populated with the CreateClusterCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateClusterCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateClusterCommon Send returns without error.
//
// See CreateClusterCommon for more information on using the CreateClusterCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateClusterCommonRequest method.
//    req, resp := client.CreateClusterCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) CreateClusterCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateClusterCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateClusterCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation CreateClusterCommon for usage and error information.
func (c *EMR) CreateClusterCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateClusterCommonRequest(input)
	return out, req.Send()
}

// CreateClusterCommonWithContext is the same as CreateClusterCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateClusterCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateClusterCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the CreateClusterCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateClusterCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateClusterCommon Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateCluster API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation CreateCluster for usage and error information.
func (c *EMR) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) CreateClusterWithContext(ctx volcengine.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApplicationComponentLayoutForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentName *string `type:"string" json:",omitempty"`

	EffectiveScope *EffectiveScopeForCreateClusterInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApplicationComponentLayoutForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationComponentLayoutForCreateClusterInput) GoString() string {
	return s.String()
}

// SetComponentName sets the ComponentName field's value.
func (s *ApplicationComponentLayoutForCreateClusterInput) SetComponentName(v string) *ApplicationComponentLayoutForCreateClusterInput {
	s.ComponentName = &v
	return s
}

// SetEffectiveScope sets the EffectiveScope field's value.
func (s *ApplicationComponentLayoutForCreateClusterInput) SetEffectiveScope(v *EffectiveScopeForCreateClusterInput) *ApplicationComponentLayoutForCreateClusterInput {
	s.EffectiveScope = v
	return s
}

type ApplicationConfigForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentInstanceName *string `type:"string" json:",omitempty"`

	ComponentName *string `type:"string" json:",omitempty"`

	ConfigFileName *string `type:"string" json:",omitempty"`

	ConfigItemKey *string `type:"string" json:",omitempty"`

	ConfigItemValue *string `type:"string" json:",omitempty"`

	Deleted *bool `type:"boolean" json:",omitempty"`

	EffectiveScope *EffectiveScopeForCreateClusterInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApplicationConfigForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationConfigForCreateClusterInput) GoString() string {
	return s.String()
}

// SetComponentInstanceName sets the ComponentInstanceName field's value.
func (s *ApplicationConfigForCreateClusterInput) SetComponentInstanceName(v string) *ApplicationConfigForCreateClusterInput {
	s.ComponentInstanceName = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ApplicationConfigForCreateClusterInput) SetComponentName(v string) *ApplicationConfigForCreateClusterInput {
	s.ComponentName = &v
	return s
}

// SetConfigFileName sets the ConfigFileName field's value.
func (s *ApplicationConfigForCreateClusterInput) SetConfigFileName(v string) *ApplicationConfigForCreateClusterInput {
	s.ConfigFileName = &v
	return s
}

// SetConfigItemKey sets the ConfigItemKey field's value.
func (s *ApplicationConfigForCreateClusterInput) SetConfigItemKey(v string) *ApplicationConfigForCreateClusterInput {
	s.ConfigItemKey = &v
	return s
}

// SetConfigItemValue sets the ConfigItemValue field's value.
func (s *ApplicationConfigForCreateClusterInput) SetConfigItemValue(v string) *ApplicationConfigForCreateClusterInput {
	s.ConfigItemValue = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ApplicationConfigForCreateClusterInput) SetDeleted(v bool) *ApplicationConfigForCreateClusterInput {
	s.Deleted = &v
	return s
}

// SetEffectiveScope sets the EffectiveScope field's value.
func (s *ApplicationConfigForCreateClusterInput) SetEffectiveScope(v *EffectiveScopeForCreateClusterInput) *ApplicationConfigForCreateClusterInput {
	s.EffectiveScope = v
	return s
}

type ApplicationExtraForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationComponentLayouts []*ApplicationComponentLayoutForCreateClusterInput `type:"list" json:",omitempty"`

	ApplicationConfigs []*ApplicationConfigForCreateClusterInput `type:"list" json:",omitempty"`

	ApplicationName *string `type:"string" json:",omitempty"`

	ConnectionId *string `type:"string" json:",omitempty"`

	ConnectionType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ApplicationExtraForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationExtraForCreateClusterInput) GoString() string {
	return s.String()
}

// SetApplicationComponentLayouts sets the ApplicationComponentLayouts field's value.
func (s *ApplicationExtraForCreateClusterInput) SetApplicationComponentLayouts(v []*ApplicationComponentLayoutForCreateClusterInput) *ApplicationExtraForCreateClusterInput {
	s.ApplicationComponentLayouts = v
	return s
}

// SetApplicationConfigs sets the ApplicationConfigs field's value.
func (s *ApplicationExtraForCreateClusterInput) SetApplicationConfigs(v []*ApplicationConfigForCreateClusterInput) *ApplicationExtraForCreateClusterInput {
	s.ApplicationConfigs = v
	return s
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ApplicationExtraForCreateClusterInput) SetApplicationName(v string) *ApplicationExtraForCreateClusterInput {
	s.ApplicationName = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *ApplicationExtraForCreateClusterInput) SetConnectionId(v string) *ApplicationExtraForCreateClusterInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *ApplicationExtraForCreateClusterInput) SetConnectionType(v string) *ApplicationExtraForCreateClusterInput {
	s.ConnectionType = &v
	return s
}

type BootstrapScriptForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EffectiveScope *EffectiveScopeForCreateClusterInput `type:"structure" json:",omitempty"`

	ExecutionFailStrategy *string `type:"string" json:",omitempty" enum:"EnumOfExecutionFailStrategyForCreateClusterInput"`

	ExecutionMoment *string `type:"string" json:",omitempty" enum:"EnumOfExecutionMomentForCreateClusterInput"`

	Priority *string `min:"1" max:"1000" type:"string" json:",omitempty"`

	ScriptArgs *string `type:"string" json:",omitempty"`

	ScriptName *string `type:"string" json:",omitempty"`

	ScriptPath *string `type:"string" json:",omitempty"`

	ScriptType *string `type:"string" json:",omitempty" enum:"EnumOfScriptTypeForCreateClusterInput"`
}

// String returns the string representation
func (s BootstrapScriptForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapScriptForCreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BootstrapScriptForCreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BootstrapScriptForCreateClusterInput"}
	if s.Priority != nil && len(*s.Priority) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Priority", 1))
	}
	if s.Priority != nil && len(*s.Priority) > 1000 {
		invalidParams.Add(request.NewErrParamMaxLen("Priority", 1000, *s.Priority))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffectiveScope sets the EffectiveScope field's value.
func (s *BootstrapScriptForCreateClusterInput) SetEffectiveScope(v *EffectiveScopeForCreateClusterInput) *BootstrapScriptForCreateClusterInput {
	s.EffectiveScope = v
	return s
}

// SetExecutionFailStrategy sets the ExecutionFailStrategy field's value.
func (s *BootstrapScriptForCreateClusterInput) SetExecutionFailStrategy(v string) *BootstrapScriptForCreateClusterInput {
	s.ExecutionFailStrategy = &v
	return s
}

// SetExecutionMoment sets the ExecutionMoment field's value.
func (s *BootstrapScriptForCreateClusterInput) SetExecutionMoment(v string) *BootstrapScriptForCreateClusterInput {
	s.ExecutionMoment = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *BootstrapScriptForCreateClusterInput) SetPriority(v string) *BootstrapScriptForCreateClusterInput {
	s.Priority = &v
	return s
}

// SetScriptArgs sets the ScriptArgs field's value.
func (s *BootstrapScriptForCreateClusterInput) SetScriptArgs(v string) *BootstrapScriptForCreateClusterInput {
	s.ScriptArgs = &v
	return s
}

// SetScriptName sets the ScriptName field's value.
func (s *BootstrapScriptForCreateClusterInput) SetScriptName(v string) *BootstrapScriptForCreateClusterInput {
	s.ScriptName = &v
	return s
}

// SetScriptPath sets the ScriptPath field's value.
func (s *BootstrapScriptForCreateClusterInput) SetScriptPath(v string) *BootstrapScriptForCreateClusterInput {
	s.ScriptPath = &v
	return s
}

// SetScriptType sets the ScriptType field's value.
func (s *BootstrapScriptForCreateClusterInput) SetScriptType(v string) *BootstrapScriptForCreateClusterInput {
	s.ScriptType = &v
	return s
}

type ChargePreConfigForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	AutoRenewPeriod *int32 `type:"int32" json:",omitempty"`

	AutoRenewPeriodUnit *string `type:"string" json:",omitempty" enum:"EnumOfAutoRenewPeriodUnitForCreateClusterInput"`

	ChargePeriod *int32 `type:"int32" json:",omitempty"`

	ChargePeriodUnit *string `type:"string" json:",omitempty" enum:"EnumOfChargePeriodUnitForCreateClusterInput"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForCreateClusterInput"`
}

// String returns the string representation
func (s ChargePreConfigForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ChargePreConfigForCreateClusterInput) GoString() string {
	return s.String()
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *ChargePreConfigForCreateClusterInput) SetAutoRenew(v bool) *ChargePreConfigForCreateClusterInput {
	s.AutoRenew = &v
	return s
}

// SetAutoRenewPeriod sets the AutoRenewPeriod field's value.
func (s *ChargePreConfigForCreateClusterInput) SetAutoRenewPeriod(v int32) *ChargePreConfigForCreateClusterInput {
	s.AutoRenewPeriod = &v
	return s
}

// SetAutoRenewPeriodUnit sets the AutoRenewPeriodUnit field's value.
func (s *ChargePreConfigForCreateClusterInput) SetAutoRenewPeriodUnit(v string) *ChargePreConfigForCreateClusterInput {
	s.AutoRenewPeriodUnit = &v
	return s
}

// SetChargePeriod sets the ChargePeriod field's value.
func (s *ChargePreConfigForCreateClusterInput) SetChargePeriod(v int32) *ChargePreConfigForCreateClusterInput {
	s.ChargePeriod = &v
	return s
}

// SetChargePeriodUnit sets the ChargePeriodUnit field's value.
func (s *ChargePreConfigForCreateClusterInput) SetChargePeriodUnit(v string) *ChargePreConfigForCreateClusterInput {
	s.ChargePeriodUnit = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *ChargePreConfigForCreateClusterInput) SetChargeType(v string) *ChargePreConfigForCreateClusterInput {
	s.ChargeType = &v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationExtras []*ApplicationExtraForCreateClusterInput `type:"list" json:",omitempty"`

	ApplicationNames []*string `type:"list" json:",omitempty"`

	BootstrapScripts []*BootstrapScriptForCreateClusterInput `type:"list" json:",omitempty"`

	ChargePreConfig *ChargePreConfigForCreateClusterInput `type:"structure" json:",omitempty"`

	// ChargeType is a required field
	ChargeType *string `type:"string" json:",omitempty" required:"true"`

	// ClusterName is a required field
	ClusterName *string `type:"string" json:",omitempty" required:"true"`

	// ClusterType is a required field
	ClusterType *string `type:"string" json:",omitempty" required:"true"`

	DeployMode *string `type:"string" json:",omitempty"`

	HistoryServerMode *string `type:"string" json:",omitempty"`

	NodeAttribute *NodeAttributeForCreateClusterInput `type:"structure" json:",omitempty"`

	NodeGroupAttributes []*NodeGroupAttributeForCreateClusterInput `type:"list" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	// ReleaseVersion is a required field
	ReleaseVersion *string `type:"string" json:",omitempty" required:"true"`

	// SecurityGroupId is a required field
	SecurityGroupId *string `type:"string" json:",omitempty" required:"true"`

	SecurityMode *string `type:"string" json:",omitempty"`

	Tags []*string `type:"list" json:",omitempty"`

	// VpcId is a required field
	VpcId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ChargeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeType"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterType == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterType"))
	}
	if s.ReleaseVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ReleaseVersion"))
	}
	if s.SecurityGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupId"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.BootstrapScripts != nil {
		for i, v := range s.BootstrapScripts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BootstrapScripts", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationExtras sets the ApplicationExtras field's value.
func (s *CreateClusterInput) SetApplicationExtras(v []*ApplicationExtraForCreateClusterInput) *CreateClusterInput {
	s.ApplicationExtras = v
	return s
}

// SetApplicationNames sets the ApplicationNames field's value.
func (s *CreateClusterInput) SetApplicationNames(v []*string) *CreateClusterInput {
	s.ApplicationNames = v
	return s
}

// SetBootstrapScripts sets the BootstrapScripts field's value.
func (s *CreateClusterInput) SetBootstrapScripts(v []*BootstrapScriptForCreateClusterInput) *CreateClusterInput {
	s.BootstrapScripts = v
	return s
}

// SetChargePreConfig sets the ChargePreConfig field's value.
func (s *CreateClusterInput) SetChargePreConfig(v *ChargePreConfigForCreateClusterInput) *CreateClusterInput {
	s.ChargePreConfig = v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateClusterInput) SetChargeType(v string) *CreateClusterInput {
	s.ChargeType = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetClusterType sets the ClusterType field's value.
func (s *CreateClusterInput) SetClusterType(v string) *CreateClusterInput {
	s.ClusterType = &v
	return s
}

// SetDeployMode sets the DeployMode field's value.
func (s *CreateClusterInput) SetDeployMode(v string) *CreateClusterInput {
	s.DeployMode = &v
	return s
}

// SetHistoryServerMode sets the HistoryServerMode field's value.
func (s *CreateClusterInput) SetHistoryServerMode(v string) *CreateClusterInput {
	s.HistoryServerMode = &v
	return s
}

// SetNodeAttribute sets the NodeAttribute field's value.
func (s *CreateClusterInput) SetNodeAttribute(v *NodeAttributeForCreateClusterInput) *CreateClusterInput {
	s.NodeAttribute = v
	return s
}

// SetNodeGroupAttributes sets the NodeGroupAttributes field's value.
func (s *CreateClusterInput) SetNodeGroupAttributes(v []*NodeGroupAttributeForCreateClusterInput) *CreateClusterInput {
	s.NodeGroupAttributes = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateClusterInput) SetProjectName(v string) *CreateClusterInput {
	s.ProjectName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *CreateClusterInput) SetReleaseVersion(v string) *CreateClusterInput {
	s.ReleaseVersion = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *CreateClusterInput) SetSecurityGroupId(v string) *CreateClusterInput {
	s.SecurityGroupId = &v
	return s
}

// SetSecurityMode sets the SecurityMode field's value.
func (s *CreateClusterInput) SetSecurityMode(v string) *CreateClusterInput {
	s.SecurityMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateClusterInput) SetVpcId(v string) *CreateClusterInput {
	s.VpcId = &v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ClusterId *string `type:"string" json:",omitempty"`

	OperationId *string `type:"string" json:",omitempty"`

	ResultData *ResultDataForCreateClusterOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateClusterOutput) SetClusterId(v string) *CreateClusterOutput {
	s.ClusterId = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *CreateClusterOutput) SetOperationId(v string) *CreateClusterOutput {
	s.OperationId = &v
	return s
}

// SetResultData sets the ResultData field's value.
func (s *CreateClusterOutput) SetResultData(v *ResultDataForCreateClusterOutput) *CreateClusterOutput {
	s.ResultData = v
	return s
}

type DataDiskForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DataDiskForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataDiskForCreateClusterInput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DataDiskForCreateClusterInput) SetCount(v int32) *DataDiskForCreateClusterInput {
	s.Count = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DataDiskForCreateClusterInput) SetSize(v int32) *DataDiskForCreateClusterInput {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *DataDiskForCreateClusterInput) SetVolumeType(v string) *DataDiskForCreateClusterInput {
	s.VolumeType = &v
	return s
}

type EffectiveScopeForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentNames []*string `type:"list" json:",omitempty"`

	EffectiveType *string `type:"string" json:",omitempty" enum:"EnumOfEffectiveTypeForCreateClusterInput"`

	NodeGroupIds []*string `type:"list" json:",omitempty"`

	NodeGroupNames []*string `type:"list" json:",omitempty"`

	NodeGroupTypes []*string `type:"list" json:",omitempty"`

	NodeIds []*string `type:"list" json:",omitempty"`

	NodeNames []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s EffectiveScopeForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectiveScopeForCreateClusterInput) GoString() string {
	return s.String()
}

// SetComponentNames sets the ComponentNames field's value.
func (s *EffectiveScopeForCreateClusterInput) SetComponentNames(v []*string) *EffectiveScopeForCreateClusterInput {
	s.ComponentNames = v
	return s
}

// SetEffectiveType sets the EffectiveType field's value.
func (s *EffectiveScopeForCreateClusterInput) SetEffectiveType(v string) *EffectiveScopeForCreateClusterInput {
	s.EffectiveType = &v
	return s
}

// SetNodeGroupIds sets the NodeGroupIds field's value.
func (s *EffectiveScopeForCreateClusterInput) SetNodeGroupIds(v []*string) *EffectiveScopeForCreateClusterInput {
	s.NodeGroupIds = v
	return s
}

// SetNodeGroupNames sets the NodeGroupNames field's value.
func (s *EffectiveScopeForCreateClusterInput) SetNodeGroupNames(v []*string) *EffectiveScopeForCreateClusterInput {
	s.NodeGroupNames = v
	return s
}

// SetNodeGroupTypes sets the NodeGroupTypes field's value.
func (s *EffectiveScopeForCreateClusterInput) SetNodeGroupTypes(v []*string) *EffectiveScopeForCreateClusterInput {
	s.NodeGroupTypes = v
	return s
}

// SetNodeIds sets the NodeIds field's value.
func (s *EffectiveScopeForCreateClusterInput) SetNodeIds(v []*string) *EffectiveScopeForCreateClusterInput {
	s.NodeIds = v
	return s
}

// SetNodeNames sets the NodeNames field's value.
func (s *EffectiveScopeForCreateClusterInput) SetNodeNames(v []*string) *EffectiveScopeForCreateClusterInput {
	s.NodeNames = v
	return s
}

type NodeAttributeForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EcsIamRole *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAttributeForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAttributeForCreateClusterInput) GoString() string {
	return s.String()
}

// SetEcsIamRole sets the EcsIamRole field's value.
func (s *NodeAttributeForCreateClusterInput) SetEcsIamRole(v string) *NodeAttributeForCreateClusterInput {
	s.EcsIamRole = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeAttributeForCreateClusterInput) SetZoneId(v string) *NodeAttributeForCreateClusterInput {
	s.ZoneId = &v
	return s
}

type NodeGroupAttributeForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `type:"int32" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForCreateClusterInput"`

	DataDisks []*DataDiskForCreateClusterInput `type:"list" json:",omitempty"`

	EcsInstanceTypes []*string `type:"list" json:",omitempty"`

	EcsKeyPairName *string `type:"string" json:",omitempty"`

	EcsPassword *string `type:"string" json:",omitempty"`

	NodeCount *int32 `type:"int32" json:",omitempty"`

	NodeGroupName *string `type:"string" json:",omitempty"`

	NodeGroupType *string `type:"string" json:",omitempty" enum:"EnumOfNodeGroupTypeForCreateClusterInput"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	SystemDisk *SystemDiskForCreateClusterInput `type:"structure" json:",omitempty"`

	WithPublicIp *bool `type:"boolean" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeGroupAttributeForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeGroupAttributeForCreateClusterInput) GoString() string {
	return s.String()
}

// SetBandwidth sets the Bandwidth field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetBandwidth(v int32) *NodeGroupAttributeForCreateClusterInput {
	s.Bandwidth = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetChargeType(v string) *NodeGroupAttributeForCreateClusterInput {
	s.ChargeType = &v
	return s
}

// SetDataDisks sets the DataDisks field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetDataDisks(v []*DataDiskForCreateClusterInput) *NodeGroupAttributeForCreateClusterInput {
	s.DataDisks = v
	return s
}

// SetEcsInstanceTypes sets the EcsInstanceTypes field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetEcsInstanceTypes(v []*string) *NodeGroupAttributeForCreateClusterInput {
	s.EcsInstanceTypes = v
	return s
}

// SetEcsKeyPairName sets the EcsKeyPairName field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetEcsKeyPairName(v string) *NodeGroupAttributeForCreateClusterInput {
	s.EcsKeyPairName = &v
	return s
}

// SetEcsPassword sets the EcsPassword field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetEcsPassword(v string) *NodeGroupAttributeForCreateClusterInput {
	s.EcsPassword = &v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetNodeCount(v int32) *NodeGroupAttributeForCreateClusterInput {
	s.NodeCount = &v
	return s
}

// SetNodeGroupName sets the NodeGroupName field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetNodeGroupName(v string) *NodeGroupAttributeForCreateClusterInput {
	s.NodeGroupName = &v
	return s
}

// SetNodeGroupType sets the NodeGroupType field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetNodeGroupType(v string) *NodeGroupAttributeForCreateClusterInput {
	s.NodeGroupType = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetSubnetIds(v []*string) *NodeGroupAttributeForCreateClusterInput {
	s.SubnetIds = v
	return s
}

// SetSystemDisk sets the SystemDisk field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetSystemDisk(v *SystemDiskForCreateClusterInput) *NodeGroupAttributeForCreateClusterInput {
	s.SystemDisk = v
	return s
}

// SetWithPublicIp sets the WithPublicIp field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetWithPublicIp(v bool) *NodeGroupAttributeForCreateClusterInput {
	s.WithPublicIp = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *NodeGroupAttributeForCreateClusterInput) SetZoneId(v string) *NodeGroupAttributeForCreateClusterInput {
	s.ZoneId = &v
	return s
}

type ResultDataForCreateClusterOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ResultDataForCreateClusterOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultDataForCreateClusterOutput) GoString() string {
	return s.String()
}

type SystemDiskForCreateClusterInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SystemDiskForCreateClusterInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemDiskForCreateClusterInput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *SystemDiskForCreateClusterInput) SetSize(v int32) *SystemDiskForCreateClusterInput {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *SystemDiskForCreateClusterInput) SetVolumeType(v string) *SystemDiskForCreateClusterInput {
	s.VolumeType = &v
	return s
}

const (
	// EnumOfAutoRenewPeriodUnitForCreateClusterInputMonth is a EnumOfAutoRenewPeriodUnitForCreateClusterInput enum value
	EnumOfAutoRenewPeriodUnitForCreateClusterInputMonth = "Month"

	// EnumOfAutoRenewPeriodUnitForCreateClusterInputYear is a EnumOfAutoRenewPeriodUnitForCreateClusterInput enum value
	EnumOfAutoRenewPeriodUnitForCreateClusterInputYear = "Year"
)

const (
	// EnumOfChargePeriodUnitForCreateClusterInputMonth is a EnumOfChargePeriodUnitForCreateClusterInput enum value
	EnumOfChargePeriodUnitForCreateClusterInputMonth = "Month"

	// EnumOfChargePeriodUnitForCreateClusterInputYear is a EnumOfChargePeriodUnitForCreateClusterInput enum value
	EnumOfChargePeriodUnitForCreateClusterInputYear = "Year"
)

const (
	// EnumOfChargeTypeForCreateClusterInputPre is a EnumOfChargeTypeForCreateClusterInput enum value
	EnumOfChargeTypeForCreateClusterInputPre = "PRE"

	// EnumOfChargeTypeForCreateClusterInputPost is a EnumOfChargeTypeForCreateClusterInput enum value
	EnumOfChargeTypeForCreateClusterInputPost = "POST"
)

const (
	// EnumOfEffectiveTypeForCreateClusterInputCluster is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputCluster = "CLUSTER"

	// EnumOfEffectiveTypeForCreateClusterInputNodeGroupName is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputNodeGroupName = "NODE_GROUP_NAME"

	// EnumOfEffectiveTypeForCreateClusterInputNodeGroupId is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputNodeGroupId = "NODE_GROUP_ID"

	// EnumOfEffectiveTypeForCreateClusterInputNodeGroupType is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputNodeGroupType = "NODE_GROUP_TYPE"

	// EnumOfEffectiveTypeForCreateClusterInputNodeName is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputNodeName = "NODE_NAME"

	// EnumOfEffectiveTypeForCreateClusterInputNodeId is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputNodeId = "NODE_ID"

	// EnumOfEffectiveTypeForCreateClusterInputComponentName is a EnumOfEffectiveTypeForCreateClusterInput enum value
	EnumOfEffectiveTypeForCreateClusterInputComponentName = "COMPONENT_NAME"
)

const (
	// EnumOfExecutionFailStrategyForCreateClusterInputFailedContinue is a EnumOfExecutionFailStrategyForCreateClusterInput enum value
	EnumOfExecutionFailStrategyForCreateClusterInputFailedContinue = "FAILED_CONTINUE"

	// EnumOfExecutionFailStrategyForCreateClusterInputFailedBlock is a EnumOfExecutionFailStrategyForCreateClusterInput enum value
	EnumOfExecutionFailStrategyForCreateClusterInputFailedBlock = "FAILED_BLOCK"
)

const (
	// EnumOfExecutionMomentForCreateClusterInputBeforeApplicationInstall is a EnumOfExecutionMomentForCreateClusterInput enum value
	EnumOfExecutionMomentForCreateClusterInputBeforeApplicationInstall = "BEFORE_APPLICATION_INSTALL"

	// EnumOfExecutionMomentForCreateClusterInputAfterApplicationStarted is a EnumOfExecutionMomentForCreateClusterInput enum value
	EnumOfExecutionMomentForCreateClusterInputAfterApplicationStarted = "AFTER_APPLICATION_STARTED"
)

const (
	// EnumOfNodeGroupTypeForCreateClusterInputMaster is a EnumOfNodeGroupTypeForCreateClusterInput enum value
	EnumOfNodeGroupTypeForCreateClusterInputMaster = "MASTER"

	// EnumOfNodeGroupTypeForCreateClusterInputCore is a EnumOfNodeGroupTypeForCreateClusterInput enum value
	EnumOfNodeGroupTypeForCreateClusterInputCore = "CORE"

	// EnumOfNodeGroupTypeForCreateClusterInputTask is a EnumOfNodeGroupTypeForCreateClusterInput enum value
	EnumOfNodeGroupTypeForCreateClusterInputTask = "TASK"
)

const (
	// EnumOfScriptTypeForCreateClusterInputNormal is a EnumOfScriptTypeForCreateClusterInput enum value
	EnumOfScriptTypeForCreateClusterInputNormal = "NORMAL"

	// EnumOfScriptTypeForCreateClusterInputBootstrap is a EnumOfScriptTypeForCreateClusterInput enum value
	EnumOfScriptTypeForCreateClusterInputBootstrap = "BOOTSTRAP"
)
