// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package edx

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListEDXCommon = "ListEDX"

// ListEDXCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListEDXCommon operation. The "output" return
// value will be populated with the ListEDXCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListEDXCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListEDXCommon Send returns without error.
//
// See ListEDXCommon for more information on using the ListEDXCommon
// API call, and error handling.
//
//    // Example sending a request using the ListEDXCommonRequest method.
//    req, resp := client.ListEDXCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) ListEDXCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListEDXCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListEDXCommon API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation ListEDXCommon for usage and error information.
func (c *EDX) ListEDXCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListEDXCommonRequest(input)
	return out, req.Send()
}

// ListEDXCommonWithContext is the same as ListEDXCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListEDXCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) ListEDXCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListEDXCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEDX = "ListEDX"

// ListEDXRequest generates a "volcengine/request.Request" representing the
// client's request for the ListEDX operation. The "output" return
// value will be populated with the ListEDXCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListEDXCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListEDXCommon Send returns without error.
//
// See ListEDX for more information on using the ListEDX
// API call, and error handling.
//
//    // Example sending a request using the ListEDXRequest method.
//    req, resp := client.ListEDXRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) ListEDXRequest(input *ListEDXInput) (req *request.Request, output *ListEDXOutput) {
	op := &request.Operation{
		Name:       opListEDX,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEDXInput{}
	}

	output = &ListEDXOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListEDX API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation ListEDX for usage and error information.
func (c *EDX) ListEDX(input *ListEDXInput) (*ListEDXOutput, error) {
	req, out := c.ListEDXRequest(input)
	return out, req.Send()
}

// ListEDXWithContext is the same as ListEDX with the addition of
// the ability to pass a context and additional request options.
//
// See ListEDX for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) ListEDXWithContext(ctx volcengine.Context, input *ListEDXInput, opts ...request.Option) (*ListEDXOutput, error) {
	req, out := c.ListEDXRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListEDXInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListEDXInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEDXInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEDXInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEDXInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ListEDXInput) SetInstanceId(v string) *ListEDXInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListEDXInput) SetName(v string) *ListEDXInput {
	s.Name = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListEDXInput) SetPageNumber(v int32) *ListEDXInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListEDXInput) SetPageSize(v int32) *ListEDXInput {
	s.PageSize = &v
	return s
}

type ListEDXOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	EDXList []*ListForListEDXOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListEDXOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEDXOutput) GoString() string {
	return s.String()
}

// SetEDXList sets the EDXList field's value.
func (s *ListEDXOutput) SetEDXList(v []*ListForListEDXOutput) *ListEDXOutput {
	s.EDXList = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListEDXOutput) SetPageNumber(v int32) *ListEDXOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListEDXOutput) SetPageSize(v int32) *ListEDXOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListEDXOutput) SetTotalCount(v int32) *ListEDXOutput {
	s.TotalCount = &v
	return s
}

type ListForListEDXOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AssociatedBandwidthPkgCount *int32 `type:"int32" json:",omitempty"`

	AssociatedVGWCount *int32 `type:"int32" json:",omitempty"`

	EDX *ForListEDXOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ListForListEDXOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForListEDXOutput) GoString() string {
	return s.String()
}

// SetAssociatedBandwidthPkgCount sets the AssociatedBandwidthPkgCount field's value.
func (s *ListForListEDXOutput) SetAssociatedBandwidthPkgCount(v int32) *ListForListEDXOutput {
	s.AssociatedBandwidthPkgCount = &v
	return s
}

// SetAssociatedVGWCount sets the AssociatedVGWCount field's value.
func (s *ListForListEDXOutput) SetAssociatedVGWCount(v int32) *ListForListEDXOutput {
	s.AssociatedVGWCount = &v
	return s
}

// SetEDX sets the EDX field's value.
func (s *ListForListEDXOutput) SetEDX(v *ForListEDXOutput) *ListForListEDXOutput {
	s.EDX = v
	return s
}
