// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package edx

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateVirtualInterfaceCommon = "CreateVirtualInterface"

// CreateVirtualInterfaceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateVirtualInterfaceCommon operation. The "output" return
// value will be populated with the CreateVirtualInterfaceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateVirtualInterfaceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateVirtualInterfaceCommon Send returns without error.
//
// See CreateVirtualInterfaceCommon for more information on using the CreateVirtualInterfaceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateVirtualInterfaceCommonRequest method.
//    req, resp := client.CreateVirtualInterfaceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) CreateVirtualInterfaceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateVirtualInterfaceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateVirtualInterfaceCommon API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation CreateVirtualInterfaceCommon for usage and error information.
func (c *EDX) CreateVirtualInterfaceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateVirtualInterfaceCommonRequest(input)
	return out, req.Send()
}

// CreateVirtualInterfaceCommonWithContext is the same as CreateVirtualInterfaceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualInterfaceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) CreateVirtualInterfaceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateVirtualInterfaceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVirtualInterface = "CreateVirtualInterface"

// CreateVirtualInterfaceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateVirtualInterface operation. The "output" return
// value will be populated with the CreateVirtualInterfaceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateVirtualInterfaceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateVirtualInterfaceCommon Send returns without error.
//
// See CreateVirtualInterface for more information on using the CreateVirtualInterface
// API call, and error handling.
//
//    // Example sending a request using the CreateVirtualInterfaceRequest method.
//    req, resp := client.CreateVirtualInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EDX) CreateVirtualInterfaceRequest(input *CreateVirtualInterfaceInput) (req *request.Request, output *CreateVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVirtualInterfaceInput{}
	}

	output = &CreateVirtualInterfaceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateVirtualInterface API operation for EDX.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EDX's
// API operation CreateVirtualInterface for usage and error information.
func (c *EDX) CreateVirtualInterface(input *CreateVirtualInterfaceInput) (*CreateVirtualInterfaceOutput, error) {
	req, out := c.CreateVirtualInterfaceRequest(input)
	return out, req.Send()
}

// CreateVirtualInterfaceWithContext is the same as CreateVirtualInterface with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVirtualInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EDX) CreateVirtualInterfaceWithContext(ctx volcengine.Context, input *CreateVirtualInterfaceInput, opts ...request.Option) (*CreateVirtualInterfaceOutput, error) {
	req, out := c.CreateVirtualInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateVirtualInterfaceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// DXPInstanceId is a required field
	DXPInstanceId *string `type:"string" json:",omitempty" required:"true"`

	// LocalIP is a required field
	LocalIP *string `type:"string" json:",omitempty" required:"true"`

	// MaxBandwidth is a required field
	MaxBandwidth *int32 `type:"int32" json:",omitempty" required:"true"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	// PeerIP is a required field
	PeerIP *string `type:"string" json:",omitempty" required:"true"`

	// VlanId is a required field
	VlanId *int32 `type:"int32" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateVirtualInterfaceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualInterfaceInput"}
	if s.DXPInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DXPInstanceId"))
	}
	if s.LocalIP == nil {
		invalidParams.Add(request.NewErrParamRequired("LocalIP"))
	}
	if s.MaxBandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxBandwidth"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PeerIP == nil {
		invalidParams.Add(request.NewErrParamRequired("PeerIP"))
	}
	if s.VlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("VlanId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDXPInstanceId sets the DXPInstanceId field's value.
func (s *CreateVirtualInterfaceInput) SetDXPInstanceId(v string) *CreateVirtualInterfaceInput {
	s.DXPInstanceId = &v
	return s
}

// SetLocalIP sets the LocalIP field's value.
func (s *CreateVirtualInterfaceInput) SetLocalIP(v string) *CreateVirtualInterfaceInput {
	s.LocalIP = &v
	return s
}

// SetMaxBandwidth sets the MaxBandwidth field's value.
func (s *CreateVirtualInterfaceInput) SetMaxBandwidth(v int32) *CreateVirtualInterfaceInput {
	s.MaxBandwidth = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVirtualInterfaceInput) SetName(v string) *CreateVirtualInterfaceInput {
	s.Name = &v
	return s
}

// SetPeerIP sets the PeerIP field's value.
func (s *CreateVirtualInterfaceInput) SetPeerIP(v string) *CreateVirtualInterfaceInput {
	s.PeerIP = &v
	return s
}

// SetVlanId sets the VlanId field's value.
func (s *CreateVirtualInterfaceInput) SetVlanId(v int32) *CreateVirtualInterfaceInput {
	s.VlanId = &v
	return s
}

type CreateVirtualInterfaceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateVirtualInterfaceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateVirtualInterfaceOutput) SetInstanceId(v string) *CreateVirtualInterfaceOutput {
	s.InstanceId = &v
	return s
}
