// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opQueryZoneCommon = "QueryZone"

// QueryZoneCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryZoneCommon operation. The "output" return
// value will be populated with the QueryZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryZoneCommon Send returns without error.
//
// See QueryZoneCommon for more information on using the QueryZoneCommon
// API call, and error handling.
//
//    // Example sending a request using the QueryZoneCommonRequest method.
//    req, resp := client.QueryZoneCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) QueryZoneCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opQueryZoneCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryZoneCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation QueryZoneCommon for usage and error information.
func (c *DNS) QueryZoneCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.QueryZoneCommonRequest(input)
	return out, req.Send()
}

// QueryZoneCommonWithContext is the same as QueryZoneCommon with the addition of
// the ability to pass a context and additional request options.
//
// See QueryZoneCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) QueryZoneCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.QueryZoneCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQueryZone = "QueryZone"

// QueryZoneRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryZone operation. The "output" return
// value will be populated with the QueryZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryZoneCommon Send returns without error.
//
// See QueryZone for more information on using the QueryZone
// API call, and error handling.
//
//    // Example sending a request using the QueryZoneRequest method.
//    req, resp := client.QueryZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) QueryZoneRequest(input *QueryZoneInput) (req *request.Request, output *QueryZoneOutput) {
	op := &request.Operation{
		Name:       opQueryZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryZoneInput{}
	}

	output = &QueryZoneOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// QueryZone API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation QueryZone for usage and error information.
func (c *DNS) QueryZone(input *QueryZoneInput) (*QueryZoneOutput, error) {
	req, out := c.QueryZoneRequest(input)
	return out, req.Send()
}

// QueryZoneWithContext is the same as QueryZone with the addition of
// the ability to pass a context and additional request options.
//
// See QueryZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) QueryZoneWithContext(ctx volcengine.Context, input *QueryZoneInput, opts ...request.Option) (*QueryZoneOutput, error) {
	req, out := c.QueryZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type QueryZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ZID is a required field
	ZID *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s QueryZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryZoneInput"}
	if s.ZID == nil {
		invalidParams.Add(request.NewErrParamRequired("ZID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetZID sets the ZID field's value.
func (s *QueryZoneInput) SetZID(v int64) *QueryZoneInput {
	s.ZID = &v
	return s
}

type QueryZoneOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	AllocateDNSServerList []*string `type:"list" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	ConfigurationCode *string `type:"string" json:",omitempty"`

	DnsSecurity *string `type:"string" json:",omitempty"`

	ExpiredTime *int64 `type:"int64" json:",omitempty"`

	InstanceNo *string `type:"string" json:",omitempty"`

	IsNSCorrect *bool `type:"boolean" json:",omitempty"`

	IsSubDomain *bool `type:"boolean" json:",omitempty"`

	RealDNSServerList []*string `type:"list" json:",omitempty"`

	RecordCount *int32 `type:"int32" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	Stage *int32 `type:"int32" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubDomainHost *string `type:"string" json:",omitempty"`

	TradeCode *string `type:"string" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s QueryZoneOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryZoneOutput) GoString() string {
	return s.String()
}

// SetAllocateDNSServerList sets the AllocateDNSServerList field's value.
func (s *QueryZoneOutput) SetAllocateDNSServerList(v []*string) *QueryZoneOutput {
	s.AllocateDNSServerList = v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *QueryZoneOutput) SetAutoRenew(v bool) *QueryZoneOutput {
	s.AutoRenew = &v
	return s
}

// SetConfigurationCode sets the ConfigurationCode field's value.
func (s *QueryZoneOutput) SetConfigurationCode(v string) *QueryZoneOutput {
	s.ConfigurationCode = &v
	return s
}

// SetDnsSecurity sets the DnsSecurity field's value.
func (s *QueryZoneOutput) SetDnsSecurity(v string) *QueryZoneOutput {
	s.DnsSecurity = &v
	return s
}

// SetExpiredTime sets the ExpiredTime field's value.
func (s *QueryZoneOutput) SetExpiredTime(v int64) *QueryZoneOutput {
	s.ExpiredTime = &v
	return s
}

// SetInstanceNo sets the InstanceNo field's value.
func (s *QueryZoneOutput) SetInstanceNo(v string) *QueryZoneOutput {
	s.InstanceNo = &v
	return s
}

// SetIsNSCorrect sets the IsNSCorrect field's value.
func (s *QueryZoneOutput) SetIsNSCorrect(v bool) *QueryZoneOutput {
	s.IsNSCorrect = &v
	return s
}

// SetIsSubDomain sets the IsSubDomain field's value.
func (s *QueryZoneOutput) SetIsSubDomain(v bool) *QueryZoneOutput {
	s.IsSubDomain = &v
	return s
}

// SetRealDNSServerList sets the RealDNSServerList field's value.
func (s *QueryZoneOutput) SetRealDNSServerList(v []*string) *QueryZoneOutput {
	s.RealDNSServerList = v
	return s
}

// SetRecordCount sets the RecordCount field's value.
func (s *QueryZoneOutput) SetRecordCount(v int32) *QueryZoneOutput {
	s.RecordCount = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *QueryZoneOutput) SetRemark(v string) *QueryZoneOutput {
	s.Remark = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *QueryZoneOutput) SetStage(v int32) *QueryZoneOutput {
	s.Stage = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueryZoneOutput) SetStatus(v int32) *QueryZoneOutput {
	s.Status = &v
	return s
}

// SetSubDomainHost sets the SubDomainHost field's value.
func (s *QueryZoneOutput) SetSubDomainHost(v string) *QueryZoneOutput {
	s.SubDomainHost = &v
	return s
}

// SetTradeCode sets the TradeCode field's value.
func (s *QueryZoneOutput) SetTradeCode(v string) *QueryZoneOutput {
	s.TradeCode = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *QueryZoneOutput) SetUpdatedAt(v string) *QueryZoneOutput {
	s.UpdatedAt = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *QueryZoneOutput) SetZoneName(v string) *QueryZoneOutput {
	s.ZoneName = &v
	return s
}
