// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dms

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDataMigrateTaskCommon = "CreateDataMigrateTask"

// CreateDataMigrateTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataMigrateTaskCommon operation. The "output" return
// value will be populated with the CreateDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataMigrateTaskCommon Send returns without error.
//
// See CreateDataMigrateTaskCommon for more information on using the CreateDataMigrateTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDataMigrateTaskCommonRequest method.
//    req, resp := client.CreateDataMigrateTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) CreateDataMigrateTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDataMigrateTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataMigrateTaskCommon API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation CreateDataMigrateTaskCommon for usage and error information.
func (c *DMS) CreateDataMigrateTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDataMigrateTaskCommonRequest(input)
	return out, req.Send()
}

// CreateDataMigrateTaskCommonWithContext is the same as CreateDataMigrateTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataMigrateTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) CreateDataMigrateTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDataMigrateTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataMigrateTask = "CreateDataMigrateTask"

// CreateDataMigrateTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDataMigrateTask operation. The "output" return
// value will be populated with the CreateDataMigrateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDataMigrateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDataMigrateTaskCommon Send returns without error.
//
// See CreateDataMigrateTask for more information on using the CreateDataMigrateTask
// API call, and error handling.
//
//    // Example sending a request using the CreateDataMigrateTaskRequest method.
//    req, resp := client.CreateDataMigrateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DMS) CreateDataMigrateTaskRequest(input *CreateDataMigrateTaskInput) (req *request.Request, output *CreateDataMigrateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateDataMigrateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataMigrateTaskInput{}
	}

	output = &CreateDataMigrateTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDataMigrateTask API operation for DMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DMS's
// API operation CreateDataMigrateTask for usage and error information.
func (c *DMS) CreateDataMigrateTask(input *CreateDataMigrateTaskInput) (*CreateDataMigrateTaskOutput, error) {
	req, out := c.CreateDataMigrateTaskRequest(input)
	return out, req.Send()
}

// CreateDataMigrateTaskWithContext is the same as CreateDataMigrateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataMigrateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DMS) CreateDataMigrateTaskWithContext(ctx volcengine.Context, input *CreateDataMigrateTaskInput, opts ...request.Option) (*CreateDataMigrateTaskOutput, error) {
	req, out := c.CreateDataMigrateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AdvanceConfigForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IncreaseSetting *IncreaseSettingForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	PrivateLink *PrivateLinkForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	RenameSetting *RenameSettingForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	TimeBandwidthSetting []*TimeBandwidthSettingForCreateDataMigrateTaskInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s AdvanceConfigForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AdvanceConfigForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdvanceConfigForCreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AdvanceConfigForCreateDataMigrateTaskInput"}
	if s.IncreaseSetting != nil {
		if err := s.IncreaseSetting.Validate(); err != nil {
			invalidParams.AddNested("IncreaseSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.RenameSetting != nil {
		if err := s.RenameSetting.Validate(); err != nil {
			invalidParams.AddNested("RenameSetting", err.(request.ErrInvalidParams))
		}
	}
	if s.TimeBandwidthSetting != nil {
		for i, v := range s.TimeBandwidthSetting {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TimeBandwidthSetting", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncreaseSetting sets the IncreaseSetting field's value.
func (s *AdvanceConfigForCreateDataMigrateTaskInput) SetIncreaseSetting(v *IncreaseSettingForCreateDataMigrateTaskInput) *AdvanceConfigForCreateDataMigrateTaskInput {
	s.IncreaseSetting = v
	return s
}

// SetPrivateLink sets the PrivateLink field's value.
func (s *AdvanceConfigForCreateDataMigrateTaskInput) SetPrivateLink(v *PrivateLinkForCreateDataMigrateTaskInput) *AdvanceConfigForCreateDataMigrateTaskInput {
	s.PrivateLink = v
	return s
}

// SetRenameSetting sets the RenameSetting field's value.
func (s *AdvanceConfigForCreateDataMigrateTaskInput) SetRenameSetting(v *RenameSettingForCreateDataMigrateTaskInput) *AdvanceConfigForCreateDataMigrateTaskInput {
	s.RenameSetting = v
	return s
}

// SetTimeBandwidthSetting sets the TimeBandwidthSetting field's value.
func (s *AdvanceConfigForCreateDataMigrateTaskInput) SetTimeBandwidthSetting(v []*TimeBandwidthSettingForCreateDataMigrateTaskInput) *AdvanceConfigForCreateDataMigrateTaskInput {
	s.TimeBandwidthSetting = v
	return s
}

type BasicConfigForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int32 `min:"1" max:"1.073741824e+09" type:"int32" json:",omitempty"`

	EnableRangeCheck *bool `type:"boolean" json:",omitempty"`

	FailedNumToAbort *int32 `type:"int32" json:",omitempty"`

	ObjectMigrationPolicy *ObjectMigrationPolicyForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	OfflineMigrationPolicy *OfflineMigrationPolicyForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	OverwritePolicy *string `type:"string" json:",omitempty" enum:"EnumOfOverwritePolicyForCreateDataMigrateTaskInput"`

	SourceType *string `type:"string" json:",omitempty" enum:"EnumOfSourceTypeForCreateDataMigrateTaskInput"`

	StorageClass *string `type:"string" json:",omitempty" enum:"EnumOfStorageClassForCreateDataMigrateTaskInput"`

	TaskName *string `min:"3" max:"32" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BasicConfigForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BasicConfigForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BasicConfigForCreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BasicConfigForCreateDataMigrateTaskInput"}
	if s.Bandwidth != nil && *s.Bandwidth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Bandwidth", 1))
	}
	if s.Bandwidth != nil && *s.Bandwidth > 1.073741824e+09 {
		invalidParams.Add(request.NewErrParamMaxValue("Bandwidth", 1.073741824e+09))
	}
	if s.FailedNumToAbort != nil && *s.FailedNumToAbort < -1 {
		invalidParams.Add(request.NewErrParamMinValue("FailedNumToAbort", -1))
	}
	if s.TaskName != nil && len(*s.TaskName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TaskName", 3))
	}
	if s.TaskName != nil && len(*s.TaskName) > 32 {
		invalidParams.Add(request.NewErrParamMaxLen("TaskName", 32, *s.TaskName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetBandwidth(v int32) *BasicConfigForCreateDataMigrateTaskInput {
	s.Bandwidth = &v
	return s
}

// SetEnableRangeCheck sets the EnableRangeCheck field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetEnableRangeCheck(v bool) *BasicConfigForCreateDataMigrateTaskInput {
	s.EnableRangeCheck = &v
	return s
}

// SetFailedNumToAbort sets the FailedNumToAbort field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetFailedNumToAbort(v int32) *BasicConfigForCreateDataMigrateTaskInput {
	s.FailedNumToAbort = &v
	return s
}

// SetObjectMigrationPolicy sets the ObjectMigrationPolicy field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetObjectMigrationPolicy(v *ObjectMigrationPolicyForCreateDataMigrateTaskInput) *BasicConfigForCreateDataMigrateTaskInput {
	s.ObjectMigrationPolicy = v
	return s
}

// SetOfflineMigrationPolicy sets the OfflineMigrationPolicy field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetOfflineMigrationPolicy(v *OfflineMigrationPolicyForCreateDataMigrateTaskInput) *BasicConfigForCreateDataMigrateTaskInput {
	s.OfflineMigrationPolicy = v
	return s
}

// SetOverwritePolicy sets the OverwritePolicy field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetOverwritePolicy(v string) *BasicConfigForCreateDataMigrateTaskInput {
	s.OverwritePolicy = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetSourceType(v string) *BasicConfigForCreateDataMigrateTaskInput {
	s.SourceType = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetStorageClass(v string) *BasicConfigForCreateDataMigrateTaskInput {
	s.StorageClass = &v
	return s
}

// SetTaskName sets the TaskName field's value.
func (s *BasicConfigForCreateDataMigrateTaskInput) SetTaskName(v string) *BasicConfigForCreateDataMigrateTaskInput {
	s.TaskName = &v
	return s
}

type BucketAccessConfigForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AK *string `type:"string" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	RoleTrn *string `type:"string" json:",omitempty"`

	SK *string `type:"string" json:",omitempty"`

	Vendor *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BucketAccessConfigForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BucketAccessConfigForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetAK sets the AK field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetAK(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.AK = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetBucketName(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.BucketName = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetEndpoint(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.Endpoint = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetRegion(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.Region = &v
	return s
}

// SetRoleTrn sets the RoleTrn field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetRoleTrn(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.RoleTrn = &v
	return s
}

// SetSK sets the SK field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetSK(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.SK = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *BucketAccessConfigForCreateDataMigrateTaskInput) SetVendor(v string) *BucketAccessConfigForCreateDataMigrateTaskInput {
	s.Vendor = &v
	return s
}

type CreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdvanceConfig *AdvanceConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	BasicConfig *BasicConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	Source *SourceForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	Target *TargetForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataMigrateTaskInput"}
	if s.AdvanceConfig != nil {
		if err := s.AdvanceConfig.Validate(); err != nil {
			invalidParams.AddNested("AdvanceConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.BasicConfig != nil {
		if err := s.BasicConfig.Validate(); err != nil {
			invalidParams.AddNested("BasicConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvanceConfig sets the AdvanceConfig field's value.
func (s *CreateDataMigrateTaskInput) SetAdvanceConfig(v *AdvanceConfigForCreateDataMigrateTaskInput) *CreateDataMigrateTaskInput {
	s.AdvanceConfig = v
	return s
}

// SetBasicConfig sets the BasicConfig field's value.
func (s *CreateDataMigrateTaskInput) SetBasicConfig(v *BasicConfigForCreateDataMigrateTaskInput) *CreateDataMigrateTaskInput {
	s.BasicConfig = v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateDataMigrateTaskInput) SetSource(v *SourceForCreateDataMigrateTaskInput) *CreateDataMigrateTaskInput {
	s.Source = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateDataMigrateTaskInput) SetTarget(v *TargetForCreateDataMigrateTaskInput) *CreateDataMigrateTaskInput {
	s.Target = v
	return s
}

type CreateDataMigrateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	TaskID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CreateDataMigrateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataMigrateTaskOutput) GoString() string {
	return s.String()
}

// SetTaskID sets the TaskID field's value.
func (s *CreateDataMigrateTaskOutput) SetTaskID(v int64) *CreateDataMigrateTaskOutput {
	s.TaskID = &v
	return s
}

type IncreaseSettingForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Interval *int32 `min:"3600" max:"86400" type:"int32" json:",omitempty"`

	Times *int32 `min:"1" max:"30" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s IncreaseSettingForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseSettingForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseSettingForCreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseSettingForCreateDataMigrateTaskInput"}
	if s.Interval != nil && *s.Interval < 3600 {
		invalidParams.Add(request.NewErrParamMinValue("Interval", 3600))
	}
	if s.Interval != nil && *s.Interval > 86400 {
		invalidParams.Add(request.NewErrParamMaxValue("Interval", 86400))
	}
	if s.Times != nil && *s.Times < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Times", 1))
	}
	if s.Times != nil && *s.Times > 30 {
		invalidParams.Add(request.NewErrParamMaxValue("Times", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterval sets the Interval field's value.
func (s *IncreaseSettingForCreateDataMigrateTaskInput) SetInterval(v int32) *IncreaseSettingForCreateDataMigrateTaskInput {
	s.Interval = &v
	return s
}

// SetTimes sets the Times field's value.
func (s *IncreaseSettingForCreateDataMigrateTaskInput) SetTimes(v int32) *IncreaseSettingForCreateDataMigrateTaskInput {
	s.Times = &v
	return s
}

type ObjectMigrationPolicyForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SyncAcl *bool `type:"boolean" json:",omitempty"`

	SyncSymlink *bool `type:"boolean" json:",omitempty"`

	SyncTag *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ObjectMigrationPolicyForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectMigrationPolicyForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetSyncAcl sets the SyncAcl field's value.
func (s *ObjectMigrationPolicyForCreateDataMigrateTaskInput) SetSyncAcl(v bool) *ObjectMigrationPolicyForCreateDataMigrateTaskInput {
	s.SyncAcl = &v
	return s
}

// SetSyncSymlink sets the SyncSymlink field's value.
func (s *ObjectMigrationPolicyForCreateDataMigrateTaskInput) SetSyncSymlink(v bool) *ObjectMigrationPolicyForCreateDataMigrateTaskInput {
	s.SyncSymlink = &v
	return s
}

// SetSyncTag sets the SyncTag field's value.
func (s *ObjectMigrationPolicyForCreateDataMigrateTaskInput) SetSyncTag(v bool) *ObjectMigrationPolicyForCreateDataMigrateTaskInput {
	s.SyncTag = &v
	return s
}

type ObjectSourceConfigForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketAccessConfig *BucketAccessConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	IsExcluded *bool `type:"boolean" json:",omitempty"`

	KeyListFile *string `type:"string" json:",omitempty"`

	PrefixList []*string `type:"list" json:",omitempty"`

	PrefixListFile *string `type:"string" json:",omitempty"`

	ScanWithDelimiter *bool `type:"boolean" json:",omitempty"`

	StartTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ObjectSourceConfigForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectSourceConfigForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetBucketAccessConfig sets the BucketAccessConfig field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetBucketAccessConfig(v *BucketAccessConfigForCreateDataMigrateTaskInput) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.BucketAccessConfig = v
	return s
}

// SetIsExcluded sets the IsExcluded field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetIsExcluded(v bool) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.IsExcluded = &v
	return s
}

// SetKeyListFile sets the KeyListFile field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetKeyListFile(v string) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.KeyListFile = &v
	return s
}

// SetPrefixList sets the PrefixList field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetPrefixList(v []*string) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.PrefixList = v
	return s
}

// SetPrefixListFile sets the PrefixListFile field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetPrefixListFile(v string) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.PrefixListFile = &v
	return s
}

// SetScanWithDelimiter sets the ScanWithDelimiter field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetScanWithDelimiter(v bool) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.ScanWithDelimiter = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ObjectSourceConfigForCreateDataMigrateTaskInput) SetStartTime(v string) *ObjectSourceConfigForCreateDataMigrateTaskInput {
	s.StartTime = &v
	return s
}

type OfflineMigrationPolicyForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	Target *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OfflineMigrationPolicyForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OfflineMigrationPolicyForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *OfflineMigrationPolicyForCreateDataMigrateTaskInput) SetSource(v string) *OfflineMigrationPolicyForCreateDataMigrateTaskInput {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *OfflineMigrationPolicyForCreateDataMigrateTaskInput) SetTarget(v string) *OfflineMigrationPolicyForCreateDataMigrateTaskInput {
	s.Target = &v
	return s
}

type PrivateLinkForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ENIRole *string `type:"string" json:",omitempty"`

	IdcIP *string `type:"string" json:",omitempty"`

	IdcPort *int32 `type:"int32" json:",omitempty"`

	SecurityGroupIDs []*string `type:"list" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	VpcID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrivateLinkForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateLinkForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetENIRole sets the ENIRole field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetENIRole(v string) *PrivateLinkForCreateDataMigrateTaskInput {
	s.ENIRole = &v
	return s
}

// SetIdcIP sets the IdcIP field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetIdcIP(v string) *PrivateLinkForCreateDataMigrateTaskInput {
	s.IdcIP = &v
	return s
}

// SetIdcPort sets the IdcPort field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetIdcPort(v int32) *PrivateLinkForCreateDataMigrateTaskInput {
	s.IdcPort = &v
	return s
}

// SetSecurityGroupIDs sets the SecurityGroupIDs field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetSecurityGroupIDs(v []*string) *PrivateLinkForCreateDataMigrateTaskInput {
	s.SecurityGroupIDs = v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetSubnetID(v string) *PrivateLinkForCreateDataMigrateTaskInput {
	s.SubnetID = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *PrivateLinkForCreateDataMigrateTaskInput) SetVpcID(v string) *PrivateLinkForCreateDataMigrateTaskInput {
	s.VpcID = &v
	return s
}

type RenameSettingForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Pattern *string `max:"696" type:"string" json:",omitempty"`

	ReplaceStr *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RenameSettingForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenameSettingForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenameSettingForCreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenameSettingForCreateDataMigrateTaskInput"}
	if s.Pattern != nil && len(*s.Pattern) > 696 {
		invalidParams.Add(request.NewErrParamMaxLen("Pattern", 696, *s.Pattern))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPattern sets the Pattern field's value.
func (s *RenameSettingForCreateDataMigrateTaskInput) SetPattern(v string) *RenameSettingForCreateDataMigrateTaskInput {
	s.Pattern = &v
	return s
}

// SetReplaceStr sets the ReplaceStr field's value.
func (s *RenameSettingForCreateDataMigrateTaskInput) SetReplaceStr(v string) *RenameSettingForCreateDataMigrateTaskInput {
	s.ReplaceStr = &v
	return s
}

type SourceForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ObjectSourceConfig *ObjectSourceConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	UrlSourceConfig *UrlSourceConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SourceForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetObjectSourceConfig sets the ObjectSourceConfig field's value.
func (s *SourceForCreateDataMigrateTaskInput) SetObjectSourceConfig(v *ObjectSourceConfigForCreateDataMigrateTaskInput) *SourceForCreateDataMigrateTaskInput {
	s.ObjectSourceConfig = v
	return s
}

// SetUrlSourceConfig sets the UrlSourceConfig field's value.
func (s *SourceForCreateDataMigrateTaskInput) SetUrlSourceConfig(v *UrlSourceConfigForCreateDataMigrateTaskInput) *SourceForCreateDataMigrateTaskInput {
	s.UrlSourceConfig = v
	return s
}

type TargetForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AK *string `type:"string" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	RoleTrn *string `type:"string" json:",omitempty"`

	SK *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetAK sets the AK field's value.
func (s *TargetForCreateDataMigrateTaskInput) SetAK(v string) *TargetForCreateDataMigrateTaskInput {
	s.AK = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *TargetForCreateDataMigrateTaskInput) SetBucketName(v string) *TargetForCreateDataMigrateTaskInput {
	s.BucketName = &v
	return s
}

// SetRoleTrn sets the RoleTrn field's value.
func (s *TargetForCreateDataMigrateTaskInput) SetRoleTrn(v string) *TargetForCreateDataMigrateTaskInput {
	s.RoleTrn = &v
	return s
}

// SetSK sets the SK field's value.
func (s *TargetForCreateDataMigrateTaskInput) SetSK(v string) *TargetForCreateDataMigrateTaskInput {
	s.SK = &v
	return s
}

type TimeBandwidthSettingForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bandwidth *int64 `max:"1.073741824e+09" type:"int64" json:",omitempty"`

	End *int32 `min:"1" max:"24" type:"int32" json:",omitempty"`

	Start *int32 `max:"23" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TimeBandwidthSettingForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBandwidthSettingForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeBandwidthSettingForCreateDataMigrateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeBandwidthSettingForCreateDataMigrateTaskInput"}
	if s.Bandwidth != nil && *s.Bandwidth > 1.073741824e+09 {
		invalidParams.Add(request.NewErrParamMaxValue("Bandwidth", 1.073741824e+09))
	}
	if s.End != nil && *s.End < 1 {
		invalidParams.Add(request.NewErrParamMinValue("End", 1))
	}
	if s.End != nil && *s.End > 24 {
		invalidParams.Add(request.NewErrParamMaxValue("End", 24))
	}
	if s.Start != nil && *s.Start > 23 {
		invalidParams.Add(request.NewErrParamMaxValue("Start", 23))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *TimeBandwidthSettingForCreateDataMigrateTaskInput) SetBandwidth(v int64) *TimeBandwidthSettingForCreateDataMigrateTaskInput {
	s.Bandwidth = &v
	return s
}

// SetEnd sets the End field's value.
func (s *TimeBandwidthSettingForCreateDataMigrateTaskInput) SetEnd(v int32) *TimeBandwidthSettingForCreateDataMigrateTaskInput {
	s.End = &v
	return s
}

// SetStart sets the Start field's value.
func (s *TimeBandwidthSettingForCreateDataMigrateTaskInput) SetStart(v int32) *TimeBandwidthSettingForCreateDataMigrateTaskInput {
	s.Start = &v
	return s
}

type UrlSourceConfigForCreateDataMigrateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BucketAccessConfig *BucketAccessConfigForCreateDataMigrateTaskInput `type:"structure" json:",omitempty"`

	IsUrlTryRangeGet *bool `type:"boolean" json:",omitempty"`

	UrlListLink *string `type:"string" json:",omitempty"`

	UrlListName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UrlSourceConfigForCreateDataMigrateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlSourceConfigForCreateDataMigrateTaskInput) GoString() string {
	return s.String()
}

// SetBucketAccessConfig sets the BucketAccessConfig field's value.
func (s *UrlSourceConfigForCreateDataMigrateTaskInput) SetBucketAccessConfig(v *BucketAccessConfigForCreateDataMigrateTaskInput) *UrlSourceConfigForCreateDataMigrateTaskInput {
	s.BucketAccessConfig = v
	return s
}

// SetIsUrlTryRangeGet sets the IsUrlTryRangeGet field's value.
func (s *UrlSourceConfigForCreateDataMigrateTaskInput) SetIsUrlTryRangeGet(v bool) *UrlSourceConfigForCreateDataMigrateTaskInput {
	s.IsUrlTryRangeGet = &v
	return s
}

// SetUrlListLink sets the UrlListLink field's value.
func (s *UrlSourceConfigForCreateDataMigrateTaskInput) SetUrlListLink(v string) *UrlSourceConfigForCreateDataMigrateTaskInput {
	s.UrlListLink = &v
	return s
}

// SetUrlListName sets the UrlListName field's value.
func (s *UrlSourceConfigForCreateDataMigrateTaskInput) SetUrlListName(v string) *UrlSourceConfigForCreateDataMigrateTaskInput {
	s.UrlListName = &v
	return s
}

const (
	// EnumOfOverwritePolicyForCreateDataMigrateTaskInputForce is a EnumOfOverwritePolicyForCreateDataMigrateTaskInput enum value
	EnumOfOverwritePolicyForCreateDataMigrateTaskInputForce = "Force"

	// EnumOfOverwritePolicyForCreateDataMigrateTaskInputNone is a EnumOfOverwritePolicyForCreateDataMigrateTaskInput enum value
	EnumOfOverwritePolicyForCreateDataMigrateTaskInputNone = "None"

	// EnumOfOverwritePolicyForCreateDataMigrateTaskInputLastModify is a EnumOfOverwritePolicyForCreateDataMigrateTaskInput enum value
	EnumOfOverwritePolicyForCreateDataMigrateTaskInputLastModify = "LastModify"
)

const (
	// EnumOfSourceTypeForCreateDataMigrateTaskInputStorageTypeObject is a EnumOfSourceTypeForCreateDataMigrateTaskInput enum value
	EnumOfSourceTypeForCreateDataMigrateTaskInputStorageTypeObject = "StorageTypeObject"

	// EnumOfSourceTypeForCreateDataMigrateTaskInputStorageTypeUrl is a EnumOfSourceTypeForCreateDataMigrateTaskInput enum value
	EnumOfSourceTypeForCreateDataMigrateTaskInputStorageTypeUrl = "StorageTypeUrl"
)

const (
	// EnumOfStorageClassForCreateDataMigrateTaskInputStandard is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputStandard = "Standard"

	// EnumOfStorageClassForCreateDataMigrateTaskInputInheritSource is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputInheritSource = "InheritSource"

	// EnumOfStorageClassForCreateDataMigrateTaskInputIa is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputIa = "Ia"

	// EnumOfStorageClassForCreateDataMigrateTaskInputArchiveFr is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputArchiveFr = "ArchiveFr"

	// EnumOfStorageClassForCreateDataMigrateTaskInputIntelligentTiering is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputIntelligentTiering = "IntelligentTiering"

	// EnumOfStorageClassForCreateDataMigrateTaskInputColdArchive is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputColdArchive = "ColdArchive"

	// EnumOfStorageClassForCreateDataMigrateTaskInputArchive is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputArchive = "Archive"

	// EnumOfStorageClassForCreateDataMigrateTaskInputDeepColdArchive is a EnumOfStorageClassForCreateDataMigrateTaskInput enum value
	EnumOfStorageClassForCreateDataMigrateTaskInputDeepColdArchive = "DeepColdArchive"
)
