// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListRegistriesCommon = "ListRegistries"

// ListRegistriesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRegistriesCommon operation. The "output" return
// value will be populated with the ListRegistriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRegistriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRegistriesCommon Send returns without error.
//
// See ListRegistriesCommon for more information on using the ListRegistriesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListRegistriesCommonRequest method.
//    req, resp := client.ListRegistriesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListRegistriesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListRegistriesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRegistriesCommon API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListRegistriesCommon for usage and error information.
func (c *CR) ListRegistriesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListRegistriesCommonRequest(input)
	return out, req.Send()
}

// ListRegistriesCommonWithContext is the same as ListRegistriesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegistriesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListRegistriesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListRegistriesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegistries = "ListRegistries"

// ListRegistriesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRegistries operation. The "output" return
// value will be populated with the ListRegistriesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRegistriesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRegistriesCommon Send returns without error.
//
// See ListRegistries for more information on using the ListRegistries
// API call, and error handling.
//
//    // Example sending a request using the ListRegistriesRequest method.
//    req, resp := client.ListRegistriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CR) ListRegistriesRequest(input *ListRegistriesInput) (req *request.Request, output *ListRegistriesOutput) {
	op := &request.Operation{
		Name:       opListRegistries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRegistriesInput{}
	}

	output = &ListRegistriesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRegistries API operation for CR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CR's
// API operation ListRegistries for usage and error information.
func (c *CR) ListRegistries(input *ListRegistriesInput) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	return out, req.Send()
}

// ListRegistriesWithContext is the same as ListRegistries with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegistries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CR) ListRegistriesWithContext(ctx volcengine.Context, input *ListRegistriesInput, opts ...request.Option) (*ListRegistriesOutput, error) {
	req, out := c.ListRegistriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListRegistriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Names []*string `type:"list" json:",omitempty"`

	Projects []*string `type:"list" json:",omitempty"`

	Statuses []*StatusForListRegistriesInput `type:"list" json:",omitempty"`

	Types []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListRegistriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListRegistriesInput) GoString() string {
	return s.String()
}

// SetNames sets the Names field's value.
func (s *FilterForListRegistriesInput) SetNames(v []*string) *FilterForListRegistriesInput {
	s.Names = v
	return s
}

// SetProjects sets the Projects field's value.
func (s *FilterForListRegistriesInput) SetProjects(v []*string) *FilterForListRegistriesInput {
	s.Projects = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *FilterForListRegistriesInput) SetStatuses(v []*StatusForListRegistriesInput) *FilterForListRegistriesInput {
	s.Statuses = v
	return s
}

// SetTypes sets the Types field's value.
func (s *FilterForListRegistriesInput) SetTypes(v []*string) *FilterForListRegistriesInput {
	s.Types = v
	return s
}

type ItemForListRegistriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Project *string `type:"string" json:",omitempty"`

	ProxyCache *ProxyCacheForListRegistriesOutput `type:"structure" json:",omitempty"`

	ProxyCacheEnabled *bool `type:"boolean" json:",omitempty"`

	RenewType *string `type:"string" json:",omitempty"`

	ResourceTags []*ResourceTagForListRegistriesOutput `type:"list" json:",omitempty"`

	Status *StatusForListRegistriesOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListRegistriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListRegistriesOutput) GoString() string {
	return s.String()
}

// SetChargeType sets the ChargeType field's value.
func (s *ItemForListRegistriesOutput) SetChargeType(v string) *ItemForListRegistriesOutput {
	s.ChargeType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListRegistriesOutput) SetCreateTime(v string) *ItemForListRegistriesOutput {
	s.CreateTime = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *ItemForListRegistriesOutput) SetExpireTime(v string) *ItemForListRegistriesOutput {
	s.ExpireTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListRegistriesOutput) SetName(v string) *ItemForListRegistriesOutput {
	s.Name = &v
	return s
}

// SetProject sets the Project field's value.
func (s *ItemForListRegistriesOutput) SetProject(v string) *ItemForListRegistriesOutput {
	s.Project = &v
	return s
}

// SetProxyCache sets the ProxyCache field's value.
func (s *ItemForListRegistriesOutput) SetProxyCache(v *ProxyCacheForListRegistriesOutput) *ItemForListRegistriesOutput {
	s.ProxyCache = v
	return s
}

// SetProxyCacheEnabled sets the ProxyCacheEnabled field's value.
func (s *ItemForListRegistriesOutput) SetProxyCacheEnabled(v bool) *ItemForListRegistriesOutput {
	s.ProxyCacheEnabled = &v
	return s
}

// SetRenewType sets the RenewType field's value.
func (s *ItemForListRegistriesOutput) SetRenewType(v string) *ItemForListRegistriesOutput {
	s.RenewType = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ItemForListRegistriesOutput) SetResourceTags(v []*ResourceTagForListRegistriesOutput) *ItemForListRegistriesOutput {
	s.ResourceTags = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListRegistriesOutput) SetStatus(v *StatusForListRegistriesOutput) *ItemForListRegistriesOutput {
	s.Status = v
	return s
}

// SetType sets the Type field's value.
func (s *ItemForListRegistriesOutput) SetType(v string) *ItemForListRegistriesOutput {
	s.Type = &v
	return s
}

type ListRegistriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListRegistriesInput `type:"structure" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `min:"1" max:"100" type:"int64" json:",omitempty"`

	ResourceTagFilters []*ResourceTagFilterForListRegistriesInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListRegistriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegistriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegistriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegistriesInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRegistriesInput) SetFilter(v *FilterForListRegistriesInput) *ListRegistriesInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRegistriesInput) SetPageNumber(v int64) *ListRegistriesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRegistriesInput) SetPageSize(v int64) *ListRegistriesInput {
	s.PageSize = &v
	return s
}

// SetResourceTagFilters sets the ResourceTagFilters field's value.
func (s *ListRegistriesInput) SetResourceTagFilters(v []*ResourceTagFilterForListRegistriesInput) *ListRegistriesInput {
	s.ResourceTagFilters = v
	return s
}

type ListRegistriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListRegistriesOutput `type:"list" json:",omitempty"`

	PageNumber *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	TotalCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListRegistriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegistriesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListRegistriesOutput) SetItems(v []*ItemForListRegistriesOutput) *ListRegistriesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRegistriesOutput) SetPageNumber(v int64) *ListRegistriesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRegistriesOutput) SetPageSize(v int64) *ListRegistriesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListRegistriesOutput) SetTotalCount(v int64) *ListRegistriesOutput {
	s.TotalCount = &v
	return s
}

type ProxyCacheForListRegistriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ProxyCacheForListRegistriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProxyCacheForListRegistriesOutput) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *ProxyCacheForListRegistriesOutput) SetType(v string) *ProxyCacheForListRegistriesOutput {
	s.Type = &v
	return s
}

type ResourceTagFilterForListRegistriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagFilterForListRegistriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagFilterForListRegistriesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagFilterForListRegistriesInput) SetKey(v string) *ResourceTagFilterForListRegistriesInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ResourceTagFilterForListRegistriesInput) SetValues(v []*string) *ResourceTagFilterForListRegistriesInput {
	s.Values = v
	return s
}

type ResourceTagForListRegistriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForListRegistriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForListRegistriesOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagForListRegistriesOutput) SetKey(v string) *ResourceTagForListRegistriesOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTagForListRegistriesOutput) SetValue(v string) *ResourceTagForListRegistriesOutput {
	s.Value = &v
	return s
}

type StatusForListRegistriesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *string `type:"string" json:",omitempty"`

	Phase *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForListRegistriesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListRegistriesInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *StatusForListRegistriesInput) SetCondition(v string) *StatusForListRegistriesInput {
	s.Condition = &v
	return s
}

// SetPhase sets the Phase field's value.
func (s *StatusForListRegistriesInput) SetPhase(v string) *StatusForListRegistriesInput {
	s.Phase = &v
	return s
}

type StatusForListRegistriesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Conditions []*string `type:"list" json:",omitempty"`

	Phase *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForListRegistriesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListRegistriesOutput) GoString() string {
	return s.String()
}

// SetConditions sets the Conditions field's value.
func (s *StatusForListRegistriesOutput) SetConditions(v []*string) *StatusForListRegistriesOutput {
	s.Conditions = v
	return s
}

// SetPhase sets the Phase field's value.
func (s *StatusForListRegistriesOutput) SetPhase(v string) *StatusForListRegistriesOutput {
	s.Phase = &v
	return s
}
