// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateUserCommon = "UpdateUser"

// UpdateUserCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateUserCommon operation. The "output" return
// value will be populated with the UpdateUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateUserCommon Send returns without error.
//
// See UpdateUserCommon for more information on using the UpdateUserCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateUserCommonRequest method.
//    req, resp := client.UpdateUserCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) UpdateUserCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateUserCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateUserCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation UpdateUserCommon for usage and error information.
func (c *CLOUDIDENTITY) UpdateUserCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateUserCommonRequest(input)
	return out, req.Send()
}

// UpdateUserCommonWithContext is the same as UpdateUserCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) UpdateUserCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateUserCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the UpdateUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateUserCommon Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateUser API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation UpdateUser for usage and error information.
func (c *CLOUDIDENTITY) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) UpdateUserWithContext(ctx volcengine.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateUserInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"255" type:"string" json:",omitempty"`

	DisplayName *string `max:"64" type:"string" json:",omitempty"`

	Email *string `max:"128" type:"string" json:",omitempty"`

	Phone *string `max:"20" type:"string" json:",omitempty"`

	// UserId is a required field
	UserId *string `type:"string" json:",omitempty" required:"true"`

	UserName *string `min:"1" max:"54" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.DisplayName != nil && len(*s.DisplayName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("DisplayName", 64, *s.DisplayName))
	}
	if s.Email != nil && len(*s.Email) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Email", 128, *s.Email))
	}
	if s.Phone != nil && len(*s.Phone) > 20 {
		invalidParams.Add(request.NewErrParamMaxLen("Phone", 20, *s.Phone))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.UserName != nil && len(*s.UserName) > 54 {
		invalidParams.Add(request.NewErrParamMaxLen("UserName", 54, *s.UserName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateUserInput) SetDescription(v string) *UpdateUserInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateUserInput) SetDisplayName(v string) *UpdateUserInput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UpdateUserInput) SetEmail(v string) *UpdateUserInput {
	s.Email = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *UpdateUserInput) SetPhone(v string) *UpdateUserInput {
	s.Phone = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}
