// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateGroupCommon = "CreateGroup"

// CreateGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateGroupCommon operation. The "output" return
// value will be populated with the CreateGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateGroupCommon Send returns without error.
//
// See CreateGroupCommon for more information on using the CreateGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateGroupCommonRequest method.
//    req, resp := client.CreateGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) CreateGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateGroupCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation CreateGroupCommon for usage and error information.
func (c *CLOUDIDENTITY) CreateGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateGroupCommonRequest(input)
	return out, req.Send()
}

// CreateGroupCommonWithContext is the same as CreateGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) CreateGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the CreateGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateGroupCommon Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateGroup API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation CreateGroup for usage and error information.
func (c *CLOUDIDENTITY) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) CreateGroupWithContext(ctx volcengine.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"128" type:"string" json:",omitempty"`

	DisplayName *string `max:"64" type:"string" json:",omitempty"`

	// GroupName is a required field
	GroupName *string `max:"63" type:"string" json:",omitempty" required:"true"`

	// JoinType is a required field
	JoinType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfJoinTypeForCreateGroupInput"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Description != nil && len(*s.Description) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 128, *s.Description))
	}
	if s.DisplayName != nil && len(*s.DisplayName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("DisplayName", 64, *s.DisplayName))
	}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) > 63 {
		invalidParams.Add(request.NewErrParamMaxLen("GroupName", 63, *s.GroupName))
	}
	if s.JoinType == nil {
		invalidParams.Add(request.NewErrParamRequired("JoinType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateGroupInput) SetDisplayName(v string) *CreateGroupInput {
	s.DisplayName = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetJoinType sets the JoinType field's value.
func (s *CreateGroupInput) SetJoinType(v string) *CreateGroupInput {
	s.JoinType = &v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreatedTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	GroupId *string `type:"string" json:",omitempty"`

	GroupName *string `type:"string" json:",omitempty"`

	JoinType *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	UpdatedTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateGroupOutput) SetCreatedTime(v string) *CreateGroupOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGroupOutput) SetDescription(v string) *CreateGroupOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateGroupOutput) SetDisplayName(v string) *CreateGroupOutput {
	s.DisplayName = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *CreateGroupOutput) SetGroupId(v string) *CreateGroupOutput {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupOutput) SetGroupName(v string) *CreateGroupOutput {
	s.GroupName = &v
	return s
}

// SetJoinType sets the JoinType field's value.
func (s *CreateGroupOutput) SetJoinType(v string) *CreateGroupOutput {
	s.JoinType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateGroupOutput) SetSource(v string) *CreateGroupOutput {
	s.Source = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *CreateGroupOutput) SetUpdatedTime(v string) *CreateGroupOutput {
	s.UpdatedTime = &v
	return s
}

const (
	// EnumOfJoinTypeForCreateGroupInputManual is a EnumOfJoinTypeForCreateGroupInput enum value
	EnumOfJoinTypeForCreateGroupInputManual = "Manual"

	// EnumOfJoinTypeForCreateGroupInputAuto is a EnumOfJoinTypeForCreateGroupInput enum value
	EnumOfJoinTypeForCreateGroupInputAuto = "Auto"
)
