// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTaskCommon = "ListTask"

// ListTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTaskCommon operation. The "output" return
// value will be populated with the ListTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTaskCommon Send returns without error.
//
// See ListTaskCommon for more information on using the ListTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTaskCommonRequest method.
//    req, resp := client.ListTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTaskCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListTaskCommon for usage and error information.
func (c *CLOUDDETECT) ListTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTaskCommonRequest(input)
	return out, req.Send()
}

// ListTaskCommonWithContext is the same as ListTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTask = "ListTask"

// ListTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTask operation. The "output" return
// value will be populated with the ListTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTaskCommon Send returns without error.
//
// See ListTask for more information on using the ListTask
// API call, and error handling.
//
//    // Example sending a request using the ListTaskRequest method.
//    req, resp := client.ListTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListTaskRequest(input *ListTaskInput) (req *request.Request, output *ListTaskOutput) {
	op := &request.Operation{
		Name:       opListTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTaskInput{}
	}

	output = &ListTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTask API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListTask for usage and error information.
func (c *CLOUDDETECT) ListTask(input *ListTaskInput) (*ListTaskOutput, error) {
	req, out := c.ListTaskRequest(input)
	return out, req.Send()
}

// ListTaskWithContext is the same as ListTask with the addition of
// the ability to pass a context and additional request options.
//
// See ListTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListTaskWithContext(ctx volcengine.Context, input *ListTaskInput, opts ...request.Option) (*ListTaskOutput, error) {
	req, out := c.ListTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type EndTimeForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s EndTimeForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EndTimeForListTaskOutput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *EndTimeForListTaskOutput) SetHour(v int32) *EndTimeForListTaskOutput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *EndTimeForListTaskOutput) SetMinute(v int32) *EndTimeForListTaskOutput {
	s.Minute = &v
	return s
}

type LabelForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	KeyID *int64 `type:"int64" json:",omitempty"`

	Option *string `type:"string" json:",omitempty"`

	OptionID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s LabelForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelForListTaskOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *LabelForListTaskOutput) SetKey(v string) *LabelForListTaskOutput {
	s.Key = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *LabelForListTaskOutput) SetKeyID(v int64) *LabelForListTaskOutput {
	s.KeyID = &v
	return s
}

// SetOption sets the Option field's value.
func (s *LabelForListTaskOutput) SetOption(v string) *LabelForListTaskOutput {
	s.Option = &v
	return s
}

// SetOptionID sets the OptionID field's value.
func (s *LabelForListTaskOutput) SetOptionID(v int64) *LabelForListTaskOutput {
	s.OptionID = &v
	return s
}

type ListTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Owner *string `type:"string" json:",omitempty"`

	// PageNum is a required field
	PageNum *int64 `type:"int64" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int64 `type:"int64" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTaskInput"}
	if s.PageNum == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNum"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *ListTaskInput) SetAddress(v string) *ListTaskInput {
	s.Address = &v
	return s
}

// SetID sets the ID field's value.
func (s *ListTaskInput) SetID(v string) *ListTaskInput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListTaskInput) SetName(v string) *ListTaskInput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *ListTaskInput) SetOwner(v string) *ListTaskInput {
	s.Owner = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListTaskInput) SetPageNum(v int64) *ListTaskInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTaskInput) SetPageSize(v int64) *ListTaskInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListTaskInput) SetProjectName(v string) *ListTaskInput {
	s.ProjectName = &v
	return s
}

type ListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageNum *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Pagination *PaginationForListTaskOutput `type:"structure" json:",omitempty"`

	TaskList []*TaskListForListTaskOutput `type:"list" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskOutput) GoString() string {
	return s.String()
}

// SetPageNum sets the PageNum field's value.
func (s *ListTaskOutput) SetPageNum(v int64) *ListTaskOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTaskOutput) SetPageSize(v int64) *ListTaskOutput {
	s.PageSize = &v
	return s
}

// SetPagination sets the Pagination field's value.
func (s *ListTaskOutput) SetPagination(v *PaginationForListTaskOutput) *ListTaskOutput {
	s.Pagination = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *ListTaskOutput) SetTaskList(v []*TaskListForListTaskOutput) *ListTaskOutput {
	s.TaskList = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListTaskOutput) SetTotal(v int64) *ListTaskOutput {
	s.Total = &v
	return s
}

type PaginationForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PageNum *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PaginationForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PaginationForListTaskOutput) GoString() string {
	return s.String()
}

// SetPageNum sets the PageNum field's value.
func (s *PaginationForListTaskOutput) SetPageNum(v int64) *PaginationForListTaskOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PaginationForListTaskOutput) SetPageSize(v int64) *PaginationForListTaskOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *PaginationForListTaskOutput) SetTotal(v int64) *PaginationForListTaskOutput {
	s.Total = &v
	return s
}

type PeriodConfigForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Days []*int64 `type:"list" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	TimeRangeConfig []*TimeRangeConfigForListTaskOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s PeriodConfigForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PeriodConfigForListTaskOutput) GoString() string {
	return s.String()
}

// SetDays sets the Days field's value.
func (s *PeriodConfigForListTaskOutput) SetDays(v []*int64) *PeriodConfigForListTaskOutput {
	s.Days = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PeriodConfigForListTaskOutput) SetPeriod(v int32) *PeriodConfigForListTaskOutput {
	s.Period = &v
	return s
}

// SetTimeRangeConfig sets the TimeRangeConfig field's value.
func (s *PeriodConfigForListTaskOutput) SetTimeRangeConfig(v []*TimeRangeConfigForListTaskOutput) *PeriodConfigForListTaskOutput {
	s.TimeRangeConfig = v
	return s
}

type StartTimeForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartTimeForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimeForListTaskOutput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *StartTimeForListTaskOutput) SetHour(v int32) *StartTimeForListTaskOutput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *StartTimeForListTaskOutput) SetMinute(v int32) *StartTimeForListTaskOutput {
	s.Minute = &v
	return s
}

type TaskListForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	CreateTime *int64 `type:"int64" json:",omitempty"`

	EnableShuffle *bool `type:"boolean" json:",omitempty"`

	FinishTime *int64 `type:"int64" json:",omitempty"`

	HTTPMethod *int32 `type:"int32" json:",omitempty"`

	ID *int64 `type:"int64" json:",omitempty"`

	IntervalSeconds *int32 `type:"int32" json:",omitempty"`

	Labels []*LabelForListTaskOutput `type:"list" json:",omitempty"`

	LineIDList []*int64 `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Owner *string `type:"string" json:",omitempty"`

	PeriodConfig *PeriodConfigForListTaskOutput `type:"structure" json:",omitempty"`

	RunnerIDList []*int64 `type:"list" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubTaskType *int32 `type:"int32" json:",omitempty"`

	TaskGroupID *int64 `type:"int64" json:",omitempty"`

	TaskGroupName *string `type:"string" json:",omitempty"`

	TaskType *int32 `type:"int32" json:",omitempty"`

	UpdateTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TaskListForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskListForListTaskOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *TaskListForListTaskOutput) SetAddress(v string) *TaskListForListTaskOutput {
	s.Address = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *TaskListForListTaskOutput) SetCreateTime(v int64) *TaskListForListTaskOutput {
	s.CreateTime = &v
	return s
}

// SetEnableShuffle sets the EnableShuffle field's value.
func (s *TaskListForListTaskOutput) SetEnableShuffle(v bool) *TaskListForListTaskOutput {
	s.EnableShuffle = &v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *TaskListForListTaskOutput) SetFinishTime(v int64) *TaskListForListTaskOutput {
	s.FinishTime = &v
	return s
}

// SetHTTPMethod sets the HTTPMethod field's value.
func (s *TaskListForListTaskOutput) SetHTTPMethod(v int32) *TaskListForListTaskOutput {
	s.HTTPMethod = &v
	return s
}

// SetID sets the ID field's value.
func (s *TaskListForListTaskOutput) SetID(v int64) *TaskListForListTaskOutput {
	s.ID = &v
	return s
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *TaskListForListTaskOutput) SetIntervalSeconds(v int32) *TaskListForListTaskOutput {
	s.IntervalSeconds = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *TaskListForListTaskOutput) SetLabels(v []*LabelForListTaskOutput) *TaskListForListTaskOutput {
	s.Labels = v
	return s
}

// SetLineIDList sets the LineIDList field's value.
func (s *TaskListForListTaskOutput) SetLineIDList(v []*int64) *TaskListForListTaskOutput {
	s.LineIDList = v
	return s
}

// SetName sets the Name field's value.
func (s *TaskListForListTaskOutput) SetName(v string) *TaskListForListTaskOutput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *TaskListForListTaskOutput) SetOwner(v string) *TaskListForListTaskOutput {
	s.Owner = &v
	return s
}

// SetPeriodConfig sets the PeriodConfig field's value.
func (s *TaskListForListTaskOutput) SetPeriodConfig(v *PeriodConfigForListTaskOutput) *TaskListForListTaskOutput {
	s.PeriodConfig = v
	return s
}

// SetRunnerIDList sets the RunnerIDList field's value.
func (s *TaskListForListTaskOutput) SetRunnerIDList(v []*int64) *TaskListForListTaskOutput {
	s.RunnerIDList = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TaskListForListTaskOutput) SetStatus(v int32) *TaskListForListTaskOutput {
	s.Status = &v
	return s
}

// SetSubTaskType sets the SubTaskType field's value.
func (s *TaskListForListTaskOutput) SetSubTaskType(v int32) *TaskListForListTaskOutput {
	s.SubTaskType = &v
	return s
}

// SetTaskGroupID sets the TaskGroupID field's value.
func (s *TaskListForListTaskOutput) SetTaskGroupID(v int64) *TaskListForListTaskOutput {
	s.TaskGroupID = &v
	return s
}

// SetTaskGroupName sets the TaskGroupName field's value.
func (s *TaskListForListTaskOutput) SetTaskGroupName(v string) *TaskListForListTaskOutput {
	s.TaskGroupName = &v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *TaskListForListTaskOutput) SetTaskType(v int32) *TaskListForListTaskOutput {
	s.TaskType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *TaskListForListTaskOutput) SetUpdateTime(v int64) *TaskListForListTaskOutput {
	s.UpdateTime = &v
	return s
}

type TimeRangeConfigForListTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndTime *EndTimeForListTaskOutput `type:"structure" json:",omitempty"`

	Interval *int64 `type:"int64" json:",omitempty"`

	StartTime *StartTimeForListTaskOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TimeRangeConfigForListTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRangeConfigForListTaskOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeConfigForListTaskOutput) SetEndTime(v *EndTimeForListTaskOutput) *TimeRangeConfigForListTaskOutput {
	s.EndTime = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *TimeRangeConfigForListTaskOutput) SetInterval(v int64) *TimeRangeConfigForListTaskOutput {
	s.Interval = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeConfigForListTaskOutput) SetStartTime(v *StartTimeForListTaskOutput) *TimeRangeConfigForListTaskOutput {
	s.StartTime = v
	return s
}
