// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNodesCommon = "ListNodes"

// ListNodesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodesCommon operation. The "output" return
// value will be populated with the ListNodesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodesCommon Send returns without error.
//
// See ListNodesCommon for more information on using the ListNodesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNodesCommonRequest method.
//    req, resp := client.ListNodesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListNodesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNodesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodesCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListNodesCommon for usage and error information.
func (c *CLOUDDETECT) ListNodesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNodesCommonRequest(input)
	return out, req.Send()
}

// ListNodesCommonWithContext is the same as ListNodesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListNodesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNodesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNodes = "ListNodes"

// ListNodesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNodes operation. The "output" return
// value will be populated with the ListNodesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNodesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNodesCommon Send returns without error.
//
// See ListNodes for more information on using the ListNodes
// API call, and error handling.
//
//    // Example sending a request using the ListNodesRequest method.
//    req, resp := client.ListNodesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListNodesRequest(input *ListNodesInput) (req *request.Request, output *ListNodesOutput) {
	op := &request.Operation{
		Name:       opListNodes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNodesInput{}
	}

	output = &ListNodesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNodes API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListNodes for usage and error information.
func (c *CLOUDDETECT) ListNodes(input *ListNodesInput) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	return out, req.Send()
}

// ListNodesWithContext is the same as ListNodes with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListNodesWithContext(ctx volcengine.Context, input *ListNodesInput, opts ...request.Option) (*ListNodesOutput, error) {
	req, out := c.ListNodesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type LineListForListNodesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ID *int64 `type:"int64" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LineListForListNodesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LineListForListNodesOutput) GoString() string {
	return s.String()
}

// SetID sets the ID field's value.
func (s *LineListForListNodesOutput) SetID(v int64) *LineListForListNodesOutput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *LineListForListNodesOutput) SetName(v string) *LineListForListNodesOutput {
	s.Name = &v
	return s
}

type ListNodesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// IsMainland is a required field
	IsMainland *bool `type:"boolean" json:",omitempty" required:"true"`

	LineType []*int32 `type:"list" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListNodesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodesInput"}
	if s.IsMainland == nil {
		invalidParams.Add(request.NewErrParamRequired("IsMainland"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsMainland sets the IsMainland field's value.
func (s *ListNodesInput) SetIsMainland(v bool) *ListNodesInput {
	s.IsMainland = &v
	return s
}

// SetLineType sets the LineType field's value.
func (s *ListNodesInput) SetLineType(v []*int32) *ListNodesInput {
	s.LineType = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListNodesInput) SetProjectName(v string) *ListNodesInput {
	s.ProjectName = &v
	return s
}

type ListNodesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	LineList []*LineListForListNodesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListNodesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodesOutput) GoString() string {
	return s.String()
}

// SetLineList sets the LineList field's value.
func (s *ListNodesOutput) SetLineList(v []*LineListForListNodesOutput) *ListNodesOutput {
	s.LineList = v
	return s
}
