// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetTaskResultCommon = "GetTaskResult"

// GetTaskResultCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetTaskResultCommon operation. The "output" return
// value will be populated with the GetTaskResultCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetTaskResultCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetTaskResultCommon Send returns without error.
//
// See GetTaskResultCommon for more information on using the GetTaskResultCommon
// API call, and error handling.
//
//    // Example sending a request using the GetTaskResultCommonRequest method.
//    req, resp := client.GetTaskResultCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) GetTaskResultCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetTaskResultCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetTaskResultCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation GetTaskResultCommon for usage and error information.
func (c *CLOUDDETECT) GetTaskResultCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetTaskResultCommonRequest(input)
	return out, req.Send()
}

// GetTaskResultCommonWithContext is the same as GetTaskResultCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaskResultCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) GetTaskResultCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetTaskResultCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTaskResult = "GetTaskResult"

// GetTaskResultRequest generates a "volcengine/request.Request" representing the
// client's request for the GetTaskResult operation. The "output" return
// value will be populated with the GetTaskResultCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetTaskResultCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetTaskResultCommon Send returns without error.
//
// See GetTaskResult for more information on using the GetTaskResult
// API call, and error handling.
//
//    // Example sending a request using the GetTaskResultRequest method.
//    req, resp := client.GetTaskResultRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) GetTaskResultRequest(input *GetTaskResultInput) (req *request.Request, output *GetTaskResultOutput) {
	op := &request.Operation{
		Name:       opGetTaskResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTaskResultInput{}
	}

	output = &GetTaskResultOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetTaskResult API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation GetTaskResult for usage and error information.
func (c *CLOUDDETECT) GetTaskResult(input *GetTaskResultInput) (*GetTaskResultOutput, error) {
	req, out := c.GetTaskResultRequest(input)
	return out, req.Send()
}

// GetTaskResultWithContext is the same as GetTaskResult with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaskResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) GetTaskResultWithContext(ctx volcengine.Context, input *GetTaskResultInput, opts ...request.Option) (*GetTaskResultOutput, error) {
	req, out := c.GetTaskResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssertionForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConditionMessage *string `type:"string" json:",omitempty"`

	ResultValue *string `type:"string" json:",omitempty"`

	Success *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AssertionForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AssertionForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetConditionMessage sets the ConditionMessage field's value.
func (s *AssertionForGetTaskResultOutput) SetConditionMessage(v string) *AssertionForGetTaskResultOutput {
	s.ConditionMessage = &v
	return s
}

// SetResultValue sets the ResultValue field's value.
func (s *AssertionForGetTaskResultOutput) SetResultValue(v string) *AssertionForGetTaskResultOutput {
	s.ResultValue = &v
	return s
}

// SetSuccess sets the Success field's value.
func (s *AssertionForGetTaskResultOutput) SetSuccess(v bool) *AssertionForGetTaskResultOutput {
	s.Success = &v
	return s
}

type BasicDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Assertions []*AssertionForGetTaskResultOutput `type:"list" json:",omitempty"`

	ChUk *string `type:"string" json:",omitempty"`

	ClientInfo *ClientInfoForGetTaskResultOutput `type:"structure" json:",omitempty"`

	ErrorMsg *string `type:"string" json:",omitempty"`

	TargetInfo *TargetInfoForGetTaskResultOutput `type:"structure" json:",omitempty"`

	Timestamp *int64 `type:"int64" json:",omitempty"`

	UsabilityInfo *UsabilityInfoForGetTaskResultOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s BasicDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BasicDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetAssertions sets the Assertions field's value.
func (s *BasicDetailForGetTaskResultOutput) SetAssertions(v []*AssertionForGetTaskResultOutput) *BasicDetailForGetTaskResultOutput {
	s.Assertions = v
	return s
}

// SetChUk sets the ChUk field's value.
func (s *BasicDetailForGetTaskResultOutput) SetChUk(v string) *BasicDetailForGetTaskResultOutput {
	s.ChUk = &v
	return s
}

// SetClientInfo sets the ClientInfo field's value.
func (s *BasicDetailForGetTaskResultOutput) SetClientInfo(v *ClientInfoForGetTaskResultOutput) *BasicDetailForGetTaskResultOutput {
	s.ClientInfo = v
	return s
}

// SetErrorMsg sets the ErrorMsg field's value.
func (s *BasicDetailForGetTaskResultOutput) SetErrorMsg(v string) *BasicDetailForGetTaskResultOutput {
	s.ErrorMsg = &v
	return s
}

// SetTargetInfo sets the TargetInfo field's value.
func (s *BasicDetailForGetTaskResultOutput) SetTargetInfo(v *TargetInfoForGetTaskResultOutput) *BasicDetailForGetTaskResultOutput {
	s.TargetInfo = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *BasicDetailForGetTaskResultOutput) SetTimestamp(v int64) *BasicDetailForGetTaskResultOutput {
	s.Timestamp = &v
	return s
}

// SetUsabilityInfo sets the UsabilityInfo field's value.
func (s *BasicDetailForGetTaskResultOutput) SetUsabilityInfo(v *UsabilityInfoForGetTaskResultOutput) *BasicDetailForGetTaskResultOutput {
	s.UsabilityInfo = v
	return s
}

type ClientInfoForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	City *string `type:"string" json:",omitempty"`

	DNSLocalDNSIP *string `type:"string" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	Ipv6 *string `type:"string" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Tupe *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ClientInfoForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientInfoForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *ClientInfoForGetTaskResultOutput) SetCity(v string) *ClientInfoForGetTaskResultOutput {
	s.City = &v
	return s
}

// SetDNSLocalDNSIP sets the DNSLocalDNSIP field's value.
func (s *ClientInfoForGetTaskResultOutput) SetDNSLocalDNSIP(v string) *ClientInfoForGetTaskResultOutput {
	s.DNSLocalDNSIP = &v
	return s
}

// SetIP sets the IP field's value.
func (s *ClientInfoForGetTaskResultOutput) SetIP(v string) *ClientInfoForGetTaskResultOutput {
	s.IP = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *ClientInfoForGetTaskResultOutput) SetIpv6(v string) *ClientInfoForGetTaskResultOutput {
	s.Ipv6 = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *ClientInfoForGetTaskResultOutput) SetIsp(v string) *ClientInfoForGetTaskResultOutput {
	s.Isp = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ClientInfoForGetTaskResultOutput) SetRegion(v string) *ClientInfoForGetTaskResultOutput {
	s.Region = &v
	return s
}

// SetTupe sets the Tupe field's value.
func (s *ClientInfoForGetTaskResultOutput) SetTupe(v string) *ClientInfoForGetTaskResultOutput {
	s.Tupe = &v
	return s
}

type DNSDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ARecord []*string `type:"list" json:",omitempty"`

	AaaaRecord []*string `type:"list" json:",omitempty"`

	CnameRecord []*string `type:"list" json:",omitempty"`

	DNSCost *int64 `type:"int64" json:",omitempty"`

	Detail *string `type:"string" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	RecordCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DNSDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DNSDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetARecord sets the ARecord field's value.
func (s *DNSDetailForGetTaskResultOutput) SetARecord(v []*string) *DNSDetailForGetTaskResultOutput {
	s.ARecord = v
	return s
}

// SetAaaaRecord sets the AaaaRecord field's value.
func (s *DNSDetailForGetTaskResultOutput) SetAaaaRecord(v []*string) *DNSDetailForGetTaskResultOutput {
	s.AaaaRecord = v
	return s
}

// SetCnameRecord sets the CnameRecord field's value.
func (s *DNSDetailForGetTaskResultOutput) SetCnameRecord(v []*string) *DNSDetailForGetTaskResultOutput {
	s.CnameRecord = v
	return s
}

// SetDNSCost sets the DNSCost field's value.
func (s *DNSDetailForGetTaskResultOutput) SetDNSCost(v int64) *DNSDetailForGetTaskResultOutput {
	s.DNSCost = &v
	return s
}

// SetDetail sets the Detail field's value.
func (s *DNSDetailForGetTaskResultOutput) SetDetail(v string) *DNSDetailForGetTaskResultOutput {
	s.Detail = &v
	return s
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *DNSDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *DNSDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetRecordCount sets the RecordCount field's value.
func (s *DNSDetailForGetTaskResultOutput) SetRecordCount(v int32) *DNSDetailForGetTaskResultOutput {
	s.RecordCount = &v
	return s
}

type DataForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BasicDetail *BasicDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	DNSDetail *DNSDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	DownloadDetail *DownloadDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	HTTPDetail *HTTPDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	PageDetail *PageDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	PingDetail *PingDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	TCPDetail *TCPDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	TaskID *int64 `type:"int64" json:",omitempty"`

	UDPDetail *UDPDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	UploadDetail *UploadDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DataForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetBasicDetail sets the BasicDetail field's value.
func (s *DataForGetTaskResultOutput) SetBasicDetail(v *BasicDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.BasicDetail = v
	return s
}

// SetDNSDetail sets the DNSDetail field's value.
func (s *DataForGetTaskResultOutput) SetDNSDetail(v *DNSDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.DNSDetail = v
	return s
}

// SetDownloadDetail sets the DownloadDetail field's value.
func (s *DataForGetTaskResultOutput) SetDownloadDetail(v *DownloadDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.DownloadDetail = v
	return s
}

// SetHTTPDetail sets the HTTPDetail field's value.
func (s *DataForGetTaskResultOutput) SetHTTPDetail(v *HTTPDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.HTTPDetail = v
	return s
}

// SetPageDetail sets the PageDetail field's value.
func (s *DataForGetTaskResultOutput) SetPageDetail(v *PageDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.PageDetail = v
	return s
}

// SetPingDetail sets the PingDetail field's value.
func (s *DataForGetTaskResultOutput) SetPingDetail(v *PingDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.PingDetail = v
	return s
}

// SetTCPDetail sets the TCPDetail field's value.
func (s *DataForGetTaskResultOutput) SetTCPDetail(v *TCPDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.TCPDetail = v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *DataForGetTaskResultOutput) SetTaskID(v int64) *DataForGetTaskResultOutput {
	s.TaskID = &v
	return s
}

// SetUDPDetail sets the UDPDetail field's value.
func (s *DataForGetTaskResultOutput) SetUDPDetail(v *UDPDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.UDPDetail = v
	return s
}

// SetUploadDetail sets the UploadDetail field's value.
func (s *DataForGetTaskResultOutput) SetUploadDetail(v *UploadDetailForGetTaskResultOutput) *DataForGetTaskResultOutput {
	s.UploadDetail = v
	return s
}

type DiagnoseDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSDetail *string `type:"string" json:",omitempty"`

	MtrDetail *string `type:"string" json:",omitempty"`

	PingDetail *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DiagnoseDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DiagnoseDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDNSDetail sets the DNSDetail field's value.
func (s *DiagnoseDetailForGetTaskResultOutput) SetDNSDetail(v string) *DiagnoseDetailForGetTaskResultOutput {
	s.DNSDetail = &v
	return s
}

// SetMtrDetail sets the MtrDetail field's value.
func (s *DiagnoseDetailForGetTaskResultOutput) SetMtrDetail(v string) *DiagnoseDetailForGetTaskResultOutput {
	s.MtrDetail = &v
	return s
}

// SetPingDetail sets the PingDetail field's value.
func (s *DiagnoseDetailForGetTaskResultOutput) SetPingDetail(v string) *DiagnoseDetailForGetTaskResultOutput {
	s.PingDetail = &v
	return s
}

type DownloadDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSCost *int64 `type:"int64" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	DownloadSize *int64 `type:"int64" json:",omitempty"`

	DownloadSpeed *int64 `type:"int64" json:",omitempty"`

	HTTPCode *int64 `type:"int64" json:",omitempty"`

	HTTPRequestHeader *string `type:"string" json:",omitempty"`

	HTTPResponseBody *string `type:"string" json:",omitempty"`

	HTTPResponseHeader *string `type:"string" json:",omitempty"`

	HTTPVersion *string `type:"string" json:",omitempty"`

	LocationDetail []*LocationDetailForGetTaskResultOutput `type:"list" json:",omitempty"`

	RecvCost *int64 `type:"int64" json:",omitempty"`

	RedirectCost *int64 `type:"int64" json:",omitempty"`

	RedirectNums *int64 `type:"int64" json:",omitempty"`

	SendCost *int64 `type:"int64" json:",omitempty"`

	SslCost *int64 `type:"int64" json:",omitempty"`

	TCPCost *int64 `type:"int64" json:",omitempty"`

	TotalCost *int64 `type:"int64" json:",omitempty"`

	TtfbCost *int64 `type:"int64" json:",omitempty"`

	UploadSize *int64 `type:"int64" json:",omitempty"`

	UploadSpeed *int64 `type:"int64" json:",omitempty"`

	UploadTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s DownloadDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDNSCost sets the DNSCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetDNSCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.DNSCost = &v
	return s
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *DownloadDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetDownloadSize sets the DownloadSize field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetDownloadSize(v int64) *DownloadDetailForGetTaskResultOutput {
	s.DownloadSize = &v
	return s
}

// SetDownloadSpeed sets the DownloadSpeed field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetDownloadSpeed(v int64) *DownloadDetailForGetTaskResultOutput {
	s.DownloadSpeed = &v
	return s
}

// SetHTTPCode sets the HTTPCode field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetHTTPCode(v int64) *DownloadDetailForGetTaskResultOutput {
	s.HTTPCode = &v
	return s
}

// SetHTTPRequestHeader sets the HTTPRequestHeader field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetHTTPRequestHeader(v string) *DownloadDetailForGetTaskResultOutput {
	s.HTTPRequestHeader = &v
	return s
}

// SetHTTPResponseBody sets the HTTPResponseBody field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetHTTPResponseBody(v string) *DownloadDetailForGetTaskResultOutput {
	s.HTTPResponseBody = &v
	return s
}

// SetHTTPResponseHeader sets the HTTPResponseHeader field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetHTTPResponseHeader(v string) *DownloadDetailForGetTaskResultOutput {
	s.HTTPResponseHeader = &v
	return s
}

// SetHTTPVersion sets the HTTPVersion field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetHTTPVersion(v string) *DownloadDetailForGetTaskResultOutput {
	s.HTTPVersion = &v
	return s
}

// SetLocationDetail sets the LocationDetail field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetLocationDetail(v []*LocationDetailForGetTaskResultOutput) *DownloadDetailForGetTaskResultOutput {
	s.LocationDetail = v
	return s
}

// SetRecvCost sets the RecvCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetRecvCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.RecvCost = &v
	return s
}

// SetRedirectCost sets the RedirectCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetRedirectCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.RedirectCost = &v
	return s
}

// SetRedirectNums sets the RedirectNums field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetRedirectNums(v int64) *DownloadDetailForGetTaskResultOutput {
	s.RedirectNums = &v
	return s
}

// SetSendCost sets the SendCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetSendCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.SendCost = &v
	return s
}

// SetSslCost sets the SslCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetSslCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.SslCost = &v
	return s
}

// SetTCPCost sets the TCPCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetTCPCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.TCPCost = &v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetTotalCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.TotalCost = &v
	return s
}

// SetTtfbCost sets the TtfbCost field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetTtfbCost(v int64) *DownloadDetailForGetTaskResultOutput {
	s.TtfbCost = &v
	return s
}

// SetUploadSize sets the UploadSize field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetUploadSize(v int64) *DownloadDetailForGetTaskResultOutput {
	s.UploadSize = &v
	return s
}

// SetUploadSpeed sets the UploadSpeed field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetUploadSpeed(v int64) *DownloadDetailForGetTaskResultOutput {
	s.UploadSpeed = &v
	return s
}

// SetUploadTime sets the UploadTime field's value.
func (s *DownloadDetailForGetTaskResultOutput) SetUploadTime(v int64) *DownloadDetailForGetTaskResultOutput {
	s.UploadTime = &v
	return s
}

type GetTaskResultInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// EndTime is a required field
	EndTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// PageNum is a required field
	PageNum *int64 `type:"int64" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int64 `type:"int64" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	// StartTime is a required field
	StartTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// TaskID is a required field
	TaskID *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetTaskResultInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTaskResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTaskResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTaskResultInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.PageNum == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNum"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.TaskID == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetTaskResultInput) SetEndTime(v int64) *GetTaskResultInput {
	s.EndTime = &v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *GetTaskResultInput) SetPageNum(v int64) *GetTaskResultInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *GetTaskResultInput) SetPageSize(v int64) *GetTaskResultInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *GetTaskResultInput) SetProjectName(v string) *GetTaskResultInput {
	s.ProjectName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetTaskResultInput) SetStartTime(v int64) *GetTaskResultInput {
	s.StartTime = &v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *GetTaskResultInput) SetTaskID(v int64) *GetTaskResultInput {
	s.TaskID = &v
	return s
}

type GetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*DataForGetTaskResultOutput `type:"list" json:",omitempty"`

	Pagination *PaginationForGetTaskResultOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s GetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTaskResultOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *GetTaskResultOutput) SetData(v []*DataForGetTaskResultOutput) *GetTaskResultOutput {
	s.Data = v
	return s
}

// SetPagination sets the Pagination field's value.
func (s *GetTaskResultOutput) SetPagination(v *PaginationForGetTaskResultOutput) *GetTaskResultOutput {
	s.Pagination = v
	return s
}

type HTTPDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSCost *int64 `type:"int64" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	HTTPCode *int64 `type:"int64" json:",omitempty"`

	HTTPRequestHeader *string `type:"string" json:",omitempty"`

	HTTPResponseBody *string `type:"string" json:",omitempty"`

	HTTPResponseHeader *string `type:"string" json:",omitempty"`

	HTTPVersion *string `type:"string" json:",omitempty"`

	LocationDetail []*LocationDetailForGetTaskResultOutput `type:"list" json:",omitempty"`

	RecvCost *int64 `type:"int64" json:",omitempty"`

	RedirectCost *int64 `type:"int64" json:",omitempty"`

	RedirectNums *int64 `type:"int64" json:",omitempty"`

	SendCost *int64 `type:"int64" json:",omitempty"`

	SslCost *int64 `type:"int64" json:",omitempty"`

	TCPCost *int64 `type:"int64" json:",omitempty"`

	TotalCost *int64 `type:"int64" json:",omitempty"`

	TtfbCost *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s HTTPDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDNSCost sets the DNSCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetDNSCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.DNSCost = &v
	return s
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *HTTPDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetHTTPCode sets the HTTPCode field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetHTTPCode(v int64) *HTTPDetailForGetTaskResultOutput {
	s.HTTPCode = &v
	return s
}

// SetHTTPRequestHeader sets the HTTPRequestHeader field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetHTTPRequestHeader(v string) *HTTPDetailForGetTaskResultOutput {
	s.HTTPRequestHeader = &v
	return s
}

// SetHTTPResponseBody sets the HTTPResponseBody field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetHTTPResponseBody(v string) *HTTPDetailForGetTaskResultOutput {
	s.HTTPResponseBody = &v
	return s
}

// SetHTTPResponseHeader sets the HTTPResponseHeader field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetHTTPResponseHeader(v string) *HTTPDetailForGetTaskResultOutput {
	s.HTTPResponseHeader = &v
	return s
}

// SetHTTPVersion sets the HTTPVersion field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetHTTPVersion(v string) *HTTPDetailForGetTaskResultOutput {
	s.HTTPVersion = &v
	return s
}

// SetLocationDetail sets the LocationDetail field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetLocationDetail(v []*LocationDetailForGetTaskResultOutput) *HTTPDetailForGetTaskResultOutput {
	s.LocationDetail = v
	return s
}

// SetRecvCost sets the RecvCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetRecvCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.RecvCost = &v
	return s
}

// SetRedirectCost sets the RedirectCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetRedirectCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.RedirectCost = &v
	return s
}

// SetRedirectNums sets the RedirectNums field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetRedirectNums(v int64) *HTTPDetailForGetTaskResultOutput {
	s.RedirectNums = &v
	return s
}

// SetSendCost sets the SendCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetSendCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.SendCost = &v
	return s
}

// SetSslCost sets the SslCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetSslCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.SslCost = &v
	return s
}

// SetTCPCost sets the TCPCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetTCPCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.TCPCost = &v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetTotalCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.TotalCost = &v
	return s
}

// SetTtfbCost sets the TtfbCost field's value.
func (s *HTTPDetailForGetTaskResultOutput) SetTtfbCost(v int64) *HTTPDetailForGetTaskResultOutput {
	s.TtfbCost = &v
	return s
}

type LocationDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RemoteAddress *string `type:"string" json:",omitempty"`

	RequestHeaders []*RequestHeaderForGetTaskResultOutput `type:"list" json:",omitempty"`

	ResponseHeaders []*ResponseHeaderForGetTaskResultOutput `type:"list" json:",omitempty"`

	StatusCode *int32 `type:"int32" json:",omitempty"`

	TimeDNS *float64 `type:"double" json:",omitempty"`

	TimeReceive *float64 `type:"double" json:",omitempty"`

	TimeSsl *float64 `type:"double" json:",omitempty"`

	TimeTCP *float64 `type:"double" json:",omitempty"`

	TimeTotal *float64 `type:"double" json:",omitempty"`

	TimeWait *float64 `type:"double" json:",omitempty"`

	URL *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LocationDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LocationDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetRemoteAddress sets the RemoteAddress field's value.
func (s *LocationDetailForGetTaskResultOutput) SetRemoteAddress(v string) *LocationDetailForGetTaskResultOutput {
	s.RemoteAddress = &v
	return s
}

// SetRequestHeaders sets the RequestHeaders field's value.
func (s *LocationDetailForGetTaskResultOutput) SetRequestHeaders(v []*RequestHeaderForGetTaskResultOutput) *LocationDetailForGetTaskResultOutput {
	s.RequestHeaders = v
	return s
}

// SetResponseHeaders sets the ResponseHeaders field's value.
func (s *LocationDetailForGetTaskResultOutput) SetResponseHeaders(v []*ResponseHeaderForGetTaskResultOutput) *LocationDetailForGetTaskResultOutput {
	s.ResponseHeaders = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *LocationDetailForGetTaskResultOutput) SetStatusCode(v int32) *LocationDetailForGetTaskResultOutput {
	s.StatusCode = &v
	return s
}

// SetTimeDNS sets the TimeDNS field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeDNS(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeDNS = &v
	return s
}

// SetTimeReceive sets the TimeReceive field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeReceive(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeReceive = &v
	return s
}

// SetTimeSsl sets the TimeSsl field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeSsl(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeSsl = &v
	return s
}

// SetTimeTCP sets the TimeTCP field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeTCP(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeTCP = &v
	return s
}

// SetTimeTotal sets the TimeTotal field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeTotal(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeTotal = &v
	return s
}

// SetTimeWait sets the TimeWait field's value.
func (s *LocationDetailForGetTaskResultOutput) SetTimeWait(v float64) *LocationDetailForGetTaskResultOutput {
	s.TimeWait = &v
	return s
}

// SetURL sets the URL field's value.
func (s *LocationDetailForGetTaskResultOutput) SetURL(v string) *LocationDetailForGetTaskResultOutput {
	s.URL = &v
	return s
}

type PageDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	HTTPRequestHeader *string `type:"string" json:",omitempty"`

	HTTPResponseHeader *string `type:"string" json:",omitempty"`

	PageCountElement *int64 `type:"int64" json:",omitempty"`

	PageCountErrorElement *int64 `type:"int64" json:",omitempty"`

	PageDownloadBytesTotal *int64 `type:"int64" json:",omitempty"`

	PageElemSpeedAvg *float64 `type:"double" json:",omitempty"`

	PageElementSpeedAvg *int64 `type:"int64" json:",omitempty"`

	PageErrorElemProportion *float64 `type:"double" json:",omitempty"`

	PageErrorElementProportion *int64 `type:"int64" json:",omitempty"`

	PageRequestID *string `type:"string" json:",omitempty"`

	PageTimeFirstScreen *int64 `type:"int64" json:",omitempty"`

	PageTimeTotal *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PageDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *PageDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *PageDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetHTTPRequestHeader sets the HTTPRequestHeader field's value.
func (s *PageDetailForGetTaskResultOutput) SetHTTPRequestHeader(v string) *PageDetailForGetTaskResultOutput {
	s.HTTPRequestHeader = &v
	return s
}

// SetHTTPResponseHeader sets the HTTPResponseHeader field's value.
func (s *PageDetailForGetTaskResultOutput) SetHTTPResponseHeader(v string) *PageDetailForGetTaskResultOutput {
	s.HTTPResponseHeader = &v
	return s
}

// SetPageCountElement sets the PageCountElement field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageCountElement(v int64) *PageDetailForGetTaskResultOutput {
	s.PageCountElement = &v
	return s
}

// SetPageCountErrorElement sets the PageCountErrorElement field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageCountErrorElement(v int64) *PageDetailForGetTaskResultOutput {
	s.PageCountErrorElement = &v
	return s
}

// SetPageDownloadBytesTotal sets the PageDownloadBytesTotal field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageDownloadBytesTotal(v int64) *PageDetailForGetTaskResultOutput {
	s.PageDownloadBytesTotal = &v
	return s
}

// SetPageElemSpeedAvg sets the PageElemSpeedAvg field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageElemSpeedAvg(v float64) *PageDetailForGetTaskResultOutput {
	s.PageElemSpeedAvg = &v
	return s
}

// SetPageElementSpeedAvg sets the PageElementSpeedAvg field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageElementSpeedAvg(v int64) *PageDetailForGetTaskResultOutput {
	s.PageElementSpeedAvg = &v
	return s
}

// SetPageErrorElemProportion sets the PageErrorElemProportion field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageErrorElemProportion(v float64) *PageDetailForGetTaskResultOutput {
	s.PageErrorElemProportion = &v
	return s
}

// SetPageErrorElementProportion sets the PageErrorElementProportion field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageErrorElementProportion(v int64) *PageDetailForGetTaskResultOutput {
	s.PageErrorElementProportion = &v
	return s
}

// SetPageRequestID sets the PageRequestID field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageRequestID(v string) *PageDetailForGetTaskResultOutput {
	s.PageRequestID = &v
	return s
}

// SetPageTimeFirstScreen sets the PageTimeFirstScreen field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageTimeFirstScreen(v int64) *PageDetailForGetTaskResultOutput {
	s.PageTimeFirstScreen = &v
	return s
}

// SetPageTimeTotal sets the PageTimeTotal field's value.
func (s *PageDetailForGetTaskResultOutput) SetPageTimeTotal(v int64) *PageDetailForGetTaskResultOutput {
	s.PageTimeTotal = &v
	return s
}

type PaginationForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PageNum *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PaginationForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PaginationForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetPageNum sets the PageNum field's value.
func (s *PaginationForGetTaskResultOutput) SetPageNum(v int64) *PaginationForGetTaskResultOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PaginationForGetTaskResultOutput) SetPageSize(v int64) *PaginationForGetTaskResultOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *PaginationForGetTaskResultOutput) SetTotal(v int64) *PaginationForGetTaskResultOutput {
	s.Total = &v
	return s
}

type PingDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSCost *int64 `type:"int64" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	MtrHops *int64 `type:"int64" json:",omitempty"`

	PingAvgCost *int64 `type:"int64" json:",omitempty"`

	PingDetail *string `type:"string" json:",omitempty"`

	PingLossRate *float64 `type:"double" json:",omitempty"`

	PingMaxCost *int64 `type:"int64" json:",omitempty"`

	PingMinCost *int64 `type:"int64" json:",omitempty"`

	PingReceiveTimes *int64 `type:"int64" json:",omitempty"`

	PingSendTimes *int64 `type:"int64" json:",omitempty"`

	ResolveCost *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PingDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PingDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDNSCost sets the DNSCost field's value.
func (s *PingDetailForGetTaskResultOutput) SetDNSCost(v int64) *PingDetailForGetTaskResultOutput {
	s.DNSCost = &v
	return s
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *PingDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *PingDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetMtrHops sets the MtrHops field's value.
func (s *PingDetailForGetTaskResultOutput) SetMtrHops(v int64) *PingDetailForGetTaskResultOutput {
	s.MtrHops = &v
	return s
}

// SetPingAvgCost sets the PingAvgCost field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingAvgCost(v int64) *PingDetailForGetTaskResultOutput {
	s.PingAvgCost = &v
	return s
}

// SetPingDetail sets the PingDetail field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingDetail(v string) *PingDetailForGetTaskResultOutput {
	s.PingDetail = &v
	return s
}

// SetPingLossRate sets the PingLossRate field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingLossRate(v float64) *PingDetailForGetTaskResultOutput {
	s.PingLossRate = &v
	return s
}

// SetPingMaxCost sets the PingMaxCost field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingMaxCost(v int64) *PingDetailForGetTaskResultOutput {
	s.PingMaxCost = &v
	return s
}

// SetPingMinCost sets the PingMinCost field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingMinCost(v int64) *PingDetailForGetTaskResultOutput {
	s.PingMinCost = &v
	return s
}

// SetPingReceiveTimes sets the PingReceiveTimes field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingReceiveTimes(v int64) *PingDetailForGetTaskResultOutput {
	s.PingReceiveTimes = &v
	return s
}

// SetPingSendTimes sets the PingSendTimes field's value.
func (s *PingDetailForGetTaskResultOutput) SetPingSendTimes(v int64) *PingDetailForGetTaskResultOutput {
	s.PingSendTimes = &v
	return s
}

// SetResolveCost sets the ResolveCost field's value.
func (s *PingDetailForGetTaskResultOutput) SetResolveCost(v int64) *PingDetailForGetTaskResultOutput {
	s.ResolveCost = &v
	return s
}

type RequestHeaderForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *RequestHeaderForGetTaskResultOutput) SetKey(v string) *RequestHeaderForGetTaskResultOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderForGetTaskResultOutput) SetValue(v string) *RequestHeaderForGetTaskResultOutput {
	s.Value = &v
	return s
}

type ResponseHeaderForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResponseHeaderForGetTaskResultOutput) SetKey(v string) *ResponseHeaderForGetTaskResultOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResponseHeaderForGetTaskResultOutput) SetValue(v string) *ResponseHeaderForGetTaskResultOutput {
	s.Value = &v
	return s
}

type TCPDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	TCPResponse *string `type:"string" json:",omitempty"`

	TCPTimeConnect *int64 `type:"int64" json:",omitempty"`

	TCPTimeDNS *int64 `type:"int64" json:",omitempty"`

	TCPTimeReceive *int64 `type:"int64" json:",omitempty"`

	TCPTimeResponse *int64 `type:"int64" json:",omitempty"`

	TCPTimeTotal *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TCPDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *TCPDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *TCPDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetTCPResponse sets the TCPResponse field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPResponse(v string) *TCPDetailForGetTaskResultOutput {
	s.TCPResponse = &v
	return s
}

// SetTCPTimeConnect sets the TCPTimeConnect field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPTimeConnect(v int64) *TCPDetailForGetTaskResultOutput {
	s.TCPTimeConnect = &v
	return s
}

// SetTCPTimeDNS sets the TCPTimeDNS field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPTimeDNS(v int64) *TCPDetailForGetTaskResultOutput {
	s.TCPTimeDNS = &v
	return s
}

// SetTCPTimeReceive sets the TCPTimeReceive field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPTimeReceive(v int64) *TCPDetailForGetTaskResultOutput {
	s.TCPTimeReceive = &v
	return s
}

// SetTCPTimeResponse sets the TCPTimeResponse field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPTimeResponse(v int64) *TCPDetailForGetTaskResultOutput {
	s.TCPTimeResponse = &v
	return s
}

// SetTCPTimeTotal sets the TCPTimeTotal field's value.
func (s *TCPDetailForGetTaskResultOutput) SetTCPTimeTotal(v int64) *TCPDetailForGetTaskResultOutput {
	s.TCPTimeTotal = &v
	return s
}

type TargetInfoForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	City *string `type:"string" json:",omitempty"`

	DetectURL *string `type:"string" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	Ipv6 *string `type:"string" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetInfoForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetInfoForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *TargetInfoForGetTaskResultOutput) SetCity(v string) *TargetInfoForGetTaskResultOutput {
	s.City = &v
	return s
}

// SetDetectURL sets the DetectURL field's value.
func (s *TargetInfoForGetTaskResultOutput) SetDetectURL(v string) *TargetInfoForGetTaskResultOutput {
	s.DetectURL = &v
	return s
}

// SetIP sets the IP field's value.
func (s *TargetInfoForGetTaskResultOutput) SetIP(v string) *TargetInfoForGetTaskResultOutput {
	s.IP = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *TargetInfoForGetTaskResultOutput) SetIpv6(v string) *TargetInfoForGetTaskResultOutput {
	s.Ipv6 = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *TargetInfoForGetTaskResultOutput) SetIsp(v string) *TargetInfoForGetTaskResultOutput {
	s.Isp = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *TargetInfoForGetTaskResultOutput) SetRegion(v string) *TargetInfoForGetTaskResultOutput {
	s.Region = &v
	return s
}

type UDPDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	UDPResponse *string `type:"string" json:",omitempty"`

	UDPTimeDNS *int64 `type:"int64" json:",omitempty"`

	UDPTimeReceive *int64 `type:"int64" json:",omitempty"`

	UDPTimeTotal *int64 `type:"int64" json:",omitempty"`

	UDPTimeWait *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s UDPDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UDPDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *UDPDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *UDPDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetUDPResponse sets the UDPResponse field's value.
func (s *UDPDetailForGetTaskResultOutput) SetUDPResponse(v string) *UDPDetailForGetTaskResultOutput {
	s.UDPResponse = &v
	return s
}

// SetUDPTimeDNS sets the UDPTimeDNS field's value.
func (s *UDPDetailForGetTaskResultOutput) SetUDPTimeDNS(v int64) *UDPDetailForGetTaskResultOutput {
	s.UDPTimeDNS = &v
	return s
}

// SetUDPTimeReceive sets the UDPTimeReceive field's value.
func (s *UDPDetailForGetTaskResultOutput) SetUDPTimeReceive(v int64) *UDPDetailForGetTaskResultOutput {
	s.UDPTimeReceive = &v
	return s
}

// SetUDPTimeTotal sets the UDPTimeTotal field's value.
func (s *UDPDetailForGetTaskResultOutput) SetUDPTimeTotal(v int64) *UDPDetailForGetTaskResultOutput {
	s.UDPTimeTotal = &v
	return s
}

// SetUDPTimeWait sets the UDPTimeWait field's value.
func (s *UDPDetailForGetTaskResultOutput) SetUDPTimeWait(v int64) *UDPDetailForGetTaskResultOutput {
	s.UDPTimeWait = &v
	return s
}

type UploadDetailForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSCost *int64 `type:"int64" json:",omitempty"`

	DiagnoseDetail *DiagnoseDetailForGetTaskResultOutput `type:"structure" json:",omitempty"`

	DownloadSize *int64 `type:"int64" json:",omitempty"`

	DownloadSpeed *int64 `type:"int64" json:",omitempty"`

	HTTPCode *int64 `type:"int64" json:",omitempty"`

	HTTPRequestHeader *string `type:"string" json:",omitempty"`

	HTTPResponseBody *string `type:"string" json:",omitempty"`

	HTTPResponseHeader *string `type:"string" json:",omitempty"`

	LocationDetail []*LocationDetailForGetTaskResultOutput `type:"list" json:",omitempty"`

	RecvCost *int64 `type:"int64" json:",omitempty"`

	RedirectCost *int64 `type:"int64" json:",omitempty"`

	RedirectNums *int64 `type:"int64" json:",omitempty"`

	SendCost *int64 `type:"int64" json:",omitempty"`

	SslCost *int64 `type:"int64" json:",omitempty"`

	TCPCost *int64 `type:"int64" json:",omitempty"`

	TotalCost *int64 `type:"int64" json:",omitempty"`

	TtfbCost *int64 `type:"int64" json:",omitempty"`

	UploadSize *int64 `type:"int64" json:",omitempty"`

	UploadSpeed *int64 `type:"int64" json:",omitempty"`

	UploadTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s UploadDetailForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadDetailForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetDNSCost sets the DNSCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetDNSCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.DNSCost = &v
	return s
}

// SetDiagnoseDetail sets the DiagnoseDetail field's value.
func (s *UploadDetailForGetTaskResultOutput) SetDiagnoseDetail(v *DiagnoseDetailForGetTaskResultOutput) *UploadDetailForGetTaskResultOutput {
	s.DiagnoseDetail = v
	return s
}

// SetDownloadSize sets the DownloadSize field's value.
func (s *UploadDetailForGetTaskResultOutput) SetDownloadSize(v int64) *UploadDetailForGetTaskResultOutput {
	s.DownloadSize = &v
	return s
}

// SetDownloadSpeed sets the DownloadSpeed field's value.
func (s *UploadDetailForGetTaskResultOutput) SetDownloadSpeed(v int64) *UploadDetailForGetTaskResultOutput {
	s.DownloadSpeed = &v
	return s
}

// SetHTTPCode sets the HTTPCode field's value.
func (s *UploadDetailForGetTaskResultOutput) SetHTTPCode(v int64) *UploadDetailForGetTaskResultOutput {
	s.HTTPCode = &v
	return s
}

// SetHTTPRequestHeader sets the HTTPRequestHeader field's value.
func (s *UploadDetailForGetTaskResultOutput) SetHTTPRequestHeader(v string) *UploadDetailForGetTaskResultOutput {
	s.HTTPRequestHeader = &v
	return s
}

// SetHTTPResponseBody sets the HTTPResponseBody field's value.
func (s *UploadDetailForGetTaskResultOutput) SetHTTPResponseBody(v string) *UploadDetailForGetTaskResultOutput {
	s.HTTPResponseBody = &v
	return s
}

// SetHTTPResponseHeader sets the HTTPResponseHeader field's value.
func (s *UploadDetailForGetTaskResultOutput) SetHTTPResponseHeader(v string) *UploadDetailForGetTaskResultOutput {
	s.HTTPResponseHeader = &v
	return s
}

// SetLocationDetail sets the LocationDetail field's value.
func (s *UploadDetailForGetTaskResultOutput) SetLocationDetail(v []*LocationDetailForGetTaskResultOutput) *UploadDetailForGetTaskResultOutput {
	s.LocationDetail = v
	return s
}

// SetRecvCost sets the RecvCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetRecvCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.RecvCost = &v
	return s
}

// SetRedirectCost sets the RedirectCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetRedirectCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.RedirectCost = &v
	return s
}

// SetRedirectNums sets the RedirectNums field's value.
func (s *UploadDetailForGetTaskResultOutput) SetRedirectNums(v int64) *UploadDetailForGetTaskResultOutput {
	s.RedirectNums = &v
	return s
}

// SetSendCost sets the SendCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetSendCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.SendCost = &v
	return s
}

// SetSslCost sets the SslCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetSslCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.SslCost = &v
	return s
}

// SetTCPCost sets the TCPCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetTCPCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.TCPCost = &v
	return s
}

// SetTotalCost sets the TotalCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetTotalCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.TotalCost = &v
	return s
}

// SetTtfbCost sets the TtfbCost field's value.
func (s *UploadDetailForGetTaskResultOutput) SetTtfbCost(v int64) *UploadDetailForGetTaskResultOutput {
	s.TtfbCost = &v
	return s
}

// SetUploadSize sets the UploadSize field's value.
func (s *UploadDetailForGetTaskResultOutput) SetUploadSize(v int64) *UploadDetailForGetTaskResultOutput {
	s.UploadSize = &v
	return s
}

// SetUploadSpeed sets the UploadSpeed field's value.
func (s *UploadDetailForGetTaskResultOutput) SetUploadSpeed(v int64) *UploadDetailForGetTaskResultOutput {
	s.UploadSpeed = &v
	return s
}

// SetUploadTime sets the UploadTime field's value.
func (s *UploadDetailForGetTaskResultOutput) SetUploadTime(v int64) *UploadDetailForGetTaskResultOutput {
	s.UploadTime = &v
	return s
}

type UsabilityInfoForGetTaskResultOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Reason []*string `type:"list" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UsabilityInfoForGetTaskResultOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UsabilityInfoForGetTaskResultOutput) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *UsabilityInfoForGetTaskResultOutput) SetReason(v []*string) *UsabilityInfoForGetTaskResultOutput {
	s.Reason = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UsabilityInfoForGetTaskResultOutput) SetStatus(v string) *UsabilityInfoForGetTaskResultOutput {
	s.Status = &v
	return s
}
