// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clb

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNetworkLoadBalancerCommon = "CreateNetworkLoadBalancer"

// CreateNetworkLoadBalancerCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNetworkLoadBalancerCommon operation. The "output" return
// value will be populated with the CreateNetworkLoadBalancerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNetworkLoadBalancerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNetworkLoadBalancerCommon Send returns without error.
//
// See CreateNetworkLoadBalancerCommon for more information on using the CreateNetworkLoadBalancerCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNetworkLoadBalancerCommonRequest method.
//    req, resp := client.CreateNetworkLoadBalancerCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) CreateNetworkLoadBalancerCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNetworkLoadBalancerCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNetworkLoadBalancerCommon API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation CreateNetworkLoadBalancerCommon for usage and error information.
func (c *CLB) CreateNetworkLoadBalancerCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNetworkLoadBalancerCommonRequest(input)
	return out, req.Send()
}

// CreateNetworkLoadBalancerCommonWithContext is the same as CreateNetworkLoadBalancerCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkLoadBalancerCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) CreateNetworkLoadBalancerCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNetworkLoadBalancerCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNetworkLoadBalancer = "CreateNetworkLoadBalancer"

// CreateNetworkLoadBalancerRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNetworkLoadBalancer operation. The "output" return
// value will be populated with the CreateNetworkLoadBalancerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNetworkLoadBalancerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNetworkLoadBalancerCommon Send returns without error.
//
// See CreateNetworkLoadBalancer for more information on using the CreateNetworkLoadBalancer
// API call, and error handling.
//
//    // Example sending a request using the CreateNetworkLoadBalancerRequest method.
//    req, resp := client.CreateNetworkLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) CreateNetworkLoadBalancerRequest(input *CreateNetworkLoadBalancerInput) (req *request.Request, output *CreateNetworkLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCreateNetworkLoadBalancer,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNetworkLoadBalancerInput{}
	}

	output = &CreateNetworkLoadBalancerOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateNetworkLoadBalancer API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation CreateNetworkLoadBalancer for usage and error information.
func (c *CLB) CreateNetworkLoadBalancer(input *CreateNetworkLoadBalancerInput) (*CreateNetworkLoadBalancerOutput, error) {
	req, out := c.CreateNetworkLoadBalancerRequest(input)
	return out, req.Send()
}

// CreateNetworkLoadBalancerWithContext is the same as CreateNetworkLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNetworkLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) CreateNetworkLoadBalancerWithContext(ctx volcengine.Context, input *CreateNetworkLoadBalancerInput, opts ...request.Option) (*CreateNetworkLoadBalancerOutput, error) {
	req, out := c.CreateNetworkLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNetworkLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `type:"string"`

	CrossZoneEnabled *bool `type:"boolean"`

	Description *string `type:"string"`

	IpAddressVersion *string `type:"string"`

	Ipv4BandwidthPackageId *string `type:"string"`

	LoadBalancerName *string `type:"string"`

	ModificationProtectionStatus *string `type:"string"`

	// NetworkType is a required field
	NetworkType *string `type:"string" required:"true"`

	ProjectName *string `type:"string"`

	// RegionId is a required field
	RegionId *string `type:"string" required:"true"`

	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	Tags []*TagForCreateNetworkLoadBalancerInput `type:"list"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`

	ZoneMappings []*ZoneMappingForCreateNetworkLoadBalancerInput `type:"list"`
}

// String returns the string representation
func (s CreateNetworkLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNetworkLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNetworkLoadBalancerInput"}
	if s.NetworkType == nil {
		invalidParams.Add(request.NewErrParamRequired("NetworkType"))
	}
	if s.RegionId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionId"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.ZoneMappings != nil {
		for i, v := range s.ZoneMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ZoneMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateNetworkLoadBalancerInput) SetClientToken(v string) *CreateNetworkLoadBalancerInput {
	s.ClientToken = &v
	return s
}

// SetCrossZoneEnabled sets the CrossZoneEnabled field's value.
func (s *CreateNetworkLoadBalancerInput) SetCrossZoneEnabled(v bool) *CreateNetworkLoadBalancerInput {
	s.CrossZoneEnabled = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNetworkLoadBalancerInput) SetDescription(v string) *CreateNetworkLoadBalancerInput {
	s.Description = &v
	return s
}

// SetIpAddressVersion sets the IpAddressVersion field's value.
func (s *CreateNetworkLoadBalancerInput) SetIpAddressVersion(v string) *CreateNetworkLoadBalancerInput {
	s.IpAddressVersion = &v
	return s
}

// SetIpv4BandwidthPackageId sets the Ipv4BandwidthPackageId field's value.
func (s *CreateNetworkLoadBalancerInput) SetIpv4BandwidthPackageId(v string) *CreateNetworkLoadBalancerInput {
	s.Ipv4BandwidthPackageId = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CreateNetworkLoadBalancerInput) SetLoadBalancerName(v string) *CreateNetworkLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

// SetModificationProtectionStatus sets the ModificationProtectionStatus field's value.
func (s *CreateNetworkLoadBalancerInput) SetModificationProtectionStatus(v string) *CreateNetworkLoadBalancerInput {
	s.ModificationProtectionStatus = &v
	return s
}

// SetNetworkType sets the NetworkType field's value.
func (s *CreateNetworkLoadBalancerInput) SetNetworkType(v string) *CreateNetworkLoadBalancerInput {
	s.NetworkType = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateNetworkLoadBalancerInput) SetProjectName(v string) *CreateNetworkLoadBalancerInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *CreateNetworkLoadBalancerInput) SetRegionId(v string) *CreateNetworkLoadBalancerInput {
	s.RegionId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateNetworkLoadBalancerInput) SetSecurityGroupIds(v []*string) *CreateNetworkLoadBalancerInput {
	s.SecurityGroupIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNetworkLoadBalancerInput) SetTags(v []*TagForCreateNetworkLoadBalancerInput) *CreateNetworkLoadBalancerInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateNetworkLoadBalancerInput) SetVpcId(v string) *CreateNetworkLoadBalancerInput {
	s.VpcId = &v
	return s
}

// SetZoneMappings sets the ZoneMappings field's value.
func (s *CreateNetworkLoadBalancerInput) SetZoneMappings(v []*ZoneMappingForCreateNetworkLoadBalancerInput) *CreateNetworkLoadBalancerInput {
	s.ZoneMappings = v
	return s
}

type CreateNetworkLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	LoadBalancerId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateNetworkLoadBalancerOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNetworkLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetLoadBalancerId sets the LoadBalancerId field's value.
func (s *CreateNetworkLoadBalancerOutput) SetLoadBalancerId(v string) *CreateNetworkLoadBalancerOutput {
	s.LoadBalancerId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateNetworkLoadBalancerOutput) SetRequestId(v string) *CreateNetworkLoadBalancerOutput {
	s.RequestId = &v
	return s
}

type TagForCreateNetworkLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateNetworkLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateNetworkLoadBalancerInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateNetworkLoadBalancerInput) SetKey(v string) *TagForCreateNetworkLoadBalancerInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateNetworkLoadBalancerInput) SetValue(v string) *TagForCreateNetworkLoadBalancerInput {
	s.Value = &v
	return s
}

type ZoneMappingForCreateNetworkLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	EipId *string `type:"string"`

	Ipv4Address *string `type:"string"`

	// SubnetId is a required field
	SubnetId *string `type:"string" required:"true"`

	// ZoneId is a required field
	ZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ZoneMappingForCreateNetworkLoadBalancerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ZoneMappingForCreateNetworkLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZoneMappingForCreateNetworkLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZoneMappingForCreateNetworkLoadBalancerInput"}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.ZoneId == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEipId sets the EipId field's value.
func (s *ZoneMappingForCreateNetworkLoadBalancerInput) SetEipId(v string) *ZoneMappingForCreateNetworkLoadBalancerInput {
	s.EipId = &v
	return s
}

// SetIpv4Address sets the Ipv4Address field's value.
func (s *ZoneMappingForCreateNetworkLoadBalancerInput) SetIpv4Address(v string) *ZoneMappingForCreateNetworkLoadBalancerInput {
	s.Ipv4Address = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *ZoneMappingForCreateNetworkLoadBalancerInput) SetSubnetId(v string) *ZoneMappingForCreateNetworkLoadBalancerInput {
	s.SubnetId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ZoneMappingForCreateNetworkLoadBalancerInput) SetZoneId(v string) *ZoneMappingForCreateNetworkLoadBalancerInput {
	s.ZoneId = &v
	return s
}
