// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListWorkspacesCommon = "ListWorkspaces"

// ListWorkspacesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListWorkspacesCommon operation. The "output" return
// value will be populated with the ListWorkspacesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListWorkspacesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListWorkspacesCommon Send returns without error.
//
// See ListWorkspacesCommon for more information on using the ListWorkspacesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListWorkspacesCommonRequest method.
//    req, resp := client.ListWorkspacesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListWorkspacesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListWorkspacesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListWorkspacesCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListWorkspacesCommon for usage and error information.
func (c *BIO) ListWorkspacesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListWorkspacesCommonRequest(input)
	return out, req.Send()
}

// ListWorkspacesCommonWithContext is the same as ListWorkspacesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspacesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListWorkspacesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListWorkspacesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkspaces = "ListWorkspaces"

// ListWorkspacesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListWorkspaces operation. The "output" return
// value will be populated with the ListWorkspacesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListWorkspacesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListWorkspacesCommon Send returns without error.
//
// See ListWorkspaces for more information on using the ListWorkspaces
// API call, and error handling.
//
//    // Example sending a request using the ListWorkspacesRequest method.
//    req, resp := client.ListWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListWorkspacesRequest(input *ListWorkspacesInput) (req *request.Request, output *ListWorkspacesOutput) {
	op := &request.Operation{
		Name:       opListWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWorkspacesInput{}
	}

	output = &ListWorkspacesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListWorkspaces API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListWorkspaces for usage and error information.
func (c *BIO) ListWorkspaces(input *ListWorkspacesInput) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	return out, req.Send()
}

// ListWorkspacesWithContext is the same as ListWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListWorkspacesWithContext(ctx volcengine.Context, input *ListWorkspacesInput, opts ...request.Option) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListWorkspacesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IDs []*string `type:"list" json:",omitempty"`

	IsPublic *bool `type:"boolean" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	Labels []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListWorkspacesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListWorkspacesInput) GoString() string {
	return s.String()
}

// SetIDs sets the IDs field's value.
func (s *FilterForListWorkspacesInput) SetIDs(v []*string) *FilterForListWorkspacesInput {
	s.IDs = v
	return s
}

// SetIsPublic sets the IsPublic field's value.
func (s *FilterForListWorkspacesInput) SetIsPublic(v bool) *FilterForListWorkspacesInput {
	s.IsPublic = &v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListWorkspacesInput) SetKeyword(v string) *FilterForListWorkspacesInput {
	s.Keyword = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *FilterForListWorkspacesInput) SetLabels(v []*string) *FilterForListWorkspacesInput {
	s.Labels = v
	return s
}

type ItemForListWorkspacesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CoverDownloadURL *string `type:"string" json:",omitempty"`

	CreateTime *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Labels []*string `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	OwnerName *string `type:"string" json:",omitempty"`

	PublicMeta *PublicMetaForListWorkspacesOutput `type:"structure" json:",omitempty"`

	Role *string `type:"string" json:",omitempty" enum:"EnumOfRoleForListWorkspacesOutput"`

	S3Bucket *string `type:"string" json:",omitempty"`

	UpdateTime *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListWorkspacesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetCoverDownloadURL sets the CoverDownloadURL field's value.
func (s *ItemForListWorkspacesOutput) SetCoverDownloadURL(v string) *ItemForListWorkspacesOutput {
	s.CoverDownloadURL = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ItemForListWorkspacesOutput) SetCreateTime(v int32) *ItemForListWorkspacesOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListWorkspacesOutput) SetDescription(v string) *ItemForListWorkspacesOutput {
	s.Description = &v
	return s
}

// SetID sets the ID field's value.
func (s *ItemForListWorkspacesOutput) SetID(v string) *ItemForListWorkspacesOutput {
	s.ID = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ItemForListWorkspacesOutput) SetLabels(v []*string) *ItemForListWorkspacesOutput {
	s.Labels = v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListWorkspacesOutput) SetName(v string) *ItemForListWorkspacesOutput {
	s.Name = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *ItemForListWorkspacesOutput) SetOwnerName(v string) *ItemForListWorkspacesOutput {
	s.OwnerName = &v
	return s
}

// SetPublicMeta sets the PublicMeta field's value.
func (s *ItemForListWorkspacesOutput) SetPublicMeta(v *PublicMetaForListWorkspacesOutput) *ItemForListWorkspacesOutput {
	s.PublicMeta = v
	return s
}

// SetRole sets the Role field's value.
func (s *ItemForListWorkspacesOutput) SetRole(v string) *ItemForListWorkspacesOutput {
	s.Role = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *ItemForListWorkspacesOutput) SetS3Bucket(v string) *ItemForListWorkspacesOutput {
	s.S3Bucket = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListWorkspacesOutput) SetUpdateTime(v int32) *ItemForListWorkspacesOutput {
	s.UpdateTime = &v
	return s
}

type ListWorkspacesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListWorkspacesInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListWorkspacesInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListWorkspacesInput"`
}

// String returns the string representation
func (s ListWorkspacesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkspacesInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListWorkspacesInput) SetFilter(v *FilterForListWorkspacesInput) *ListWorkspacesInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListWorkspacesInput) SetPageNumber(v int32) *ListWorkspacesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListWorkspacesInput) SetPageSize(v int32) *ListWorkspacesInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListWorkspacesInput) SetSortBy(v string) *ListWorkspacesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListWorkspacesInput) SetSortOrder(v string) *ListWorkspacesInput {
	s.SortOrder = &v
	return s
}

type ListWorkspacesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListWorkspacesOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListWorkspacesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListWorkspacesOutput) SetItems(v []*ItemForListWorkspacesOutput) *ListWorkspacesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListWorkspacesOutput) SetPageNumber(v int32) *ListWorkspacesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListWorkspacesOutput) SetPageSize(v int32) *ListWorkspacesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListWorkspacesOutput) SetTotalCount(v int32) *ListWorkspacesOutput {
	s.TotalCount = &v
	return s
}

type PublicMetaForListWorkspacesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TosBucketTotalStorage *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s PublicMetaForListWorkspacesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicMetaForListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetTosBucketTotalStorage sets the TosBucketTotalStorage field's value.
func (s *PublicMetaForListWorkspacesOutput) SetTosBucketTotalStorage(v float64) *PublicMetaForListWorkspacesOutput {
	s.TosBucketTotalStorage = &v
	return s
}

const (
	// EnumOfRoleForListWorkspacesOutputAdmin is a EnumOfRoleForListWorkspacesOutput enum value
	EnumOfRoleForListWorkspacesOutputAdmin = "Admin"

	// EnumOfRoleForListWorkspacesOutputUser is a EnumOfRoleForListWorkspacesOutput enum value
	EnumOfRoleForListWorkspacesOutputUser = "User"

	// EnumOfRoleForListWorkspacesOutputVisitor is a EnumOfRoleForListWorkspacesOutput enum value
	EnumOfRoleForListWorkspacesOutputVisitor = "Visitor"
)

const (
	// EnumOfSortByForListWorkspacesInputName is a EnumOfSortByForListWorkspacesInput enum value
	EnumOfSortByForListWorkspacesInputName = "Name"

	// EnumOfSortByForListWorkspacesInputCreateTime is a EnumOfSortByForListWorkspacesInput enum value
	EnumOfSortByForListWorkspacesInputCreateTime = "CreateTime"

	// EnumOfSortByForListWorkspacesInputUpdateTime is a EnumOfSortByForListWorkspacesInput enum value
	EnumOfSortByForListWorkspacesInputUpdateTime = "UpdateTime"

	// EnumOfSortByForListWorkspacesInputVisitTime is a EnumOfSortByForListWorkspacesInput enum value
	EnumOfSortByForListWorkspacesInputVisitTime = "VisitTime"

	// EnumOfSortByForListWorkspacesInputId is a EnumOfSortByForListWorkspacesInput enum value
	EnumOfSortByForListWorkspacesInputId = "ID"
)

const (
	// EnumOfSortOrderForListWorkspacesInputAsc is a EnumOfSortOrderForListWorkspacesInput enum value
	EnumOfSortOrderForListWorkspacesInputAsc = "Asc"

	// EnumOfSortOrderForListWorkspacesInputDesc is a EnumOfSortOrderForListWorkspacesInput enum value
	EnumOfSortOrderForListWorkspacesInputDesc = "Desc"
)
