// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDataModelRowsCommon = "ListDataModelRows"

// ListDataModelRowsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDataModelRowsCommon operation. The "output" return
// value will be populated with the ListDataModelRowsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDataModelRowsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDataModelRowsCommon Send returns without error.
//
// See ListDataModelRowsCommon for more information on using the ListDataModelRowsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDataModelRowsCommonRequest method.
//    req, resp := client.ListDataModelRowsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListDataModelRowsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDataModelRowsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDataModelRowsCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListDataModelRowsCommon for usage and error information.
func (c *BIO) ListDataModelRowsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDataModelRowsCommonRequest(input)
	return out, req.Send()
}

// ListDataModelRowsCommonWithContext is the same as ListDataModelRowsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataModelRowsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListDataModelRowsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDataModelRowsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataModelRows = "ListDataModelRows"

// ListDataModelRowsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDataModelRows operation. The "output" return
// value will be populated with the ListDataModelRowsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDataModelRowsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDataModelRowsCommon Send returns without error.
//
// See ListDataModelRows for more information on using the ListDataModelRows
// API call, and error handling.
//
//    // Example sending a request using the ListDataModelRowsRequest method.
//    req, resp := client.ListDataModelRowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListDataModelRowsRequest(input *ListDataModelRowsInput) (req *request.Request, output *ListDataModelRowsOutput) {
	op := &request.Operation{
		Name:       opListDataModelRows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDataModelRowsInput{}
	}

	output = &ListDataModelRowsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDataModelRows API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListDataModelRows for usage and error information.
func (c *BIO) ListDataModelRows(input *ListDataModelRowsInput) (*ListDataModelRowsOutput, error) {
	req, out := c.ListDataModelRowsRequest(input)
	return out, req.Send()
}

// ListDataModelRowsWithContext is the same as ListDataModelRows with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataModelRows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListDataModelRowsWithContext(ctx volcengine.Context, input *ListDataModelRowsInput, opts ...request.Option) (*ListDataModelRowsOutput, error) {
	req, out := c.ListDataModelRowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type FilterForListDataModelRowsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InSetIDs []*string `type:"list" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	RowIDs []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListDataModelRowsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListDataModelRowsInput) GoString() string {
	return s.String()
}

// SetInSetIDs sets the InSetIDs field's value.
func (s *FilterForListDataModelRowsInput) SetInSetIDs(v []*string) *FilterForListDataModelRowsInput {
	s.InSetIDs = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListDataModelRowsInput) SetKeyword(v string) *FilterForListDataModelRowsInput {
	s.Keyword = &v
	return s
}

// SetRowIDs sets the RowIDs field's value.
func (s *FilterForListDataModelRowsInput) SetRowIDs(v []*string) *FilterForListDataModelRowsInput {
	s.RowIDs = v
	return s
}

type ListDataModelRowsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListDataModelRowsInput `type:"structure" json:",omitempty"`

	// ID is a required field
	ID *string `type:"string" json:",omitempty" required:"true"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListDataModelRowsInput"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListDataModelRowsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataModelRowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataModelRowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataModelRowsInput"}
	if s.ID == nil {
		invalidParams.Add(request.NewErrParamRequired("ID"))
	}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDataModelRowsInput) SetFilter(v *FilterForListDataModelRowsInput) *ListDataModelRowsInput {
	s.Filter = v
	return s
}

// SetID sets the ID field's value.
func (s *ListDataModelRowsInput) SetID(v string) *ListDataModelRowsInput {
	s.ID = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDataModelRowsInput) SetPageNumber(v int32) *ListDataModelRowsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDataModelRowsInput) SetPageSize(v int32) *ListDataModelRowsInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListDataModelRowsInput) SetSortBy(v string) *ListDataModelRowsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListDataModelRowsInput) SetSortOrder(v string) *ListDataModelRowsInput {
	s.SortOrder = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ListDataModelRowsInput) SetWorkspaceID(v string) *ListDataModelRowsInput {
	s.WorkspaceID = &v
	return s
}

type ListDataModelRowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Headers []*string `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Rows []*RowForListDataModelRowsOutput `type:"list" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDataModelRowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataModelRowsOutput) GoString() string {
	return s.String()
}

// SetHeaders sets the Headers field's value.
func (s *ListDataModelRowsOutput) SetHeaders(v []*string) *ListDataModelRowsOutput {
	s.Headers = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDataModelRowsOutput) SetPageNumber(v int32) *ListDataModelRowsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDataModelRowsOutput) SetPageSize(v int32) *ListDataModelRowsOutput {
	s.PageSize = &v
	return s
}

// SetRows sets the Rows field's value.
func (s *ListDataModelRowsOutput) SetRows(v []*RowForListDataModelRowsOutput) *ListDataModelRowsOutput {
	s.Rows = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListDataModelRowsOutput) SetTotalCount(v int32) *ListDataModelRowsOutput {
	s.TotalCount = &v
	return s
}

type RowForListDataModelRowsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RowForListDataModelRowsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RowForListDataModelRowsOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfSortOrderForListDataModelRowsInputDesc is a EnumOfSortOrderForListDataModelRowsInput enum value
	EnumOfSortOrderForListDataModelRowsInputDesc = "Desc"

	// EnumOfSortOrderForListDataModelRowsInputAsc is a EnumOfSortOrderForListDataModelRowsInput enum value
	EnumOfSortOrderForListDataModelRowsInputAsc = "Asc"
)
