// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListClustersCommon = "ListClusters"

// ListClustersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListClustersCommon operation. The "output" return
// value will be populated with the ListClustersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListClustersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListClustersCommon Send returns without error.
//
// See ListClustersCommon for more information on using the ListClustersCommon
// API call, and error handling.
//
//    // Example sending a request using the ListClustersCommonRequest method.
//    req, resp := client.ListClustersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListClustersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListClustersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListClustersCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListClustersCommon for usage and error information.
func (c *BIO) ListClustersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListClustersCommonRequest(input)
	return out, req.Send()
}

// ListClustersCommonWithContext is the same as ListClustersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListClustersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListClustersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListClustersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "volcengine/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the ListClustersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListClustersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListClustersCommon Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListClusters API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListClusters for usage and error information.
func (c *BIO) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListClustersWithContext(ctx volcengine.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ExternalConfigForListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExecutionRootDir *string `type:"string" json:",omitempty"`

	Filesystem *string `type:"string" json:",omitempty" enum:"EnumOfFilesystemForListClustersOutput"`

	JupyterhubClusterKubeConfig *string `type:"string" json:",omitempty"`

	JupyterhubEndpoint *string `type:"string" json:",omitempty"`

	JupyterhubJWTSecret *string `type:"string" json:",omitempty"`

	JupyterhubUserNamespace *string `type:"string" json:",omitempty"`

	NereidClusterID *string `type:"string" json:",omitempty"`

	NereidEndpoint *string `type:"string" json:",omitempty"`

	ResourceScheduler *string `type:"string" json:",omitempty"`

	S3ProxyConfig *S3ProxyConfigForListClustersOutput `type:"structure" json:",omitempty"`

	WESEndpoint *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ExternalConfigForListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalConfigForListClustersOutput) GoString() string {
	return s.String()
}

// SetExecutionRootDir sets the ExecutionRootDir field's value.
func (s *ExternalConfigForListClustersOutput) SetExecutionRootDir(v string) *ExternalConfigForListClustersOutput {
	s.ExecutionRootDir = &v
	return s
}

// SetFilesystem sets the Filesystem field's value.
func (s *ExternalConfigForListClustersOutput) SetFilesystem(v string) *ExternalConfigForListClustersOutput {
	s.Filesystem = &v
	return s
}

// SetJupyterhubClusterKubeConfig sets the JupyterhubClusterKubeConfig field's value.
func (s *ExternalConfigForListClustersOutput) SetJupyterhubClusterKubeConfig(v string) *ExternalConfigForListClustersOutput {
	s.JupyterhubClusterKubeConfig = &v
	return s
}

// SetJupyterhubEndpoint sets the JupyterhubEndpoint field's value.
func (s *ExternalConfigForListClustersOutput) SetJupyterhubEndpoint(v string) *ExternalConfigForListClustersOutput {
	s.JupyterhubEndpoint = &v
	return s
}

// SetJupyterhubJWTSecret sets the JupyterhubJWTSecret field's value.
func (s *ExternalConfigForListClustersOutput) SetJupyterhubJWTSecret(v string) *ExternalConfigForListClustersOutput {
	s.JupyterhubJWTSecret = &v
	return s
}

// SetJupyterhubUserNamespace sets the JupyterhubUserNamespace field's value.
func (s *ExternalConfigForListClustersOutput) SetJupyterhubUserNamespace(v string) *ExternalConfigForListClustersOutput {
	s.JupyterhubUserNamespace = &v
	return s
}

// SetNereidClusterID sets the NereidClusterID field's value.
func (s *ExternalConfigForListClustersOutput) SetNereidClusterID(v string) *ExternalConfigForListClustersOutput {
	s.NereidClusterID = &v
	return s
}

// SetNereidEndpoint sets the NereidEndpoint field's value.
func (s *ExternalConfigForListClustersOutput) SetNereidEndpoint(v string) *ExternalConfigForListClustersOutput {
	s.NereidEndpoint = &v
	return s
}

// SetResourceScheduler sets the ResourceScheduler field's value.
func (s *ExternalConfigForListClustersOutput) SetResourceScheduler(v string) *ExternalConfigForListClustersOutput {
	s.ResourceScheduler = &v
	return s
}

// SetS3ProxyConfig sets the S3ProxyConfig field's value.
func (s *ExternalConfigForListClustersOutput) SetS3ProxyConfig(v *S3ProxyConfigForListClustersOutput) *ExternalConfigForListClustersOutput {
	s.S3ProxyConfig = v
	return s
}

// SetWESEndpoint sets the WESEndpoint field's value.
func (s *ExternalConfigForListClustersOutput) SetWESEndpoint(v string) *ExternalConfigForListClustersOutput {
	s.WESEndpoint = &v
	return s
}

type FilterForListClustersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IDs []*string `type:"list" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	Public *bool `type:"boolean" json:",omitempty"`

	Status []*string `type:"list" json:",omitempty"`

	Type []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForListClustersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForListClustersInput) GoString() string {
	return s.String()
}

// SetIDs sets the IDs field's value.
func (s *FilterForListClustersInput) SetIDs(v []*string) *FilterForListClustersInput {
	s.IDs = v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *FilterForListClustersInput) SetKeyword(v string) *FilterForListClustersInput {
	s.Keyword = &v
	return s
}

// SetPublic sets the Public field's value.
func (s *FilterForListClustersInput) SetPublic(v bool) *FilterForListClustersInput {
	s.Public = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilterForListClustersInput) SetStatus(v []*string) *FilterForListClustersInput {
	s.Status = v
	return s
}

// SetType sets the Type field's value.
func (s *FilterForListClustersInput) SetType(v []*string) *FilterForListClustersInput {
	s.Type = v
	return s
}

type ItemForListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bound *bool `type:"boolean" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ErrorMessage *string `type:"string" json:",omitempty"`

	ExternalConfig *ExternalConfigForListClustersOutput `type:"structure" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Public *bool `type:"boolean" json:",omitempty"`

	SharedConfig *SharedConfigForListClustersOutput `type:"structure" json:",omitempty"`

	StartTime *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForListClustersOutput"`

	StoppedTime *int32 `type:"int32" json:",omitempty"`

	VKEConfig *VKEConfigForListClustersOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListClustersOutput) GoString() string {
	return s.String()
}

// SetBound sets the Bound field's value.
func (s *ItemForListClustersOutput) SetBound(v bool) *ItemForListClustersOutput {
	s.Bound = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListClustersOutput) SetDescription(v string) *ItemForListClustersOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ItemForListClustersOutput) SetErrorMessage(v string) *ItemForListClustersOutput {
	s.ErrorMessage = &v
	return s
}

// SetExternalConfig sets the ExternalConfig field's value.
func (s *ItemForListClustersOutput) SetExternalConfig(v *ExternalConfigForListClustersOutput) *ItemForListClustersOutput {
	s.ExternalConfig = v
	return s
}

// SetID sets the ID field's value.
func (s *ItemForListClustersOutput) SetID(v string) *ItemForListClustersOutput {
	s.ID = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListClustersOutput) SetName(v string) *ItemForListClustersOutput {
	s.Name = &v
	return s
}

// SetPublic sets the Public field's value.
func (s *ItemForListClustersOutput) SetPublic(v bool) *ItemForListClustersOutput {
	s.Public = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *ItemForListClustersOutput) SetSharedConfig(v *SharedConfigForListClustersOutput) *ItemForListClustersOutput {
	s.SharedConfig = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListClustersOutput) SetStartTime(v int32) *ItemForListClustersOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListClustersOutput) SetStatus(v string) *ItemForListClustersOutput {
	s.Status = &v
	return s
}

// SetStoppedTime sets the StoppedTime field's value.
func (s *ItemForListClustersOutput) SetStoppedTime(v int32) *ItemForListClustersOutput {
	s.StoppedTime = &v
	return s
}

// SetVKEConfig sets the VKEConfig field's value.
func (s *ItemForListClustersOutput) SetVKEConfig(v *VKEConfigForListClustersOutput) *ItemForListClustersOutput {
	s.VKEConfig = v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *FilterForListClustersInput `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListClustersInput) SetFilter(v *FilterForListClustersInput) *ListClustersInput {
	s.Filter = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListClustersInput) SetPageNumber(v int32) *ListClustersInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListClustersInput) SetPageSize(v int32) *ListClustersInput {
	s.PageSize = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListClustersOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListClustersOutput) SetItems(v []*ItemForListClustersOutput) *ListClustersOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListClustersOutput) SetPageNumber(v int32) *ListClustersOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListClustersOutput) SetPageSize(v int32) *ListClustersOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListClustersOutput) SetTotalCount(v int32) *ListClustersOutput {
	s.TotalCount = &v
	return s
}

type S3ProxyConfigForListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	Endpoint *string `type:"string" json:",omitempty"`

	ForcePathStyle *bool `type:"boolean" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	SecretKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s S3ProxyConfigForListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ProxyConfigForListClustersOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *S3ProxyConfigForListClustersOutput) SetAccessKey(v string) *S3ProxyConfigForListClustersOutput {
	s.AccessKey = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *S3ProxyConfigForListClustersOutput) SetEndpoint(v string) *S3ProxyConfigForListClustersOutput {
	s.Endpoint = &v
	return s
}

// SetForcePathStyle sets the ForcePathStyle field's value.
func (s *S3ProxyConfigForListClustersOutput) SetForcePathStyle(v bool) *S3ProxyConfigForListClustersOutput {
	s.ForcePathStyle = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *S3ProxyConfigForListClustersOutput) SetRegion(v string) *S3ProxyConfigForListClustersOutput {
	s.Region = &v
	return s
}

// SetSecretKey sets the SecretKey field's value.
func (s *S3ProxyConfigForListClustersOutput) SetSecretKey(v string) *S3ProxyConfigForListClustersOutput {
	s.SecretKey = &v
	return s
}

type SharedConfigForListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SharedConfigForListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForListClustersOutput) GoString() string {
	return s.String()
}

type VKEConfigForListClustersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClusterID *string `type:"string" json:",omitempty"`

	StorageClass *string `type:"string" json:",omitempty"`

	VCIEnabled *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s VKEConfigForListClustersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VKEConfigForListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterID sets the ClusterID field's value.
func (s *VKEConfigForListClustersOutput) SetClusterID(v string) *VKEConfigForListClustersOutput {
	s.ClusterID = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *VKEConfigForListClustersOutput) SetStorageClass(v string) *VKEConfigForListClustersOutput {
	s.StorageClass = &v
	return s
}

// SetVCIEnabled sets the VCIEnabled field's value.
func (s *VKEConfigForListClustersOutput) SetVCIEnabled(v bool) *VKEConfigForListClustersOutput {
	s.VCIEnabled = &v
	return s
}

const (
	// EnumOfFilesystemForListClustersOutputTos is a EnumOfFilesystemForListClustersOutput enum value
	EnumOfFilesystemForListClustersOutputTos = "tos"

	// EnumOfFilesystemForListClustersOutputLocal is a EnumOfFilesystemForListClustersOutput enum value
	EnumOfFilesystemForListClustersOutputLocal = "local"
)

const (
	// EnumOfStatusForListClustersOutputCreating is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputCreating = "Creating"

	// EnumOfStatusForListClustersOutputCreateFailed is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputCreateFailed = "CreateFailed"

	// EnumOfStatusForListClustersOutputRunning is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputRunning = "Running"

	// EnumOfStatusForListClustersOutputError is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputError = "Error"

	// EnumOfStatusForListClustersOutputDeleting is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputDeleting = "Deleting"

	// EnumOfStatusForListClustersOutputDeleteFailed is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputDeleteFailed = "DeleteFailed"

	// EnumOfStatusForListClustersOutputUpdating is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputUpdating = "Updating"

	// EnumOfStatusForListClustersOutputStopped is a EnumOfStatusForListClustersOutput enum value
	EnumOfStatusForListClustersOutputStopped = "Stopped"
)

const (
	// EnumOfStatusListForListClustersInputCreating is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputCreating = "Creating"

	// EnumOfStatusListForListClustersInputCreateFailed is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputCreateFailed = "CreateFailed"

	// EnumOfStatusListForListClustersInputRunning is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputRunning = "Running"

	// EnumOfStatusListForListClustersInputError is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputError = "Error"

	// EnumOfStatusListForListClustersInputDeleting is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputDeleting = "Deleting"

	// EnumOfStatusListForListClustersInputDeleteFailed is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputDeleteFailed = "DeleteFailed"

	// EnumOfStatusListForListClustersInputUpdating is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputUpdating = "Updating"

	// EnumOfStatusListForListClustersInputStopped is a EnumOfStatusListForListClustersInput enum value
	EnumOfStatusListForListClustersInputStopped = "Stopped"
)

const (
	// EnumOfTypeListForListClustersInputVolcVke is a EnumOfTypeListForListClustersInput enum value
	EnumOfTypeListForListClustersInputVolcVke = "volc-vke"

	// EnumOfTypeListForListClustersInputExternal is a EnumOfTypeListForListClustersInput enum value
	EnumOfTypeListForListClustersInputExternal = "external"

	// EnumOfTypeListForListClustersInputShared is a EnumOfTypeListForListClustersInput enum value
	EnumOfTypeListForListClustersInputShared = "shared"
)
