// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package billing

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRenewInstanceCommon = "RenewInstance"

// RenewInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RenewInstanceCommon operation. The "output" return
// value will be populated with the RenewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RenewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RenewInstanceCommon Send returns without error.
//
// See RenewInstanceCommon for more information on using the RenewInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the RenewInstanceCommonRequest method.
//    req, resp := client.RenewInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BILLING) RenewInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRenewInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RenewInstanceCommon API operation for BILLING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BILLING's
// API operation RenewInstanceCommon for usage and error information.
func (c *BILLING) RenewInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RenewInstanceCommonRequest(input)
	return out, req.Send()
}

// RenewInstanceCommonWithContext is the same as RenewInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RenewInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BILLING) RenewInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RenewInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRenewInstance = "RenewInstance"

// RenewInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the RenewInstance operation. The "output" return
// value will be populated with the RenewInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RenewInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after RenewInstanceCommon Send returns without error.
//
// See RenewInstance for more information on using the RenewInstance
// API call, and error handling.
//
//    // Example sending a request using the RenewInstanceRequest method.
//    req, resp := client.RenewInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BILLING) RenewInstanceRequest(input *RenewInstanceInput) (req *request.Request, output *RenewInstanceOutput) {
	op := &request.Operation{
		Name:       opRenewInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewInstanceInput{}
	}

	output = &RenewInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RenewInstance API operation for BILLING.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BILLING's
// API operation RenewInstance for usage and error information.
func (c *BILLING) RenewInstance(input *RenewInstanceInput) (*RenewInstanceOutput, error) {
	req, out := c.RenewInstanceRequest(input)
	return out, req.Send()
}

// RenewInstanceWithContext is the same as RenewInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RenewInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BILLING) RenewInstanceWithContext(ctx volcengine.Context, input *RenewInstanceInput, opts ...request.Option) (*RenewInstanceOutput, error) {
	req, out := c.RenewInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RenewInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	// InstanceID is a required field
	InstanceID *string `type:"string" json:",omitempty" required:"true"`

	// Product is a required field
	Product *string `type:"string" json:",omitempty" required:"true"`

	RenewRelatedInstance *bool `type:"boolean" json:",omitempty"`

	RenewalDuration *int64 `type:"int64" json:",omitempty"`

	// RenewalDurationUnit is a required field
	RenewalDurationUnit *string `type:"string" json:",omitempty" required:"true"`

	UnitedExpireDay *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RenewInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenewInstanceInput"}
	if s.InstanceID == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceID"))
	}
	if s.Product == nil {
		invalidParams.Add(request.NewErrParamRequired("Product"))
	}
	if s.RenewalDurationUnit == nil {
		invalidParams.Add(request.NewErrParamRequired("RenewalDurationUnit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *RenewInstanceInput) SetClientToken(v string) *RenewInstanceInput {
	s.ClientToken = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *RenewInstanceInput) SetInstanceID(v string) *RenewInstanceInput {
	s.InstanceID = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *RenewInstanceInput) SetProduct(v string) *RenewInstanceInput {
	s.Product = &v
	return s
}

// SetRenewRelatedInstance sets the RenewRelatedInstance field's value.
func (s *RenewInstanceInput) SetRenewRelatedInstance(v bool) *RenewInstanceInput {
	s.RenewRelatedInstance = &v
	return s
}

// SetRenewalDuration sets the RenewalDuration field's value.
func (s *RenewInstanceInput) SetRenewalDuration(v int64) *RenewInstanceInput {
	s.RenewalDuration = &v
	return s
}

// SetRenewalDurationUnit sets the RenewalDurationUnit field's value.
func (s *RenewInstanceInput) SetRenewalDurationUnit(v string) *RenewInstanceInput {
	s.RenewalDurationUnit = &v
	return s
}

// SetUnitedExpireDay sets the UnitedExpireDay field's value.
func (s *RenewInstanceInput) SetUnitedExpireDay(v string) *RenewInstanceInput {
	s.UnitedExpireDay = &v
	return s
}

type RenewInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	OrderIDList []*string `type:"list" json:",omitempty"`

	SuccessInstanceList []*SuccessInstanceListForRenewInstanceOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RenewInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewInstanceOutput) GoString() string {
	return s.String()
}

// SetOrderIDList sets the OrderIDList field's value.
func (s *RenewInstanceOutput) SetOrderIDList(v []*string) *RenewInstanceOutput {
	s.OrderIDList = v
	return s
}

// SetSuccessInstanceList sets the SuccessInstanceList field's value.
func (s *RenewInstanceOutput) SetSuccessInstanceList(v []*SuccessInstanceListForRenewInstanceOutput) *RenewInstanceOutput {
	s.SuccessInstanceList = v
	return s
}

type SuccessInstanceListForRenewInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	Product *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SuccessInstanceListForRenewInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SuccessInstanceListForRenewInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceID sets the InstanceID field's value.
func (s *SuccessInstanceListForRenewInstanceOutput) SetInstanceID(v string) *SuccessInstanceListForRenewInstanceOutput {
	s.InstanceID = &v
	return s
}

// SetProduct sets the Product field's value.
func (s *SuccessInstanceListForRenewInstanceOutput) SetProduct(v string) *SuccessInstanceListForRenewInstanceOutput {
	s.Product = &v
	return s
}
