// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ark

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateModelCustomizationJobCommon = "CreateModelCustomizationJob"

// CreateModelCustomizationJobCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateModelCustomizationJobCommon operation. The "output" return
// value will be populated with the CreateModelCustomizationJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateModelCustomizationJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateModelCustomizationJobCommon Send returns without error.
//
// See CreateModelCustomizationJobCommon for more information on using the CreateModelCustomizationJobCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateModelCustomizationJobCommonRequest method.
//    req, resp := client.CreateModelCustomizationJobCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ARK) CreateModelCustomizationJobCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateModelCustomizationJobCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateModelCustomizationJobCommon API operation for ARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ARK's
// API operation CreateModelCustomizationJobCommon for usage and error information.
func (c *ARK) CreateModelCustomizationJobCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateModelCustomizationJobCommonRequest(input)
	return out, req.Send()
}

// CreateModelCustomizationJobCommonWithContext is the same as CreateModelCustomizationJobCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelCustomizationJobCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARK) CreateModelCustomizationJobCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateModelCustomizationJobCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelCustomizationJob = "CreateModelCustomizationJob"

// CreateModelCustomizationJobRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateModelCustomizationJob operation. The "output" return
// value will be populated with the CreateModelCustomizationJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateModelCustomizationJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateModelCustomizationJobCommon Send returns without error.
//
// See CreateModelCustomizationJob for more information on using the CreateModelCustomizationJob
// API call, and error handling.
//
//    // Example sending a request using the CreateModelCustomizationJobRequest method.
//    req, resp := client.CreateModelCustomizationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ARK) CreateModelCustomizationJobRequest(input *CreateModelCustomizationJobInput) (req *request.Request, output *CreateModelCustomizationJobOutput) {
	op := &request.Operation{
		Name:       opCreateModelCustomizationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelCustomizationJobInput{}
	}

	output = &CreateModelCustomizationJobOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateModelCustomizationJob API operation for ARK.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ARK's
// API operation CreateModelCustomizationJob for usage and error information.
func (c *ARK) CreateModelCustomizationJob(input *CreateModelCustomizationJobInput) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	return out, req.Send()
}

// CreateModelCustomizationJobWithContext is the same as CreateModelCustomizationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelCustomizationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ARK) CreateModelCustomizationJobWithContext(ctx volcengine.Context, input *CreateModelCustomizationJobInput, opts ...request.Option) (*CreateModelCustomizationJobOutput, error) {
	req, out := c.CreateModelCustomizationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomizationType is a required field
	CustomizationType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfCustomizationTypeForCreateModelCustomizationJobInput"`

	Data *DataForCreateModelCustomizationJobInput `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Hyperparameters []*HyperparameterForCreateModelCustomizationJobInput `type:"list" json:",omitempty"`

	ModelReference *ModelReferenceForCreateModelCustomizationJobInput `type:"structure" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`

	SaveModelLimit *int32 `min:"1" max:"10" type:"int32" json:",omitempty"`

	Tags []*TagForCreateModelCustomizationJobInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelCustomizationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelCustomizationJobInput"}
	if s.CustomizationType == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomizationType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SaveModelLimit != nil && *s.SaveModelLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SaveModelLimit", 1))
	}
	if s.SaveModelLimit != nil && *s.SaveModelLimit > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("SaveModelLimit", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomizationType sets the CustomizationType field's value.
func (s *CreateModelCustomizationJobInput) SetCustomizationType(v string) *CreateModelCustomizationJobInput {
	s.CustomizationType = &v
	return s
}

// SetData sets the Data field's value.
func (s *CreateModelCustomizationJobInput) SetData(v *DataForCreateModelCustomizationJobInput) *CreateModelCustomizationJobInput {
	s.Data = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateModelCustomizationJobInput) SetDescription(v string) *CreateModelCustomizationJobInput {
	s.Description = &v
	return s
}

// SetHyperparameters sets the Hyperparameters field's value.
func (s *CreateModelCustomizationJobInput) SetHyperparameters(v []*HyperparameterForCreateModelCustomizationJobInput) *CreateModelCustomizationJobInput {
	s.Hyperparameters = v
	return s
}

// SetModelReference sets the ModelReference field's value.
func (s *CreateModelCustomizationJobInput) SetModelReference(v *ModelReferenceForCreateModelCustomizationJobInput) *CreateModelCustomizationJobInput {
	s.ModelReference = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelCustomizationJobInput) SetName(v string) *CreateModelCustomizationJobInput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateModelCustomizationJobInput) SetProjectName(v string) *CreateModelCustomizationJobInput {
	s.ProjectName = &v
	return s
}

// SetSaveModelLimit sets the SaveModelLimit field's value.
func (s *CreateModelCustomizationJobInput) SetSaveModelLimit(v int32) *CreateModelCustomizationJobInput {
	s.SaveModelLimit = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateModelCustomizationJobInput) SetTags(v []*TagForCreateModelCustomizationJobInput) *CreateModelCustomizationJobInput {
	s.Tags = v
	return s
}

type CreateModelCustomizationJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateModelCustomizationJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelCustomizationJobOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateModelCustomizationJobOutput) SetId(v string) *CreateModelCustomizationJobOutput {
	s.Id = &v
	return s
}

type DataForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EncryptionKeyringType *string `type:"string" json:",omitempty" enum:"EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInput"`

	KMSTrn *string `type:"string" json:",omitempty"`

	TrainingSet *TrainingSetForCreateModelCustomizationJobInput `type:"structure" json:",omitempty"`

	ValidationPercentage *int32 `type:"int32" json:",omitempty"`

	ValidationSet *ValidationSetForCreateModelCustomizationJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DataForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetEncryptionKeyringType sets the EncryptionKeyringType field's value.
func (s *DataForCreateModelCustomizationJobInput) SetEncryptionKeyringType(v string) *DataForCreateModelCustomizationJobInput {
	s.EncryptionKeyringType = &v
	return s
}

// SetKMSTrn sets the KMSTrn field's value.
func (s *DataForCreateModelCustomizationJobInput) SetKMSTrn(v string) *DataForCreateModelCustomizationJobInput {
	s.KMSTrn = &v
	return s
}

// SetTrainingSet sets the TrainingSet field's value.
func (s *DataForCreateModelCustomizationJobInput) SetTrainingSet(v *TrainingSetForCreateModelCustomizationJobInput) *DataForCreateModelCustomizationJobInput {
	s.TrainingSet = v
	return s
}

// SetValidationPercentage sets the ValidationPercentage field's value.
func (s *DataForCreateModelCustomizationJobInput) SetValidationPercentage(v int32) *DataForCreateModelCustomizationJobInput {
	s.ValidationPercentage = &v
	return s
}

// SetValidationSet sets the ValidationSet field's value.
func (s *DataForCreateModelCustomizationJobInput) SetValidationSet(v *ValidationSetForCreateModelCustomizationJobInput) *DataForCreateModelCustomizationJobInput {
	s.ValidationSet = v
	return s
}

type DatasetForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DatasetId *string `type:"string" json:",omitempty"`

	DatasetVersionId *string `type:"string" json:",omitempty"`

	Multiplier *float64 `type:"double" json:",omitempty"`

	SampleCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s DatasetForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DatasetForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetDatasetId sets the DatasetId field's value.
func (s *DatasetForCreateModelCustomizationJobInput) SetDatasetId(v string) *DatasetForCreateModelCustomizationJobInput {
	s.DatasetId = &v
	return s
}

// SetDatasetVersionId sets the DatasetVersionId field's value.
func (s *DatasetForCreateModelCustomizationJobInput) SetDatasetVersionId(v string) *DatasetForCreateModelCustomizationJobInput {
	s.DatasetVersionId = &v
	return s
}

// SetMultiplier sets the Multiplier field's value.
func (s *DatasetForCreateModelCustomizationJobInput) SetMultiplier(v float64) *DatasetForCreateModelCustomizationJobInput {
	s.Multiplier = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *DatasetForCreateModelCustomizationJobInput) SetSampleCount(v int64) *DatasetForCreateModelCustomizationJobInput {
	s.SampleCount = &v
	return s
}

type FoundationModelForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ModelVersion *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FoundationModelForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FoundationModelForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *FoundationModelForCreateModelCustomizationJobInput) SetModelVersion(v string) *FoundationModelForCreateModelCustomizationJobInput {
	s.ModelVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *FoundationModelForCreateModelCustomizationJobInput) SetName(v string) *FoundationModelForCreateModelCustomizationJobInput {
	s.Name = &v
	return s
}

type HyperparameterForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HyperparameterForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HyperparameterForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HyperparameterForCreateModelCustomizationJobInput) SetName(v string) *HyperparameterForCreateModelCustomizationJobInput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HyperparameterForCreateModelCustomizationJobInput) SetValue(v string) *HyperparameterForCreateModelCustomizationJobInput {
	s.Value = &v
	return s
}

type ModelReferenceForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomModelId *string `type:"string" json:",omitempty"`

	FoundationModel *FoundationModelForCreateModelCustomizationJobInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ModelReferenceForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelReferenceForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetCustomModelId sets the CustomModelId field's value.
func (s *ModelReferenceForCreateModelCustomizationJobInput) SetCustomModelId(v string) *ModelReferenceForCreateModelCustomizationJobInput {
	s.CustomModelId = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *ModelReferenceForCreateModelCustomizationJobInput) SetFoundationModel(v *FoundationModelForCreateModelCustomizationJobInput) *ModelReferenceForCreateModelCustomizationJobInput {
	s.FoundationModel = v
	return s
}

type PresetDatasetForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DatasetVersionId *string `type:"string" json:",omitempty"`

	InjectMultiplier *float64 `type:"double" json:",omitempty"`

	InjectSampleCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s PresetDatasetForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PresetDatasetForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetDatasetVersionId sets the DatasetVersionId field's value.
func (s *PresetDatasetForCreateModelCustomizationJobInput) SetDatasetVersionId(v string) *PresetDatasetForCreateModelCustomizationJobInput {
	s.DatasetVersionId = &v
	return s
}

// SetInjectMultiplier sets the InjectMultiplier field's value.
func (s *PresetDatasetForCreateModelCustomizationJobInput) SetInjectMultiplier(v float64) *PresetDatasetForCreateModelCustomizationJobInput {
	s.InjectMultiplier = &v
	return s
}

// SetInjectSampleCount sets the InjectSampleCount field's value.
func (s *PresetDatasetForCreateModelCustomizationJobInput) SetInjectSampleCount(v int64) *PresetDatasetForCreateModelCustomizationJobInput {
	s.InjectSampleCount = &v
	return s
}

type TagForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateModelCustomizationJobInput) SetKey(v string) *TagForCreateModelCustomizationJobInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateModelCustomizationJobInput) SetValue(v string) *TagForCreateModelCustomizationJobInput {
	s.Value = &v
	return s
}

type TrainingSetForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Datasets []*DatasetForCreateModelCustomizationJobInput `type:"list" json:",omitempty"`

	PresetData *string `type:"string" json:",omitempty"`

	PresetDataPercentage *int32 `type:"int32" json:",omitempty"`

	PresetDatasets []*PresetDatasetForCreateModelCustomizationJobInput `type:"list" json:",omitempty"`

	TosBucket *string `type:"string" json:",omitempty"`

	TosPaths []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TrainingSetForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingSetForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetDatasets(v []*DatasetForCreateModelCustomizationJobInput) *TrainingSetForCreateModelCustomizationJobInput {
	s.Datasets = v
	return s
}

// SetPresetData sets the PresetData field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetPresetData(v string) *TrainingSetForCreateModelCustomizationJobInput {
	s.PresetData = &v
	return s
}

// SetPresetDataPercentage sets the PresetDataPercentage field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetPresetDataPercentage(v int32) *TrainingSetForCreateModelCustomizationJobInput {
	s.PresetDataPercentage = &v
	return s
}

// SetPresetDatasets sets the PresetDatasets field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetPresetDatasets(v []*PresetDatasetForCreateModelCustomizationJobInput) *TrainingSetForCreateModelCustomizationJobInput {
	s.PresetDatasets = v
	return s
}

// SetTosBucket sets the TosBucket field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetTosBucket(v string) *TrainingSetForCreateModelCustomizationJobInput {
	s.TosBucket = &v
	return s
}

// SetTosPaths sets the TosPaths field's value.
func (s *TrainingSetForCreateModelCustomizationJobInput) SetTosPaths(v []*string) *TrainingSetForCreateModelCustomizationJobInput {
	s.TosPaths = v
	return s
}

type ValidationSetForCreateModelCustomizationJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Datasets []*DatasetForCreateModelCustomizationJobInput `type:"list" json:",omitempty"`

	TosBucket *string `type:"string" json:",omitempty"`

	TosPaths []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ValidationSetForCreateModelCustomizationJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationSetForCreateModelCustomizationJobInput) GoString() string {
	return s.String()
}

// SetDatasets sets the Datasets field's value.
func (s *ValidationSetForCreateModelCustomizationJobInput) SetDatasets(v []*DatasetForCreateModelCustomizationJobInput) *ValidationSetForCreateModelCustomizationJobInput {
	s.Datasets = v
	return s
}

// SetTosBucket sets the TosBucket field's value.
func (s *ValidationSetForCreateModelCustomizationJobInput) SetTosBucket(v string) *ValidationSetForCreateModelCustomizationJobInput {
	s.TosBucket = &v
	return s
}

// SetTosPaths sets the TosPaths field's value.
func (s *ValidationSetForCreateModelCustomizationJobInput) SetTosPaths(v []*string) *ValidationSetForCreateModelCustomizationJobInput {
	s.TosPaths = v
	return s
}

const (
	// EnumOfCustomizationTypeForCreateModelCustomizationJobInputFinetuneSft is a EnumOfCustomizationTypeForCreateModelCustomizationJobInput enum value
	EnumOfCustomizationTypeForCreateModelCustomizationJobInputFinetuneSft = "FinetuneSft"

	// EnumOfCustomizationTypeForCreateModelCustomizationJobInputFinetuneLoRa is a EnumOfCustomizationTypeForCreateModelCustomizationJobInput enum value
	EnumOfCustomizationTypeForCreateModelCustomizationJobInputFinetuneLoRa = "FinetuneLoRA"

	// EnumOfCustomizationTypeForCreateModelCustomizationJobInputPretrain is a EnumOfCustomizationTypeForCreateModelCustomizationJobInput enum value
	EnumOfCustomizationTypeForCreateModelCustomizationJobInputPretrain = "Pretrain"

	// EnumOfCustomizationTypeForCreateModelCustomizationJobInputDpoloRa is a EnumOfCustomizationTypeForCreateModelCustomizationJobInput enum value
	EnumOfCustomizationTypeForCreateModelCustomizationJobInputDpoloRa = "DPOLoRA"

	// EnumOfCustomizationTypeForCreateModelCustomizationJobInputDpo is a EnumOfCustomizationTypeForCreateModelCustomizationJobInput enum value
	EnumOfCustomizationTypeForCreateModelCustomizationJobInputDpo = "DPO"
)

const (
	// EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInputManagedKeyring is a EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInput enum value
	EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInputManagedKeyring = "ManagedKeyring"

	// EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInputCustomKeyring is a EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInput enum value
	EnumOfEncryptionKeyringTypeForCreateModelCustomizationJobInputCustomKeyring = "CustomKeyring"
)
