// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyCertificateAttributesCommon = "ModifyCertificateAttributes"

// ModifyCertificateAttributesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyCertificateAttributesCommon operation. The "output" return
// value will be populated with the ModifyCertificateAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyCertificateAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyCertificateAttributesCommon Send returns without error.
//
// See ModifyCertificateAttributesCommon for more information on using the ModifyCertificateAttributesCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyCertificateAttributesCommonRequest method.
//    req, resp := client.ModifyCertificateAttributesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) ModifyCertificateAttributesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyCertificateAttributesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyCertificateAttributesCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation ModifyCertificateAttributesCommon for usage and error information.
func (c *ALB) ModifyCertificateAttributesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyCertificateAttributesCommonRequest(input)
	return out, req.Send()
}

// ModifyCertificateAttributesCommonWithContext is the same as ModifyCertificateAttributesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCertificateAttributesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) ModifyCertificateAttributesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyCertificateAttributesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyCertificateAttributes = "ModifyCertificateAttributes"

// ModifyCertificateAttributesRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyCertificateAttributes operation. The "output" return
// value will be populated with the ModifyCertificateAttributesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyCertificateAttributesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyCertificateAttributesCommon Send returns without error.
//
// See ModifyCertificateAttributes for more information on using the ModifyCertificateAttributes
// API call, and error handling.
//
//    // Example sending a request using the ModifyCertificateAttributesRequest method.
//    req, resp := client.ModifyCertificateAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) ModifyCertificateAttributesRequest(input *ModifyCertificateAttributesInput) (req *request.Request, output *ModifyCertificateAttributesOutput) {
	op := &request.Operation{
		Name:       opModifyCertificateAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyCertificateAttributesInput{}
	}

	output = &ModifyCertificateAttributesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyCertificateAttributes API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation ModifyCertificateAttributes for usage and error information.
func (c *ALB) ModifyCertificateAttributes(input *ModifyCertificateAttributesInput) (*ModifyCertificateAttributesOutput, error) {
	req, out := c.ModifyCertificateAttributesRequest(input)
	return out, req.Send()
}

// ModifyCertificateAttributesWithContext is the same as ModifyCertificateAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyCertificateAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) ModifyCertificateAttributesWithContext(ctx volcengine.Context, input *ModifyCertificateAttributesInput, opts ...request.Option) (*ModifyCertificateAttributesOutput, error) {
	req, out := c.ModifyCertificateAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyCertificateAttributesInput struct {
	_ struct{} `type:"structure"`

	// CertificateId is a required field
	CertificateId *string `type:"string" required:"true"`

	CertificateName *string `min:"1" max:"128" type:"string"`

	Description *string `type:"string"`
}

// String returns the string representation
func (s ModifyCertificateAttributesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCertificateAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyCertificateAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyCertificateAttributesInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateName != nil && len(*s.CertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateName", 1))
	}
	if s.CertificateName != nil && len(*s.CertificateName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("CertificateName", 128, *s.CertificateName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *ModifyCertificateAttributesInput) SetCertificateId(v string) *ModifyCertificateAttributesInput {
	s.CertificateId = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *ModifyCertificateAttributesInput) SetCertificateName(v string) *ModifyCertificateAttributesInput {
	s.CertificateName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModifyCertificateAttributesInput) SetDescription(v string) *ModifyCertificateAttributesInput {
	s.Description = &v
	return s
}

type ModifyCertificateAttributesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyCertificateAttributesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyCertificateAttributesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyCertificateAttributesOutput) SetRequestId(v string) *ModifyCertificateAttributesOutput {
	s.RequestId = &v
	return s
}
