// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package alb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeServerGroupsCommon = "DescribeServerGroups"

// DescribeServerGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeServerGroupsCommon operation. The "output" return
// value will be populated with the DescribeServerGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeServerGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeServerGroupsCommon Send returns without error.
//
// See DescribeServerGroupsCommon for more information on using the DescribeServerGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeServerGroupsCommonRequest method.
//    req, resp := client.DescribeServerGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) DescribeServerGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeServerGroupsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeServerGroupsCommon API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation DescribeServerGroupsCommon for usage and error information.
func (c *ALB) DescribeServerGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeServerGroupsCommonRequest(input)
	return out, req.Send()
}

// DescribeServerGroupsCommonWithContext is the same as DescribeServerGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServerGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) DescribeServerGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeServerGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServerGroups = "DescribeServerGroups"

// DescribeServerGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeServerGroups operation. The "output" return
// value will be populated with the DescribeServerGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeServerGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeServerGroupsCommon Send returns without error.
//
// See DescribeServerGroups for more information on using the DescribeServerGroups
// API call, and error handling.
//
//    // Example sending a request using the DescribeServerGroupsRequest method.
//    req, resp := client.DescribeServerGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ALB) DescribeServerGroupsRequest(input *DescribeServerGroupsInput) (req *request.Request, output *DescribeServerGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeServerGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServerGroupsInput{}
	}

	output = &DescribeServerGroupsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeServerGroups API operation for ALB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ALB's
// API operation DescribeServerGroups for usage and error information.
func (c *ALB) DescribeServerGroups(input *DescribeServerGroupsInput) (*DescribeServerGroupsOutput, error) {
	req, out := c.DescribeServerGroupsRequest(input)
	return out, req.Send()
}

// DescribeServerGroupsWithContext is the same as DescribeServerGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServerGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ALB) DescribeServerGroupsWithContext(ctx volcengine.Context, input *DescribeServerGroupsInput, opts ...request.Option) (*DescribeServerGroupsOutput, error) {
	req, out := c.DescribeServerGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeServerGroupsInput struct {
	_ struct{} `type:"structure"`

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `type:"integer"`

	ProjectName *string `type:"string"`

	ServerGroupIds []*string `type:"list"`

	ServerGroupNames []*string `type:"list"`

	ServerGroupType *string `type:"string"`

	TagFilters []*TagFilterForDescribeServerGroupsInput `type:"list"`

	VpcID *string `type:"string"`
}

// String returns the string representation
func (s DescribeServerGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerGroupsInput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeServerGroupsInput) SetPageNumber(v int64) *DescribeServerGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeServerGroupsInput) SetPageSize(v int64) *DescribeServerGroupsInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeServerGroupsInput) SetProjectName(v string) *DescribeServerGroupsInput {
	s.ProjectName = &v
	return s
}

// SetServerGroupIds sets the ServerGroupIds field's value.
func (s *DescribeServerGroupsInput) SetServerGroupIds(v []*string) *DescribeServerGroupsInput {
	s.ServerGroupIds = v
	return s
}

// SetServerGroupNames sets the ServerGroupNames field's value.
func (s *DescribeServerGroupsInput) SetServerGroupNames(v []*string) *DescribeServerGroupsInput {
	s.ServerGroupNames = v
	return s
}

// SetServerGroupType sets the ServerGroupType field's value.
func (s *DescribeServerGroupsInput) SetServerGroupType(v string) *DescribeServerGroupsInput {
	s.ServerGroupType = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *DescribeServerGroupsInput) SetTagFilters(v []*TagFilterForDescribeServerGroupsInput) *DescribeServerGroupsInput {
	s.TagFilters = v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *DescribeServerGroupsInput) SetVpcID(v string) *DescribeServerGroupsInput {
	s.VpcID = &v
	return s
}

type DescribeServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	PageNumber *int64 `type:"integer"`

	PageSize *int64 `type:"integer"`

	RequestId *string `type:"string"`

	ServerGroups []*ServerGroupForDescribeServerGroupsOutput `type:"list"`

	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeServerGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServerGroupsOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeServerGroupsOutput) SetPageNumber(v int64) *DescribeServerGroupsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeServerGroupsOutput) SetPageSize(v int64) *DescribeServerGroupsOutput {
	s.PageSize = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *DescribeServerGroupsOutput) SetRequestId(v string) *DescribeServerGroupsOutput {
	s.RequestId = &v
	return s
}

// SetServerGroups sets the ServerGroups field's value.
func (s *DescribeServerGroupsOutput) SetServerGroups(v []*ServerGroupForDescribeServerGroupsOutput) *DescribeServerGroupsOutput {
	s.ServerGroups = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeServerGroupsOutput) SetTotalCount(v int64) *DescribeServerGroupsOutput {
	s.TotalCount = &v
	return s
}

type HealthCheckForDescribeServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	Domain *string `type:"string"`

	Enabled *string `type:"string"`

	HealthyThreshold *int64 `type:"integer"`

	HttpCode *string `type:"string"`

	HttpVersion *string `type:"string"`

	Interval *int64 `type:"integer"`

	Method *string `type:"string"`

	Port *int64 `max:"65535" type:"integer"`

	Protocol *string `type:"string"`

	Timeout *int64 `type:"integer"`

	URI *string `type:"string"`

	UnhealthyThreshold *int64 `type:"integer"`
}

// String returns the string representation
func (s HealthCheckForDescribeServerGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckForDescribeServerGroupsOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetDomain(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.Domain = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetEnabled(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.Enabled = &v
	return s
}

// SetHealthyThreshold sets the HealthyThreshold field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetHealthyThreshold(v int64) *HealthCheckForDescribeServerGroupsOutput {
	s.HealthyThreshold = &v
	return s
}

// SetHttpCode sets the HttpCode field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetHttpCode(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.HttpCode = &v
	return s
}

// SetHttpVersion sets the HttpVersion field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetHttpVersion(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.HttpVersion = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetInterval(v int64) *HealthCheckForDescribeServerGroupsOutput {
	s.Interval = &v
	return s
}

// SetMethod sets the Method field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetMethod(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.Method = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetPort(v int64) *HealthCheckForDescribeServerGroupsOutput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetProtocol(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.Protocol = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetTimeout(v int64) *HealthCheckForDescribeServerGroupsOutput {
	s.Timeout = &v
	return s
}

// SetURI sets the URI field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetURI(v string) *HealthCheckForDescribeServerGroupsOutput {
	s.URI = &v
	return s
}

// SetUnhealthyThreshold sets the UnhealthyThreshold field's value.
func (s *HealthCheckForDescribeServerGroupsOutput) SetUnhealthyThreshold(v int64) *HealthCheckForDescribeServerGroupsOutput {
	s.UnhealthyThreshold = &v
	return s
}

type ServerGroupForDescribeServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	CreateTime *string `type:"string"`

	Description *string `type:"string"`

	HealthCheck *HealthCheckForDescribeServerGroupsOutput `type:"structure"`

	IPAddressType *string `type:"string"`

	Listeners []*string `type:"list"`

	ProjectName *string `type:"string"`

	Protocol *string `type:"string"`

	Scheduler *string `type:"string"`

	ServerCount *int64 `type:"integer"`

	ServerGroupId *string `type:"string"`

	ServerGroupName *string `type:"string"`

	ServerGroupType *string `type:"string"`

	Status *string `type:"string"`

	StickySessionConfig *StickySessionConfigForDescribeServerGroupsOutput `type:"structure"`

	Tags []*TagForDescribeServerGroupsOutput `type:"list"`

	UpdateTime *string `type:"string"`

	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ServerGroupForDescribeServerGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerGroupForDescribeServerGroupsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetCreateTime(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetDescription(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.Description = &v
	return s
}

// SetHealthCheck sets the HealthCheck field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetHealthCheck(v *HealthCheckForDescribeServerGroupsOutput) *ServerGroupForDescribeServerGroupsOutput {
	s.HealthCheck = v
	return s
}

// SetIPAddressType sets the IPAddressType field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetIPAddressType(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.IPAddressType = &v
	return s
}

// SetListeners sets the Listeners field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetListeners(v []*string) *ServerGroupForDescribeServerGroupsOutput {
	s.Listeners = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetProjectName(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.ProjectName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetProtocol(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.Protocol = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetScheduler(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.Scheduler = &v
	return s
}

// SetServerCount sets the ServerCount field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetServerCount(v int64) *ServerGroupForDescribeServerGroupsOutput {
	s.ServerCount = &v
	return s
}

// SetServerGroupId sets the ServerGroupId field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetServerGroupId(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.ServerGroupId = &v
	return s
}

// SetServerGroupName sets the ServerGroupName field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetServerGroupName(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.ServerGroupName = &v
	return s
}

// SetServerGroupType sets the ServerGroupType field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetServerGroupType(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.ServerGroupType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetStatus(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.Status = &v
	return s
}

// SetStickySessionConfig sets the StickySessionConfig field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetStickySessionConfig(v *StickySessionConfigForDescribeServerGroupsOutput) *ServerGroupForDescribeServerGroupsOutput {
	s.StickySessionConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetTags(v []*TagForDescribeServerGroupsOutput) *ServerGroupForDescribeServerGroupsOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetUpdateTime(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.UpdateTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ServerGroupForDescribeServerGroupsOutput) SetVpcId(v string) *ServerGroupForDescribeServerGroupsOutput {
	s.VpcId = &v
	return s
}

type StickySessionConfigForDescribeServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	Cookie *string `type:"string"`

	CookieTimeout *int64 `type:"integer"`

	StickySessionEnabled *string `type:"string"`

	StickySessionType *string `type:"string"`
}

// String returns the string representation
func (s StickySessionConfigForDescribeServerGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StickySessionConfigForDescribeServerGroupsOutput) GoString() string {
	return s.String()
}

// SetCookie sets the Cookie field's value.
func (s *StickySessionConfigForDescribeServerGroupsOutput) SetCookie(v string) *StickySessionConfigForDescribeServerGroupsOutput {
	s.Cookie = &v
	return s
}

// SetCookieTimeout sets the CookieTimeout field's value.
func (s *StickySessionConfigForDescribeServerGroupsOutput) SetCookieTimeout(v int64) *StickySessionConfigForDescribeServerGroupsOutput {
	s.CookieTimeout = &v
	return s
}

// SetStickySessionEnabled sets the StickySessionEnabled field's value.
func (s *StickySessionConfigForDescribeServerGroupsOutput) SetStickySessionEnabled(v string) *StickySessionConfigForDescribeServerGroupsOutput {
	s.StickySessionEnabled = &v
	return s
}

// SetStickySessionType sets the StickySessionType field's value.
func (s *StickySessionConfigForDescribeServerGroupsOutput) SetStickySessionType(v string) *StickySessionConfigForDescribeServerGroupsOutput {
	s.StickySessionType = &v
	return s
}

type TagFilterForDescribeServerGroupsInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilterForDescribeServerGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeServerGroupsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagFilterForDescribeServerGroupsInput) SetKey(v string) *TagFilterForDescribeServerGroupsInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForDescribeServerGroupsInput) SetValues(v []*string) *TagFilterForDescribeServerGroupsInput {
	s.Values = v
	return s
}

type TagForDescribeServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDescribeServerGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeServerGroupsOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeServerGroupsOutput) SetKey(v string) *TagForDescribeServerGroupsOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeServerGroupsOutput) SetValue(v string) *TagForDescribeServerGroupsOutput {
	s.Value = &v
	return s
}
