// Example Code generated by Beijing Volcanoengine Technology.
package vpcexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/vpc"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeRouteTableList() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := vpc.New(sess)
	describeRouteTableListInput := &vpc.DescribeRouteTableListInput{
		VpcId: volcengine.String("vpc-2fdz8g5nruzuo5oxru*******"),
	}

	resp, err := svc.DescribeRouteTableList(describeRouteTableListInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
