// Example Code generated by Beijing Volcanoengine Technology.
package natgatewayexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/natgateway"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeNatGateways() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := natgateway.New(sess)
	describeNatGatewaysInput := &natgateway.DescribeNatGatewaysInput{
		PageNumber: volcengine.Int64(1),
		PageSize:   volcengine.Int64(5),
		Spec:       volcengine.String("Medium"),
	}

	resp, err := svc.DescribeNatGateways(describeNatGatewaysInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
