// Example Code generated by Beijing Volcanoengine Technology.
package ecsexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/ecs"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeEventTypes() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := ecs.New(sess)
	describeEventTypesInput := &ecs.DescribeEventTypesInput{
		Types: volcengine.StringSlice([]string{"DiskError_Redeploy", "CreateInstance"}),
	}

	resp, err := svc.DescribeEventTypes(describeEventTypesInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
