// Example Code generated by Beijing Volcanoengine Technology.
package directconnectexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/directconnect"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateDirectConnectConnection() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := directconnect.New(sess)
	createDirectConnectConnectionInput := &directconnect.CreateDirectConnectConnectionInput{
		Bandwidth:                   volcengine.Int64(1000),
		ClientToken:                 volcengine.String("123e4567-e89b-12d3-a456-42665544****"),
		CustomerContactEmail:        volcengine.String("12345test@example.com"),
		CustomerContactPhone:        volcengine.String("133****2233"),
		CustomerName:                volcengine.String("张*三"),
		Description:                 volcengine.String("test"),
		DirectConnectAccessPointId:  volcengine.String("ap-cn-shanghai-***"),
		DirectConnectConnectionName: volcengine.String("test"),
		LineOperator:                volcengine.String("ChinaMobile"),
		PeerLocation:                volcengine.String("中国上海市静安区XX路XX号XX楼XX机房"),
		PortType:                    volcengine.String("1000Base"),
	}

	resp, err := svc.CreateDirectConnectConnection(createDirectConnectConnectionInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
