// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func DescribeLifecycleHooks() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	describeLifecycleHooksInput := &autoscaling.DescribeLifecycleHooksInput{
		LifecycleHookIds: volcengine.StringSlice([]string{"sgh-ybrzg7******927"}),
		PageNumber:       volcengine.Int32(1),
		PageSize:         volcengine.Int32(10),
		ScalingGroupId:   volcengine.String("scg-ybq*****6t"),
	}

	resp, err := svc.DescribeLifecycleHooks(describeLifecycleHooksInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
