// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CreateLifecycleHook() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	createLifecycleHookInput := &autoscaling.CreateLifecycleHookInput{
		LifecycleHookName:    volcengine.String("hook01"),
		LifecycleHookPolicy:  volcengine.String("CONTINUE"),
		LifecycleHookTimeout: volcengine.Int32(30),
		LifecycleHookType:    volcengine.String("SCALE_OUT"),
		ScalingGroupId:       volcengine.String("scg-ybqm0b*****e6t"),
	}

	resp, err := svc.CreateLifecycleHook(createLifecycleHookInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
