// Example Code generated by Beijing Volcanoengine Technology.
package autoscalingexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/autoscaling"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func AttachServerGroups() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := autoscaling.New(sess)
	reqServerGroupAttributes := &autoscaling.ServerGroupAttributeForAttachServerGroupsInput{
		Port:          volcengine.Int32(12),
		ServerGroupId: volcengine.String("rsp-12b2z5fnxvhts17q7y2fj****"),
		Weight:        volcengine.Int32(20),
	}
	attachServerGroupsInput := &autoscaling.AttachServerGroupsInput{
		ScalingGroupId:        volcengine.String(""),
		ServerGroupAttributes: []*autoscaling.ServerGroupAttributeForAttachServerGroupsInput{reqServerGroupAttributes},
	}

	resp, err := svc.AttachServerGroups(attachServerGroupsInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
