// Copyright 2020-2024 the Pinniped contributors. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
//

// Code generated by MockGen. DO NOT EDIT.
// Source: go.pinniped.dev/internal/federationdomain/upstreamprovider (interfaces: UpstreamOIDCIdentityProviderI)
//
// Generated by this command:
//
//	mockgen -destination=mockupstreamoidcidentityprovider.go -package=mockupstreamoidcidentityprovider -copyright_file=../../../hack/header.txt go.pinniped.dev/internal/federationdomain/upstreamprovider UpstreamOIDCIdentityProviderI
//

// Package mockupstreamoidcidentityprovider is a generated GoMock package.
package mockupstreamoidcidentityprovider

import (
	context "context"
	url "net/url"
	reflect "reflect"

	upstreamprovider "go.pinniped.dev/internal/federationdomain/upstreamprovider"
	nonce "go.pinniped.dev/pkg/oidcclient/nonce"
	oidctypes "go.pinniped.dev/pkg/oidcclient/oidctypes"
	pkce "go.pinniped.dev/pkg/oidcclient/pkce"
	gomock "go.uber.org/mock/gomock"
	oauth2 "golang.org/x/oauth2"
	types "k8s.io/apimachinery/pkg/types"
)

// MockUpstreamOIDCIdentityProviderI is a mock of UpstreamOIDCIdentityProviderI interface.
type MockUpstreamOIDCIdentityProviderI struct {
	ctrl     *gomock.Controller
	recorder *MockUpstreamOIDCIdentityProviderIMockRecorder
	isgomock struct{}
}

// MockUpstreamOIDCIdentityProviderIMockRecorder is the mock recorder for MockUpstreamOIDCIdentityProviderI.
type MockUpstreamOIDCIdentityProviderIMockRecorder struct {
	mock *MockUpstreamOIDCIdentityProviderI
}

// NewMockUpstreamOIDCIdentityProviderI creates a new mock instance.
func NewMockUpstreamOIDCIdentityProviderI(ctrl *gomock.Controller) *MockUpstreamOIDCIdentityProviderI {
	mock := &MockUpstreamOIDCIdentityProviderI{ctrl: ctrl}
	mock.recorder = &MockUpstreamOIDCIdentityProviderIMockRecorder{mock}
	return mock
}

// EXPECT returns an object that allows the caller to indicate expected use.
func (m *MockUpstreamOIDCIdentityProviderI) EXPECT() *MockUpstreamOIDCIdentityProviderIMockRecorder {
	return m.recorder
}

// AllowsPasswordGrant mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) AllowsPasswordGrant() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "AllowsPasswordGrant")
	ret0, _ := ret[0].(bool)
	return ret0
}

// AllowsPasswordGrant indicates an expected call of AllowsPasswordGrant.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) AllowsPasswordGrant() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "AllowsPasswordGrant", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).AllowsPasswordGrant))
}

// ExchangeAuthcodeAndValidateTokens mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) ExchangeAuthcodeAndValidateTokens(ctx context.Context, authcode string, pkceCodeVerifier pkce.Code, expectedIDTokenNonce nonce.Nonce, redirectURI string) (*oidctypes.Token, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ExchangeAuthcodeAndValidateTokens", ctx, authcode, pkceCodeVerifier, expectedIDTokenNonce, redirectURI)
	ret0, _ := ret[0].(*oidctypes.Token)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ExchangeAuthcodeAndValidateTokens indicates an expected call of ExchangeAuthcodeAndValidateTokens.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) ExchangeAuthcodeAndValidateTokens(ctx, authcode, pkceCodeVerifier, expectedIDTokenNonce, redirectURI any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ExchangeAuthcodeAndValidateTokens", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).ExchangeAuthcodeAndValidateTokens), ctx, authcode, pkceCodeVerifier, expectedIDTokenNonce, redirectURI)
}

// GetAdditionalAuthcodeParams mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetAdditionalAuthcodeParams() map[string]string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAdditionalAuthcodeParams")
	ret0, _ := ret[0].(map[string]string)
	return ret0
}

// GetAdditionalAuthcodeParams indicates an expected call of GetAdditionalAuthcodeParams.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetAdditionalAuthcodeParams() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAdditionalAuthcodeParams", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetAdditionalAuthcodeParams))
}

// GetAdditionalClaimMappings mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetAdditionalClaimMappings() map[string]string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAdditionalClaimMappings")
	ret0, _ := ret[0].(map[string]string)
	return ret0
}

// GetAdditionalClaimMappings indicates an expected call of GetAdditionalClaimMappings.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetAdditionalClaimMappings() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAdditionalClaimMappings", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetAdditionalClaimMappings))
}

// GetAuthorizationURL mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetAuthorizationURL() *url.URL {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetAuthorizationURL")
	ret0, _ := ret[0].(*url.URL)
	return ret0
}

// GetAuthorizationURL indicates an expected call of GetAuthorizationURL.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetAuthorizationURL() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetAuthorizationURL", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetAuthorizationURL))
}

// GetClientID mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetClientID() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetClientID")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetClientID indicates an expected call of GetClientID.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetClientID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetClientID", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetClientID))
}

// GetGroupsClaim mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetGroupsClaim() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetGroupsClaim")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetGroupsClaim indicates an expected call of GetGroupsClaim.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetGroupsClaim() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetGroupsClaim", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetGroupsClaim))
}

// GetResourceName mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetResourceName() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetResourceName")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetResourceName indicates an expected call of GetResourceName.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetResourceName() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourceName", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetResourceName))
}

// GetResourceUID mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetResourceUID() types.UID {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetResourceUID")
	ret0, _ := ret[0].(types.UID)
	return ret0
}

// GetResourceUID indicates an expected call of GetResourceUID.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetResourceUID() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetResourceUID", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetResourceUID))
}

// GetScopes mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetScopes() []string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetScopes")
	ret0, _ := ret[0].([]string)
	return ret0
}

// GetScopes indicates an expected call of GetScopes.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetScopes() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetScopes", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetScopes))
}

// GetUsernameClaim mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) GetUsernameClaim() string {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "GetUsernameClaim")
	ret0, _ := ret[0].(string)
	return ret0
}

// GetUsernameClaim indicates an expected call of GetUsernameClaim.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) GetUsernameClaim() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "GetUsernameClaim", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).GetUsernameClaim))
}

// HasUserInfoURL mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) HasUserInfoURL() bool {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "HasUserInfoURL")
	ret0, _ := ret[0].(bool)
	return ret0
}

// HasUserInfoURL indicates an expected call of HasUserInfoURL.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) HasUserInfoURL() *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "HasUserInfoURL", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).HasUserInfoURL))
}

// PasswordCredentialsGrantAndValidateTokens mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) PasswordCredentialsGrantAndValidateTokens(ctx context.Context, username, password string) (*oidctypes.Token, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PasswordCredentialsGrantAndValidateTokens", ctx, username, password)
	ret0, _ := ret[0].(*oidctypes.Token)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PasswordCredentialsGrantAndValidateTokens indicates an expected call of PasswordCredentialsGrantAndValidateTokens.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) PasswordCredentialsGrantAndValidateTokens(ctx, username, password any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PasswordCredentialsGrantAndValidateTokens", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).PasswordCredentialsGrantAndValidateTokens), ctx, username, password)
}

// PerformRefresh mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) PerformRefresh(ctx context.Context, refreshToken string) (*oauth2.Token, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "PerformRefresh", ctx, refreshToken)
	ret0, _ := ret[0].(*oauth2.Token)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// PerformRefresh indicates an expected call of PerformRefresh.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) PerformRefresh(ctx, refreshToken any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "PerformRefresh", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).PerformRefresh), ctx, refreshToken)
}

// RevokeToken mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) RevokeToken(ctx context.Context, token string, tokenType upstreamprovider.RevocableTokenType) error {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "RevokeToken", ctx, token, tokenType)
	ret0, _ := ret[0].(error)
	return ret0
}

// RevokeToken indicates an expected call of RevokeToken.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) RevokeToken(ctx, token, tokenType any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "RevokeToken", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).RevokeToken), ctx, token, tokenType)
}

// ValidateTokenAndMergeWithUserInfo mocks base method.
func (m *MockUpstreamOIDCIdentityProviderI) ValidateTokenAndMergeWithUserInfo(ctx context.Context, tok *oauth2.Token, expectedIDTokenNonce nonce.Nonce, requireIDToken, requireUserInfo bool) (*oidctypes.Token, error) {
	m.ctrl.T.Helper()
	ret := m.ctrl.Call(m, "ValidateTokenAndMergeWithUserInfo", ctx, tok, expectedIDTokenNonce, requireIDToken, requireUserInfo)
	ret0, _ := ret[0].(*oidctypes.Token)
	ret1, _ := ret[1].(error)
	return ret0, ret1
}

// ValidateTokenAndMergeWithUserInfo indicates an expected call of ValidateTokenAndMergeWithUserInfo.
func (mr *MockUpstreamOIDCIdentityProviderIMockRecorder) ValidateTokenAndMergeWithUserInfo(ctx, tok, expectedIDTokenNonce, requireIDToken, requireUserInfo any) *gomock.Call {
	mr.mock.ctrl.T.Helper()
	return mr.mock.ctrl.RecordCallWithMethodType(mr.mock, "ValidateTokenAndMergeWithUserInfo", reflect.TypeOf((*MockUpstreamOIDCIdentityProviderI)(nil).ValidateTokenAndMergeWithUserInfo), ctx, tok, expectedIDTokenNonce, requireIDToken, requireUserInfo)
}
