package authoring

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// ModelClient is the client for the Model methods of the Authoring service.
type ModelClient struct {
	BaseClient
}

// NewModelClient creates an instance of the ModelClient client.
func NewModelClient(endpoint string) ModelClient {
	return ModelClient{New(endpoint)}
}

// AddClosedList adds a list entity model to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// closedListModelCreateObject - a model containing the name and words for the new list entity extractor.
func (client ModelClient) AddClosedList(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddClosedList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddClosedListPreparer(ctx, appID, versionID, closedListModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.AddClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddClosedList", resp, "Failure responding to request")
	}

	return
}

// AddClosedListPreparer prepares the AddClosedList request.
func (client ModelClient) AddClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, closedListModelCreateObject ClosedListModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithJSON(closedListModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddClosedListSender sends the AddClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddClosedListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddClosedListResponder handles the response to the AddClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddClosedListResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCompositeEntityChild creates a single child in an existing composite entity model in a version of the
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeChildModelCreateObject - a model object containing the name of the new composite child model.
func (client ModelClient) AddCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddCompositeEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, compositeChildModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCompositeEntityChild", resp, "Failure responding to request")
	}

	return
}

// AddCompositeEntityChildPreparer prepares the AddCompositeEntityChild request.
func (client ModelClient) AddCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeChildModelCreateObject CompositeChildModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children", pathParameters),
		autorest.WithJSON(compositeChildModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCompositeEntityChildSender sends the AddCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddCompositeEntityChildResponder handles the response to the AddCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCompositeEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltDomain adds a customizable prebuilt domain along with all of its intent and entity models in a
// version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainObject - a prebuilt domain create object containing the name of the domain.
func (client ModelClient) AddCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (result ListUUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddCustomPrebuiltDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddCustomPrebuiltDomainPreparer(ctx, appID, versionID, prebuiltDomainObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltDomain", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltDomainPreparer prepares the AddCustomPrebuiltDomain request.
func (client ModelClient) AddCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainObject PrebuiltDomainCreateBaseObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains", pathParameters),
		autorest.WithJSON(prebuiltDomainObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltDomainSender sends the AddCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddCustomPrebuiltDomainResponder handles the response to the AddCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltDomainResponder(resp *http.Response) (result ListUUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltEntity adds a prebuilt entity model to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the prebuilt entity and the name of
// the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltEntity(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddCustomPrebuiltEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddCustomPrebuiltEntityPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltEntity", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltEntityPreparer prepares the AddCustomPrebuiltEntity request.
func (client ModelClient) AddCustomPrebuiltEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltEntitySender sends the AddCustomPrebuiltEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddCustomPrebuiltEntityResponder handles the response to the AddCustomPrebuiltEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltIntent adds a customizable prebuilt intent model to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltDomainModelCreateObject - a model object containing the name of the customizable prebuilt intent and
// the name of the domain to which this model belongs.
func (client ModelClient) AddCustomPrebuiltIntent(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddCustomPrebuiltIntent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddCustomPrebuiltIntentPreparer(ctx, appID, versionID, prebuiltDomainModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddCustomPrebuiltIntent", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltIntentPreparer prepares the AddCustomPrebuiltIntent request.
func (client ModelClient) AddCustomPrebuiltIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltDomainModelCreateObject PrebuiltDomainModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters),
		autorest.WithJSON(prebuiltDomainModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltIntentSender sends the AddCustomPrebuiltIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddCustomPrebuiltIntentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddCustomPrebuiltIntentResponder handles the response to the AddCustomPrebuiltIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddCustomPrebuiltIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddEntity adds an entity extractor to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityModelCreateObject - a model object containing the name of the new entity extractor and its children.
func (client ModelClient) AddEntity(ctx context.Context, appID uuid.UUID, versionID string, entityModelCreateObject EntityModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddEntityPreparer(ctx, appID, versionID, entityModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntity", resp, "Failure sending request")
		return
	}

	result, err = client.AddEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntity", resp, "Failure responding to request")
	}

	return
}

// AddEntityPreparer prepares the AddEntity request.
func (client ModelClient) AddEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityModelCreateObject EntityModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithJSON(entityModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddEntitySender sends the AddEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddEntityResponder handles the response to the AddEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) AddEntityResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddEntityChild creates a single child in an existing entity model hierarchy in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
// childEntityModelCreateObject - a model object containing the name of the new child model and its children.
func (client ModelClient) AddEntityChild(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, childEntityModelCreateObject ChildEntityModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddEntityChildPreparer(ctx, appID, versionID, entityID, childEntityModelCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.AddEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddEntityChild", resp, "Failure responding to request")
	}

	return
}

// AddEntityChildPreparer prepares the AddEntityChild request.
func (client ModelClient) AddEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, childEntityModelCreateObject ChildEntityModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/children", pathParameters),
		autorest.WithJSON(childEntityModelCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddEntityChildSender sends the AddEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddEntityChildResponder handles the response to the AddEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) AddEntityChildResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddExplicitListItem sends the add explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// item - the new explicit list item.
func (client ModelClient) AddExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, item ExplicitListItemCreateObject) (result Int32, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddExplicitListItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddExplicitListItemPreparer(ctx, appID, versionID, entityID, item)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.AddExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddExplicitListItem", resp, "Failure responding to request")
	}

	return
}

// AddExplicitListItemPreparer prepares the AddExplicitListItem request.
func (client ModelClient) AddExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, item ExplicitListItemCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", pathParameters),
		autorest.WithJSON(item))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddExplicitListItemSender sends the AddExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddExplicitListItemSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddExplicitListItemResponder handles the response to the AddExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) AddExplicitListItemResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddIntent adds an intent to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentCreateObject - a model object containing the name of the new intent.
func (client ModelClient) AddIntent(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddIntent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddIntentPreparer(ctx, appID, versionID, intentCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddIntent", resp, "Failure sending request")
		return
	}

	result, err = client.AddIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddIntent", resp, "Failure responding to request")
	}

	return
}

// AddIntentPreparer prepares the AddIntent request.
func (client ModelClient) AddIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentCreateObject ModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithJSON(intentCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddIntentSender sends the AddIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddIntentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddIntentResponder handles the response to the AddIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) AddIntentResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddPrebuilt adds a list of prebuilt entities to a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltExtractorNames - an array of prebuilt entity extractor names.
func (client ModelClient) AddPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (result ListPrebuiltEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddPrebuilt")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: prebuiltExtractorNames,
			Constraints: []validation.Constraint{{Target: "prebuiltExtractorNames", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "AddPrebuilt", err.Error())
	}

	req, err := client.AddPrebuiltPreparer(ctx, appID, versionID, prebuiltExtractorNames)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.AddPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddPrebuilt", resp, "Failure responding to request")
	}

	return
}

// AddPrebuiltPreparer prepares the AddPrebuilt request.
func (client ModelClient) AddPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltExtractorNames []string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithJSON(prebuiltExtractorNames))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddPrebuiltSender sends the AddPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddPrebuiltSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddPrebuiltResponder handles the response to the AddPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) AddPrebuiltResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddSubList adds a sublist to an existing list entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list entity extractor ID.
// wordListCreateObject - words list.
func (client ModelClient) AddSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (result Int64, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.AddSubList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddSubListPreparer(ctx, appID, versionID, clEntityID, wordListCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddSubList", resp, "Failure sending request")
		return
	}

	result, err = client.AddSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "AddSubList", resp, "Failure responding to request")
	}

	return
}

// AddSubListPreparer prepares the AddSubList request.
func (client ModelClient) AddSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, wordListCreateObject WordListObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists", pathParameters),
		autorest.WithJSON(wordListCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSubListSender sends the AddSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) AddSubListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// AddSubListResponder handles the response to the AddSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) AddSubListResponder(resp *http.Response) (result Int64, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateClosedListEntityRole sends the create closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateClosedListEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateClosedListEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateClosedListEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateClosedListEntityRolePreparer prepares the CreateClosedListEntityRole request.
func (client ModelClient) CreateClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateClosedListEntityRoleSender sends the CreateClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateClosedListEntityRoleResponder handles the response to the CreateClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateClosedListEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCompositeEntityRole sends the create composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateCompositeEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCompositeEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateCompositeEntityRolePreparer prepares the CreateCompositeEntityRole request.
func (client ModelClient) CreateCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateCompositeEntityRoleSender sends the CreateCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateCompositeEntityRoleResponder handles the response to the CreateCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateCompositeEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateCustomPrebuiltEntityRole sends the create custom prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateCustomPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateCustomPrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateCustomPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCustomPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateCustomPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCustomPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateCustomPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateCustomPrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateCustomPrebuiltEntityRolePreparer prepares the CreateCustomPrebuiltEntityRole request.
func (client ModelClient) CreateCustomPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateCustomPrebuiltEntityRoleSender sends the CreateCustomPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateCustomPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateCustomPrebuiltEntityRoleResponder handles the response to the CreateCustomPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateCustomPrebuiltEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEntityRole sends the create entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateEntityRolePreparer prepares the CreateEntityRole request.
func (client ModelClient) CreateEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateEntityRoleSender sends the CreateEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateEntityRoleResponder handles the response to the CreateEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateHierarchicalEntityRole sends the create hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateHierarchicalEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateHierarchicalEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateHierarchicalEntityRolePreparer prepares the CreateHierarchicalEntityRole request.
func (client ModelClient) CreateHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateHierarchicalEntityRoleSender sends the CreateHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateHierarchicalEntityRoleResponder handles the response to the CreateHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateHierarchicalEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePatternAnyEntityModel sends the create pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// extractorCreateObject - a model object containing the name and explicit list for the new Pattern.Any entity
// extractor.
func (client ModelClient) CreatePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, extractorCreateObject PatternAnyModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreatePatternAnyEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreatePatternAnyEntityModelPreparer(ctx, appID, versionID, extractorCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityModel", resp, "Failure responding to request")
	}

	return
}

// CreatePatternAnyEntityModelPreparer prepares the CreatePatternAnyEntityModel request.
func (client ModelClient) CreatePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, extractorCreateObject PatternAnyModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities", pathParameters),
		autorest.WithJSON(extractorCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePatternAnyEntityModelSender sends the CreatePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreatePatternAnyEntityModelResponder handles the response to the CreatePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePatternAnyEntityModelResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePatternAnyEntityRole sends the create pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreatePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreatePatternAnyEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreatePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePatternAnyEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreatePatternAnyEntityRolePreparer prepares the CreatePatternAnyEntityRole request.
func (client ModelClient) CreatePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePatternAnyEntityRoleSender sends the CreatePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreatePatternAnyEntityRoleResponder handles the response to the CreatePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePatternAnyEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreatePrebuiltEntityRole sends the create prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreatePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreatePrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreatePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreatePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreatePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreatePrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreatePrebuiltEntityRolePreparer prepares the CreatePrebuiltEntityRole request.
func (client ModelClient) CreatePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreatePrebuiltEntityRoleSender sends the CreatePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreatePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreatePrebuiltEntityRoleResponder handles the response to the CreatePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreatePrebuiltEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateRegexEntityModel sends the create regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityExtractorCreateObj - a model object containing the name and regex pattern for the new regular
// expression entity extractor.
func (client ModelClient) CreateRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityExtractorCreateObj RegexModelCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateRegexEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateRegexEntityModelPreparer(ctx, appID, versionID, regexEntityExtractorCreateObj)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityModel", resp, "Failure responding to request")
	}

	return
}

// CreateRegexEntityModelPreparer prepares the CreateRegexEntityModel request.
func (client ModelClient) CreateRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityExtractorCreateObj RegexModelCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities", pathParameters),
		autorest.WithJSON(regexEntityExtractorCreateObj))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRegexEntityModelSender sends the CreateRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateRegexEntityModelResponder handles the response to the CreateRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateRegexEntityModelResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateRegexEntityRole sends the create regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity model ID.
// entityRoleCreateObject - an entity role object containing the name of role.
func (client ModelClient) CreateRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.CreateRegexEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateRegexEntityRolePreparer(ctx, appID, versionID, entityID, entityRoleCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "CreateRegexEntityRole", resp, "Failure responding to request")
	}

	return
}

// CreateRegexEntityRolePreparer prepares the CreateRegexEntityRole request.
func (client ModelClient) CreateRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityRoleCreateObject EntityRoleCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", pathParameters),
		autorest.WithJSON(entityRoleCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRegexEntityRoleSender sends the CreateRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) CreateRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateRegexEntityRoleResponder handles the response to the CreateRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) CreateRegexEntityRoleResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteClosedList deletes a list entity model from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list entity model ID.
func (client ModelClient) DeleteClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteClosedList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedList", resp, "Failure responding to request")
	}

	return
}

// DeleteClosedListPreparer prepares the DeleteClosedList request.
func (client ModelClient) DeleteClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteClosedListSender sends the DeleteClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteClosedListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteClosedListResponder handles the response to the DeleteClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteClosedListEntityRole sends the delete closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteClosedListEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteClosedListEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteClosedListEntityRolePreparer prepares the DeleteClosedListEntityRole request.
func (client ModelClient) DeleteClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteClosedListEntityRoleSender sends the DeleteClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteClosedListEntityRoleResponder handles the response to the DeleteClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteClosedListEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntity deletes a composite entity from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) DeleteCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteCompositeEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteCompositeEntityPreparer prepares the DeleteCompositeEntity request.
func (client ModelClient) DeleteCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntitySender sends the DeleteCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCompositeEntityResponder handles the response to the DeleteCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntityChild deletes a composite entity extractor child from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// cChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteCompositeEntityChild(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteCompositeEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCompositeEntityChildPreparer(ctx, appID, versionID, cEntityID, cChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityChild", resp, "Failure responding to request")
	}

	return
}

// DeleteCompositeEntityChildPreparer prepares the DeleteCompositeEntityChild request.
func (client ModelClient) DeleteCompositeEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, cChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cChildId":  autorest.Encode("path", cChildID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/children/{cChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntityChildSender sends the DeleteCompositeEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCompositeEntityChildResponder handles the response to the DeleteCompositeEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCompositeEntityRole sends the delete composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteCompositeEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCompositeEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteCompositeEntityRolePreparer prepares the DeleteCompositeEntityRole request.
func (client ModelClient) DeleteCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCompositeEntityRoleSender sends the DeleteCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCompositeEntityRoleResponder handles the response to the DeleteCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCompositeEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCustomEntityRole sends the delete custom entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteCustomEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteCustomEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCustomEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCustomEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCustomEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteCustomEntityRolePreparer prepares the DeleteCustomEntityRole request.
func (client ModelClient) DeleteCustomEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCustomEntityRoleSender sends the DeleteCustomEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCustomEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCustomEntityRoleResponder handles the response to the DeleteCustomEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCustomEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteCustomPrebuiltDomain deletes a prebuilt domain's models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// domainName - domain name.
func (client ModelClient) DeleteCustomPrebuiltDomain(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteCustomPrebuiltDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteCustomPrebuiltDomainPreparer(ctx, appID, versionID, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteCustomPrebuiltDomain", resp, "Failure responding to request")
	}

	return
}

// DeleteCustomPrebuiltDomainPreparer prepares the DeleteCustomPrebuiltDomain request.
func (client ModelClient) DeleteCustomPrebuiltDomainPreparer(ctx context.Context, appID uuid.UUID, versionID string, domainName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"domainName": autorest.Encode("path", domainName),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltdomains/{domainName}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteCustomPrebuiltDomainSender sends the DeleteCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteCustomPrebuiltDomainResponder handles the response to the DeleteCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteCustomPrebuiltDomainResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntity deletes an entity or a child from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor or the child entity extractor ID.
func (client ModelClient) DeleteEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteEntityPreparer prepares the DeleteEntity request.
func (client ModelClient) DeleteEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntitySender sends the DeleteEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteEntityResponder handles the response to the DeleteEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntityFeature deletes a relation from the feature relations used by the entity in a version of the
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
// featureRelationDeleteObject - a feature information object containing the feature relation to delete.
func (client ModelClient) DeleteEntityFeature(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, featureRelationDeleteObject ModelFeatureInformation) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteEntityFeature")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteEntityFeaturePreparer(ctx, appID, versionID, entityID, featureRelationDeleteObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityFeature", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntityFeatureSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityFeature", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityFeatureResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityFeature", resp, "Failure responding to request")
	}

	return
}

// DeleteEntityFeaturePreparer prepares the DeleteEntityFeature request.
func (client ModelClient) DeleteEntityFeaturePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, featureRelationDeleteObject ModelFeatureInformation) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/features", pathParameters),
		autorest.WithJSON(featureRelationDeleteObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntityFeatureSender sends the DeleteEntityFeature request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntityFeatureSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteEntityFeatureResponder handles the response to the DeleteEntityFeature request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityFeatureResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteEntityRole sends the delete entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteEntityRolePreparer prepares the DeleteEntityRole request.
func (client ModelClient) DeleteEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntityRoleSender sends the DeleteEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteEntityRoleResponder handles the response to the DeleteEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteExplicitListItem sends the delete explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the pattern.any entity id.
// itemID - the explicit list item which will be deleted.
func (client ModelClient) DeleteExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteExplicitListItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteExplicitListItem", resp, "Failure responding to request")
	}

	return
}

// DeleteExplicitListItemPreparer prepares the DeleteExplicitListItem request.
func (client ModelClient) DeleteExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteExplicitListItemSender sends the DeleteExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteExplicitListItemSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteExplicitListItemResponder handles the response to the DeleteExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteExplicitListItemResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntity deletes a hierarchical entity from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) DeleteHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteHierarchicalEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteHierarchicalEntityPreparer prepares the DeleteHierarchicalEntity request.
func (client ModelClient) DeleteHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntitySender sends the DeleteHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteHierarchicalEntityResponder handles the response to the DeleteHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntityChild deletes a hierarchical entity extractor child in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) DeleteHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteHierarchicalEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// DeleteHierarchicalEntityChildPreparer prepares the DeleteHierarchicalEntityChild request.
func (client ModelClient) DeleteHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntityChildSender sends the DeleteHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteHierarchicalEntityChildResponder handles the response to the DeleteHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteHierarchicalEntityRole sends the delete hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteHierarchicalEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteHierarchicalEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteHierarchicalEntityRolePreparer prepares the DeleteHierarchicalEntityRole request.
func (client ModelClient) DeleteHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteHierarchicalEntityRoleSender sends the DeleteHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteHierarchicalEntityRoleResponder handles the response to the DeleteHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteHierarchicalEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteIntent deletes an intent from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// deleteUtterances - if true, deletes the intent's example utterances. If false, moves the example utterances
// to the None intent. The default value is false.
func (client ModelClient) DeleteIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteIntent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteIntentPreparer(ctx, appID, versionID, intentID, deleteUtterances)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntent", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntent", resp, "Failure responding to request")
	}

	return
}

// DeleteIntentPreparer prepares the DeleteIntent request.
func (client ModelClient) DeleteIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, deleteUtterances *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if deleteUtterances != nil {
		queryParameters["deleteUtterances"] = autorest.Encode("query", *deleteUtterances)
	} else {
		queryParameters["deleteUtterances"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteIntentSender sends the DeleteIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteIntentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteIntentResponder handles the response to the DeleteIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteIntentFeature deletes a relation from the feature relations used by the intent in a version of the
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// featureRelationDeleteObject - a feature information object containing the feature relation to delete.
func (client ModelClient) DeleteIntentFeature(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, featureRelationDeleteObject ModelFeatureInformation) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteIntentFeature")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteIntentFeaturePreparer(ctx, appID, versionID, intentID, featureRelationDeleteObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntentFeature", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteIntentFeatureSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntentFeature", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteIntentFeatureResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteIntentFeature", resp, "Failure responding to request")
	}

	return
}

// DeleteIntentFeaturePreparer prepares the DeleteIntentFeature request.
func (client ModelClient) DeleteIntentFeaturePreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, featureRelationDeleteObject ModelFeatureInformation) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/features", pathParameters),
		autorest.WithJSON(featureRelationDeleteObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteIntentFeatureSender sends the DeleteIntentFeature request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteIntentFeatureSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteIntentFeatureResponder handles the response to the DeleteIntentFeature request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteIntentFeatureResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePatternAnyEntityModel sends the delete pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
func (client ModelClient) DeletePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeletePatternAnyEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePatternAnyEntityModelPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityModel", resp, "Failure responding to request")
	}

	return
}

// DeletePatternAnyEntityModelPreparer prepares the DeletePatternAnyEntityModel request.
func (client ModelClient) DeletePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePatternAnyEntityModelSender sends the DeletePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeletePatternAnyEntityModelResponder handles the response to the DeletePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePatternAnyEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePatternAnyEntityRole sends the delete pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeletePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeletePatternAnyEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePatternAnyEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeletePatternAnyEntityRolePreparer prepares the DeletePatternAnyEntityRole request.
func (client ModelClient) DeletePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePatternAnyEntityRoleSender sends the DeletePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeletePatternAnyEntityRoleResponder handles the response to the DeletePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePatternAnyEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePrebuilt deletes a prebuilt entity extractor from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) DeletePrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeletePrebuilt")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuilt", resp, "Failure responding to request")
	}

	return
}

// DeletePrebuiltPreparer prepares the DeletePrebuilt request.
func (client ModelClient) DeletePrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrebuiltSender sends the DeletePrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePrebuiltSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeletePrebuiltResponder handles the response to the DeletePrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePrebuiltResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeletePrebuiltEntityRole sends the delete prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeletePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeletePrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeletePrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeletePrebuiltEntityRolePreparer prepares the DeletePrebuiltEntityRole request.
func (client ModelClient) DeletePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePrebuiltEntityRoleSender sends the DeletePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeletePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeletePrebuiltEntityRoleResponder handles the response to the DeletePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeletePrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRegexEntityModel sends the delete regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regular expression entity extractor ID.
func (client ModelClient) DeleteRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteRegexEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteRegexEntityModelPreparer(ctx, appID, versionID, regexEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityModel", resp, "Failure responding to request")
	}

	return
}

// DeleteRegexEntityModelPreparer prepares the DeleteRegexEntityModel request.
func (client ModelClient) DeleteRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRegexEntityModelSender sends the DeleteRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteRegexEntityModelResponder handles the response to the DeleteRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteRegexEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRegexEntityRole sends the delete regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role Id.
func (client ModelClient) DeleteRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteRegexEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteRegexEntityRole", resp, "Failure responding to request")
	}

	return
}

// DeleteRegexEntityRolePreparer prepares the DeleteRegexEntityRole request.
func (client ModelClient) DeleteRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRegexEntityRoleSender sends the DeleteRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteRegexEntityRoleResponder handles the response to the DeleteRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteRegexEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSubList deletes a sublist of a specific list entity model from a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list entity extractor ID.
// subListID - the sublist ID.
func (client ModelClient) DeleteSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int64) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.DeleteSubList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSubListPreparer(ctx, appID, versionID, clEntityID, subListID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteSubList", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "DeleteSubList", resp, "Failure responding to request")
	}

	return
}

// DeleteSubListPreparer prepares the DeleteSubList request.
func (client ModelClient) DeleteSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSubListSender sends the DeleteSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) DeleteSubListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteSubListResponder handles the response to the DeleteSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) DeleteSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ExamplesMethod gets the example utterances for the given intent or entity model in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// modelID - the ID (GUID) of the model.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ExamplesMethod(ctx context.Context, appID uuid.UUID, versionID string, modelID string, skip *int32, take *int32) (result ListLabelTextObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ExamplesMethod")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ExamplesMethod", err.Error())
	}

	req, err := client.ExamplesMethodPreparer(ctx, appID, versionID, modelID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ExamplesMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExamplesMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ExamplesMethod", resp, "Failure sending request")
		return
	}

	result, err = client.ExamplesMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ExamplesMethod", resp, "Failure responding to request")
	}

	return
}

// ExamplesMethodPreparer prepares the ExamplesMethod request.
func (client ModelClient) ExamplesMethodPreparer(ctx context.Context, appID uuid.UUID, versionID string, modelID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"modelId":   autorest.Encode("path", modelID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/models/{modelId}/examples", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExamplesMethodSender sends the ExamplesMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ExamplesMethodSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ExamplesMethodResponder handles the response to the ExamplesMethod request. The method always
// closes the http.Response Body.
func (client ModelClient) ExamplesMethodResponder(resp *http.Response) (result ListLabelTextObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedList gets information about a list entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list model ID.
func (client ModelClient) GetClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (result ClosedListEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetClosedList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetClosedListPreparer(ctx, appID, versionID, clEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedList", resp, "Failure responding to request")
	}

	return
}

// GetClosedListPreparer prepares the GetClosedList request.
func (client ModelClient) GetClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListSender sends the GetClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetClosedListResponder handles the response to the GetClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListResponder(resp *http.Response) (result ClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetClosedListEntityRole sends the get closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetClosedListEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetClosedListEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetClosedListEntityRolePreparer prepares the GetClosedListEntityRole request.
func (client ModelClient) GetClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetClosedListEntityRoleSender sends the GetClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetClosedListEntityRoleResponder handles the response to the GetClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetClosedListEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntity gets information about a composite entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) GetCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result CompositeEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetCompositeEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCompositeEntityPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// GetCompositeEntityPreparer prepares the GetCompositeEntity request.
func (client ModelClient) GetCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntitySender sends the GetCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetCompositeEntityResponder handles the response to the GetCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityResponder(resp *http.Response) (result CompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCompositeEntityRole sends the get composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - entity role ID.
func (client ModelClient) GetCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetCompositeEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCompositeEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetCompositeEntityRolePreparer prepares the GetCompositeEntityRole request.
func (client ModelClient) GetCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCompositeEntityRoleSender sends the GetCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetCompositeEntityRoleResponder handles the response to the GetCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCompositeEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetCustomEntityRole sends the get custom entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetCustomEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetCustomEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCustomEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCustomEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCustomEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCustomEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetCustomEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetCustomEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetCustomEntityRolePreparer prepares the GetCustomEntityRole request.
func (client ModelClient) GetCustomEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCustomEntityRoleSender sends the GetCustomEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetCustomEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetCustomEntityRoleResponder handles the response to the GetCustomEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetCustomEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntity gets information about an entity model in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetEntity(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result NDepthEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetEntityPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntity", resp, "Failure responding to request")
	}

	return
}

// GetEntityPreparer prepares the GetEntity request.
func (client ModelClient) GetEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntitySender sends the GetEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetEntityResponder handles the response to the GetEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityResponder(resp *http.Response) (result NDepthEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntityFeatures gets the information of the features used by the entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetEntityFeatures(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListModelFeatureInformation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetEntityFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetEntityFeaturesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntityFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityFeatures", resp, "Failure responding to request")
	}

	return
}

// GetEntityFeaturesPreparer prepares the GetEntityFeatures request.
func (client ModelClient) GetEntityFeaturesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/features", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntityFeaturesSender sends the GetEntityFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntityFeaturesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetEntityFeaturesResponder handles the response to the GetEntityFeatures request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityFeaturesResponder(resp *http.Response) (result ListModelFeatureInformation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEntityRole sends the get entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetEntityRolePreparer prepares the GetEntityRole request.
func (client ModelClient) GetEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetEntityRoleSender sends the GetEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetEntityRoleResponder handles the response to the GetEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExplicitList sends the get explicit list request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity id.
func (client ModelClient) GetExplicitList(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListExplicitListItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetExplicitList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExplicitListPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExplicitListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitList", resp, "Failure sending request")
		return
	}

	result, err = client.GetExplicitListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitList", resp, "Failure responding to request")
	}

	return
}

// GetExplicitListPreparer prepares the GetExplicitList request.
func (client ModelClient) GetExplicitListPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExplicitListSender sends the GetExplicitList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetExplicitListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExplicitListResponder handles the response to the GetExplicitList request. The method always
// closes the http.Response Body.
func (client ModelClient) GetExplicitListResponder(resp *http.Response) (result ListExplicitListItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExplicitListItem sends the get explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity Id.
// itemID - the explicit list item Id.
func (client ModelClient) GetExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (result ExplicitListItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetExplicitListItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.GetExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetExplicitListItem", resp, "Failure responding to request")
	}

	return
}

// GetExplicitListItemPreparer prepares the GetExplicitListItem request.
func (client ModelClient) GetExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExplicitListItemSender sends the GetExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetExplicitListItemSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExplicitListItemResponder handles the response to the GetExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) GetExplicitListItemResponder(resp *http.Response) (result ExplicitListItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntity gets information about a hierarchical entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) GetHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result HierarchicalEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetHierarchicalEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// GetHierarchicalEntityPreparer prepares the GetHierarchicalEntity request.
func (client ModelClient) GetHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntitySender sends the GetHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetHierarchicalEntityResponder handles the response to the GetHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityResponder(resp *http.Response) (result HierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityChild gets information about the child's model contained in an hierarchical entity child model
// in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
func (client ModelClient) GetHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (result HierarchicalChildEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetHierarchicalEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// GetHierarchicalEntityChildPreparer prepares the GetHierarchicalEntityChild request.
func (client ModelClient) GetHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityChildSender sends the GetHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetHierarchicalEntityChildResponder handles the response to the GetHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityChildResponder(resp *http.Response) (result HierarchicalChildEntity, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetHierarchicalEntityRole sends the get hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - entity role ID.
func (client ModelClient) GetHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetHierarchicalEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetHierarchicalEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetHierarchicalEntityRolePreparer prepares the GetHierarchicalEntityRole request.
func (client ModelClient) GetHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetHierarchicalEntityRoleSender sends the GetHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetHierarchicalEntityRoleResponder handles the response to the GetHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetHierarchicalEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntent gets information about the intent model in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
func (client ModelClient) GetIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (result IntentClassifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetIntent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetIntentPreparer(ctx, appID, versionID, intentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntent", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntent", resp, "Failure responding to request")
	}

	return
}

// GetIntentPreparer prepares the GetIntent request.
func (client ModelClient) GetIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentSender sends the GetIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetIntentResponder handles the response to the GetIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentResponder(resp *http.Response) (result IntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIntentFeatures gets the information of the features used by the intent in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
func (client ModelClient) GetIntentFeatures(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (result ListModelFeatureInformation, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetIntentFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetIntentFeaturesPreparer(ctx, appID, versionID, intentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntentFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIntentFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntentFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.GetIntentFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetIntentFeatures", resp, "Failure responding to request")
	}

	return
}

// GetIntentFeaturesPreparer prepares the GetIntentFeatures request.
func (client ModelClient) GetIntentFeaturesPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/features", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIntentFeaturesSender sends the GetIntentFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetIntentFeaturesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetIntentFeaturesResponder handles the response to the GetIntentFeatures request. The method always
// closes the http.Response Body.
func (client ModelClient) GetIntentFeaturesResponder(resp *http.Response) (result ListModelFeatureInformation, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityInfo sends the get pattern any entity info request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
func (client ModelClient) GetPatternAnyEntityInfo(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result PatternAnyEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetPatternAnyEntityInfo")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPatternAnyEntityInfoPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityInfo", resp, "Failure responding to request")
	}

	return
}

// GetPatternAnyEntityInfoPreparer prepares the GetPatternAnyEntityInfo request.
func (client ModelClient) GetPatternAnyEntityInfoPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityInfoSender sends the GetPatternAnyEntityInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityInfoSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPatternAnyEntityInfoResponder handles the response to the GetPatternAnyEntityInfo request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityInfoResponder(resp *http.Response) (result PatternAnyEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPatternAnyEntityRole sends the get pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetPatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetPatternAnyEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetPatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPatternAnyEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetPatternAnyEntityRolePreparer prepares the GetPatternAnyEntityRole request.
func (client ModelClient) GetPatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPatternAnyEntityRoleSender sends the GetPatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPatternAnyEntityRoleResponder handles the response to the GetPatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPatternAnyEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuilt gets information about a prebuilt entity model in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// prebuiltID - the prebuilt entity extractor ID.
func (client ModelClient) GetPrebuilt(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (result PrebuiltEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetPrebuilt")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPrebuiltPreparer(ctx, appID, versionID, prebuiltID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuilt", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuilt", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuilt", resp, "Failure responding to request")
	}

	return
}

// GetPrebuiltPreparer prepares the GetPrebuilt request.
func (client ModelClient) GetPrebuiltPreparer(ctx context.Context, appID uuid.UUID, versionID string, prebuiltID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"prebuiltId": autorest.Encode("path", prebuiltID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{prebuiltId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltSender sends the GetPrebuilt request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPrebuiltResponder handles the response to the GetPrebuilt request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltResponder(resp *http.Response) (result PrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrebuiltEntityRole sends the get prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetPrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetPrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetPrebuiltEntityRolePreparer prepares the GetPrebuiltEntityRole request.
func (client ModelClient) GetPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrebuiltEntityRoleSender sends the GetPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPrebuiltEntityRoleResponder handles the response to the GetPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetPrebuiltEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityEntityInfo sends the get regex entity entity info request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regular expression entity model ID.
func (client ModelClient) GetRegexEntityEntityInfo(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (result RegexEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetRegexEntityEntityInfo")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRegexEntityEntityInfoPreparer(ctx, appID, versionID, regexEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityEntityInfo", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityEntityInfoSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityEntityInfo", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityEntityInfoResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityEntityInfo", resp, "Failure responding to request")
	}

	return
}

// GetRegexEntityEntityInfoPreparer prepares the GetRegexEntityEntityInfo request.
func (client ModelClient) GetRegexEntityEntityInfoPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityEntityInfoSender sends the GetRegexEntityEntityInfo request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityEntityInfoSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetRegexEntityEntityInfoResponder handles the response to the GetRegexEntityEntityInfo request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityEntityInfoResponder(resp *http.Response) (result RegexEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRegexEntityRole sends the get regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity ID.
// roleID - entity role ID.
func (client ModelClient) GetRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (result EntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.GetRegexEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.GetRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "GetRegexEntityRole", resp, "Failure responding to request")
	}

	return
}

// GetRegexEntityRolePreparer prepares the GetRegexEntityRole request.
func (client ModelClient) GetRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRegexEntityRoleSender sends the GetRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) GetRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetRegexEntityRoleResponder handles the response to the GetRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) GetRegexEntityRoleResponder(resp *http.Response) (result EntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListClosedListEntityRoles sends the list closed list entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListClosedListEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListClosedListEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListClosedListEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedListEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListClosedListEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedListEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListClosedListEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedListEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListClosedListEntityRolesPreparer prepares the ListClosedListEntityRoles request.
func (client ModelClient) ListClosedListEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListClosedListEntityRolesSender sends the ListClosedListEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListClosedListEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListClosedListEntityRolesResponder handles the response to the ListClosedListEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListClosedListEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListClosedLists gets information about all the list entity models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListClosedLists(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListClosedListEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListClosedLists")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListClosedLists", err.Error())
	}

	req, err := client.ListClosedListsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedLists", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListClosedListsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedLists", resp, "Failure sending request")
		return
	}

	result, err = client.ListClosedListsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListClosedLists", resp, "Failure responding to request")
	}

	return
}

// ListClosedListsPreparer prepares the ListClosedLists request.
func (client ModelClient) ListClosedListsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListClosedListsSender sends the ListClosedLists request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListClosedListsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListClosedListsResponder handles the response to the ListClosedLists request. The method always
// closes the http.Response Body.
func (client ModelClient) ListClosedListsResponder(resp *http.Response) (result ListClosedListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCompositeEntities gets information about all the composite entity models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListCompositeEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListCompositeEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCompositeEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListCompositeEntities", err.Error())
	}

	req, err := client.ListCompositeEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCompositeEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCompositeEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntities", resp, "Failure responding to request")
	}

	return
}

// ListCompositeEntitiesPreparer prepares the ListCompositeEntities request.
func (client ModelClient) ListCompositeEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCompositeEntitiesSender sends the ListCompositeEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCompositeEntitiesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCompositeEntitiesResponder handles the response to the ListCompositeEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCompositeEntitiesResponder(resp *http.Response) (result ListCompositeEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCompositeEntityRoles sends the list composite entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
func (client ModelClient) ListCompositeEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCompositeEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCompositeEntityRolesPreparer(ctx, appID, versionID, cEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCompositeEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListCompositeEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCompositeEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListCompositeEntityRolesPreparer prepares the ListCompositeEntityRoles request.
func (client ModelClient) ListCompositeEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCompositeEntityRolesSender sends the ListCompositeEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCompositeEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCompositeEntityRolesResponder handles the response to the ListCompositeEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCompositeEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltEntities gets all prebuilt entities used in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCustomPrebuiltEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCustomPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntities", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltEntitiesPreparer prepares the ListCustomPrebuiltEntities request.
func (client ModelClient) ListCustomPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltEntitiesSender sends the ListCustomPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCustomPrebuiltEntitiesResponder handles the response to the ListCustomPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltEntitiesResponder(resp *http.Response) (result ListEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltEntityRoles sends the list custom prebuilt entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListCustomPrebuiltEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCustomPrebuiltEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCustomPrebuiltEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltEntityRolesPreparer prepares the ListCustomPrebuiltEntityRoles request.
func (client ModelClient) ListCustomPrebuiltEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltEntityRolesSender sends the ListCustomPrebuiltEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCustomPrebuiltEntityRolesResponder handles the response to the ListCustomPrebuiltEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltIntents gets information about customizable prebuilt intents added to a version of the
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltIntents(ctx context.Context, appID uuid.UUID, versionID string) (result ListIntentClassifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCustomPrebuiltIntents")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCustomPrebuiltIntentsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltIntents", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltIntentsPreparer prepares the ListCustomPrebuiltIntents request.
func (client ModelClient) ListCustomPrebuiltIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltintents", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltIntentsSender sends the ListCustomPrebuiltIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltIntentsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCustomPrebuiltIntentsResponder handles the response to the ListCustomPrebuiltIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCustomPrebuiltModels gets all prebuilt intent and entity model information used in a version of this
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListCustomPrebuiltModels(ctx context.Context, appID uuid.UUID, versionID string) (result ListCustomPrebuiltModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListCustomPrebuiltModels")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCustomPrebuiltModelsPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCustomPrebuiltModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListCustomPrebuiltModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListCustomPrebuiltModels", resp, "Failure responding to request")
	}

	return
}

// ListCustomPrebuiltModelsPreparer prepares the ListCustomPrebuiltModels request.
func (client ModelClient) ListCustomPrebuiltModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltmodels", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCustomPrebuiltModelsSender sends the ListCustomPrebuiltModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListCustomPrebuiltModelsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListCustomPrebuiltModelsResponder handles the response to the ListCustomPrebuiltModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListCustomPrebuiltModelsResponder(resp *http.Response) (result ListCustomPrebuiltModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEntities gets information about all the simple entity models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListNDepthEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListEntities", err.Error())
	}

	req, err := client.ListEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntities", resp, "Failure responding to request")
	}

	return
}

// ListEntitiesPreparer prepares the ListEntities request.
func (client ModelClient) ListEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEntitiesSender sends the ListEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListEntitiesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListEntitiesResponder handles the response to the ListEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListEntitiesResponder(resp *http.Response) (result ListNDepthEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEntityRoles sends the list entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListEntityRolesPreparer prepares the ListEntityRoles request.
func (client ModelClient) ListEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEntityRolesSender sends the ListEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListEntityRolesResponder handles the response to the ListEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEntitySuggestions get suggested example utterances that would improve the accuracy of the entity model in a
// version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the target entity extractor model to enhance.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListEntitySuggestions(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (result ListEntitiesSuggestionExample, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListEntitySuggestions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListEntitySuggestions", err.Error())
	}

	req, err := client.ListEntitySuggestionsPreparer(ctx, appID, versionID, entityID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntitySuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEntitySuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntitySuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.ListEntitySuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListEntitySuggestions", resp, "Failure responding to request")
	}

	return
}

// ListEntitySuggestionsPreparer prepares the ListEntitySuggestions request.
func (client ModelClient) ListEntitySuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEntitySuggestionsSender sends the ListEntitySuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListEntitySuggestionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListEntitySuggestionsResponder handles the response to the ListEntitySuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) ListEntitySuggestionsResponder(resp *http.Response) (result ListEntitiesSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHierarchicalEntities gets information about all the hierarchical entity models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListHierarchicalEntities(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListHierarchicalEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListHierarchicalEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListHierarchicalEntities", err.Error())
	}

	req, err := client.ListHierarchicalEntitiesPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHierarchicalEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListHierarchicalEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntities", resp, "Failure responding to request")
	}

	return
}

// ListHierarchicalEntitiesPreparer prepares the ListHierarchicalEntities request.
func (client ModelClient) ListHierarchicalEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHierarchicalEntitiesSender sends the ListHierarchicalEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListHierarchicalEntitiesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListHierarchicalEntitiesResponder handles the response to the ListHierarchicalEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListHierarchicalEntitiesResponder(resp *http.Response) (result ListHierarchicalEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListHierarchicalEntityRoles sends the list hierarchical entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
func (client ModelClient) ListHierarchicalEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListHierarchicalEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListHierarchicalEntityRolesPreparer(ctx, appID, versionID, hEntityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListHierarchicalEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListHierarchicalEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListHierarchicalEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListHierarchicalEntityRolesPreparer prepares the ListHierarchicalEntityRoles request.
func (client ModelClient) ListHierarchicalEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListHierarchicalEntityRolesSender sends the ListHierarchicalEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListHierarchicalEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListHierarchicalEntityRolesResponder handles the response to the ListHierarchicalEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListHierarchicalEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListIntents gets information about the intent models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListIntents(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListIntentClassifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListIntents")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListIntents", err.Error())
	}

	req, err := client.ListIntentsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntents", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListIntentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntents", resp, "Failure sending request")
		return
	}

	result, err = client.ListIntentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntents", resp, "Failure responding to request")
	}

	return
}

// ListIntentsPreparer prepares the ListIntents request.
func (client ModelClient) ListIntentsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListIntentsSender sends the ListIntents request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListIntentsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListIntentsResponder handles the response to the ListIntents request. The method always
// closes the http.Response Body.
func (client ModelClient) ListIntentsResponder(resp *http.Response) (result ListIntentClassifier, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListIntentSuggestions suggests example utterances that would improve the accuracy of the intent model in a version
// of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListIntentSuggestions(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (result ListIntentsSuggestionExample, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListIntentSuggestions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListIntentSuggestions", err.Error())
	}

	req, err := client.ListIntentSuggestionsPreparer(ctx, appID, versionID, intentID, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntentSuggestions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListIntentSuggestionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntentSuggestions", resp, "Failure sending request")
		return
	}

	result, err = client.ListIntentSuggestionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListIntentSuggestions", resp, "Failure responding to request")
	}

	return
}

// ListIntentSuggestionsPreparer prepares the ListIntentSuggestions request.
func (client ModelClient) ListIntentSuggestionsPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/suggest", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListIntentSuggestionsSender sends the ListIntentSuggestions request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListIntentSuggestionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListIntentSuggestionsResponder handles the response to the ListIntentSuggestions request. The method always
// closes the http.Response Body.
func (client ModelClient) ListIntentSuggestionsResponder(resp *http.Response) (result ListIntentsSuggestionExample, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListModels gets information about all the intent and entity models in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListModels(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListModelInfoResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListModels")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListModels", err.Error())
	}

	req, err := client.ListModelsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListModels", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListModelsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListModels", resp, "Failure sending request")
		return
	}

	result, err = client.ListModelsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListModels", resp, "Failure responding to request")
	}

	return
}

// ListModelsPreparer prepares the ListModels request.
func (client ModelClient) ListModelsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/models", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListModelsSender sends the ListModels request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListModelsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListModelsResponder handles the response to the ListModels request. The method always
// closes the http.Response Body.
func (client ModelClient) ListModelsResponder(resp *http.Response) (result ListModelInfoResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPatternAnyEntityInfos sends the list pattern any entity infos request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListPatternAnyEntityInfos(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListPatternAnyEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListPatternAnyEntityInfos")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListPatternAnyEntityInfos", err.Error())
	}

	req, err := client.ListPatternAnyEntityInfosPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityInfos", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPatternAnyEntityInfosSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityInfos", resp, "Failure sending request")
		return
	}

	result, err = client.ListPatternAnyEntityInfosResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityInfos", resp, "Failure responding to request")
	}

	return
}

// ListPatternAnyEntityInfosPreparer prepares the ListPatternAnyEntityInfos request.
func (client ModelClient) ListPatternAnyEntityInfosPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPatternAnyEntityInfosSender sends the ListPatternAnyEntityInfos request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPatternAnyEntityInfosSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListPatternAnyEntityInfosResponder handles the response to the ListPatternAnyEntityInfos request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPatternAnyEntityInfosResponder(resp *http.Response) (result ListPatternAnyEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPatternAnyEntityRoles sends the list pattern any entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListPatternAnyEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListPatternAnyEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPatternAnyEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPatternAnyEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListPatternAnyEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPatternAnyEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListPatternAnyEntityRolesPreparer prepares the ListPatternAnyEntityRoles request.
func (client ModelClient) ListPatternAnyEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPatternAnyEntityRolesSender sends the ListPatternAnyEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPatternAnyEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListPatternAnyEntityRolesResponder handles the response to the ListPatternAnyEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPatternAnyEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuiltEntities gets all the available prebuilt entities in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client ModelClient) ListPrebuiltEntities(ctx context.Context, appID uuid.UUID, versionID string) (result ListAvailablePrebuiltEntityModel, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListPrebuiltEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPrebuiltEntitiesPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntities", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntities", resp, "Failure responding to request")
	}

	return
}

// ListPrebuiltEntitiesPreparer prepares the ListPrebuiltEntities request.
func (client ModelClient) ListPrebuiltEntitiesPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/listprebuilts", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltEntitiesSender sends the ListPrebuiltEntities request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltEntitiesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListPrebuiltEntitiesResponder handles the response to the ListPrebuiltEntities request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltEntitiesResponder(resp *http.Response) (result ListAvailablePrebuiltEntityModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuiltEntityRoles sends the list prebuilt entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListPrebuiltEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListPrebuiltEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPrebuiltEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuiltEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListPrebuiltEntityRolesPreparer prepares the ListPrebuiltEntityRoles request.
func (client ModelClient) ListPrebuiltEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltEntityRolesSender sends the ListPrebuiltEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListPrebuiltEntityRolesResponder handles the response to the ListPrebuiltEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListPrebuilts gets information about all the prebuilt entities in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListPrebuilts(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListPrebuiltEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListPrebuilts")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListPrebuilts", err.Error())
	}

	req, err := client.ListPrebuiltsPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuilts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListPrebuiltsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuilts", resp, "Failure sending request")
		return
	}

	result, err = client.ListPrebuiltsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListPrebuilts", resp, "Failure responding to request")
	}

	return
}

// ListPrebuiltsPreparer prepares the ListPrebuilts request.
func (client ModelClient) ListPrebuiltsPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListPrebuiltsSender sends the ListPrebuilts request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListPrebuiltsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListPrebuiltsResponder handles the response to the ListPrebuilts request. The method always
// closes the http.Response Body.
func (client ModelClient) ListPrebuiltsResponder(resp *http.Response) (result ListPrebuiltEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegexEntityInfos sends the list regex entity infos request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client ModelClient) ListRegexEntityInfos(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (result ListRegexEntityExtractor, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListRegexEntityInfos")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ListRegexEntityInfos", err.Error())
	}

	req, err := client.ListRegexEntityInfosPreparer(ctx, appID, versionID, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityInfos", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegexEntityInfosSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityInfos", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegexEntityInfosResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityInfos", resp, "Failure responding to request")
	}

	return
}

// ListRegexEntityInfosPreparer prepares the ListRegexEntityInfos request.
func (client ModelClient) ListRegexEntityInfosPreparer(ctx context.Context, appID uuid.UUID, versionID string, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRegexEntityInfosSender sends the ListRegexEntityInfos request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListRegexEntityInfosSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListRegexEntityInfosResponder handles the response to the ListRegexEntityInfos request. The method always
// closes the http.Response Body.
func (client ModelClient) ListRegexEntityInfosResponder(resp *http.Response) (result ListRegexEntityExtractor, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRegexEntityRoles sends the list regex entity roles request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - entity Id
func (client ModelClient) ListRegexEntityRoles(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (result ListEntityRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ListRegexEntityRoles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListRegexEntityRolesPreparer(ctx, appID, versionID, entityID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityRoles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRegexEntityRolesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityRoles", resp, "Failure sending request")
		return
	}

	result, err = client.ListRegexEntityRolesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ListRegexEntityRoles", resp, "Failure responding to request")
	}

	return
}

// ListRegexEntityRolesPreparer prepares the ListRegexEntityRoles request.
func (client ModelClient) ListRegexEntityRolesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRegexEntityRolesSender sends the ListRegexEntityRoles request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ListRegexEntityRolesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListRegexEntityRolesResponder handles the response to the ListRegexEntityRoles request. The method always
// closes the http.Response Body.
func (client ModelClient) ListRegexEntityRolesResponder(resp *http.Response) (result ListEntityRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PatchClosedList adds a batch of sublists to an existing list entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list entity model ID.
// closedListModelPatchObject - a words list batch.
func (client ModelClient) PatchClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.PatchClosedList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PatchClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelPatchObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "PatchClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "PatchClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.PatchClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "PatchClosedList", resp, "Failure responding to request")
	}

	return
}

// PatchClosedListPreparer prepares the PatchClosedList request.
func (client ModelClient) PatchClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelPatchObject ClosedListModelPatchObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelPatchObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchClosedListSender sends the PatchClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) PatchClosedListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// PatchClosedListResponder handles the response to the PatchClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) PatchClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ReplaceEntityFeatures updates the information of the features used by the entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor ID.
// featureRelationsUpdateObject - a list of feature information objects containing the new feature relations.
func (client ModelClient) ReplaceEntityFeatures(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, featureRelationsUpdateObject []ModelFeatureInformation) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ReplaceEntityFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: featureRelationsUpdateObject,
			Constraints: []validation.Constraint{{Target: "featureRelationsUpdateObject", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ReplaceEntityFeatures", err.Error())
	}

	req, err := client.ReplaceEntityFeaturesPreparer(ctx, appID, versionID, entityID, featureRelationsUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceEntityFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ReplaceEntityFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceEntityFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.ReplaceEntityFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceEntityFeatures", resp, "Failure responding to request")
	}

	return
}

// ReplaceEntityFeaturesPreparer prepares the ReplaceEntityFeatures request.
func (client ModelClient) ReplaceEntityFeaturesPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, featureRelationsUpdateObject []ModelFeatureInformation) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/features", pathParameters),
		autorest.WithJSON(featureRelationsUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReplaceEntityFeaturesSender sends the ReplaceEntityFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ReplaceEntityFeaturesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ReplaceEntityFeaturesResponder handles the response to the ReplaceEntityFeatures request. The method always
// closes the http.Response Body.
func (client ModelClient) ReplaceEntityFeaturesResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ReplaceIntentFeatures updates the information of the features used by the intent in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// featureRelationsUpdateObject - a list of feature information objects containing the new feature relations.
func (client ModelClient) ReplaceIntentFeatures(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, featureRelationsUpdateObject []ModelFeatureInformation) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.ReplaceIntentFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: featureRelationsUpdateObject,
			Constraints: []validation.Constraint{{Target: "featureRelationsUpdateObject", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("authoring.ModelClient", "ReplaceIntentFeatures", err.Error())
	}

	req, err := client.ReplaceIntentFeaturesPreparer(ctx, appID, versionID, intentID, featureRelationsUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceIntentFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ReplaceIntentFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceIntentFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.ReplaceIntentFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "ReplaceIntentFeatures", resp, "Failure responding to request")
	}

	return
}

// ReplaceIntentFeaturesPreparer prepares the ReplaceIntentFeatures request.
func (client ModelClient) ReplaceIntentFeaturesPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, featureRelationsUpdateObject []ModelFeatureInformation) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}/features", pathParameters),
		autorest.WithJSON(featureRelationsUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReplaceIntentFeaturesSender sends the ReplaceIntentFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) ReplaceIntentFeaturesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ReplaceIntentFeaturesResponder handles the response to the ReplaceIntentFeatures request. The method always
// closes the http.Response Body.
func (client ModelClient) ReplaceIntentFeaturesResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateClosedList updates the list entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list model ID.
// closedListModelUpdateObject - the new list entity name and words list.
func (client ModelClient) UpdateClosedList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateClosedList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateClosedListPreparer(ctx, appID, versionID, clEntityID, closedListModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateClosedListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateClosedListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedList", resp, "Failure responding to request")
	}

	return
}

// UpdateClosedListPreparer prepares the UpdateClosedList request.
func (client ModelClient) UpdateClosedListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, closedListModelUpdateObject ClosedListModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}", pathParameters),
		autorest.WithJSON(closedListModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateClosedListSender sends the UpdateClosedList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateClosedListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateClosedListResponder handles the response to the UpdateClosedList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateClosedListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateClosedListEntityRole sends the update closed list entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateClosedListEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateClosedListEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateClosedListEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedListEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateClosedListEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedListEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateClosedListEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateClosedListEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateClosedListEntityRolePreparer prepares the UpdateClosedListEntityRole request.
func (client ModelClient) UpdateClosedListEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateClosedListEntityRoleSender sends the UpdateClosedListEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateClosedListEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateClosedListEntityRoleResponder handles the response to the UpdateClosedListEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateClosedListEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCompositeEntity updates a composite entity in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// compositeModelUpdateObject - a model object containing the new entity extractor name and children.
func (client ModelClient) UpdateCompositeEntity(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateCompositeEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateCompositeEntityPreparer(ctx, appID, versionID, cEntityID, compositeModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCompositeEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCompositeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateCompositeEntityPreparer prepares the UpdateCompositeEntity request.
func (client ModelClient) UpdateCompositeEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, compositeModelUpdateObject CompositeEntityModel) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}", pathParameters),
		autorest.WithJSON(compositeModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCompositeEntitySender sends the UpdateCompositeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCompositeEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateCompositeEntityResponder handles the response to the UpdateCompositeEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCompositeEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCompositeEntityRole sends the update composite entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// cEntityID - the composite entity extractor ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateCompositeEntityRole(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateCompositeEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateCompositeEntityRolePreparer(ctx, appID, versionID, cEntityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCompositeEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCompositeEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCompositeEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateCompositeEntityRolePreparer prepares the UpdateCompositeEntityRole request.
func (client ModelClient) UpdateCompositeEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, cEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"cEntityId": autorest.Encode("path", cEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/compositeentities/{cEntityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCompositeEntityRoleSender sends the UpdateCompositeEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCompositeEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateCompositeEntityRoleResponder handles the response to the UpdateCompositeEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCompositeEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateCustomPrebuiltEntityRole sends the update custom prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateCustomPrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateCustomPrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateCustomPrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCustomPrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateCustomPrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCustomPrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateCustomPrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateCustomPrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateCustomPrebuiltEntityRolePreparer prepares the UpdateCustomPrebuiltEntityRole request.
func (client ModelClient) UpdateCustomPrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/customprebuiltentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateCustomPrebuiltEntityRoleSender sends the UpdateCustomPrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateCustomPrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateCustomPrebuiltEntityRoleResponder handles the response to the UpdateCustomPrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateCustomPrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEntityChild updates the name of an entity extractor or the name and instanceOf model of a child entity
// extractor.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity extractor or the child entity extractor ID.
// entityModelUpdateObject - a model object containing the name new entity extractor or the name and instance
// of model of a child entity extractor
func (client ModelClient) UpdateEntityChild(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityModelUpdateObject EntityModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateEntityChildPreparer(ctx, appID, versionID, entityID, entityModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityChild", resp, "Failure responding to request")
	}

	return
}

// UpdateEntityChildPreparer prepares the UpdateEntityChild request.
func (client ModelClient) UpdateEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, entityModelUpdateObject EntityModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}", pathParameters),
		autorest.WithJSON(entityModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntityChildSender sends the UpdateEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateEntityChildResponder handles the response to the UpdateEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateEntityRole sends the update entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateEntityRolePreparer prepares the UpdateEntityRole request.
func (client ModelClient) UpdateEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/entities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntityRoleSender sends the UpdateEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateEntityRoleResponder handles the response to the UpdateEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateExplicitListItem sends the update explicit list item request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// itemID - the explicit list item ID.
// item - the new explicit list item.
func (client ModelClient) UpdateExplicitListItem(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64, item ExplicitListItemUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateExplicitListItem")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateExplicitListItemPreparer(ctx, appID, versionID, entityID, itemID, item)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateExplicitListItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateExplicitListItemSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateExplicitListItem", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateExplicitListItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateExplicitListItem", resp, "Failure responding to request")
	}

	return
}

// UpdateExplicitListItemPreparer prepares the UpdateExplicitListItem request.
func (client ModelClient) UpdateExplicitListItemPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, itemID int64, item ExplicitListItemUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"itemId":    autorest.Encode("path", itemID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/explicitlist/{itemId}", pathParameters),
		autorest.WithJSON(item))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateExplicitListItemSender sends the UpdateExplicitListItem request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateExplicitListItemSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateExplicitListItemResponder handles the response to the UpdateExplicitListItem request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateExplicitListItemResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntity updates the name of a hierarchical entity model in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// modelUpdateObject - model containing names of the hierarchical entity.
func (client ModelClient) UpdateHierarchicalEntity(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateHierarchicalEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateHierarchicalEntityPreparer(ctx, appID, versionID, hEntityID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateHierarchicalEntityPreparer prepares the UpdateHierarchicalEntity request.
func (client ModelClient) UpdateHierarchicalEntityPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntitySender sends the UpdateHierarchicalEntity request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntitySender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateHierarchicalEntityResponder handles the response to the UpdateHierarchicalEntity request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntityChild renames a single child in an existing hierarchical entity model in a version of the
// application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// hChildID - the hierarchical entity extractor child ID.
// hierarchicalChildModelUpdateObject - model object containing new name of the hierarchical entity child.
func (client ModelClient) UpdateHierarchicalEntityChild(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateHierarchicalEntityChild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateHierarchicalEntityChildPreparer(ctx, appID, versionID, hEntityID, hChildID, hierarchicalChildModelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityChild", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntityChildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityChildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityChild", resp, "Failure responding to request")
	}

	return
}

// UpdateHierarchicalEntityChildPreparer prepares the UpdateHierarchicalEntityChild request.
func (client ModelClient) UpdateHierarchicalEntityChildPreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, hChildID uuid.UUID, hierarchicalChildModelUpdateObject HierarchicalChildModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hChildId":  autorest.Encode("path", hChildID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/children/{hChildId}", pathParameters),
		autorest.WithJSON(hierarchicalChildModelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntityChildSender sends the UpdateHierarchicalEntityChild request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntityChildSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateHierarchicalEntityChildResponder handles the response to the UpdateHierarchicalEntityChild request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityChildResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateHierarchicalEntityRole sends the update hierarchical entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// hEntityID - the hierarchical entity extractor ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateHierarchicalEntityRole(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateHierarchicalEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateHierarchicalEntityRolePreparer(ctx, appID, versionID, hEntityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateHierarchicalEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateHierarchicalEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateHierarchicalEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateHierarchicalEntityRolePreparer prepares the UpdateHierarchicalEntityRole request.
func (client ModelClient) UpdateHierarchicalEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, hEntityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"hEntityId": autorest.Encode("path", hEntityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/hierarchicalentities/{hEntityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateHierarchicalEntityRoleSender sends the UpdateHierarchicalEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateHierarchicalEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateHierarchicalEntityRoleResponder handles the response to the UpdateHierarchicalEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateHierarchicalEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateIntent updates the name of an intent in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// intentID - the intent classifier ID.
// modelUpdateObject - a model object containing the new intent name.
func (client ModelClient) UpdateIntent(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateIntent")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateIntentPreparer(ctx, appID, versionID, intentID, modelUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateIntent", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateIntentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateIntent", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateIntentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateIntent", resp, "Failure responding to request")
	}

	return
}

// UpdateIntentPreparer prepares the UpdateIntent request.
func (client ModelClient) UpdateIntentPreparer(ctx context.Context, appID uuid.UUID, versionID string, intentID uuid.UUID, modelUpdateObject ModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"intentId":  autorest.Encode("path", intentID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/intents/{intentId}", pathParameters),
		autorest.WithJSON(modelUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateIntentSender sends the UpdateIntent request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateIntentSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateIntentResponder handles the response to the UpdateIntent request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateIntentResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePatternAnyEntityModel sends the update pattern any entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the Pattern.Any entity extractor ID.
// patternAnyUpdateObject - an object containing the explicit list of the Pattern.Any entity.
func (client ModelClient) UpdatePatternAnyEntityModel(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, patternAnyUpdateObject PatternAnyModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdatePatternAnyEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePatternAnyEntityModelPreparer(ctx, appID, versionID, entityID, patternAnyUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePatternAnyEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePatternAnyEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityModel", resp, "Failure responding to request")
	}

	return
}

// UpdatePatternAnyEntityModelPreparer prepares the UpdatePatternAnyEntityModel request.
func (client ModelClient) UpdatePatternAnyEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, patternAnyUpdateObject PatternAnyModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}", pathParameters),
		autorest.WithJSON(patternAnyUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePatternAnyEntityModelSender sends the UpdatePatternAnyEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePatternAnyEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdatePatternAnyEntityModelResponder handles the response to the UpdatePatternAnyEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePatternAnyEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePatternAnyEntityRole sends the update pattern any entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdatePatternAnyEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdatePatternAnyEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePatternAnyEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePatternAnyEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePatternAnyEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePatternAnyEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdatePatternAnyEntityRolePreparer prepares the UpdatePatternAnyEntityRole request.
func (client ModelClient) UpdatePatternAnyEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/patternanyentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePatternAnyEntityRoleSender sends the UpdatePatternAnyEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePatternAnyEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdatePatternAnyEntityRoleResponder handles the response to the UpdatePatternAnyEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePatternAnyEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePrebuiltEntityRole sends the update prebuilt entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdatePrebuiltEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdatePrebuiltEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePrebuiltEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePrebuiltEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePrebuiltEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePrebuiltEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePrebuiltEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdatePrebuiltEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdatePrebuiltEntityRolePreparer prepares the UpdatePrebuiltEntityRole request.
func (client ModelClient) UpdatePrebuiltEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/prebuilts/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePrebuiltEntityRoleSender sends the UpdatePrebuiltEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdatePrebuiltEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdatePrebuiltEntityRoleResponder handles the response to the UpdatePrebuiltEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdatePrebuiltEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRegexEntityModel sends the update regex entity model request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// regexEntityID - the regular expression entity extractor ID.
// regexEntityUpdateObject - an object containing the new entity name and regex pattern.
func (client ModelClient) UpdateRegexEntityModel(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID, regexEntityUpdateObject RegexModelUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateRegexEntityModel")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateRegexEntityModelPreparer(ctx, appID, versionID, regexEntityID, regexEntityUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityModel", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRegexEntityModelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityModel", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRegexEntityModelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityModel", resp, "Failure responding to request")
	}

	return
}

// UpdateRegexEntityModelPreparer prepares the UpdateRegexEntityModel request.
func (client ModelClient) UpdateRegexEntityModelPreparer(ctx context.Context, appID uuid.UUID, versionID string, regexEntityID uuid.UUID, regexEntityUpdateObject RegexModelUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":         autorest.Encode("path", appID),
		"regexEntityId": autorest.Encode("path", regexEntityID),
		"versionId":     autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{regexEntityId}", pathParameters),
		autorest.WithJSON(regexEntityUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateRegexEntityModelSender sends the UpdateRegexEntityModel request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateRegexEntityModelSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateRegexEntityModelResponder handles the response to the UpdateRegexEntityModel request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateRegexEntityModelResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateRegexEntityRole sends the update regex entity role request.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// entityID - the entity ID.
// roleID - the entity role ID.
// entityRoleUpdateObject - the new entity role.
func (client ModelClient) UpdateRegexEntityRole(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateRegexEntityRole")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateRegexEntityRolePreparer(ctx, appID, versionID, entityID, roleID, entityRoleUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityRole", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateRegexEntityRoleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityRole", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateRegexEntityRoleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateRegexEntityRole", resp, "Failure responding to request")
	}

	return
}

// UpdateRegexEntityRolePreparer prepares the UpdateRegexEntityRole request.
func (client ModelClient) UpdateRegexEntityRolePreparer(ctx context.Context, appID uuid.UUID, versionID string, entityID uuid.UUID, roleID uuid.UUID, entityRoleUpdateObject EntityRoleUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"entityId":  autorest.Encode("path", entityID),
		"roleId":    autorest.Encode("path", roleID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/regexentities/{entityId}/roles/{roleId}", pathParameters),
		autorest.WithJSON(entityRoleUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateRegexEntityRoleSender sends the UpdateRegexEntityRole request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateRegexEntityRoleSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateRegexEntityRoleResponder handles the response to the UpdateRegexEntityRole request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateRegexEntityRoleResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSubList updates one of the list entity's sublists in a version of the application.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
// clEntityID - the list entity extractor ID.
// subListID - the sublist ID.
// wordListBaseUpdateObject - a sublist update object containing the new canonical form and the list of words.
func (client ModelClient) UpdateSubList(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int64, wordListBaseUpdateObject WordListBaseUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelClient.UpdateSubList")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSubListPreparer(ctx, appID, versionID, clEntityID, subListID, wordListBaseUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateSubList", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSubListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateSubList", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSubListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.ModelClient", "UpdateSubList", resp, "Failure responding to request")
	}

	return
}

// UpdateSubListPreparer prepares the UpdateSubList request.
func (client ModelClient) UpdateSubListPreparer(ctx context.Context, appID uuid.UUID, versionID string, clEntityID uuid.UUID, subListID int64, wordListBaseUpdateObject WordListBaseUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":      autorest.Encode("path", appID),
		"clEntityId": autorest.Encode("path", clEntityID),
		"subListId":  autorest.Encode("path", subListID),
		"versionId":  autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/authoring/v3.0-preview", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/versions/{versionId}/closedlists/{clEntityId}/sublists/{subListId}", pathParameters),
		autorest.WithJSON(wordListBaseUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSubListSender sends the UpdateSubList request. The method will close the
// http.Response Body if it receives an error.
func (client ModelClient) UpdateSubListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateSubListResponder handles the response to the UpdateSubList request. The method always
// closes the http.Response Body.
func (client ModelClient) UpdateSubListResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
