// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListNotifyTemplatesCommon = "ListNotifyTemplates"

// ListNotifyTemplatesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNotifyTemplatesCommon operation. The "output" return
// value will be populated with the ListNotifyTemplatesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNotifyTemplatesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNotifyTemplatesCommon Send returns without error.
//
// See ListNotifyTemplatesCommon for more information on using the ListNotifyTemplatesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListNotifyTemplatesCommonRequest method.
//    req, resp := client.ListNotifyTemplatesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) ListNotifyTemplatesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListNotifyTemplatesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNotifyTemplatesCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation ListNotifyTemplatesCommon for usage and error information.
func (c *VOLCOBSERVE) ListNotifyTemplatesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListNotifyTemplatesCommonRequest(input)
	return out, req.Send()
}

// ListNotifyTemplatesCommonWithContext is the same as ListNotifyTemplatesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifyTemplatesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) ListNotifyTemplatesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListNotifyTemplatesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNotifyTemplates = "ListNotifyTemplates"

// ListNotifyTemplatesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListNotifyTemplates operation. The "output" return
// value will be populated with the ListNotifyTemplatesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListNotifyTemplatesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListNotifyTemplatesCommon Send returns without error.
//
// See ListNotifyTemplates for more information on using the ListNotifyTemplates
// API call, and error handling.
//
//    // Example sending a request using the ListNotifyTemplatesRequest method.
//    req, resp := client.ListNotifyTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) ListNotifyTemplatesRequest(input *ListNotifyTemplatesInput) (req *request.Request, output *ListNotifyTemplatesOutput) {
	op := &request.Operation{
		Name:       opListNotifyTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListNotifyTemplatesInput{}
	}

	output = &ListNotifyTemplatesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListNotifyTemplates API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation ListNotifyTemplates for usage and error information.
func (c *VOLCOBSERVE) ListNotifyTemplates(input *ListNotifyTemplatesInput) (*ListNotifyTemplatesOutput, error) {
	req, out := c.ListNotifyTemplatesRequest(input)
	return out, req.Send()
}

// ListNotifyTemplatesWithContext is the same as ListNotifyTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotifyTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) ListNotifyTemplatesWithContext(ctx volcengine.Context, input *ListNotifyTemplatesInput, opts ...request.Option) (*ListNotifyTemplatesOutput, error) {
	req, out := c.ListNotifyTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DataForListNotifyTemplatesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Channel *string `type:"string" json:",omitempty"`

	Content *string `type:"string" json:",omitempty"`

	CreatedAt *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Title *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DataForListNotifyTemplatesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForListNotifyTemplatesOutput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *DataForListNotifyTemplatesOutput) SetChannel(v string) *DataForListNotifyTemplatesOutput {
	s.Channel = &v
	return s
}

// SetContent sets the Content field's value.
func (s *DataForListNotifyTemplatesOutput) SetContent(v string) *DataForListNotifyTemplatesOutput {
	s.Content = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataForListNotifyTemplatesOutput) SetCreatedAt(v string) *DataForListNotifyTemplatesOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataForListNotifyTemplatesOutput) SetDescription(v string) *DataForListNotifyTemplatesOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DataForListNotifyTemplatesOutput) SetId(v string) *DataForListNotifyTemplatesOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataForListNotifyTemplatesOutput) SetName(v string) *DataForListNotifyTemplatesOutput {
	s.Name = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *DataForListNotifyTemplatesOutput) SetTitle(v string) *DataForListNotifyTemplatesOutput {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataForListNotifyTemplatesOutput) SetType(v string) *DataForListNotifyTemplatesOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataForListNotifyTemplatesOutput) SetUpdatedAt(v string) *DataForListNotifyTemplatesOutput {
	s.UpdatedAt = &v
	return s
}

type ListNotifyTemplatesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Channels []*string `type:"list" json:",omitempty"`

	Ids []*string `type:"list" json:",omitempty"`

	Name *string `min:"1" max:"128" type:"string" json:",omitempty"`

	PageNumber *int64 `type:"integer" json:",omitempty"`

	PageSize *int64 `type:"integer" json:",omitempty"`

	Types []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListNotifyTemplatesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotifyTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotifyTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotifyTemplatesInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 128, *s.Name))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannels sets the Channels field's value.
func (s *ListNotifyTemplatesInput) SetChannels(v []*string) *ListNotifyTemplatesInput {
	s.Channels = v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListNotifyTemplatesInput) SetIds(v []*string) *ListNotifyTemplatesInput {
	s.Ids = v
	return s
}

// SetName sets the Name field's value.
func (s *ListNotifyTemplatesInput) SetName(v string) *ListNotifyTemplatesInput {
	s.Name = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNotifyTemplatesInput) SetPageNumber(v int64) *ListNotifyTemplatesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNotifyTemplatesInput) SetPageSize(v int64) *ListNotifyTemplatesInput {
	s.PageSize = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *ListNotifyTemplatesInput) SetTypes(v []*string) *ListNotifyTemplatesInput {
	s.Types = v
	return s
}

type ListNotifyTemplatesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*DataForListNotifyTemplatesOutput `type:"list" json:",omitempty"`

	PageNumber *int64 `type:"integer" json:",omitempty"`

	PageSize *int64 `type:"integer" json:",omitempty"`

	TotalCount *int64 `type:"integer" json:",omitempty"`
}

// String returns the string representation
func (s ListNotifyTemplatesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotifyTemplatesOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ListNotifyTemplatesOutput) SetData(v []*DataForListNotifyTemplatesOutput) *ListNotifyTemplatesOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListNotifyTemplatesOutput) SetPageNumber(v int64) *ListNotifyTemplatesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNotifyTemplatesOutput) SetPageSize(v int64) *ListNotifyTemplatesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListNotifyTemplatesOutput) SetTotalCount(v int64) *ListNotifyTemplatesOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfChannelListForListNotifyTemplatesInputEmail is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputEmail = "email"

	// EnumOfChannelListForListNotifyTemplatesInputSms is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputSms = "sms"

	// EnumOfChannelListForListNotifyTemplatesInputPhone is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputPhone = "phone"

	// EnumOfChannelListForListNotifyTemplatesInputLark is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputLark = "lark"

	// EnumOfChannelListForListNotifyTemplatesInputDingtalk is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputDingtalk = "dingtalk"

	// EnumOfChannelListForListNotifyTemplatesInputWecom is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputWecom = "wecom"

	// EnumOfChannelListForListNotifyTemplatesInputSlack is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputSlack = "slack"

	// EnumOfChannelListForListNotifyTemplatesInputApi is a EnumOfChannelListForListNotifyTemplatesInput enum value
	EnumOfChannelListForListNotifyTemplatesInputApi = "api"
)

const (
	// EnumOfTypeListForListNotifyTemplatesInputMetric is a EnumOfTypeListForListNotifyTemplatesInput enum value
	EnumOfTypeListForListNotifyTemplatesInputMetric = "metric"

	// EnumOfTypeListForListNotifyTemplatesInputEvent is a EnumOfTypeListForListNotifyTemplatesInput enum value
	EnumOfTypeListForListNotifyTemplatesInputEvent = "event"
)
