// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package storageebs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeAutoSnapshotPolicyCommon = "DescribeAutoSnapshotPolicy"

// DescribeAutoSnapshotPolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAutoSnapshotPolicyCommon operation. The "output" return
// value will be populated with the DescribeAutoSnapshotPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAutoSnapshotPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAutoSnapshotPolicyCommon Send returns without error.
//
// See DescribeAutoSnapshotPolicyCommon for more information on using the DescribeAutoSnapshotPolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeAutoSnapshotPolicyCommonRequest method.
//    req, resp := client.DescribeAutoSnapshotPolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) DescribeAutoSnapshotPolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeAutoSnapshotPolicyCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeAutoSnapshotPolicyCommon API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation DescribeAutoSnapshotPolicyCommon for usage and error information.
func (c *STORAGEEBS) DescribeAutoSnapshotPolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeAutoSnapshotPolicyCommonRequest(input)
	return out, req.Send()
}

// DescribeAutoSnapshotPolicyCommonWithContext is the same as DescribeAutoSnapshotPolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoSnapshotPolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) DescribeAutoSnapshotPolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeAutoSnapshotPolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAutoSnapshotPolicy = "DescribeAutoSnapshotPolicy"

// DescribeAutoSnapshotPolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAutoSnapshotPolicy operation. The "output" return
// value will be populated with the DescribeAutoSnapshotPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAutoSnapshotPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAutoSnapshotPolicyCommon Send returns without error.
//
// See DescribeAutoSnapshotPolicy for more information on using the DescribeAutoSnapshotPolicy
// API call, and error handling.
//
//    // Example sending a request using the DescribeAutoSnapshotPolicyRequest method.
//    req, resp := client.DescribeAutoSnapshotPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) DescribeAutoSnapshotPolicyRequest(input *DescribeAutoSnapshotPolicyInput) (req *request.Request, output *DescribeAutoSnapshotPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoSnapshotPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoSnapshotPolicyInput{}
	}

	output = &DescribeAutoSnapshotPolicyOutput{}
	req = c.newRequest(op, input, output)

	return
}

// DescribeAutoSnapshotPolicy API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation DescribeAutoSnapshotPolicy for usage and error information.
func (c *STORAGEEBS) DescribeAutoSnapshotPolicy(input *DescribeAutoSnapshotPolicyInput) (*DescribeAutoSnapshotPolicyOutput, error) {
	req, out := c.DescribeAutoSnapshotPolicyRequest(input)
	return out, req.Send()
}

// DescribeAutoSnapshotPolicyWithContext is the same as DescribeAutoSnapshotPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAutoSnapshotPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) DescribeAutoSnapshotPolicyWithContext(ctx volcengine.Context, input *DescribeAutoSnapshotPolicyInput, opts ...request.Option) (*DescribeAutoSnapshotPolicyOutput, error) {
	req, out := c.DescribeAutoSnapshotPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput struct {
	_ struct{} `type:"structure"`

	AutoSnapshotPolicyId *string `type:"string"`

	AutoSnapshotPolicyName *string `type:"string"`

	CreatedAt *string `type:"string"`

	DestinationRegion *string `type:"string"`

	DestinationRetentionDays *int32 `max:"65536" type:"int32"`

	EnableCopy *bool `type:"boolean"`

	ProjectName *string `type:"string"`

	RepeatDays *int32 `type:"int32"`

	RepeatWeekdays []*string `type:"list"`

	RetentionDays *int32 `type:"int32"`

	Status *string `type:"string"`

	Tags []*TagForDescribeAutoSnapshotPolicyOutput `type:"list"`

	TimePoints []*string `type:"list"`

	UpdatedAt *string `type:"string"`

	VolumeNums *int32 `type:"int32"`
}

// String returns the string representation
func (s AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) GoString() string {
	return s.String()
}

// SetAutoSnapshotPolicyId sets the AutoSnapshotPolicyId field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetAutoSnapshotPolicyId(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.AutoSnapshotPolicyId = &v
	return s
}

// SetAutoSnapshotPolicyName sets the AutoSnapshotPolicyName field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetAutoSnapshotPolicyName(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.AutoSnapshotPolicyName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetCreatedAt(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.CreatedAt = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetDestinationRegion(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.DestinationRegion = &v
	return s
}

// SetDestinationRetentionDays sets the DestinationRetentionDays field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetDestinationRetentionDays(v int32) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.DestinationRetentionDays = &v
	return s
}

// SetEnableCopy sets the EnableCopy field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetEnableCopy(v bool) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.EnableCopy = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetProjectName(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.ProjectName = &v
	return s
}

// SetRepeatDays sets the RepeatDays field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetRepeatDays(v int32) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.RepeatDays = &v
	return s
}

// SetRepeatWeekdays sets the RepeatWeekdays field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetRepeatWeekdays(v []*string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.RepeatWeekdays = v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetRetentionDays(v int32) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.RetentionDays = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetStatus(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetTags(v []*TagForDescribeAutoSnapshotPolicyOutput) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.Tags = v
	return s
}

// SetTimePoints sets the TimePoints field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetTimePoints(v []*string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.TimePoints = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetUpdatedAt(v string) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.UpdatedAt = &v
	return s
}

// SetVolumeNums sets the VolumeNums field's value.
func (s *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) SetVolumeNums(v int32) *AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput {
	s.VolumeNums = &v
	return s
}

type DescribeAutoSnapshotPolicyInput struct {
	_ struct{} `type:"structure"`

	AutoSnapshotPolicyIds []*string `type:"list"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `max:"100" type:"int32"`

	ProjectName *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoSnapshotPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoSnapshotPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAutoSnapshotPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAutoSnapshotPolicyInput"}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoSnapshotPolicyIds sets the AutoSnapshotPolicyIds field's value.
func (s *DescribeAutoSnapshotPolicyInput) SetAutoSnapshotPolicyIds(v []*string) *DescribeAutoSnapshotPolicyInput {
	s.AutoSnapshotPolicyIds = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAutoSnapshotPolicyInput) SetPageNumber(v int32) *DescribeAutoSnapshotPolicyInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAutoSnapshotPolicyInput) SetPageSize(v int32) *DescribeAutoSnapshotPolicyInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeAutoSnapshotPolicyInput) SetProjectName(v string) *DescribeAutoSnapshotPolicyInput {
	s.ProjectName = &v
	return s
}

type DescribeAutoSnapshotPolicyOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AutoSnapshotPolicies []*AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput `type:"list"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	TotalCount *int32 `type:"int32"`
}

// String returns the string representation
func (s DescribeAutoSnapshotPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoSnapshotPolicyOutput) GoString() string {
	return s.String()
}

// SetAutoSnapshotPolicies sets the AutoSnapshotPolicies field's value.
func (s *DescribeAutoSnapshotPolicyOutput) SetAutoSnapshotPolicies(v []*AutoSnapshotPolicyForDescribeAutoSnapshotPolicyOutput) *DescribeAutoSnapshotPolicyOutput {
	s.AutoSnapshotPolicies = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAutoSnapshotPolicyOutput) SetPageNumber(v int32) *DescribeAutoSnapshotPolicyOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAutoSnapshotPolicyOutput) SetPageSize(v int32) *DescribeAutoSnapshotPolicyOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeAutoSnapshotPolicyOutput) SetTotalCount(v int32) *DescribeAutoSnapshotPolicyOutput {
	s.TotalCount = &v
	return s
}

type TagForDescribeAutoSnapshotPolicyOutput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForDescribeAutoSnapshotPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeAutoSnapshotPolicyOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeAutoSnapshotPolicyOutput) SetKey(v string) *TagForDescribeAutoSnapshotPolicyOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeAutoSnapshotPolicyOutput) SetValue(v string) *TagForDescribeAutoSnapshotPolicyOutput {
	s.Value = &v
	return s
}
