// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateServiceCommon = "UpdateService"

// UpdateServiceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateServiceCommon operation. The "output" return
// value will be populated with the UpdateServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateServiceCommon Send returns without error.
//
// See UpdateServiceCommon for more information on using the UpdateServiceCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateServiceCommonRequest method.
//    req, resp := client.UpdateServiceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateServiceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateServiceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateServiceCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateServiceCommon for usage and error information.
func (c *MLPLATFORM20240701) UpdateServiceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateServiceCommonRequest(input)
	return out, req.Send()
}

// UpdateServiceCommonWithContext is the same as UpdateServiceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateServiceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateServiceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the UpdateServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateServiceCommon Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
//    // Example sending a request using the UpdateServiceRequest method.
//    req, resp := client.UpdateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateService API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateService for usage and error information.
func (c *MLPLATFORM20240701) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateServiceWithContext(ctx volcengine.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApigConfigForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	UpstreamConfig *UpstreamConfigForUpdateServiceInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApigConfigForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApigConfigForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetInstanceID sets the InstanceID field's value.
func (s *ApigConfigForUpdateServiceInput) SetInstanceID(v string) *ApigConfigForUpdateServiceInput {
	s.InstanceID = &v
	return s
}

// SetUpstreamConfig sets the UpstreamConfig field's value.
func (s *ApigConfigForUpdateServiceInput) SetUpstreamConfig(v *UpstreamConfigForUpdateServiceInput) *ApigConfigForUpdateServiceInput {
	s.UpstreamConfig = v
	return s
}

type CLBConfigForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Scheduler *string `type:"string" json:",omitempty" enum:"EnumOfSchedulerForUpdateServiceInput"`
}

// String returns the string representation
func (s CLBConfigForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CLBConfigForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CLBConfigForUpdateServiceInput) SetInstanceId(v string) *CLBConfigForUpdateServiceInput {
	s.InstanceId = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *CLBConfigForUpdateServiceInput) SetScheduler(v string) *CLBConfigForUpdateServiceInput {
	s.Scheduler = &v
	return s
}

type ConsistentHashConfigForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HashKeyType *string `type:"string" json:",omitempty" enum:"EnumOfHashKeyTypeForUpdateServiceInput"`

	HttpHeaderName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConsistentHashConfigForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsistentHashConfigForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *ConsistentHashConfigForUpdateServiceInput) SetHashKeyType(v string) *ConsistentHashConfigForUpdateServiceInput {
	s.HashKeyType = &v
	return s
}

// SetHttpHeaderName sets the HttpHeaderName field's value.
func (s *ConsistentHashConfigForUpdateServiceInput) SetHttpHeaderName(v string) *ConsistentHashConfigForUpdateServiceInput {
	s.HttpHeaderName = &v
	return s
}

type ConvertWeightForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DeploymentId *string `type:"string" json:",omitempty"`

	Weight *int32 `max:"10" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertWeightForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertWeightForUpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConvertWeightForUpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConvertWeightForUpdateServiceInput"}
	if s.Weight != nil && *s.Weight > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("Weight", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ConvertWeightForUpdateServiceInput) SetDeploymentId(v string) *ConvertWeightForUpdateServiceInput {
	s.DeploymentId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertWeightForUpdateServiceInput) SetWeight(v int32) *ConvertWeightForUpdateServiceInput {
	s.Weight = &v
	return s
}

type MirrorTrafficPolicyForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Percent *int32 `type:"int32" json:",omitempty"`

	SourceDeploymentId *string `type:"string" json:",omitempty"`

	TargetDeploymentId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MirrorTrafficPolicyForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MirrorTrafficPolicyForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetPercent sets the Percent field's value.
func (s *MirrorTrafficPolicyForUpdateServiceInput) SetPercent(v int32) *MirrorTrafficPolicyForUpdateServiceInput {
	s.Percent = &v
	return s
}

// SetSourceDeploymentId sets the SourceDeploymentId field's value.
func (s *MirrorTrafficPolicyForUpdateServiceInput) SetSourceDeploymentId(v string) *MirrorTrafficPolicyForUpdateServiceInput {
	s.SourceDeploymentId = &v
	return s
}

// SetTargetDeploymentId sets the TargetDeploymentId field's value.
func (s *MirrorTrafficPolicyForUpdateServiceInput) SetTargetDeploymentId(v string) *MirrorTrafficPolicyForUpdateServiceInput {
	s.TargetDeploymentId = &v
	return s
}

type PortForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForUpdateServiceInput"`
}

// String returns the string representation
func (s PortForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForUpdateServiceInput) SetExposePort(v string) *PortForUpdateServiceInput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForUpdateServiceInput) SetListenPort(v string) *PortForUpdateServiceInput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForUpdateServiceInput) SetPath(v string) *PortForUpdateServiceInput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForUpdateServiceInput) SetType(v string) *PortForUpdateServiceInput {
	s.Type = &v
	return s
}

type StatusForUpdateServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForUpdateServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForUpdateServiceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForUpdateServiceOutput) SetMessage(v string) *StatusForUpdateServiceOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForUpdateServiceOutput) SetSecondaryState(v string) *StatusForUpdateServiceOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForUpdateServiceOutput) SetState(v string) *StatusForUpdateServiceOutput {
	s.State = &v
	return s
}

type TrafficConfigForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enables []*string `type:"list" json:",omitempty"`

	MirrorTrafficPolicy *MirrorTrafficPolicyForUpdateServiceInput `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty" enum:"EnumOfModeForUpdateServiceInput"`

	Weights []*ConvertWeightForUpdateServiceInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TrafficConfigForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficConfigForUpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrafficConfigForUpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrafficConfigForUpdateServiceInput"}
	if s.Weights != nil {
		for i, v := range s.Weights {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Weights", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnables sets the Enables field's value.
func (s *TrafficConfigForUpdateServiceInput) SetEnables(v []*string) *TrafficConfigForUpdateServiceInput {
	s.Enables = v
	return s
}

// SetMirrorTrafficPolicy sets the MirrorTrafficPolicy field's value.
func (s *TrafficConfigForUpdateServiceInput) SetMirrorTrafficPolicy(v *MirrorTrafficPolicyForUpdateServiceInput) *TrafficConfigForUpdateServiceInput {
	s.MirrorTrafficPolicy = v
	return s
}

// SetMode sets the Mode field's value.
func (s *TrafficConfigForUpdateServiceInput) SetMode(v string) *TrafficConfigForUpdateServiceInput {
	s.Mode = &v
	return s
}

// SetWeights sets the Weights field's value.
func (s *TrafficConfigForUpdateServiceInput) SetWeights(v []*ConvertWeightForUpdateServiceInput) *TrafficConfigForUpdateServiceInput {
	s.Weights = v
	return s
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApigConfig *ApigConfigForUpdateServiceInput `type:"structure" json:",omitempty"`

	CLBConfig *CLBConfigForUpdateServiceInput `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	Ports []*PortForUpdateServiceInput `type:"list" json:",omitempty"`

	ServiceName *string `type:"string" json:",omitempty"`

	TrafficConfig *TrafficConfigForUpdateServiceInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s UpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.TrafficConfig != nil {
		if err := s.TrafficConfig.Validate(); err != nil {
			invalidParams.AddNested("TrafficConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApigConfig sets the ApigConfig field's value.
func (s *UpdateServiceInput) SetApigConfig(v *ApigConfigForUpdateServiceInput) *UpdateServiceInput {
	s.ApigConfig = v
	return s
}

// SetCLBConfig sets the CLBConfig field's value.
func (s *UpdateServiceInput) SetCLBConfig(v *CLBConfigForUpdateServiceInput) *UpdateServiceInput {
	s.CLBConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateServiceInput) SetDescription(v string) *UpdateServiceInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *UpdateServiceInput) SetDryRun(v bool) *UpdateServiceInput {
	s.DryRun = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateServiceInput) SetId(v string) *UpdateServiceInput {
	s.Id = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *UpdateServiceInput) SetPorts(v []*PortForUpdateServiceInput) *UpdateServiceInput {
	s.Ports = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateServiceInput) SetServiceName(v string) *UpdateServiceInput {
	s.ServiceName = &v
	return s
}

// SetTrafficConfig sets the TrafficConfig field's value.
func (s *UpdateServiceInput) SetTrafficConfig(v *TrafficConfigForUpdateServiceInput) *UpdateServiceInput {
	s.TrafficConfig = v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`

	Status *StatusForUpdateServiceOutput `type:"structure" json:",omitempty"`

	VersionId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateServiceOutput) SetId(v string) *UpdateServiceOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateServiceOutput) SetStatus(v *StatusForUpdateServiceOutput) *UpdateServiceOutput {
	s.Status = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *UpdateServiceOutput) SetVersionId(v string) *UpdateServiceOutput {
	s.VersionId = &v
	return s
}

type UpstreamConfigForUpdateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsistentHashConfig *ConsistentHashConfigForUpdateServiceInput `type:"structure" json:",omitempty"`

	LoadBalancePolicy *string `type:"string" json:",omitempty" enum:"EnumOfLoadBalancePolicyForUpdateServiceInput"`
}

// String returns the string representation
func (s UpstreamConfigForUpdateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpstreamConfigForUpdateServiceInput) GoString() string {
	return s.String()
}

// SetConsistentHashConfig sets the ConsistentHashConfig field's value.
func (s *UpstreamConfigForUpdateServiceInput) SetConsistentHashConfig(v *ConsistentHashConfigForUpdateServiceInput) *UpstreamConfigForUpdateServiceInput {
	s.ConsistentHashConfig = v
	return s
}

// SetLoadBalancePolicy sets the LoadBalancePolicy field's value.
func (s *UpstreamConfigForUpdateServiceInput) SetLoadBalancePolicy(v string) *UpstreamConfigForUpdateServiceInput {
	s.LoadBalancePolicy = &v
	return s
}

const (
	// EnumOfHashKeyTypeForUpdateServiceInputHttpHeaderName is a EnumOfHashKeyTypeForUpdateServiceInput enum value
	EnumOfHashKeyTypeForUpdateServiceInputHttpHeaderName = "HttpHeaderName"
)

const (
	// EnumOfLoadBalancePolicyForUpdateServiceInputRoundRobin is a EnumOfLoadBalancePolicyForUpdateServiceInput enum value
	EnumOfLoadBalancePolicyForUpdateServiceInputRoundRobin = "ROUND_ROBIN"

	// EnumOfLoadBalancePolicyForUpdateServiceInputLeastConn is a EnumOfLoadBalancePolicyForUpdateServiceInput enum value
	EnumOfLoadBalancePolicyForUpdateServiceInputLeastConn = "LEAST_CONN"

	// EnumOfLoadBalancePolicyForUpdateServiceInputRandom is a EnumOfLoadBalancePolicyForUpdateServiceInput enum value
	EnumOfLoadBalancePolicyForUpdateServiceInputRandom = "RANDOM"

	// EnumOfLoadBalancePolicyForUpdateServiceInputConsistentHash is a EnumOfLoadBalancePolicyForUpdateServiceInput enum value
	EnumOfLoadBalancePolicyForUpdateServiceInputConsistentHash = "CONSISTENT_HASH"
)

const (
	// EnumOfModeForUpdateServiceInputDefault is a EnumOfModeForUpdateServiceInput enum value
	EnumOfModeForUpdateServiceInputDefault = "Default"

	// EnumOfModeForUpdateServiceInputWeight is a EnumOfModeForUpdateServiceInput enum value
	EnumOfModeForUpdateServiceInputWeight = "Weight"
)

const (
	// EnumOfSchedulerForUpdateServiceInputWrr is a EnumOfSchedulerForUpdateServiceInput enum value
	EnumOfSchedulerForUpdateServiceInputWrr = "wrr"

	// EnumOfSchedulerForUpdateServiceInputWlc is a EnumOfSchedulerForUpdateServiceInput enum value
	EnumOfSchedulerForUpdateServiceInputWlc = "wlc"

	// EnumOfSchedulerForUpdateServiceInputSh is a EnumOfSchedulerForUpdateServiceInput enum value
	EnumOfSchedulerForUpdateServiceInputSh = "sh"
)

const (
	// EnumOfTypeForUpdateServiceInputHttp11 is a EnumOfTypeForUpdateServiceInput enum value
	EnumOfTypeForUpdateServiceInputHttp11 = "HTTP/1.1"

	// EnumOfTypeForUpdateServiceInputHttp2 is a EnumOfTypeForUpdateServiceInput enum value
	EnumOfTypeForUpdateServiceInputHttp2 = "HTTP2"

	// EnumOfTypeForUpdateServiceInputGrpc is a EnumOfTypeForUpdateServiceInput enum value
	EnumOfTypeForUpdateServiceInputGrpc = "GRPC"

	// EnumOfTypeForUpdateServiceInputMetrics is a EnumOfTypeForUpdateServiceInput enum value
	EnumOfTypeForUpdateServiceInputMetrics = "Metrics"

	// EnumOfTypeForUpdateServiceInputOther is a EnumOfTypeForUpdateServiceInput enum value
	EnumOfTypeForUpdateServiceInputOther = "Other"
)
