// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetDeploymentCommon = "GetDeployment"

// GetDeploymentCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetDeploymentCommon operation. The "output" return
// value will be populated with the GetDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetDeploymentCommon Send returns without error.
//
// See GetDeploymentCommon for more information on using the GetDeploymentCommon
// API call, and error handling.
//
//    // Example sending a request using the GetDeploymentCommonRequest method.
//    req, resp := client.GetDeploymentCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetDeploymentCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetDeploymentCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetDeploymentCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetDeploymentCommon for usage and error information.
func (c *MLPLATFORM20240701) GetDeploymentCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetDeploymentCommonRequest(input)
	return out, req.Send()
}

// GetDeploymentCommonWithContext is the same as GetDeploymentCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeploymentCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetDeploymentCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetDeploymentCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "volcengine/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the GetDeploymentCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetDeploymentCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetDeploymentCommon Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetDeployment API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetDeployment for usage and error information.
func (c *MLPLATFORM20240701) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetDeploymentWithContext(ctx volcengine.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CfsForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForGetDeploymentOutput) SetFileSystemName(v string) *CfsForGetDeploymentOutput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForGetDeploymentOutput) SetNamespaceId(v string) *CfsForGetDeploymentOutput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForGetDeploymentOutput) SetOptions(v *OptionsForGetDeploymentOutput) *CfsForGetDeploymentOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForGetDeploymentOutput) SetTos(v *TosForGetDeploymentOutput) *CfsForGetDeploymentOutput {
	s.Tos = v
	return s
}

type ConfigForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Nas *NasForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForGetDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForGetDeploymentOutput) SetCfs(v *CfsForGetDeploymentOutput) *ConfigForGetDeploymentOutput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForGetDeploymentOutput) SetNas(v *NasForGetDeploymentOutput) *ConfigForGetDeploymentOutput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForGetDeploymentOutput) SetSfcs(v *SfcsForGetDeploymentOutput) *ConfigForGetDeploymentOutput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForGetDeploymentOutput) SetTos(v *TosForGetDeploymentOutput) *ConfigForGetDeploymentOutput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForGetDeploymentOutput) SetVepfs(v *VepfsForGetDeploymentOutput) *ConfigForGetDeploymentOutput {
	s.Vepfs = v
	return s
}

type ConvertCredentialForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertCredentialForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCredentialForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *ConvertCredentialForGetDeploymentOutput) SetRegistryToken(v string) *ConvertCredentialForGetDeploymentOutput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *ConvertCredentialForGetDeploymentOutput) SetRegistryUsername(v string) *ConvertCredentialForGetDeploymentOutput {
	s.RegistryUsername = &v
	return s
}

type ConvertOptionsForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForGetDeploymentOutput) SetInternalSync(v int64) *ConvertOptionsForGetDeploymentOutput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForGetDeploymentOutput) SetReplicas(v int64) *ConvertOptionsForGetDeploymentOutput {
	s.Replicas = &v
	return s
}

type ConvertStatusForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertStatusForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertStatusForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ConvertStatusForGetDeploymentOutput) SetMessage(v string) *ConvertStatusForGetDeploymentOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *ConvertStatusForGetDeploymentOutput) SetSecondaryState(v string) *ConvertStatusForGetDeploymentOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *ConvertStatusForGetDeploymentOutput) SetState(v string) *ConvertStatusForGetDeploymentOutput {
	s.State = &v
	return s
}

type CredentialForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	SecretAccessKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *CredentialForGetDeploymentOutput) SetAccessKey(v string) *CredentialForGetDeploymentOutput {
	s.AccessKey = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *CredentialForGetDeploymentOutput) SetSecretAccessKey(v string) *CredentialForGetDeploymentOutput {
	s.SecretAccessKey = &v
	return s
}

type EnvForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EnvForGetDeploymentOutput) SetName(v string) *EnvForGetDeploymentOutput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForGetDeploymentOutput) SetValue(v string) *EnvForGetDeploymentOutput {
	s.Value = &v
	return s
}

type ExecForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ExecForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *ExecForGetDeploymentOutput) SetCommand(v string) *ExecForGetDeploymentOutput {
	s.Command = &v
	return s
}

type FlexibleResourceClaimForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetCpu(v float64) *FlexibleResourceClaimForGetDeploymentOutput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetFamily(v string) *FlexibleResourceClaimForGetDeploymentOutput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetGpuCount(v float64) *FlexibleResourceClaimForGetDeploymentOutput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetGpuType(v string) *FlexibleResourceClaimForGetDeploymentOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetMemoryGiB(v float64) *FlexibleResourceClaimForGetDeploymentOutput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForGetDeploymentOutput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForGetDeploymentOutput {
	s.RdmaEniCount = &v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HistoryVersionLimit *int32 `max:"100" type:"int32" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	IncludeInstanceItems *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.HistoryVersionLimit != nil && *s.HistoryVersionLimit > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("HistoryVersionLimit", 100))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHistoryVersionLimit sets the HistoryVersionLimit field's value.
func (s *GetDeploymentInput) SetHistoryVersionLimit(v int32) *GetDeploymentInput {
	s.HistoryVersionLimit = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeploymentInput) SetId(v string) *GetDeploymentInput {
	s.Id = &v
	return s
}

// SetIncludeInstanceItems sets the IncludeInstanceItems field's value.
func (s *GetDeploymentInput) SetIncludeInstanceItems(v bool) *GetDeploymentInput {
	s.IncludeInstanceItems = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	HistoryVersions []*HistoryVersionForGetDeploymentOutput `type:"list" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	InstanceItems []*InstanceItemForGetDeploymentOutput `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	Roles []*RoleForGetDeploymentOutput `type:"list" json:",omitempty"`

	ServiceId *string `type:"string" json:",omitempty"`

	Status *ConvertStatusForGetDeploymentOutput `type:"structure" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetDeploymentOutput) SetCreateTime(v string) *GetDeploymentOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetDeploymentOutput) SetCreatedBy(v string) *GetDeploymentOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDeploymentOutput) SetDescription(v string) *GetDeploymentOutput {
	s.Description = &v
	return s
}

// SetHistoryVersions sets the HistoryVersions field's value.
func (s *GetDeploymentOutput) SetHistoryVersions(v []*HistoryVersionForGetDeploymentOutput) *GetDeploymentOutput {
	s.HistoryVersions = v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeploymentOutput) SetId(v string) *GetDeploymentOutput {
	s.Id = &v
	return s
}

// SetInstanceItems sets the InstanceItems field's value.
func (s *GetDeploymentOutput) SetInstanceItems(v []*InstanceItemForGetDeploymentOutput) *GetDeploymentOutput {
	s.InstanceItems = v
	return s
}

// SetName sets the Name field's value.
func (s *GetDeploymentOutput) SetName(v string) *GetDeploymentOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetDeploymentOutput) SetPriority(v int32) *GetDeploymentOutput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *GetDeploymentOutput) SetResourceQueueId(v string) *GetDeploymentOutput {
	s.ResourceQueueId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *GetDeploymentOutput) SetRoles(v []*RoleForGetDeploymentOutput) *GetDeploymentOutput {
	s.Roles = v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetDeploymentOutput) SetServiceId(v string) *GetDeploymentOutput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDeploymentOutput) SetStatus(v *ConvertStatusForGetDeploymentOutput) *GetDeploymentOutput {
	s.Status = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetDeploymentOutput) SetUpdateTime(v string) *GetDeploymentOutput {
	s.UpdateTime = &v
	return s
}

type HTTPGetForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTPHeaders []*HTTPHeaderForGetDeploymentOutput `type:"list" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Scheme *string `type:"string" json:",omitempty" enum:"EnumOfSchemeForGetDeploymentOutput"`
}

// String returns the string representation
func (s HTTPGetForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPGetForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetHTTPHeaders sets the HTTPHeaders field's value.
func (s *HTTPGetForGetDeploymentOutput) SetHTTPHeaders(v []*HTTPHeaderForGetDeploymentOutput) *HTTPGetForGetDeploymentOutput {
	s.HTTPHeaders = v
	return s
}

// SetPath sets the Path field's value.
func (s *HTTPGetForGetDeploymentOutput) SetPath(v string) *HTTPGetForGetDeploymentOutput {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *HTTPGetForGetDeploymentOutput) SetPort(v int32) *HTTPGetForGetDeploymentOutput {
	s.Port = &v
	return s
}

// SetScheme sets the Scheme field's value.
func (s *HTTPGetForGetDeploymentOutput) SetScheme(v string) *HTTPGetForGetDeploymentOutput {
	s.Scheme = &v
	return s
}

type HTTPHeaderForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HTTPHeaderForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeaderForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HTTPHeaderForGetDeploymentOutput) SetName(v string) *HTTPHeaderForGetDeploymentOutput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeaderForGetDeploymentOutput) SetValue(v string) *HTTPHeaderForGetDeploymentOutput {
	s.Value = &v
	return s
}

type HistoryVersionForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChangeType *string `type:"string" json:",omitempty" enum:"EnumOfChangeTypeForGetDeploymentOutput"`

	CreateTime *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	Roles []*RoleForGetDeploymentOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s HistoryVersionForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryVersionForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetChangeType sets the ChangeType field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetChangeType(v string) *HistoryVersionForGetDeploymentOutput {
	s.ChangeType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetCreateTime(v string) *HistoryVersionForGetDeploymentOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetId(v string) *HistoryVersionForGetDeploymentOutput {
	s.Id = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetPriority(v int32) *HistoryVersionForGetDeploymentOutput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetResourceQueueId(v string) *HistoryVersionForGetDeploymentOutput {
	s.ResourceQueueId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *HistoryVersionForGetDeploymentOutput) SetRoles(v []*RoleForGetDeploymentOutput) *HistoryVersionForGetDeploymentOutput {
	s.Roles = v
	return s
}

type ImageForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *ConvertCredentialForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForGetDeploymentOutput) SetCredential(v *ConvertCredentialForGetDeploymentOutput) *ImageForGetDeploymentOutput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForGetDeploymentOutput) SetType(v string) *ImageForGetDeploymentOutput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForGetDeploymentOutput) SetUrl(v string) *ImageForGetDeploymentOutput {
	s.Url = &v
	return s
}

type InstanceItemForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	DeploymentId *string `type:"string" json:",omitempty"`

	DeploymentVersionId *string `type:"string" json:",omitempty"`

	Ip *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ServiceId *string `type:"string" json:",omitempty"`

	Status *ConvertStatusForGetDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s InstanceItemForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceItemForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *InstanceItemForGetDeploymentOutput) SetCreateTime(v string) *InstanceItemForGetDeploymentOutput {
	s.CreateTime = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *InstanceItemForGetDeploymentOutput) SetDeploymentId(v string) *InstanceItemForGetDeploymentOutput {
	s.DeploymentId = &v
	return s
}

// SetDeploymentVersionId sets the DeploymentVersionId field's value.
func (s *InstanceItemForGetDeploymentOutput) SetDeploymentVersionId(v string) *InstanceItemForGetDeploymentOutput {
	s.DeploymentVersionId = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *InstanceItemForGetDeploymentOutput) SetIp(v string) *InstanceItemForGetDeploymentOutput {
	s.Ip = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceItemForGetDeploymentOutput) SetName(v string) *InstanceItemForGetDeploymentOutput {
	s.Name = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *InstanceItemForGetDeploymentOutput) SetServiceId(v string) *InstanceItemForGetDeploymentOutput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceItemForGetDeploymentOutput) SetStatus(v *ConvertStatusForGetDeploymentOutput) *InstanceItemForGetDeploymentOutput {
	s.Status = v
	return s
}

type LivenessProbeForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForGetDeploymentOutput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForGetDeploymentOutput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForGetDeploymentOutput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s LivenessProbeForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LivenessProbeForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetEnabled(v bool) *LivenessProbeForGetDeploymentOutput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetExec(v *ExecForGetDeploymentOutput) *LivenessProbeForGetDeploymentOutput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetFailureThreshold(v int32) *LivenessProbeForGetDeploymentOutput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetHTTPGet(v *HTTPGetForGetDeploymentOutput) *LivenessProbeForGetDeploymentOutput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetInitialDelaySeconds(v int32) *LivenessProbeForGetDeploymentOutput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetPeriodSeconds(v int32) *LivenessProbeForGetDeploymentOutput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetSuccessThreshold(v int32) *LivenessProbeForGetDeploymentOutput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetTCPSocket(v *TCPSocketForGetDeploymentOutput) *LivenessProbeForGetDeploymentOutput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *LivenessProbeForGetDeploymentOutput) SetTimeoutSeconds(v int32) *LivenessProbeForGetDeploymentOutput {
	s.TimeoutSeconds = &v
	return s
}

type ModelForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ModelID *string `type:"string" json:",omitempty"`

	ModelVersionID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModelForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetModelID sets the ModelID field's value.
func (s *ModelForGetDeploymentOutput) SetModelID(v string) *ModelForGetDeploymentOutput {
	s.ModelID = &v
	return s
}

// SetModelVersionID sets the ModelVersionID field's value.
func (s *ModelForGetDeploymentOutput) SetModelVersionID(v string) *ModelForGetDeploymentOutput {
	s.ModelVersionID = &v
	return s
}

type NasForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForGetDeploymentOutput) SetAddr(v string) *NasForGetDeploymentOutput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForGetDeploymentOutput) SetFileSystemName(v string) *NasForGetDeploymentOutput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForGetDeploymentOutput) SetId(v string) *NasForGetDeploymentOutput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForGetDeploymentOutput) SetNasType(v string) *NasForGetDeploymentOutput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForGetDeploymentOutput) SetSubPath(v string) *NasForGetDeploymentOutput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForGetDeploymentOutput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForGetDeploymentOutput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForGetDeploymentOutput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForGetDeploymentOutput) SetStrategyType(v string) *NodeAffinitySpecForGetDeploymentOutput {
	s.StrategyType = &v
	return s
}

type OptionsForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForGetDeploymentOutput) SetInternalSync(v int64) *OptionsForGetDeploymentOutput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForGetDeploymentOutput) SetMetaCacheCapacity(v int64) *OptionsForGetDeploymentOutput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForGetDeploymentOutput) SetMetaCacheExpiryMinutes(v int64) *OptionsForGetDeploymentOutput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForGetDeploymentOutput) SetMetaCacheExpiryMsec(v int64) *OptionsForGetDeploymentOutput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type PortForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForGetDeploymentOutput"`
}

// String returns the string representation
func (s PortForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForGetDeploymentOutput) SetExposePort(v string) *PortForGetDeploymentOutput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForGetDeploymentOutput) SetListenPort(v string) *PortForGetDeploymentOutput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForGetDeploymentOutput) SetPath(v string) *PortForGetDeploymentOutput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForGetDeploymentOutput) SetType(v string) *PortForGetDeploymentOutput {
	s.Type = &v
	return s
}

type ReadinessProbeForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForGetDeploymentOutput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForGetDeploymentOutput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForGetDeploymentOutput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReadinessProbeForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReadinessProbeForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetEnabled(v bool) *ReadinessProbeForGetDeploymentOutput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetExec(v *ExecForGetDeploymentOutput) *ReadinessProbeForGetDeploymentOutput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetFailureThreshold(v int32) *ReadinessProbeForGetDeploymentOutput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetHTTPGet(v *HTTPGetForGetDeploymentOutput) *ReadinessProbeForGetDeploymentOutput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetInitialDelaySeconds(v int32) *ReadinessProbeForGetDeploymentOutput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetPeriodSeconds(v int32) *ReadinessProbeForGetDeploymentOutput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetSuccessThreshold(v int32) *ReadinessProbeForGetDeploymentOutput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetTCPSocket(v *TCPSocketForGetDeploymentOutput) *ReadinessProbeForGetDeploymentOutput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *ReadinessProbeForGetDeploymentOutput) SetTimeoutSeconds(v int32) *ReadinessProbeForGetDeploymentOutput {
	s.TimeoutSeconds = &v
	return s
}

type ResourceForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForGetDeploymentOutput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForGetDeploymentOutput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForGetDeploymentOutput) *ResourceForGetDeploymentOutput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForGetDeploymentOutput) SetInstanceTypeId(v string) *ResourceForGetDeploymentOutput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForGetDeploymentOutput) SetType(v string) *ResourceForGetDeploymentOutput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForGetDeploymentOutput) SetZoneId(v string) *ResourceForGetDeploymentOutput {
	s.ZoneId = &v
	return s
}

type RoleForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	Credential *CredentialForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Envs []*EnvForGetDeploymentOutput `type:"list" json:",omitempty"`

	Expose *bool `type:"boolean" json:",omitempty"`

	GracefulShutdownPeriod *int32 `type:"int32" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Image *ImageForGetDeploymentOutput `type:"structure" json:",omitempty"`

	LivenessProbe *LivenessProbeForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Model *ModelForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Ports []*PortForGetDeploymentOutput `type:"list" json:",omitempty"`

	ReadinessProbe *ReadinessProbeForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Replicas *int32 `type:"int32" json:",omitempty"`

	Resource *ResourceForGetDeploymentOutput `type:"structure" json:",omitempty"`

	RollingUpdateStrategy *RollingUpdateStrategyForGetDeploymentOutput `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	ShardNum *int32 `type:"int32" json:",omitempty"`

	StartupProbe *StartupProbeForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Status *StatusForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Storages []*StorageForGetDeploymentOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RoleForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCommand sets the Command field's value.
func (s *RoleForGetDeploymentOutput) SetCommand(v string) *RoleForGetDeploymentOutput {
	s.Command = &v
	return s
}

// SetCredential sets the Credential field's value.
func (s *RoleForGetDeploymentOutput) SetCredential(v *CredentialForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Credential = v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *RoleForGetDeploymentOutput) SetEnvs(v []*EnvForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Envs = v
	return s
}

// SetExpose sets the Expose field's value.
func (s *RoleForGetDeploymentOutput) SetExpose(v bool) *RoleForGetDeploymentOutput {
	s.Expose = &v
	return s
}

// SetGracefulShutdownPeriod sets the GracefulShutdownPeriod field's value.
func (s *RoleForGetDeploymentOutput) SetGracefulShutdownPeriod(v int32) *RoleForGetDeploymentOutput {
	s.GracefulShutdownPeriod = &v
	return s
}

// SetId sets the Id field's value.
func (s *RoleForGetDeploymentOutput) SetId(v string) *RoleForGetDeploymentOutput {
	s.Id = &v
	return s
}

// SetImage sets the Image field's value.
func (s *RoleForGetDeploymentOutput) SetImage(v *ImageForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Image = v
	return s
}

// SetLivenessProbe sets the LivenessProbe field's value.
func (s *RoleForGetDeploymentOutput) SetLivenessProbe(v *LivenessProbeForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.LivenessProbe = v
	return s
}

// SetModel sets the Model field's value.
func (s *RoleForGetDeploymentOutput) SetModel(v *ModelForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Model = v
	return s
}

// SetName sets the Name field's value.
func (s *RoleForGetDeploymentOutput) SetName(v string) *RoleForGetDeploymentOutput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForGetDeploymentOutput) SetNodeAffinitySpec(v *NodeAffinitySpecForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.NodeAffinitySpec = v
	return s
}

// SetPorts sets the Ports field's value.
func (s *RoleForGetDeploymentOutput) SetPorts(v []*PortForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Ports = v
	return s
}

// SetReadinessProbe sets the ReadinessProbe field's value.
func (s *RoleForGetDeploymentOutput) SetReadinessProbe(v *ReadinessProbeForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.ReadinessProbe = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForGetDeploymentOutput) SetReplicas(v int32) *RoleForGetDeploymentOutput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForGetDeploymentOutput) SetResource(v *ResourceForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Resource = v
	return s
}

// SetRollingUpdateStrategy sets the RollingUpdateStrategy field's value.
func (s *RoleForGetDeploymentOutput) SetRollingUpdateStrategy(v *RollingUpdateStrategyForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.RollingUpdateStrategy = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *RoleForGetDeploymentOutput) SetSecurityGroupIds(v []*string) *RoleForGetDeploymentOutput {
	s.SecurityGroupIds = v
	return s
}

// SetShardNum sets the ShardNum field's value.
func (s *RoleForGetDeploymentOutput) SetShardNum(v int32) *RoleForGetDeploymentOutput {
	s.ShardNum = &v
	return s
}

// SetStartupProbe sets the StartupProbe field's value.
func (s *RoleForGetDeploymentOutput) SetStartupProbe(v *StartupProbeForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.StartupProbe = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RoleForGetDeploymentOutput) SetStatus(v *StatusForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Status = v
	return s
}

// SetStorages sets the Storages field's value.
func (s *RoleForGetDeploymentOutput) SetStorages(v []*StorageForGetDeploymentOutput) *RoleForGetDeploymentOutput {
	s.Storages = v
	return s
}

type RollingUpdateStrategyForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxSurge *int32 `type:"int32" json:",omitempty"`

	MaxUnavailable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RollingUpdateStrategyForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RollingUpdateStrategyForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetMaxSurge sets the MaxSurge field's value.
func (s *RollingUpdateStrategyForGetDeploymentOutput) SetMaxSurge(v int32) *RollingUpdateStrategyForGetDeploymentOutput {
	s.MaxSurge = &v
	return s
}

// SetMaxUnavailable sets the MaxUnavailable field's value.
func (s *RollingUpdateStrategyForGetDeploymentOutput) SetMaxUnavailable(v int32) *RollingUpdateStrategyForGetDeploymentOutput {
	s.MaxUnavailable = &v
	return s
}

type SfcsForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForGetDeploymentOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetDeploymentOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForGetDeploymentOutput) SetCachePolicyId(v string) *SfcsForGetDeploymentOutput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForGetDeploymentOutput) SetFileSystemName(v string) *SfcsForGetDeploymentOutput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForGetDeploymentOutput) SetOptions(v *ConvertOptionsForGetDeploymentOutput) *SfcsForGetDeploymentOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForGetDeploymentOutput) SetTos(v *TosForGetDeploymentOutput) *SfcsForGetDeploymentOutput {
	s.Tos = v
	return s
}

type StartupProbeForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Exec *ExecForGetDeploymentOutput `type:"structure" json:",omitempty"`

	FailureThreshold *int32 `type:"int32" json:",omitempty"`

	HTTPGet *HTTPGetForGetDeploymentOutput `type:"structure" json:",omitempty"`

	InitialDelaySeconds *int32 `type:"int32" json:",omitempty"`

	PeriodSeconds *int32 `type:"int32" json:",omitempty"`

	SuccessThreshold *int32 `type:"int32" json:",omitempty"`

	TCPSocket *TCPSocketForGetDeploymentOutput `type:"structure" json:",omitempty"`

	TimeoutSeconds *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartupProbeForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartupProbeForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *StartupProbeForGetDeploymentOutput) SetEnabled(v bool) *StartupProbeForGetDeploymentOutput {
	s.Enabled = &v
	return s
}

// SetExec sets the Exec field's value.
func (s *StartupProbeForGetDeploymentOutput) SetExec(v *ExecForGetDeploymentOutput) *StartupProbeForGetDeploymentOutput {
	s.Exec = v
	return s
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *StartupProbeForGetDeploymentOutput) SetFailureThreshold(v int32) *StartupProbeForGetDeploymentOutput {
	s.FailureThreshold = &v
	return s
}

// SetHTTPGet sets the HTTPGet field's value.
func (s *StartupProbeForGetDeploymentOutput) SetHTTPGet(v *HTTPGetForGetDeploymentOutput) *StartupProbeForGetDeploymentOutput {
	s.HTTPGet = v
	return s
}

// SetInitialDelaySeconds sets the InitialDelaySeconds field's value.
func (s *StartupProbeForGetDeploymentOutput) SetInitialDelaySeconds(v int32) *StartupProbeForGetDeploymentOutput {
	s.InitialDelaySeconds = &v
	return s
}

// SetPeriodSeconds sets the PeriodSeconds field's value.
func (s *StartupProbeForGetDeploymentOutput) SetPeriodSeconds(v int32) *StartupProbeForGetDeploymentOutput {
	s.PeriodSeconds = &v
	return s
}

// SetSuccessThreshold sets the SuccessThreshold field's value.
func (s *StartupProbeForGetDeploymentOutput) SetSuccessThreshold(v int32) *StartupProbeForGetDeploymentOutput {
	s.SuccessThreshold = &v
	return s
}

// SetTCPSocket sets the TCPSocket field's value.
func (s *StartupProbeForGetDeploymentOutput) SetTCPSocket(v *TCPSocketForGetDeploymentOutput) *StartupProbeForGetDeploymentOutput {
	s.TCPSocket = v
	return s
}

// SetTimeoutSeconds sets the TimeoutSeconds field's value.
func (s *StartupProbeForGetDeploymentOutput) SetTimeoutSeconds(v int32) *StartupProbeForGetDeploymentOutput {
	s.TimeoutSeconds = &v
	return s
}

type StatusForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailableReplicas *int32 `type:"int32" json:",omitempty"`

	ExpectedReplicias *int32 `type:"int32" json:",omitempty"`

	ExpectedUpdatedReplicas *int32 `type:"int32" json:",omitempty"`

	TotalReplicas *int32 `type:"int32" json:",omitempty"`

	UpdatedAvailableReplicas *int32 `type:"int32" json:",omitempty"`

	UpdatedReplicas *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StatusForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetAvailableReplicas sets the AvailableReplicas field's value.
func (s *StatusForGetDeploymentOutput) SetAvailableReplicas(v int32) *StatusForGetDeploymentOutput {
	s.AvailableReplicas = &v
	return s
}

// SetExpectedReplicias sets the ExpectedReplicias field's value.
func (s *StatusForGetDeploymentOutput) SetExpectedReplicias(v int32) *StatusForGetDeploymentOutput {
	s.ExpectedReplicias = &v
	return s
}

// SetExpectedUpdatedReplicas sets the ExpectedUpdatedReplicas field's value.
func (s *StatusForGetDeploymentOutput) SetExpectedUpdatedReplicas(v int32) *StatusForGetDeploymentOutput {
	s.ExpectedUpdatedReplicas = &v
	return s
}

// SetTotalReplicas sets the TotalReplicas field's value.
func (s *StatusForGetDeploymentOutput) SetTotalReplicas(v int32) *StatusForGetDeploymentOutput {
	s.TotalReplicas = &v
	return s
}

// SetUpdatedAvailableReplicas sets the UpdatedAvailableReplicas field's value.
func (s *StatusForGetDeploymentOutput) SetUpdatedAvailableReplicas(v int32) *StatusForGetDeploymentOutput {
	s.UpdatedAvailableReplicas = &v
	return s
}

// SetUpdatedReplicas sets the UpdatedReplicas field's value.
func (s *StatusForGetDeploymentOutput) SetUpdatedReplicas(v int32) *StatusForGetDeploymentOutput {
	s.UpdatedReplicas = &v
	return s
}

type StorageForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForGetDeploymentOutput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForGetDeploymentOutput) SetConfig(v *ConfigForGetDeploymentOutput) *StorageForGetDeploymentOutput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForGetDeploymentOutput) SetMountPath(v string) *StorageForGetDeploymentOutput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForGetDeploymentOutput) SetReadOnly(v bool) *StorageForGetDeploymentOutput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForGetDeploymentOutput) SetType(v string) *StorageForGetDeploymentOutput {
	s.Type = &v
	return s
}

type TCPSocketForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TCPSocketForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPSocketForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetPort sets the Port field's value.
func (s *TCPSocketForGetDeploymentOutput) SetPort(v int32) *TCPSocketForGetDeploymentOutput {
	s.Port = &v
	return s
}

type TosForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForGetDeploymentOutput) SetBucket(v string) *TosForGetDeploymentOutput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForGetDeploymentOutput) SetPrefix(v string) *TosForGetDeploymentOutput {
	s.Prefix = &v
	return s
}

type VepfsForGetDeploymentOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForGetDeploymentOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForGetDeploymentOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForGetDeploymentOutput) SetFileSystemName(v string) *VepfsForGetDeploymentOutput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForGetDeploymentOutput) SetHostPath(v string) *VepfsForGetDeploymentOutput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForGetDeploymentOutput) SetId(v string) *VepfsForGetDeploymentOutput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForGetDeploymentOutput) SetSubPath(v string) *VepfsForGetDeploymentOutput {
	s.SubPath = &v
	return s
}

const (
	// EnumOfChangeTypeForGetDeploymentOutputCreateService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputCreateService = "CreateService"

	// EnumOfChangeTypeForGetDeploymentOutputUpdateService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputUpdateService = "UpdateService"

	// EnumOfChangeTypeForGetDeploymentOutputMigrateService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputMigrateService = "MigrateService"

	// EnumOfChangeTypeForGetDeploymentOutputStopService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputStopService = "StopService"

	// EnumOfChangeTypeForGetDeploymentOutputStartService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputStartService = "StartService"

	// EnumOfChangeTypeForGetDeploymentOutputDeleteService is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputDeleteService = "DeleteService"

	// EnumOfChangeTypeForGetDeploymentOutputCreateDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputCreateDeployment = "CreateDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputUpdateDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputUpdateDeployment = "UpdateDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputMigrateDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputMigrateDeployment = "MigrateDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputStopDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputStopDeployment = "StopDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputStartDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputStartDeployment = "StartDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputScaleDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputScaleDeployment = "ScaleDeployment"

	// EnumOfChangeTypeForGetDeploymentOutputDeleteDeployment is a EnumOfChangeTypeForGetDeploymentOutput enum value
	EnumOfChangeTypeForGetDeploymentOutputDeleteDeployment = "DeleteDeployment"
)

const (
	// EnumOfGPUCPUNodePreferenceForGetDeploymentOutputGpurequired is a EnumOfGPUCPUNodePreferenceForGetDeploymentOutput enum value
	EnumOfGPUCPUNodePreferenceForGetDeploymentOutputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForGetDeploymentOutputGpupreferred is a EnumOfGPUCPUNodePreferenceForGetDeploymentOutput enum value
	EnumOfGPUCPUNodePreferenceForGetDeploymentOutputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForGetDeploymentOutputCpurequired is a EnumOfGPUCPUNodePreferenceForGetDeploymentOutput enum value
	EnumOfGPUCPUNodePreferenceForGetDeploymentOutputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForGetDeploymentOutputCpupreferred is a EnumOfGPUCPUNodePreferenceForGetDeploymentOutput enum value
	EnumOfGPUCPUNodePreferenceForGetDeploymentOutputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfSchemeForGetDeploymentOutputHttp is a EnumOfSchemeForGetDeploymentOutput enum value
	EnumOfSchemeForGetDeploymentOutputHttp = "HTTP"

	// EnumOfSchemeForGetDeploymentOutputHttps is a EnumOfSchemeForGetDeploymentOutput enum value
	EnumOfSchemeForGetDeploymentOutputHttps = "HTTPS"
)

const (
	// EnumOfTypeForGetDeploymentOutputHttp11 is a EnumOfTypeForGetDeploymentOutput enum value
	EnumOfTypeForGetDeploymentOutputHttp11 = "HTTP/1.1"

	// EnumOfTypeForGetDeploymentOutputHttp2 is a EnumOfTypeForGetDeploymentOutput enum value
	EnumOfTypeForGetDeploymentOutputHttp2 = "HTTP2"

	// EnumOfTypeForGetDeploymentOutputGrpc is a EnumOfTypeForGetDeploymentOutput enum value
	EnumOfTypeForGetDeploymentOutputGrpc = "GRPC"

	// EnumOfTypeForGetDeploymentOutputMetrics is a EnumOfTypeForGetDeploymentOutput enum value
	EnumOfTypeForGetDeploymentOutputMetrics = "Metrics"

	// EnumOfTypeForGetDeploymentOutputOther is a EnumOfTypeForGetDeploymentOutput enum value
	EnumOfTypeForGetDeploymentOutputOther = "Other"
)
