// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdatePoolCommon = "UpdatePool"

// UpdatePoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdatePoolCommon operation. The "output" return
// value will be populated with the UpdatePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdatePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdatePoolCommon Send returns without error.
//
// See UpdatePoolCommon for more information on using the UpdatePoolCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdatePoolCommonRequest method.
//    req, resp := client.UpdatePoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) UpdatePoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdatePoolCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdatePoolCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation UpdatePoolCommon for usage and error information.
func (c *GTM) UpdatePoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdatePoolCommonRequest(input)
	return out, req.Send()
}

// UpdatePoolCommonWithContext is the same as UpdatePoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) UpdatePoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdatePoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePool = "UpdatePool"

// UpdatePoolRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdatePool operation. The "output" return
// value will be populated with the UpdatePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdatePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdatePoolCommon Send returns without error.
//
// See UpdatePool for more information on using the UpdatePool
// API call, and error handling.
//
//    // Example sending a request using the UpdatePoolRequest method.
//    req, resp := client.UpdatePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) UpdatePoolRequest(input *UpdatePoolInput) (req *request.Request, output *UpdatePoolOutput) {
	op := &request.Operation{
		Name:       opUpdatePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePoolInput{}
	}

	output = &UpdatePoolOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdatePool API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation UpdatePool for usage and error information.
func (c *GTM) UpdatePool(input *UpdatePoolInput) (*UpdatePoolOutput, error) {
	req, out := c.UpdatePoolRequest(input)
	return out, req.Send()
}

// UpdatePoolWithContext is the same as UpdatePool with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) UpdatePoolWithContext(ctx volcengine.Context, input *UpdatePoolInput, opts ...request.Option) (*UpdatePoolOutput, error) {
	req, out := c.UpdatePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForUpdatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Capacity *int64 `type:"int64" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	RectifiedGeos []*string `type:"list" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s AddressForUpdatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForUpdatePoolInput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *AddressForUpdatePoolInput) SetCapacity(v int64) *AddressForUpdatePoolInput {
	s.Capacity = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AddressForUpdatePoolInput) SetMode(v string) *AddressForUpdatePoolInput {
	s.Mode = &v
	return s
}

// SetRectifiedGeos sets the RectifiedGeos field's value.
func (s *AddressForUpdatePoolInput) SetRectifiedGeos(v []*string) *AddressForUpdatePoolInput {
	s.RectifiedGeos = v
	return s
}

// SetValue sets the Value field's value.
func (s *AddressForUpdatePoolInput) SetValue(v string) *AddressForUpdatePoolInput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AddressForUpdatePoolInput) SetWeight(v int32) *AddressForUpdatePoolInput {
	s.Weight = &v
	return s
}

type PoolForUpdatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddrType *string `type:"string" json:",omitempty"`

	Addresses []*AddressForUpdatePoolInput `type:"list" json:",omitempty"`

	Capacity *int32 `type:"int32" json:",omitempty"`

	CapacityMode *string `type:"string" json:",omitempty" enum:"EnumOfCapacityModeForUpdatePoolInput"`

	Name *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PoolForUpdatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PoolForUpdatePoolInput) GoString() string {
	return s.String()
}

// SetAddrType sets the AddrType field's value.
func (s *PoolForUpdatePoolInput) SetAddrType(v string) *PoolForUpdatePoolInput {
	s.AddrType = &v
	return s
}

// SetAddresses sets the Addresses field's value.
func (s *PoolForUpdatePoolInput) SetAddresses(v []*AddressForUpdatePoolInput) *PoolForUpdatePoolInput {
	s.Addresses = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *PoolForUpdatePoolInput) SetCapacity(v int32) *PoolForUpdatePoolInput {
	s.Capacity = &v
	return s
}

// SetCapacityMode sets the CapacityMode field's value.
func (s *PoolForUpdatePoolInput) SetCapacityMode(v string) *PoolForUpdatePoolInput {
	s.CapacityMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *PoolForUpdatePoolInput) SetName(v string) *PoolForUpdatePoolInput {
	s.Name = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *PoolForUpdatePoolInput) SetRemark(v string) *PoolForUpdatePoolInput {
	s.Remark = &v
	return s
}

type UpdatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// GtmId is a required field
	GtmId *string `type:"string" json:",omitempty" required:"true"`

	Pool *PoolForUpdatePoolInput `type:"structure" json:",omitempty"`

	// PoolId is a required field
	PoolId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UpdatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePoolInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGtmId sets the GtmId field's value.
func (s *UpdatePoolInput) SetGtmId(v string) *UpdatePoolInput {
	s.GtmId = &v
	return s
}

// SetPool sets the Pool field's value.
func (s *UpdatePoolInput) SetPool(v *PoolForUpdatePoolInput) *UpdatePoolInput {
	s.Pool = v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *UpdatePoolInput) SetPoolId(v string) *UpdatePoolInput {
	s.PoolId = &v
	return s
}

type UpdatePoolOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdatePoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePoolOutput) GoString() string {
	return s.String()
}

const (
	// EnumOfCapacityModeForUpdatePoolInputPool is a EnumOfCapacityModeForUpdatePoolInput enum value
	EnumOfCapacityModeForUpdatePoolInputPool = "pool"

	// EnumOfCapacityModeForUpdatePoolInputAddress is a EnumOfCapacityModeForUpdatePoolInput enum value
	EnumOfCapacityModeForUpdatePoolInputAddress = "address"
)
