// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package filenas

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyFileSystemSpecCommon = "ModifyFileSystemSpec"

// ModifyFileSystemSpecCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyFileSystemSpecCommon operation. The "output" return
// value will be populated with the ModifyFileSystemSpecCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyFileSystemSpecCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyFileSystemSpecCommon Send returns without error.
//
// See ModifyFileSystemSpecCommon for more information on using the ModifyFileSystemSpecCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyFileSystemSpecCommonRequest method.
//    req, resp := client.ModifyFileSystemSpecCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FILENAS) ModifyFileSystemSpecCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyFileSystemSpecCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyFileSystemSpecCommon API operation for FILENAS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FILENAS's
// API operation ModifyFileSystemSpecCommon for usage and error information.
func (c *FILENAS) ModifyFileSystemSpecCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyFileSystemSpecCommonRequest(input)
	return out, req.Send()
}

// ModifyFileSystemSpecCommonWithContext is the same as ModifyFileSystemSpecCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyFileSystemSpecCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FILENAS) ModifyFileSystemSpecCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyFileSystemSpecCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyFileSystemSpec = "ModifyFileSystemSpec"

// ModifyFileSystemSpecRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyFileSystemSpec operation. The "output" return
// value will be populated with the ModifyFileSystemSpecCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyFileSystemSpecCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyFileSystemSpecCommon Send returns without error.
//
// See ModifyFileSystemSpec for more information on using the ModifyFileSystemSpec
// API call, and error handling.
//
//    // Example sending a request using the ModifyFileSystemSpecRequest method.
//    req, resp := client.ModifyFileSystemSpecRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FILENAS) ModifyFileSystemSpecRequest(input *ModifyFileSystemSpecInput) (req *request.Request, output *ModifyFileSystemSpecOutput) {
	op := &request.Operation{
		Name:       opModifyFileSystemSpec,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyFileSystemSpecInput{}
	}

	output = &ModifyFileSystemSpecOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyFileSystemSpec API operation for FILENAS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FILENAS's
// API operation ModifyFileSystemSpec for usage and error information.
func (c *FILENAS) ModifyFileSystemSpec(input *ModifyFileSystemSpecInput) (*ModifyFileSystemSpecOutput, error) {
	req, out := c.ModifyFileSystemSpecRequest(input)
	return out, req.Send()
}

// ModifyFileSystemSpecWithContext is the same as ModifyFileSystemSpec with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyFileSystemSpec for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FILENAS) ModifyFileSystemSpecWithContext(ctx volcengine.Context, input *ModifyFileSystemSpecInput, opts ...request.Option) (*ModifyFileSystemSpecOutput, error) {
	req, out := c.ModifyFileSystemSpecRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyFileSystemSpecInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheBandwidth *int32 `min:"700" max:"100000" type:"int32" json:",omitempty"`

	// FileSystemId is a required field
	FileSystemId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ModifyFileSystemSpecInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyFileSystemSpecInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyFileSystemSpecInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyFileSystemSpecInput"}
	if s.CacheBandwidth != nil && *s.CacheBandwidth < 700 {
		invalidParams.Add(request.NewErrParamMinValue("CacheBandwidth", 700))
	}
	if s.CacheBandwidth != nil && *s.CacheBandwidth > 100000 {
		invalidParams.Add(request.NewErrParamMaxValue("CacheBandwidth", 100000))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheBandwidth sets the CacheBandwidth field's value.
func (s *ModifyFileSystemSpecInput) SetCacheBandwidth(v int32) *ModifyFileSystemSpecInput {
	s.CacheBandwidth = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *ModifyFileSystemSpecInput) SetFileSystemId(v string) *ModifyFileSystemSpecInput {
	s.FileSystemId = &v
	return s
}

type ModifyFileSystemSpecOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	OrderNo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ModifyFileSystemSpecOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyFileSystemSpecOutput) GoString() string {
	return s.String()
}

// SetOrderNo sets the OrderNo field's value.
func (s *ModifyFileSystemSpecOutput) SetOrderNo(v string) *ModifyFileSystemSpecOutput {
	s.OrderNo = &v
	return s
}
