// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRunCommandCommon = "RunCommand"

// RunCommandCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RunCommandCommon operation. The "output" return
// value will be populated with the RunCommandCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunCommandCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunCommandCommon Send returns without error.
//
// See RunCommandCommon for more information on using the RunCommandCommon
// API call, and error handling.
//
//    // Example sending a request using the RunCommandCommonRequest method.
//    req, resp := client.RunCommandCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) RunCommandCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRunCommandCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// RunCommandCommon API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation RunCommandCommon for usage and error information.
func (c *ECS) RunCommandCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RunCommandCommonRequest(input)
	return out, req.Send()
}

// RunCommandCommonWithContext is the same as RunCommandCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RunCommandCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) RunCommandCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RunCommandCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRunCommand = "RunCommand"

// RunCommandRequest generates a "volcengine/request.Request" representing the
// client's request for the RunCommand operation. The "output" return
// value will be populated with the RunCommandCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RunCommandCommon Request to send the API call to the service.
// the "output" return value is not valid until after RunCommandCommon Send returns without error.
//
// See RunCommand for more information on using the RunCommand
// API call, and error handling.
//
//    // Example sending a request using the RunCommandRequest method.
//    req, resp := client.RunCommandRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) RunCommandRequest(input *RunCommandInput) (req *request.Request, output *RunCommandOutput) {
	op := &request.Operation{
		Name:       opRunCommand,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunCommandInput{}
	}

	output = &RunCommandOutput{}
	req = c.newRequest(op, input, output)

	return
}

// RunCommand API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation RunCommand for usage and error information.
func (c *ECS) RunCommand(input *RunCommandInput) (*RunCommandOutput, error) {
	req, out := c.RunCommandRequest(input)
	return out, req.Send()
}

// RunCommandWithContext is the same as RunCommand with the addition of
// the ability to pass a context and additional request options.
//
// See RunCommand for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) RunCommandWithContext(ctx volcengine.Context, input *RunCommandInput, opts ...request.Option) (*RunCommandOutput, error) {
	req, out := c.RunCommandRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ParameterDefinitionForRunCommandInput struct {
	_ struct{} `type:"structure"`

	DecimalPrecision *string `type:"string"`

	DefaultValue *string `type:"string"`

	MaxLength *string `type:"string"`

	MaxValue *string `type:"string"`

	MinLength *string `type:"string"`

	MinValue *string `type:"string"`

	Name *string `type:"string"`

	Required *bool `type:"boolean"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s ParameterDefinitionForRunCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDefinitionForRunCommandInput) GoString() string {
	return s.String()
}

// SetDecimalPrecision sets the DecimalPrecision field's value.
func (s *ParameterDefinitionForRunCommandInput) SetDecimalPrecision(v string) *ParameterDefinitionForRunCommandInput {
	s.DecimalPrecision = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *ParameterDefinitionForRunCommandInput) SetDefaultValue(v string) *ParameterDefinitionForRunCommandInput {
	s.DefaultValue = &v
	return s
}

// SetMaxLength sets the MaxLength field's value.
func (s *ParameterDefinitionForRunCommandInput) SetMaxLength(v string) *ParameterDefinitionForRunCommandInput {
	s.MaxLength = &v
	return s
}

// SetMaxValue sets the MaxValue field's value.
func (s *ParameterDefinitionForRunCommandInput) SetMaxValue(v string) *ParameterDefinitionForRunCommandInput {
	s.MaxValue = &v
	return s
}

// SetMinLength sets the MinLength field's value.
func (s *ParameterDefinitionForRunCommandInput) SetMinLength(v string) *ParameterDefinitionForRunCommandInput {
	s.MinLength = &v
	return s
}

// SetMinValue sets the MinValue field's value.
func (s *ParameterDefinitionForRunCommandInput) SetMinValue(v string) *ParameterDefinitionForRunCommandInput {
	s.MinValue = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterDefinitionForRunCommandInput) SetName(v string) *ParameterDefinitionForRunCommandInput {
	s.Name = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ParameterDefinitionForRunCommandInput) SetRequired(v bool) *ParameterDefinitionForRunCommandInput {
	s.Required = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterDefinitionForRunCommandInput) SetType(v string) *ParameterDefinitionForRunCommandInput {
	s.Type = &v
	return s
}

type RunCommandInput struct {
	_ struct{} `type:"structure"`

	// CommandContent is a required field
	CommandContent *string `type:"string" required:"true"`

	ContentEncoding *string `type:"string"`

	EnableParameter *bool `type:"boolean"`

	Frequency *string `type:"string"`

	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	InvocationDescription *string `type:"string"`

	// InvocationName is a required field
	InvocationName *string `type:"string" required:"true"`

	LaunchTime *string `type:"string"`

	ParameterDefinitions []*ParameterDefinitionForRunCommandInput `type:"list"`

	Parameters *string `type:"string"`

	ProjectName *string `type:"string"`

	RecurrenceEndTime *string `type:"string"`

	RepeatMode *string `type:"string"`

	Tags []*TagForRunCommandInput `type:"list"`

	Timeout *int32 `type:"int32"`

	// Type is a required field
	Type *string `type:"string" required:"true"`

	Username *string `type:"string"`

	WindowsPassword *string `type:"string"`

	WorkingDir *string `type:"string"`
}

// String returns the string representation
func (s RunCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunCommandInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RunCommandInput"}
	if s.CommandContent == nil {
		invalidParams.Add(request.NewErrParamRequired("CommandContent"))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.InvocationName == nil {
		invalidParams.Add(request.NewErrParamRequired("InvocationName"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommandContent sets the CommandContent field's value.
func (s *RunCommandInput) SetCommandContent(v string) *RunCommandInput {
	s.CommandContent = &v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *RunCommandInput) SetContentEncoding(v string) *RunCommandInput {
	s.ContentEncoding = &v
	return s
}

// SetEnableParameter sets the EnableParameter field's value.
func (s *RunCommandInput) SetEnableParameter(v bool) *RunCommandInput {
	s.EnableParameter = &v
	return s
}

// SetFrequency sets the Frequency field's value.
func (s *RunCommandInput) SetFrequency(v string) *RunCommandInput {
	s.Frequency = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *RunCommandInput) SetInstanceIds(v []*string) *RunCommandInput {
	s.InstanceIds = v
	return s
}

// SetInvocationDescription sets the InvocationDescription field's value.
func (s *RunCommandInput) SetInvocationDescription(v string) *RunCommandInput {
	s.InvocationDescription = &v
	return s
}

// SetInvocationName sets the InvocationName field's value.
func (s *RunCommandInput) SetInvocationName(v string) *RunCommandInput {
	s.InvocationName = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *RunCommandInput) SetLaunchTime(v string) *RunCommandInput {
	s.LaunchTime = &v
	return s
}

// SetParameterDefinitions sets the ParameterDefinitions field's value.
func (s *RunCommandInput) SetParameterDefinitions(v []*ParameterDefinitionForRunCommandInput) *RunCommandInput {
	s.ParameterDefinitions = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *RunCommandInput) SetParameters(v string) *RunCommandInput {
	s.Parameters = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *RunCommandInput) SetProjectName(v string) *RunCommandInput {
	s.ProjectName = &v
	return s
}

// SetRecurrenceEndTime sets the RecurrenceEndTime field's value.
func (s *RunCommandInput) SetRecurrenceEndTime(v string) *RunCommandInput {
	s.RecurrenceEndTime = &v
	return s
}

// SetRepeatMode sets the RepeatMode field's value.
func (s *RunCommandInput) SetRepeatMode(v string) *RunCommandInput {
	s.RepeatMode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RunCommandInput) SetTags(v []*TagForRunCommandInput) *RunCommandInput {
	s.Tags = v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *RunCommandInput) SetTimeout(v int32) *RunCommandInput {
	s.Timeout = &v
	return s
}

// SetType sets the Type field's value.
func (s *RunCommandInput) SetType(v string) *RunCommandInput {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *RunCommandInput) SetUsername(v string) *RunCommandInput {
	s.Username = &v
	return s
}

// SetWindowsPassword sets the WindowsPassword field's value.
func (s *RunCommandInput) SetWindowsPassword(v string) *RunCommandInput {
	s.WindowsPassword = &v
	return s
}

// SetWorkingDir sets the WorkingDir field's value.
func (s *RunCommandInput) SetWorkingDir(v string) *RunCommandInput {
	s.WorkingDir = &v
	return s
}

type RunCommandOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InvocationId *string `type:"string"`
}

// String returns the string representation
func (s RunCommandOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RunCommandOutput) GoString() string {
	return s.String()
}

// SetInvocationId sets the InvocationId field's value.
func (s *RunCommandOutput) SetInvocationId(v string) *RunCommandOutput {
	s.InvocationId = &v
	return s
}

type TagForRunCommandInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForRunCommandInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForRunCommandInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForRunCommandInput) SetKey(v string) *TagForRunCommandInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForRunCommandInput) SetValue(v string) *TagForRunCommandInput {
	s.Value = &v
	return s
}
