// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListGroupsCommon = "ListGroups"

// ListGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGroupsCommon operation. The "output" return
// value will be populated with the ListGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGroupsCommon Send returns without error.
//
// See ListGroupsCommon for more information on using the ListGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListGroupsCommonRequest method.
//    req, resp := client.ListGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListGroupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGroupsCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListGroupsCommon for usage and error information.
func (c *CLOUDIDENTITY) ListGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListGroupsCommonRequest(input)
	return out, req.Send()
}

// ListGroupsCommonWithContext is the same as ListGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the ListGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGroupsCommon Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGroups API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListGroups for usage and error information.
func (c *CLOUDIDENTITY) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListGroupsWithContext(ctx volcengine.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GroupForListGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatedTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	GroupId *string `type:"string" json:",omitempty"`

	GroupName *string `type:"string" json:",omitempty"`

	JoinType *string `type:"string" json:",omitempty" enum:"EnumOfJoinTypeForListGroupsOutput"`

	Source *string `type:"string" json:",omitempty"`

	UpdatedTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GroupForListGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupForListGroupsOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GroupForListGroupsOutput) SetCreatedTime(v string) *GroupForListGroupsOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GroupForListGroupsOutput) SetDescription(v string) *GroupForListGroupsOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GroupForListGroupsOutput) SetDisplayName(v string) *GroupForListGroupsOutput {
	s.DisplayName = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GroupForListGroupsOutput) SetGroupId(v string) *GroupForListGroupsOutput {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupForListGroupsOutput) SetGroupName(v string) *GroupForListGroupsOutput {
	s.GroupName = &v
	return s
}

// SetJoinType sets the JoinType field's value.
func (s *GroupForListGroupsOutput) SetJoinType(v string) *GroupForListGroupsOutput {
	s.JoinType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *GroupForListGroupsOutput) SetSource(v string) *GroupForListGroupsOutput {
	s.Source = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *GroupForListGroupsOutput) SetUpdatedTime(v string) *GroupForListGroupsOutput {
	s.UpdatedTime = &v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	JoinType *string `type:"string" json:",omitempty" enum:"EnumOfJoinTypeForListGroupsInput"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	QueryString *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// SetJoinType sets the JoinType field's value.
func (s *ListGroupsInput) SetJoinType(v string) *ListGroupsInput {
	s.JoinType = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGroupsInput) SetPageNumber(v int32) *ListGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGroupsInput) SetPageSize(v int32) *ListGroupsInput {
	s.PageSize = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ListGroupsInput) SetQueryString(v string) *ListGroupsInput {
	s.QueryString = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Groups []*GroupForListGroupsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*GroupForListGroupsOutput) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGroupsOutput) SetPageNumber(v int32) *ListGroupsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGroupsOutput) SetPageSize(v int32) *ListGroupsOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListGroupsOutput) SetTotal(v int64) *ListGroupsOutput {
	s.Total = &v
	return s
}

const (
	// EnumOfJoinTypeForListGroupsInputManual is a EnumOfJoinTypeForListGroupsInput enum value
	EnumOfJoinTypeForListGroupsInputManual = "Manual"

	// EnumOfJoinTypeForListGroupsInputAuto is a EnumOfJoinTypeForListGroupsInput enum value
	EnumOfJoinTypeForListGroupsInputAuto = "Auto"
)

const (
	// EnumOfJoinTypeForListGroupsOutputManual is a EnumOfJoinTypeForListGroupsOutput enum value
	EnumOfJoinTypeForListGroupsOutputManual = "Manual"

	// EnumOfJoinTypeForListGroupsOutputAuto is a EnumOfJoinTypeForListGroupsOutput enum value
	EnumOfJoinTypeForListGroupsOutputAuto = "Auto"
)
